/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.cos;

import com.wovoe.carpark.Hex;
import com.wovoe.carpark.HmacAlgorithms;
import com.wovoe.carpark.HmacUtils;
import com.wovoe.carpark.cloud.cos.AnonymousCOSCredentials;
import com.wovoe.carpark.cloud.cos.COSCredentials;
import com.wovoe.carpark.cloud.cos.CosClientException;
import com.wovoe.carpark.cloud.cos.HttpMethodName;
import com.wovoe.carpark.cloud.cos.UrlEncoderUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class COSSigner {
    private static Set<String> needSignedHeaderSet = new HashSet<String>();
    private Boolean isCIWorkflowRequest = false;
    private int localTimeDelta = 0;

    static {
        needSignedHeaderSet.add("cache-control");
        needSignedHeaderSet.add("content-disposition");
        needSignedHeaderSet.add("content-encoding");
        needSignedHeaderSet.add("content-length");
        needSignedHeaderSet.add("content-md5");
        needSignedHeaderSet.add("content-type");
        needSignedHeaderSet.add("expect");
        needSignedHeaderSet.add("expires");
        needSignedHeaderSet.add("host");
        needSignedHeaderSet.add("if-match");
        needSignedHeaderSet.add("if-modified-since");
        needSignedHeaderSet.add("if-none-match");
        needSignedHeaderSet.add("if-unmodified-since");
        needSignedHeaderSet.add("origin");
        needSignedHeaderSet.add("range");
        needSignedHeaderSet.add("response-cache-control");
        needSignedHeaderSet.add("response-content-disposition");
        needSignedHeaderSet.add("response-content-encoding");
        needSignedHeaderSet.add("response-content-language");
        needSignedHeaderSet.add("response-content-type");
        needSignedHeaderSet.add("response-expires");
        needSignedHeaderSet.add("transfer-encoding");
        needSignedHeaderSet.add("versionid");
    }

    private boolean isAnonymous(COSCredentials cred) {
        return cred instanceof AnonymousCOSCredentials;
    }

    public String buildPostObjectSignature(String secretKey, String keyTime, String policy) {
        String signKey = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, secretKey).hmacHex(keyTime);
        String stringToSign = COSSigner.sha1Hex(policy);
        return new HmacUtils(HmacAlgorithms.HMAC_SHA_1, signKey).hmacHex(stringToSign);
    }

    public String buildAuthorizationStr(HttpMethodName methodName, String resouce_path, Map<String, String> headerMap, Map<String, String> paramMap, COSCredentials cred, Date expiredTime, Boolean signHost) {
        Date startTime = new Date();
        return this.buildAuthorizationStr(methodName, resouce_path, headerMap, paramMap, cred, startTime, expiredTime, signHost);
    }

    public String buildAuthorizationStr(HttpMethodName methodName, String resouce_path, Map<String, String> headerMap, Map<String, String> paramMap, COSCredentials cred, Date startTime, Date expiredTime, Boolean signHost) {
        String qSignTimeStr;
        if (this.isAnonymous(cred)) {
            return null;
        }
        if (this.isCIWorkflowRequest.booleanValue()) {
            resouce_path = resouce_path.split("\\?")[0];
        }
        Map<String, String> signHeaders = this.buildSignHeaders(headerMap, signHost);
        TreeMap<String, String> sortedSignHeaders = new TreeMap<String, String>();
        TreeMap<String, String> sortedParams = new TreeMap<String, String>();
        sortedSignHeaders.putAll(signHeaders);
        sortedParams.putAll(paramMap);
        String qHeaderListStr = this.buildSignMemberStr(sortedSignHeaders);
        String qUrlParamListStr = this.buildSignMemberStr(sortedParams);
        String qKeyTimeStr = qSignTimeStr = this.buildTimeStr(startTime, expiredTime);
        String signKey = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, cred.getCOSSecretKey()).hmacHex(qKeyTimeStr);
        String formatMethod = methodName.toString().toLowerCase();
        String formatUri = resouce_path;
        String formatParameters = this.formatMapToStr(sortedParams);
        String formatHeaders = this.formatMapToStr(sortedSignHeaders);
        String formatStr = formatMethod + "\n" + formatUri + "\n" + formatParameters + "\n" + formatHeaders + "\n";
        String hashFormatStr = COSSigner.sha1Hex(formatStr);
        String stringToSign = "sha1" + "\n" + qSignTimeStr + "\n" + hashFormatStr + "\n";
        String signature = new HmacUtils(HmacAlgorithms.HMAC_SHA_1, signKey).hmacHex(stringToSign);
        String authoriationStr = "q-sign-algorithm" + "=" + "sha1" + "&" + "q-ak" + "=" + cred.getCOSAccessKeyId() + "&" + "q-sign-time" + "=" + qSignTimeStr + "&" + "q-key-time" + "=" + qKeyTimeStr + "&" + "q-header-list" + "=" + qHeaderListStr + "&" + "q-url-param-list" + "=" + qUrlParamListStr + "&" + "q-signature" + "=" + signature;
        return authoriationStr;
    }

    public boolean needSignedHeader(String header) {
        return needSignedHeaderSet.contains(header) || header.startsWith("x-cos-");
    }

    private Map<String, String> buildSignHeaders(Map<String, String> originHeaders, Boolean signHost) {
        Boolean hasHost = false;
        HashMap<String, String> signHeaders = new HashMap<String, String>();
        for (Map.Entry<String, String> headerEntry : originHeaders.entrySet()) {
            String key = headerEntry.getKey().toLowerCase();
            if (key.equals("host")) {
                hasHost = true;
            }
            if (!this.needSignedHeader(key)) continue;
            String value = headerEntry.getValue();
            signHeaders.put(key, value);
        }
        if (!hasHost.booleanValue() && signHost.booleanValue()) {
            String msg = String.format("buildAuthorization missing header: host. %s", originHeaders);
            throw new CosClientException(msg);
        }
        return signHeaders;
    }

    private String buildSignMemberStr(Map<String, String> signHeaders) {
        StringBuilder strBuilder = new StringBuilder();
        boolean seenOne = false;
        for (String key : signHeaders.keySet()) {
            if (!seenOne) {
                seenOne = true;
            } else {
                strBuilder.append(";");
            }
            strBuilder.append(UrlEncoderUtils.encode(key).toLowerCase());
        }
        return strBuilder.toString();
    }

    private String formatMapToStr(Map<String, String> kVMap) {
        StringBuilder strBuilder = new StringBuilder();
        boolean seeOne = false;
        for (Map.Entry<String, String> entry : kVMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String encodeKey = UrlEncoderUtils.encode(key);
            String lowerEncodeKey = encodeKey.toLowerCase();
            String encodedValue = "";
            if (value != null) {
                encodedValue = UrlEncoderUtils.encode(value);
            }
            if (!seeOne) {
                seeOne = true;
            } else {
                strBuilder.append("&");
            }
            strBuilder.append(lowerEncodeKey).append("=").append(encodedValue);
        }
        return strBuilder.toString();
    }

    private String buildTimeStr(Date startTime, Date endTime) {
        StringBuilder strBuilder = new StringBuilder();
        long startTimestamp = startTime.getTime() / 1000L + (long)this.localTimeDelta;
        long endTimestamp = endTime.getTime() / 1000L + (long)this.localTimeDelta;
        strBuilder.append(startTimestamp).append(";").append(endTimestamp);
        return strBuilder.toString();
    }

    public static Set<String> getNeedSignedHeaderSet() {
        return needSignedHeaderSet;
    }

    public static void setNeedSignedHeaderSet(Set<String> needSignedHeaderSet) {
        COSSigner.needSignedHeaderSet = needSignedHeaderSet;
    }

    public void setCIWorkflowRequest(Boolean CIRequest) {
        this.isCIWorkflowRequest = CIRequest;
    }

    public int getLocalTimeDelta() {
        return this.localTimeDelta;
    }

    public void setLocalTimeDelta(int localTimeDelta) {
        this.localTimeDelta = localTimeDelta;
    }

    public static String sha1Hex(String data) {
        return Hex.encodeHexString(COSSigner.sha1(data));
    }

    public static byte[] sha1(String data) {
        return COSSigner.sha1(HmacUtils.getBytesUtf8(data));
    }

    public static byte[] sha1(byte[] data) {
        return COSSigner.getSha1Digest().digest(data);
    }

    public static MessageDigest getSha1Digest() {
        return COSSigner.getDigest("SHA-1");
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

