/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.cos;

import com.wovoe.carpark.cloud.cos.COSConfig;
import com.wovoe.carpark.cloud.cos.COSSigner;
import com.wovoe.carpark.cloud.cos.HttpMethodName;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.http.DefaultHttpResponse;
import com.wovoe.framework.http.HttpProxy;
import com.wovoe.framework.http.HttpResponse;
import com.wovoe.framework.http.HttpUtil;
import com.wovoe.framework.http.MimeType;
import com.wovoe.framework.http.SimpleX509TrustManager;
import com.wovoe.framework.http.UrlResolution;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class COSTool {
    private static String userAgent;

    public static boolean isPostFileSuccess(KeyValueEntry<HttpResponse, byte[]> kv) {
        if (kv == null || kv.getKey() == null) {
            return true;
        }
        int code = ((HttpResponse)kv.getKey()).getResponseCode();
        return code == 204 || code == 200;
    }

    public static boolean doesObjectExist(COSConfig config, boolean https, String cosKey, int connectTimoutMills, int readTimeoutMills, Proxy proxy) throws Exception {
        String domain = config.getDomain();
        if (domain == null || domain.length() == 0) {
            domain = config.generateDomain();
        }
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
        headerMap.put("User-Agent", COSTool.getUserAgent());
        headerMap.put("Host", domain);
        Date expiredTime = new Date(System.currentTimeMillis() + 3600000L);
        COSSigner cosSigner = new COSSigner();
        cosSigner.setCIWorkflowRequest(false);
        String authoriationStr = cosSigner.buildAuthorizationStr(HttpMethodName.HEAD, "/" + cosKey, headerMap, new HashMap<String, String>(), config, expiredTime, true);
        headerMap.put("Authorization", authoriationStr);
        String requestUrl = https ? "https://" : "http://";
        requestUrl = String.valueOf(requestUrl) + domain + "/" + cosKey;
        UrlResolution resol = HttpUtil.getUrlResolution();
        if (resol != null) {
            requestUrl = resol.resolution(requestUrl, 0, proxy);
        }
        HttpURLConnection httpUrlConn = null;
        DefaultHttpResponse result = null;
        try {
            if (requestUrl.startsWith("https://")) {
                TrustManager[] tm = new TrustManager[]{new SimpleX509TrustManager()};
                SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                URL url = new URL(requestUrl);
                if (proxy == null) {
                    proxy = HttpProxy.getProxy((String)requestUrl);
                }
                HttpsURLConnection httpUrlConn1 = proxy == null ? (HttpsURLConnection)url.openConnection() : (HttpsURLConnection)url.openConnection(proxy);
                httpUrlConn1.setSSLSocketFactory(ssf);
                httpUrlConn = httpUrlConn1;
            } else {
                URL url = new URL(requestUrl);
                if (proxy == null) {
                    proxy = HttpProxy.getProxy((String)requestUrl);
                }
                httpUrlConn = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            }
            httpUrlConn.setRequestMethod("HEAD");
            for (Map.Entry e : headerMap.entrySet()) {
                Object a1;
                Object a;
                Object ao = e.getValue();
                if (ao == null) continue;
                if (ao instanceof String[]) {
                    a = (String[])ao;
                    String[] stringArray = a;
                    int n = ((String[])a).length;
                    int n2 = 0;
                    while (n2 < n) {
                        a1 = stringArray[n2];
                        httpUrlConn.addRequestProperty((String)e.getKey(), (String)a1);
                        ++n2;
                    }
                    continue;
                }
                if (ao instanceof Collection) {
                    a = (Collection)ao;
                    Iterator iterator = a.iterator();
                    while (iterator.hasNext()) {
                        a1 = iterator.next();
                        httpUrlConn.addRequestProperty((String)e.getKey(), a1.toString());
                    }
                    continue;
                }
                httpUrlConn.setRequestProperty((String)e.getKey(), ao.toString());
            }
            if (connectTimoutMills > 0) {
                httpUrlConn.setConnectTimeout(connectTimoutMills);
            }
            if (readTimeoutMills > 0) {
                httpUrlConn.setReadTimeout(readTimeoutMills);
            }
            httpUrlConn.setUseCaches(false);
            httpUrlConn.connect();
            result = new DefaultHttpResponse(httpUrlConn.getHeaderFields(), httpUrlConn.getResponseCode(), httpUrlConn.getResponseMessage(), httpUrlConn.getContentLengthLong(), httpUrlConn.getContentEncoding(), httpUrlConn.getContentType());
        }
        finally {
            if (httpUrlConn != null) {
                try {
                    httpUrlConn.disconnect();
                }
                catch (Exception exception) {}
            }
        }
        if (result.getResponseCode() == 200) {
            return true;
        }
        if (result.getResponseCode() == 404) {
            return false;
        }
        throw new IOException(String.valueOf(result.getResponseCode()) + ": " + result.getResponseMessage());
    }

    public static KeyValueEntry<HttpResponse, byte[]> postFile(COSConfig config, boolean https, String cosKey, HttpUtil.FileEntry entry, int connectTimoutMills, int readTimeoutMills, Proxy proxy) throws Exception {
        KeyValueEntry returnKv;
        block31: {
            HttpURLConnection conn;
            String contentType = MimeType.getByFilename((String)entry.getFileName());
            if (contentType == null || contentType.length() == 0) {
                contentType = "application/octet-stream";
            }
            String postUrl = https ? "https://" : "http://";
            String postDomain = config.getDomain();
            if (postDomain == null || postDomain.length() == 0) {
                postDomain = config.generateDomain();
            }
            postUrl = String.valueOf(postUrl) + postDomain;
            UrlResolution resol = HttpUtil.getUrlResolution();
            if (resol != null) {
                postUrl = resol.resolution(postUrl, 1, proxy);
            }
            long startTimestamp = System.currentTimeMillis() / 1000L;
            long endTimestamp = startTimestamp + 1800L;
            String endTimestampStr = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(endTimestamp * 1000L);
            String keyTime = String.valueOf(startTimestamp) + ";" + endTimestamp;
            String boundary = "----WebKitFormBoundaryZBPbaoYE2gqeB21N";
            HashMap<String, String> formFields = new HashMap<String, String>();
            formFields.put("q-sign-algorithm", "sha1");
            formFields.put("key", cosKey);
            formFields.put("q-ak", config.getSecretId());
            formFields.put("q-key-time", keyTime);
            if (config.getStorageClass() != null && config.getStorageClass().length() > 0) {
                formFields.put("x-cos-storage-class", config.getStorageClass());
            }
            String policy = "{\n    \"expiration\": \"" + endTimestampStr + "\",\n" + "    \"conditions\": [\n" + "        { \"bucket\": \"" + config.getBucket() + "\" },\n" + "        { \"q-sign-algorithm\": \"sha1\" },\n" + "        { \"q-ak\": \"" + config.getSecretId() + "\" },\n" + "        { \"q-sign-time\":\"" + keyTime + "\" }\n" + "    ]\n" + "}";
            String encodedPolicy = Base64.getEncoder().encodeToString(policy.getBytes("UTF-8"));
            formFields.put("policy", encodedPolicy);
            COSSigner cosSigner = new COSSigner();
            String signature = cosSigner.buildPostObjectSignature(config.getSeretKey(), keyTime, policy);
            formFields.put("q-signature", signature);
            String formBody = COSTool.buildPostObjectBody(boundary, formFields, entry.getFileName(), entry.getFieldName(), contentType);
            returnKv = new KeyValueEntry();
            if (postUrl.startsWith("https://")) {
                TrustManager[] tm = new TrustManager[]{new SimpleX509TrustManager()};
                SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                URL url = new URL(postUrl);
                if (proxy == null) {
                    proxy = HttpProxy.getProxy((String)postUrl);
                }
                HttpsURLConnection httpUrlConn1 = proxy == null ? (HttpsURLConnection)url.openConnection() : (HttpsURLConnection)url.openConnection(proxy);
                httpUrlConn1.setSSLSocketFactory(ssf);
                conn = httpUrlConn1;
            } else {
                URL url = new URL(postUrl);
                if (proxy == null) {
                    proxy = HttpProxy.getProxy((String)postUrl);
                }
                conn = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
            }
            try {
                if (connectTimoutMills > 0) {
                    conn.setConnectTimeout(connectTimoutMills);
                }
                if (readTimeoutMills > 0) {
                    conn.setReadTimeout(readTimeoutMills);
                }
                conn.setUseCaches(false);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("User-Agent", COSTool.getUserAgent());
                conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                conn.setDoOutput(true);
                conn.setDoInput(true);
                OutputStream out = conn.getOutputStream();
                out.write(formBody.getBytes());
                byte[] bytes = new byte[4096];
                try (InputStream in = entry.getInputStream();){
                    int readBytes;
                    while ((readBytes = in.read(bytes)) != -1) {
                        out.write(bytes, 0, readBytes);
                    }
                }
                byte[] endData = ("\r\n--" + boundary + "--\r\n").getBytes();
                out.write(endData);
                out.flush();
                out.close();
                conn.connect();
                DefaultHttpResponse response = new DefaultHttpResponse(conn.getHeaderFields(), conn.getResponseCode(), conn.getResponseMessage(), conn.getContentLengthLong(), conn.getContentEncoding(), conn.getContentType());
                returnKv.setKey((Object)response);
                if (response.getResponseCode() != 200) break block31;
                InputStream readIn = conn.getInputStream();
                try {
                    int readBytes;
                    ByteArrayOutputStream sout = new ByteArrayOutputStream();
                    while ((readBytes = readIn.read(bytes)) != -1) {
                        sout.write(bytes, 0, readBytes);
                    }
                    returnKv.setValue((Object)sout.toByteArray());
                }
                finally {
                    try {
                        readIn.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return returnKv;
    }

    private static String buildPostObjectBody(String boundary, Map<String, String> formFields, String filename, String fileFieldName, String contentType) {
        if (fileFieldName == null || fileFieldName.length() == 0) {
            fileFieldName = "file";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry<String, String> entry : formFields.entrySet()) {
            stringBuffer.append("--").append(boundary).append("\r\n");
            stringBuffer.append("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"\r\n\r\n");
            stringBuffer.append(String.valueOf(entry.getValue()) + "\r\n");
        }
        stringBuffer.append("--").append(boundary).append("\r\n");
        stringBuffer.append("Content-Disposition: form-data; name=\"" + fileFieldName + "\"; " + "filename=\"" + filename + "\"\r\n");
        stringBuffer.append("Content-Type: " + contentType + "\r\n\r\n");
        return stringBuffer.toString();
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            userAgent = String.format("cos-java-sdk-v%s/%s/jdk-%s/%s", "5.6.89", "Windows 10", "1.8.0_144", "Java HotSpot(TM) 64-Bit Server VM");
        }
        return userAgent;
    }
}

