/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.cos;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlEncoderUtils {
    private static final String PATH_DELIMITER = "/";
    private static final String ENCODE_DELIMITER = "%2F";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static Log log = LogFactory.getLog(UrlEncoderUtils.class);

    public static String encode(String originUrl) {
        try {
            return URLEncoder.encode(originUrl, DEFAULT_ENCODING).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"URLEncoder error, exception: {}", (Throwable)e);
            return null;
        }
    }

    public static String encodeEscapeDelimiter(String urlPath) {
        StringBuilder pathBuilder = new StringBuilder();
        String[] pathSegmentsArr = urlPath.split(PATH_DELIMITER);
        boolean isFirstSegMent = true;
        String[] stringArray = pathSegmentsArr;
        int n = pathSegmentsArr.length;
        int n2 = 0;
        while (n2 < n) {
            String pathSegment = stringArray[n2];
            if (isFirstSegMent) {
                pathBuilder.append(UrlEncoderUtils.encode(pathSegment));
                isFirstSegMent = false;
            } else {
                pathBuilder.append(PATH_DELIMITER).append(UrlEncoderUtils.encode(pathSegment));
            }
            ++n2;
        }
        if (urlPath.endsWith(PATH_DELIMITER)) {
            pathBuilder.append(PATH_DELIMITER);
        }
        return pathBuilder.toString();
    }

    public static String encodeUrlPath(String urlPath) {
        if (urlPath.length() <= 1) {
            return urlPath;
        }
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(PATH_DELIMITER);
        int start = 1;
        int end = 1;
        while (end < urlPath.length()) {
            if ('/' == urlPath.charAt(end)) {
                if ('/' == urlPath.charAt(end - 1)) {
                    pathBuilder.append(ENCODE_DELIMITER);
                } else {
                    pathBuilder.append(UrlEncoderUtils.encode(urlPath.substring(start, end))).append(PATH_DELIMITER);
                }
                start = end + 1;
            }
            ++end;
        }
        if (start < end) {
            pathBuilder.append(UrlEncoderUtils.encode(urlPath.substring(start, end)));
        }
        return pathBuilder.toString();
    }

    public static String urlDecode(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

