/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.trtc;

import com.sun.jna.Native;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.cloud.client.CarparkHostSyncRemoteService;
import com.wovoe.carpark.cloud.trtc.TRTCCallCallback;
import com.wovoe.carpark.cloud.trtc.TRTCCallManager;
import com.wovoe.carpark.cloud.trtc.TRTCCloudCallback;
import com.wovoe.carpark.cloud.trtc.TRTCConstants;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.event.app.AcceptCallEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.awt.Component;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultTRTCCallManager
implements TRTCCallManager,
TRTCCloudCallback {
    private volatile boolean calling = false;
    private volatile boolean enterRoom = false;
    private volatile int callType;
    private volatile int roleType;
    private volatile String userId = "";
    private volatile String userName = "";
    private volatile String remoteUserId = "";
    private volatile String remoteUserName = "";
    private volatile String channelNo = "";
    private volatile int roomId;
    private volatile String userSig = "";
    private volatile int sdkAppId;
    private volatile boolean payingRingtone;
    private volatile long nativeLocalVideoView;
    private volatile long nateiveRemoteVideoView;
    private volatile String currentDisplayRemoteVideoUserId;
    private final Object diplayVideoLock = new Object();
    private CopyOnWriteArrayList<TRTCCallCallback> callbackList = new CopyOnWriteArrayList();

    @Override
    public boolean isCalling() {
        return this.calling;
    }

    @Override
    public boolean isEnterRoom() {
        return this.enterRoom;
    }

    @Override
    public int getCallType() {
        return this.callType;
    }

    @Override
    public int getRoleType() {
        return this.roleType;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public int getRoomId() {
        return this.roomId;
    }

    @Override
    public String getRemoteUserId() {
        return this.remoteUserId;
    }

    @Override
    public String getRemoteUserName() {
        return this.remoteUserName;
    }

    @Override
    public String getChannelNo() {
        return this.channelNo;
    }

    @Override
    public synchronized KeyValueEntry<Integer, String> acceptCall(int sdkAppId, int roomId, int callType, String acceptUserId, String acceptUserName, String acceptUserSig, String callUserId, String callUserName, String channelNo, boolean autoAnswer) {
        if (this.isCalling()) {
            return new KeyValueEntry((Object)1, (Object)"\u5f53\u524d\u6b63\u5728\u901a\u8bdd\u4e2d");
        }
        if (sdkAppId == 0 || roomId == 0 || callType != 1 && callType != 2 || acceptUserId == null || acceptUserId.length() == 0 || acceptUserSig == null || acceptUserSig.length() == 0) {
            return new KeyValueEntry((Object)2, (Object)"\u53c2\u6570\u9519\u8bef");
        }
        if (acceptUserName == null) {
            acceptUserName = "";
        }
        if (callUserName == null) {
            callUserName = "";
        }
        this.sdkAppId = sdkAppId;
        this.roomId = roomId;
        this.callType = callType;
        this.roleType = 2;
        this.userId = acceptUserId;
        this.userName = acceptUserName;
        this.userSig = acceptUserSig;
        this.remoteUserId = callUserId;
        this.remoteUserName = callUserName;
        this.channelNo = channelNo;
        try {
            this.calling = true;
            ServiceUtil.getServiceContext().getTRTCCloudContext().registerTRTCCloudCallback(this);
            if (!autoAnswer) {
                this.startRingtone();
            }
            AcceptCallEvent event = new AcceptCallEvent(this, autoAnswer);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
        }
        catch (Throwable ex) {
            if (this.payingRingtone) {
                this.stopRingtone();
            }
            ServiceUtil.getServiceContext().getTRTCCloudContext().removeTRTCCloudCallback(this);
            this.clear();
            ServiceLog.getLog().warn((Object)"\u63a5\u542c\u7535\u8bdd\u5f02\u5e38! ", ex);
            return new KeyValueEntry((Object)500, (Object)"\u5185\u90e8\u9519\u8bef");
        }
        return new KeyValueEntry((Object)0, (Object)"\u64cd\u4f5c\u6210\u529f");
    }

    public void startRingtone() {
        int result;
        File file = new File(PathFinder.findHomeDir(), "native/WLYKTRTC/ringtone.mp3");
        if (file.exists() && file.isFile() && (result = ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().startSpeaker(file.getAbsolutePath())) == 0) {
            this.payingRingtone = true;
        }
    }

    public void stopRingtone() {
        if (this.payingRingtone) {
            this.payingRingtone = false;
            try {
                ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopSpeaker();
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)"\u5173\u95ed\u94c3\u58f0\u5f02\u5e38! ", ex);
            }
        }
    }

    private void clear() {
        this.calling = false;
        this.enterRoom = false;
        this.callType = 0;
        this.roleType = 0;
        this.userId = "";
        this.userName = "";
        this.remoteUserId = "";
        this.remoteUserName = "";
        this.channelNo = "";
        this.roomId = 0;
        this.userSig = "";
        this.sdkAppId = 0;
        this.payingRingtone = false;
        this.nativeLocalVideoView = 0L;
        this.nateiveRemoteVideoView = 0L;
        this.currentDisplayRemoteVideoUserId = null;
    }

    @Override
    public void hangUp() {
        if (!this.isCalling()) {
            return;
        }
        this.hangUp(false);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void hangUp(boolean sdkRelease) {
        if (!this.isCalling()) {
            return;
        }
        if (sdkRelease) {
            try {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u975e\u6b63\u5e38\u6302\u65ad\u901a\u8bdd! \u5e95\u5c42\u5185\u90e8\u9519\u8bef", 4));
            }
            catch (Exception var2_2) {
                // empty catch block
            }
        }
        hangupMap = this.getNofifyHanupMap();
        try {
            if (sdkRelease) ** break block22
            if (this.payingRingtone) {
                this.stopRingtone();
            }
            if (this.isEnterRoom()) {
                try {
                    if (this.callType == 2) {
                        ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopLocalPreview();
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u505c\u6b62\u672c\u5730\u89c6\u9891\u5f02\u5e38! " + ex.getMessage()));
                }
                try {
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopLocalAudio();
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u505c\u6b62\u672c\u5730\u97f3\u9891\u5f02\u5e38! " + ex.getMessage()));
                }
                try {
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().exitRoom();
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u9000\u51fa\u623f\u95f4\u5f02\u5e38! " + ex.getMessage()));
                }
            }
            break block23;
        }
        finally {
            ServiceUtil.getServiceContext().getTRTCCloudContext().removeTRTCCloudCallback(this);
            this.clear();
            if (hangupMap != null) {
                this.notifyStatus(hangupMap);
            }
            var6_10 = this.callbackList.iterator();
            if (true) ** GOTO lbl51
        }
        {
            block23: {
            }
        }
        do {
            back = var6_10.next();
            try {
                back.onHangup();
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u6302\u65ad\u5f02\u5e38\u56de\u8c03! ", (Throwable)ex);
            }
lbl51:
            // 3 sources

        } while (var6_10.hasNext());
    }

    @Override
    public KeyValueEntry<Integer, String> queryAcceptRoomStatus() {
        try {
            CloudResultResponse resultResponse;
            if (!this.isCalling()) {
                return new KeyValueEntry((Object)10000, (Object)"\u72b6\u6001\u9519\u8bef\uff0c\u5f53\u524d\u4e0d\u662f\u901a\u8bdd\u72b6\u6001");
            }
            if (this.roleType != 2) {
                return new KeyValueEntry((Object)10001, (Object)"\u72b6\u6001\u9519\u8bef\uff0c\u5f53\u524d\u4e0d\u662f\u63a5\u542c\u72b6\u6001");
            }
            CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
            if (localConfig.getCarpark_deploy_type() != 1) {
                return new KeyValueEntry((Object)10002, (Object)"\u72b6\u6001\u9519\u8bef\uff0c\u5f53\u524d\u4e0d\u662f\u4e91\u7aef\u90e8\u7f72");
            }
            CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
            if (serverHost == null) {
                return new KeyValueEntry((Object)10003, (Object)"\u914d\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u627e\u5230\u4e91\u7aef\u4e3b\u673a");
            }
            if (serverHost.getHost_type() != 2) {
                return new KeyValueEntry((Object)10003, (Object)"\u914d\u7f6e\u9519\u8bef\uff0c\u4e91\u7aef\u4e3b\u673a\u7c7b\u578b\u9519\u8bef");
            }
            RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(serverHost.getHost_no(), true);
            if (rpc == null) {
                return new KeyValueEntry((Object)10004, (Object)"\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
            }
            CarparkHostSyncRemoteService carparkHostSyncRemoteService = rpc.crateRemoteService(CarparkHostSyncRemoteService.class);
            if (carparkHostSyncRemoteService == null) {
                return new KeyValueEntry((Object)10004, (Object)"\u672a\u80fd\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668");
            }
            HashMap<String, Object> requestMap = new HashMap<String, Object>();
            requestMap.put("room_id", String.valueOf(this.getRoomId()));
            requestMap.put("userId", this.getUserId());
            requestMap.put("userName", this.getUserName());
            try {
                resultResponse = carparkHostSyncRemoteService.queryVideoCallRoomStatus(requestMap);
                if (resultResponse == null) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u67e5\u8be2\u623f\u95f4\u72b6\u6001\u5f02\u5e38\uff01", (Throwable)ex);
                return new KeyValueEntry((Object)10005, (Object)"\u4e0e\u4e91\u7aef\u5efa\u7acb\u8fde\u63a5\u5931\u8d25\uff0c\u7f51\u7edc\u5f02\u5e38");
            }
            if (!resultResponse.isSuccess()) {
                ServiceLog.getLog().warn((Object)("\u67e5\u8be2\u623f\u95f4\u72b6\u6001\u5f02\u5e38\uff01\u539f\u56e0\uff1a" + resultResponse.getResponseMsg()));
                return new KeyValueEntry((Object)10006, (Object)("\u4e0e\u4e91\u7aef\u901a\u4fe1\u5931\u8d25\uff01\u539f\u56e0\uff1a" + resultResponse.getResponseMsg()));
            }
            String room_status = (String)resultResponse.get("room_status");
            if (room_status == null || room_status.length() == 0) {
                ServiceLog.getLog().warn((Object)"\u67e5\u8be2\u623f\u95f4\u72b6\u6001\u5f02\u5e38\uff01\u539f\u56e0\uff1a \u7f3a\u5c11\u54cd\u5e94\u53c2\u6570room_status");
                return new KeyValueEntry((Object)10006, (Object)"\u4e0e\u4e91\u7aef\u901a\u4fe1\u5931\u8d25\uff01\u539f\u56e0: \u7f3a\u5c11\u54cd\u5e94\u53c2\u6570");
            }
            if ("0".equals(room_status)) {
                return new KeyValueEntry((Object)0, (Object)"\u53ef\u52a0\u5165\u623f\u95f4");
            }
            if ("1".equals(room_status)) {
                return new KeyValueEntry((Object)1, (Object)"\u901a\u8bdd\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u63a5\u542c");
            }
            return new KeyValueEntry((Object)2, (Object)"\u5bf9\u65b9\u5df2\u6302\u65ad");
        }
        catch (Throwable ex) {
            ServiceLog.getLog().warn((Object)"\u67e5\u8be2\u623f\u95f4\u72b6\u6001\u9519\u8bef", ex);
            return new KeyValueEntry((Object)500, (Object)"\u5185\u90e8\u9519\u8bef");
        }
    }

    @Override
    public synchronized KeyValueEntry<Integer, String> enterRoom(Component localVideoComponent, Component remoteVideoCompent) {
        if (!this.isCalling()) {
            return new KeyValueEntry((Object)2, (Object)"\u72b6\u6001\u9519\u8bef\uff0c\u5f53\u524d\u4e0d\u662f\u901a\u8bdd\u72b6\u6001");
        }
        if (this.isEnterRoom()) {
            return new KeyValueEntry((Object)2, (Object)"\u72b6\u6001\u9519\u8bef\uff0c\u5df2\u8fdb\u5165\u901a\u8bdd\uff0c\u8bf7\u5148\u6302\u65ad");
        }
        if (this.roleType == 2) {
            this.stopRingtone();
        }
        if (this.callType == 2) {
            if (localVideoComponent == null || remoteVideoCompent == null) {
                return new KeyValueEntry((Object)1, (Object)"\u53c2\u6570\u9519\u8bef\uff0c\u89c6\u9891\u901a\u8bdd\u7684\u89c6\u9891\u9884\u89c8\u753b\u9762\u4e3aNULL");
            }
            this.nativeLocalVideoView = Native.getComponentID((Component)localVideoComponent);
            this.nateiveRemoteVideoView = Native.getComponentID((Component)remoteVideoCompent);
            if (this.nativeLocalVideoView == 0L) {
                return new KeyValueEntry((Object)1, (Object)"\u53c2\u6570\u9519\u8bef\uff0c\u672c\u5730\u89c6\u9891\u7a97\u53e3\u672a\u6253\u5f00");
            }
            if (this.nateiveRemoteVideoView == 0L) {
                return new KeyValueEntry((Object)1, (Object)"\u53c2\u6570\u9519\u8bef\uff0c\u8fdc\u7a0b\u89c6\u9891\u7a97\u53e3\u672a\u6253\u5f00");
            }
            try {
                ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().setBeautyStyle(1, 5, 1, 0);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u89c6\u9891\u7f8e\u989c\u6548\u679c\u5f02\u5e38: " + ex.getMessage()));
            }
            try {
                int videoResolution = 112;
                int resMode = 1;
                int videoFps = 15;
                int videoBitrate = TRTCConstants.getVideoBitrate(videoResolution);
                int minVideoBitrate = 0;
                boolean enableAdjustRes = true;
                ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().setVideoEncoderParam(videoResolution, resMode, videoFps, videoBitrate, minVideoBitrate, enableAdjustRes);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u672c\u5730\u89c6\u9891\u7f16\u7801\u5f02\u5e38: " + ex.getMessage()));
                return new KeyValueEntry((Object)3, (Object)"\u8bbe\u7f6e\u672c\u5730\u89c6\u9891\u7f16\u7801\u683c\u5f0f\u5931\u8d25");
            }
            try {
                ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().startLocalPreview(this.nativeLocalVideoView);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u9884\u89c8\u672c\u5730\u89c6\u9891\u5f02\u5e38: " + ex.getMessage()));
                return new KeyValueEntry((Object)4, (Object)"\u9884\u89c8\u672c\u5730\u89c6\u9891\u5f02\u5e38");
            }
        }
        try {
            ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().startLocalAudio(1);
        }
        catch (Exception ex) {
            if (this.callType == 2) {
                try {
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopLocalPreview();
                }
                catch (Exception ex1) {
                    ServiceLog.getLog().warn((Object)("\u505c\u6b62\u672c\u5730\u89c6\u9891\u9884\u89c8\u5f02\u5e38\uff01" + ex.getMessage()));
                }
            }
            ServiceLog.getLog().warn((Object)("\u542f\u52a8\u672c\u5730\u9ea6\u514b\u98ce\u97f3\u9891\u5f02\u5e38\uff01" + ex.getMessage()));
            return new KeyValueEntry((Object)5, (Object)"\u542f\u52a8\u672c\u5730\u9ea6\u514b\u98ce\u97f3\u9891\u5f02\u5e38");
        }
        try {
            int scene = this.callType == 2 ? 0 : 2;
            int role = 20;
            ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().enterRoom(this.sdkAppId, this.userId, this.userSig, this.roomId, role, scene);
            this.enterRoom = true;
        }
        catch (Throwable ex) {
            this.enterRoom = false;
            if (this.callType == 2) {
                try {
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopLocalPreview();
                }
                catch (Exception ex1) {
                    ServiceLog.getLog().warn((Object)("\u505c\u6b62\u672c\u5730\u89c6\u9891\u9884\u89c8\u5f02\u5e38\uff01" + ex.getMessage()));
                }
            }
            try {
                ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopLocalAudio();
            }
            catch (Exception ex1) {
                ServiceLog.getLog().warn((Object)("\u505c\u7528\u672c\u5730\u97f3\u9891\u5f02\u5e38\uff01" + ex.getMessage()));
            }
            ServiceLog.getLog().warn((Object)("\u8fdb\u5165\u623f\u95f4\u5931\u8d25\uff01" + ex.getMessage()));
        }
        return new KeyValueEntry((Object)0, (Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    public void addTRTCCallCallback(TRTCCallCallback callback) {
        if (callback != null) {
            this.callbackList.add(callback);
        }
    }

    @Override
    public void removeTRTCCallCallback(TRTCCallCallback callback) {
        if (callback != null) {
            this.callbackList.remove(callback);
        }
    }

    private Map<String, Object> getNofifyHanupMap() {
        if (!this.isCalling()) {
            return null;
        }
        if (!this.isEnterRoom()) {
            return null;
        }
        HashMap<String, Object> requestMap = null;
        if (this.roleType == 2) {
            requestMap = new HashMap<String, Object>();
            requestMap.put("room_id", String.valueOf(this.getRoomId()));
            requestMap.put("option", "2");
            requestMap.put("role", "1");
            requestMap.put("user_id", this.getUserId());
            requestMap.put("user_name", this.getUserId());
        } else if (this.roleType == 1) {
            requestMap = new HashMap();
            requestMap.put("room_id", String.valueOf(this.getRoomId()));
            requestMap.put("option", "2");
            requestMap.put("role", "2");
            requestMap.put("user_id", this.getUserId());
            requestMap.put("user_name", this.getUserId());
        }
        return requestMap;
    }

    private void notifyAnswerEnterRoom() {
        if (!this.isCalling()) {
            return;
        }
        if (this.roleType != 2) {
            return;
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("room_id", String.valueOf(this.getRoomId()));
        requestMap.put("option", "1");
        requestMap.put("role", "1");
        requestMap.put("user_id", this.getUserId());
        requestMap.put("user_name", this.getUserName());
        this.notifyStatus(requestMap);
    }

    private void notifyStatus(final Map<String, Object> requestMap) {
        try {
            if (requestMap == null) {
                return;
            }
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        CloudResultResponse resultResponse;
                        CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                        if (localConfig.getCarpark_deploy_type() != 1) {
                            return;
                        }
                        CarparkHost serverHost = ServiceUtil.getServiceContext().getDBConfigCache().getCarparkServerHost();
                        if (serverHost == null) {
                            return;
                        }
                        if (serverHost.getHost_type() != 2) {
                            return;
                        }
                        RpcReomtecServiceFactory rpc = ServiceUtil.getServiceContext().createRpcReomtecServiceFactory(serverHost.getHost_no(), true);
                        if (rpc == null) {
                            ServiceLog.getLog().warn((Object)"\u901a\u77e5\u623f\u95f4\u72b6\u6001\u5931\u8d25\uff01 \u672a\u80fd\u8fde\u63a5\u4e91\u7aef");
                            return;
                        }
                        CarparkHostSyncRemoteService carparkHostSyncRemoteService = rpc.crateRemoteService(CarparkHostSyncRemoteService.class);
                        if (carparkHostSyncRemoteService == null) {
                            ServiceLog.getLog().warn((Object)"\u901a\u77e5\u623f\u95f4\u72b6\u6001\u5931\u8d25\uff01 \u672a\u80fd\u8fde\u63a5\u4e91\u7aef");
                            return;
                        }
                        try {
                            resultResponse = carparkHostSyncRemoteService.callNotify(requestMap);
                            if (resultResponse == null) {
                                throw new Exception();
                            }
                        }
                        catch (Exception ex) {
                            ServiceLog.getLog().warn((Object)"\u901a\u77e5\u623f\u95f4\u72b6\u6001\u7f51\u7edc\u5f02\u5e38\uff01", (Throwable)ex);
                            return;
                        }
                        if (!resultResponse.isSuccess()) {
                            ServiceLog.getLog().warn((Object)("\u67e5\u8be2\u623f\u95f4\u72b6\u6001\u64cd\u4f5c\u5931\u8d25\uff01\u539f\u56e0\uff1a" + resultResponse.getResponseMsg()));
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u901a\u77e5\u623f\u95f4\u72b6\u6001\u5f02\u5e38\uff01" + ex.getMessage()));
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onError(int errCode, String errMsg) {
        ServiceLog.getLog().error((Object)("TRTC\u901a\u8bdd\u9519\u8bef\uff0c\u9519\u8bef\u4ee3\u7801\uff1a" + errCode + ", \u9519\u8bef\u63cf\u8ff0\uff1a" + errMsg));
    }

    @Override
    public void onWarning(int warningCode, String warningMsg) {
        ServiceLog.getLog().warn((Object)("TRTC\u901a\u8bdd-->\uff1a" + warningCode + ", \u9519\u8bef\u63cf\u8ff0\uff1a" + warningMsg));
    }

    @Override
    public void onEnterRoom(int result) {
        if (result < 0) {
            ServiceLog.getLog().warn((Object)("\u8fdb\u5165\u623f\u95f4" + this.roomId + "\u5931\u8d25\uff01 \u9519\u8bef\u4ee3\u7801\uff1a" + result));
            if (this.isCalling()) {
                if (this.roleType == 2) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u63a5\u542c\u5931\u8d25\uff01 \u9519\u8bef\u4ee3\u7801\uff1a" + result, 4));
                } else if (this.roleType == 1) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u547c\u53eb\u5931\u8d25\uff01 \u9519\u8bef\u4ee3\u7801\uff1a" + result, 4));
                }
            } else {
                this.hangUp();
            }
        } else if (this.roleType == 2) {
            this.notifyAnswerEnterRoom();
            ServiceLog.getLog().info((Object)("\u63a5\u542c\u8fdb\u5165\u623f\u95f4: " + this.roomId + ", \u8017\u65f6\uff1a" + result + "\u6beb\u79d2"));
        } else if (this.roleType == 1) {
            ServiceLog.getLog().info((Object)("\u547c\u53eb\u8fdb\u5165\u623f\u95f4: " + this.roomId + ", \u8017\u65f6\uff1a" + result + "\u6beb\u79d2"));
        } else {
            ServiceLog.getLog().warn((Object)("\u4e0d\u5e94\u8be5\u51fa\u73b0\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\uff0c\u8fdb\u5165\u623f\u95f4\u6210\u529f\uff0c\u4f46\u662f(\u547c\u53eb\u4e0e\u63a5\u542c\u72b6\u6001\u9519\u8bef) \u8fdb\u5165\u623f\u95f4: " + this.roomId + ", \u8017\u65f6\uff1a" + result + "\u6beb\u79d2"));
        }
    }

    @Override
    public void onExitRoom(int reason) {
        ServiceLog.getLog().info((Object)("\u9000\u51fa\u623f\u95f4: " + this.roomId + ", reason\uff1a" + reason));
    }

    @Override
    public void onRemoteUserEnterRoom(String userId) {
        if (this.roleType == 2 && !this.remoteUserId.equals(userId)) {
            ServiceLog.getLog().warn((Object)("\u6709\u975e\u547c\u53eb\u65b9\u52a0\u5165\u4e86\u89c6\u9891\u5bf9\u8bdd\uff01\u8003\u8651\u5e73\u53f0\u8c03\u5ea6\u662f\u5426\u51fa\u73b0\u903b\u8f91\u95ee\u9898\uff01\u8fd9\u662f\u4e00\u5bf9\u4e00\u89c6\u9891\u901a\u8bdd\uff0c\u4e0d\u5e94\u8be5\u51fa\u73b0\u8fd9\u79cd\u60c5\u51b5\uff01\u547c\u53eb\u65b9userId: " + this.remoteUserId + ", \u52a0\u5165\u901a\u8bdd\u7684user_id: " + userId));
        }
    }

    @Override
    public void onRemoteUserLeaveRoom(String userId, int reason) {
        if (this.roleType == 2) {
            if (this.remoteUserId.equals(userId)) {
                if (this.isCalling()) {
                    ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, "\u5f53\u524d\u901a\u8bdd\u5df2\u7ed3\u675f\uff0c\u5bf9\u65b9\u5df2\u6302\u65ad\u3002", 1));
                    this.hangUp();
                }
            } else {
                ServiceLog.getLog().warn((Object)("\u6709\u975e\u547c\u53eb\u65b9\u9000\u51fa\u4e86\u901a\u8bdd\uff01\u547c\u53eb\u65b9userId: " + this.remoteUserId + ", \u52a0\u5165\u901a\u8bdd\u7684user_id: " + userId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUserVideoAvailable(String userId, boolean available) {
        if (userId == null) {
            return;
        }
        Object object = this.diplayVideoLock;
        synchronized (object) {
            if (this.roleType == 2) {
                if (available) {
                    if (this.nateiveRemoteVideoView != 0L) {
                        if (this.currentDisplayRemoteVideoUserId == null) {
                            ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().startRemoteView(userId, 0, this.nateiveRemoteVideoView);
                            this.currentDisplayRemoteVideoUserId = userId;
                        } else if (userId.equals(this.remoteUserId)) {
                            if (this.currentDisplayRemoteVideoUserId != null && !userId.equals(this.currentDisplayRemoteVideoUserId)) {
                                ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopRemoteView(this.currentDisplayRemoteVideoUserId, 0);
                            }
                            ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().startRemoteView(userId, 0, this.nateiveRemoteVideoView);
                            this.currentDisplayRemoteVideoUserId = userId;
                        } else if (!userId.equals(this.currentDisplayRemoteVideoUserId)) {
                            ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopRemoteView(userId, 0);
                        } else {
                            ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().startRemoteView(userId, 0, this.nateiveRemoteVideoView);
                            this.currentDisplayRemoteVideoUserId = userId;
                        }
                    }
                } else if (this.currentDisplayRemoteVideoUserId != null && userId.equals(this.currentDisplayRemoteVideoUserId)) {
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().stopRemoteView(userId, 0);
                    this.currentDisplayRemoteVideoUserId = null;
                }
            }
        }
    }

    @Override
    public void onUserAudioAvailable(String userId, boolean available) {
    }

    @Override
    public void onFirstVideoFrame(String userId, int streamType, int width, int height) {
    }

    @Override
    public void onFirstAudioFrame(String userId) {
    }

    @Override
    public void onSendFirstLocalVideoFrame(int streamType) {
    }

    @Override
    public void onSendFirstLocalAudioFrame() {
    }

    @Override
    public void onConnectionLost() {
    }

    @Override
    public void onTryToReconnect() {
    }

    @Override
    public void onConnectionRecovery() {
    }

    @Override
    public void onCameraDidReady() {
    }

    @Override
    public void onMicDidReady() {
    }

    @Override
    public void onAudioDeviceCaptureVolumeChanged(int volume, boolean muted) {
    }

    @Override
    public void onAudioDevicePlayoutVolumeChanged(int volume, boolean muted) {
    }

    @Override
    public void nativeSdkRelease() {
        if (!this.isCalling()) {
            return;
        }
        this.hangUp(true);
    }
}

