/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.trtc;

import com.wovoe.carpark.cloud.trtc.DefaultTRTCCallManager;
import com.wovoe.carpark.cloud.trtc.TRTCCallManager;
import com.wovoe.carpark.cloud.trtc.TRTCCloudCallback;
import com.wovoe.carpark.cloud.trtc.TRTCCloudContext;
import com.wovoe.carpark.cloud.trtc.TRTCCloudFacade;
import com.wovoe.carpark.cloud.trtc.TRTCCloudProcessor;
import com.wovoe.carpark.cloud.trtc.TRTCCloudSdkProxy;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public class DefaultTRTCCloudContext
implements TRTCCloudContext,
TRTCCloudCallback {
    private TRTCCloudProcessor trtcCloudProcessor;
    private TRTCCloudFacade trtcCloudFacade;
    private CopyOnWriteArrayList<TRTCCloudCallback> callbackList;
    private final Map<String, KeyValueEntry<Map<String, Method>, Object>> classCallbackMap = new HashMap<String, KeyValueEntry<Map<String, Method>, Object>>();
    private TRTCCallManager trtcCallManager;
    private Properties trtcConfig;
    private static final String trtcConfigFileName = "carparkTrtc.conf";

    public DefaultTRTCCloudContext() {
        this.callbackList = new CopyOnWriteArrayList();
        this.registerClass(TRTCCloudCallback.class.getSimpleName(), TRTCCloudCallback.class, this);
        this.trtcCloudProcessor = new TRTCCloudProcessor(this.classCallbackMap);
        this.trtcCloudFacade = TRTCCloudSdkProxy.newProxy(TRTCCloudFacade.class, this.trtcCloudProcessor);
        this.trtcCallManager = new DefaultTRTCCallManager();
    }

    private void registerClass(String name, Class<?> cl, Object instance) {
        HashMap<String, Method> methodsMap = new HashMap<String, Method>();
        Method[] mehtods = cl.getMethods();
        if (mehtods != null) {
            Method[] methodArray = mehtods;
            int n = mehtods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                methodsMap.put(method.getName(), method);
                ++n2;
            }
        }
        this.classCallbackMap.put(name, (KeyValueEntry<Map<String, Method>, Object>)new KeyValueEntry(methodsMap, instance));
    }

    public void startProcess() {
        this.trtcCloudProcessor.start();
    }

    @Override
    public TRTCCloudFacade getTRTCCloud() {
        return this.trtcCloudFacade;
    }

    @Override
    public void registerTRTCCloudCallback(TRTCCloudCallback callback) {
        this.callbackList.add(callback);
    }

    @Override
    public void removeTRTCCloudCallback(TRTCCloudCallback callback) {
        this.callbackList.remove(callback);
    }

    @Override
    public boolean containsTRTCCloudCallback(TRTCCloudCallback callback) {
        return this.callbackList.contains(callback);
    }

    @Override
    public void onError(int errCode, String errMsg) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onError(errCode, errMsg);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onWarning(int warningCode, String warningMsg) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onWarning(warningCode, warningMsg);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onEnterRoom(int result) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onEnterRoom(result);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onExitRoom(int reason) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onExitRoom(reason);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onRemoteUserEnterRoom(String userId) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onRemoteUserEnterRoom(userId);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onRemoteUserLeaveRoom(String userId, int reason) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onRemoteUserLeaveRoom(userId, reason);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onUserVideoAvailable(String userId, boolean available) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onUserVideoAvailable(userId, available);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onUserAudioAvailable(String userId, boolean available) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onUserAudioAvailable(userId, available);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onFirstVideoFrame(String userId, int streamType, int width, int height) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onFirstVideoFrame(userId, streamType, width, height);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onFirstAudioFrame(String userId) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onFirstAudioFrame(userId);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onSendFirstLocalVideoFrame(int streamType) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onSendFirstLocalVideoFrame(streamType);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onSendFirstLocalAudioFrame() {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onSendFirstLocalAudioFrame();
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onConnectionLost() {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onConnectionLost();
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onTryToReconnect() {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onTryToReconnect();
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onConnectionRecovery() {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onConnectionRecovery();
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onCameraDidReady() {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onCameraDidReady();
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onMicDidReady() {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onMicDidReady();
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onAudioDeviceCaptureVolumeChanged(int volume, boolean muted) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onAudioDeviceCaptureVolumeChanged(volume, muted);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void onAudioDevicePlayoutVolumeChanged(int volume, boolean muted) {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.onAudioDevicePlayoutVolumeChanged(volume, muted);
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void destroy() {
        this.trtcCallManager.hangUp();
        this.callbackList.clear();
        this.trtcCloudProcessor.destroy();
    }

    @Override
    public void nativeSdkRelease() {
        for (TRTCCloudCallback c : this.callbackList) {
            try {
                c.nativeSdkRelease();
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getTrtcConfig() {
        if (this.trtcConfig == null) {
            DefaultTRTCCloudContext defaultTRTCCloudContext = this;
            synchronized (defaultTRTCCloudContext) {
                if (this.trtcConfig == null) {
                    this.trtcConfig = ServiceUtil.getServiceContext().readLocalRuntimeData(null, trtcConfigFileName, trtcConfigFileName);
                }
            }
        }
        return this.trtcConfig;
    }

    @Override
    public boolean isEnableTrtcCallAccept() {
        Properties p = this.getTrtcConfig();
        return "true".equals(p.getProperty("enableTrtcCallAccept"));
    }

    @Override
    public void enableTrtcCallAccept(boolean enable) {
        Properties p = this.getTrtcConfig();
        String v = p.getProperty("enableTrtcCallAccept");
        String v1 = String.valueOf(enable);
        if (v == null || !v.equals(v1)) {
            p.setProperty("enableTrtcCallAccept", v1);
            ServiceUtil.getServiceContext().storeRuntimeDataToFile(null, trtcConfigFileName, trtcConfigFileName, p);
        }
    }

    @Override
    public boolean isTrtcSdkNormal() {
        return this.trtcCloudProcessor.isAlive();
    }

    @Override
    public TRTCCallManager getTRTCCallManager() {
        return this.trtcCallManager;
    }
}

