/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.trtc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.StringTokenizer;

public class ProcessPacket {
    private Map<String, Object> headerMap = new LinkedHashMap<String, Object>();

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headerMap.keySet());
    }

    public String getHeaderValue(String name) {
        Object obj = this.headerMap.get(name);
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (obj instanceof Queue) {
                Queue c = (Queue)obj;
                Object xo = c.peek();
                if (xo != null) {
                    if (xo instanceof String) {
                        return (String)xo;
                    }
                    return xo.toString();
                }
                return null;
            }
            String[] s = this.getHeaderValues(name);
            if (s == null || s.length == 0) {
                return null;
            }
            return s[0];
        }
        return null;
    }

    public String[] getHeaderValues(String name) {
        Object obj = this.headerMap.get(name);
        if (obj != null) {
            if (obj instanceof String[]) {
                return (String[])obj;
            }
            if (obj instanceof Collection) {
                Collection c = (Collection)obj;
                return c.toArray(new String[c.size()]);
            }
            return new String[]{obj.toString()};
        }
        return null;
    }

    public void addHeader(String name, String value) {
        this.addHeader(name, value, true);
    }

    public void addHeader(String name, String value, boolean last) {
        if (name == null || value == null) {
            return;
        }
        Object obj = this.headerMap.get(name);
        if (obj == null) {
            this.headerMap.put(name, value);
        } else {
            LinkedList<String> list;
            if (obj instanceof String) {
                list = new LinkedList<String>();
                this.headerMap.put(name, list);
                list.addLast((String)obj);
            } else {
                list = (LinkedList<String>)obj;
            }
            if (last) {
                list.addLast(value);
            } else {
                list.addFirst(value);
            }
        }
    }

    public void addFirstHeader(String name, String value) {
        this.addHeader(name, value, false);
    }

    public void setHeader(String name, String value) {
        if (name != null && value != null) {
            this.headerMap.put(name, value);
        }
    }

    public String removeHeaderValue(String name, boolean last) {
        if (name == null) {
            return null;
        }
        Object obj = this.headerMap.get(name);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)this.headerMap.remove(name);
        }
        LinkedList list = (LinkedList)obj;
        obj = last ? list.removeLast() : list.removeFirst();
        if (list.isEmpty()) {
            this.headerMap.remove(name);
        }
        return (String)obj;
    }

    public byte[] serialize(String charset) throws UnsupportedEncodingException {
        if (charset == null || charset.length() == 0) {
            charset = "UTF-8";
        }
        StringBuilder bu = new StringBuilder(128);
        int c = 61;
        int g = 38;
        for (Map.Entry<String, Object> entry : this.headerMap.entrySet()) {
            if (bu.length() > 0) {
                bu.append('&');
            }
            if (entry.getValue() instanceof String) {
                bu.append(URLEncoder.encode(entry.getKey(), charset)).append('=').append(URLEncoder.encode((String)entry.getValue(), charset));
                continue;
            }
            if (!(entry.getValue() instanceof Collection)) continue;
            Collection s = (Collection)entry.getValue();
            for (Object o : s) {
                bu.append(URLEncoder.encode(entry.getKey(), charset)).append('=').append(URLEncoder.encode(o.toString(), charset));
            }
        }
        if (bu.length() == 0) {
            return null;
        }
        return bu.toString().getBytes(charset);
    }

    public static ProcessPacket deserialize(byte[] data, int offset, int length, String charset) throws UnsupportedEncodingException {
        if (charset == null || charset.length() == 0) {
            charset = "UTF-8";
        }
        ProcessPacket appPacket = new ProcessPacket();
        if (data == null || data.length == 0 || length == 0) {
            return appPacket;
        }
        String headerStr = new String(data, offset, length, charset);
        String b = "&";
        int c = 61;
        StringTokenizer tokens = new StringTokenizer(headerStr, "&");
        while (tokens.hasMoreTokens()) {
            int g;
            String entry = tokens.nextToken();
            if (entry.length() <= 0 || (g = entry.indexOf(61)) == -1) continue;
            String key = URLDecoder.decode(entry.substring(0, g), charset);
            String value = URLDecoder.decode(entry.substring(g + 1, entry.length()), charset);
            appPacket.addHeader(key, value);
        }
        return appPacket;
    }
}

