/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.trtc;

import com.wovoe.carpark.OSUtil;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.cloud.trtc.InvokeSdkException;
import com.wovoe.carpark.cloud.trtc.ProcessPacket;
import com.wovoe.carpark.cloud.trtc.TRTCCloudCallback;
import com.wovoe.carpark.cloud.trtc.TRTCCloudSerializeTool;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TRTCCloudProcessor
extends JobTask {
    private static final String INVOKE_CMD = "WLYK_TRTC_C:";
    private static final String EXIT_CMD = "WLYK_TRTC_EXIT";
    private static final String EXIT_CMD_RESPONSE = "WLYK_TRTC_EXIT:SUCCESS";
    private static final String HEARTBEAT_CMD = "WLYK_TRTC_HEARTBEAT:ALIVE";
    private static final String HEARTBEAT_RES_CMD = "WLYK_TRTC_HEARTBEAT:RE_ALIVE";
    private static final String INVOKE_HEAD_TYPE = "t";
    private static final String INVOKE_HEAD_TYPE_S = "S";
    private static final String INVOKE_HEAD_TYPE_R = "R";
    private static final String INVOKE_HEAD_INVOKE_ID = "i";
    private static final String INVOKE_HEAD_CLASS = "c";
    private static final String INVOKE_HEAD_METHOD = "m";
    private static final String INVOKE_HEAD_PARAM_PREFIX = "p";
    private static final String INVOKE_HEAD_PARAM_NULL_PREFIX = "n";
    private static final String NULL_TRUE = "1";
    private static final String INVOKE_HEAD_RETURN_CODE = "z";
    private static final String INVOKE_HEAD_RETURN_MSG = "g";
    private static final String INVOKE_HEAD_RETURN_CODE_SUCCESS = "0";
    private static final String INVOKE_HEAD_RETURN_MSG_SUCCESS = "SUCCESS";
    private static final String INVOKE_HEAD_RETURN_CODE_ERROR_HEAD = "1";
    private static final String INVOKE_HEAD_RETURN_CODE_ERROR_CLASS_NOTFOUND = "2";
    private static final String INVOKE_HEAD_RETURN_CODE_ERROR_METHOD_NOTFOUND = "3";
    private static final String INVOKE_HEAD_RETURN_CODE_ERROR_METHOD_PARAM_ERROR = "4";
    private static final String INVOKE_HEAD_RETURN_CODE_ERROR_INVOKE_ERROR = "5";
    private static final String INVOKE_HEAD_RETURN_RESULT = "v";
    private static final String INVOKE_HEAD_RETURN_RESULT_NULL = "w";
    private static final Object[] emptyObjects = new Object[0];
    private Process process;
    private Thread waitThead;
    private PrintStream out;
    private BufferedReader in;
    private ScheduledFuture<?> hander;
    private volatile CountDownLatch releaseLatch;
    private volatile long lastRevMills;
    private volatile boolean destroyed;
    private Map<String, KeyValueEntry<Map<String, Method>, Object>> callbackClassMap;

    public TRTCCloudProcessor(Map<String, KeyValueEntry<Map<String, Method>, Object>> classMap) {
        this.callbackClassMap = classMap;
    }

    public synchronized void start() {
        if (this.destroyed) {
            return;
        }
        if (this.hander == null) {
            this.hander = ServiceUtil.getServiceContext().schedule(this, 1L, 3L, TimeUnit.SECONDS);
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        try {
            if (this.hander != null) {
                this.hander.cancel(true);
                this.hander = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.isStarted()) {
            this.releaseLatch = new CountDownLatch(1);
            this.out.println(EXIT_CMD);
            this.out.flush();
            try {
                this.releaseLatch.await(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.closePocess();
    }

    private synchronized void closePocess() {
        try {
            if (this.process != null) {
                this.process.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.process = null;
        this.in = null;
        this.out = null;
        if (this.waitThead != null) {
            try {
                this.waitThead.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.waitThead = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() throws Exception {
        try {
            if (this.destroyed) {
                return;
            }
            if (!this.isStarted()) {
                if (this.startProcess()) {
                    this.out.println(HEARTBEAT_CMD);
                    this.out.flush();
                    return;
                }
                this.closePocess();
                return;
            }
            if (this.isHeartBeatNormal()) {
                this.out.println(HEARTBEAT_CMD);
                this.out.flush();
                return;
            }
            ServiceLog.getLog().warn((Object)"TRTC\u8fdb\u7a0b\u662f\u6d3b\u52a8\u7684, \u4f46\u662f\u5fc3\u8df3\u8d85\u65f6, \u8fd9\u5c06\u5173\u95ed\u8fdb\u7a0b\u5e76\u91cd\u65b0\u6253\u5f00");
            this.closePocess();
            if (this.startProcess()) {
                this.out.println(HEARTBEAT_CMD);
                this.out.flush();
                return;
            }
            this.closePocess();
            return;
        }
        catch (Throwable ex) {
            ServiceLog.getLog().warn((Object)"", ex);
        }
    }

    public synchronized boolean isStarted() {
        return this.process != null && this.out != null && this.process.isAlive();
    }

    private boolean isHeartBeatNormal() {
        return ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevMills < 7000L;
    }

    public boolean isAlive() {
        return this.isStarted() && this.isHeartBeatNormal();
    }

    private void onSdkReleaseCallback() {
        String className = TRTCCloudCallback.class.getSimpleName();
        KeyValueEntry<Map<String, Method>, Object> entry = this.callbackClassMap.get(className);
        if (entry == null) {
            return;
        }
        Map methodsMap = (Map)entry.getKey();
        if (methodsMap == null) {
            return;
        }
        String methodName = "nativeSdkRelease";
        Method method = (Method)methodsMap.get(methodName);
        if (method == null) {
            return;
        }
        Object classIntance = entry.getValue();
        if (classIntance == null) {
            return;
        }
        try {
            method.invoke(classIntance, emptyObjects);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u56de\u8c03" + className + "." + methodName + " \u5f02\u5e38"), (Throwable)ex);
        }
    }

    private synchronized boolean startProcess() {
        if (this.destroyed) {
            return false;
        }
        if (this.isStarted()) {
            return true;
        }
        this.closePocess();
        final CountDownLatch wait = new CountDownLatch(1);
        this.waitThead = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean isCountDonwn = false;
                Process p = null;
                OutputStream output = null;
                InputStream input = null;
                try {
                    String jrePath = OSUtil.isOS32() ? "bin/jre32/bin" : "bin/jre64/bin";
                    File javaBinDir = new File(PathFinder.findHomeDir(), jrePath);
                    String javaExe = String.valueOf(javaBinDir.getAbsolutePath()) + File.separator + "java";
                    File jarFile = new File(PathFinder.findHomeDir(), "bin/lib/CarparkCloudTrtcLib.jar");
                    if (!jarFile.exists() || !jarFile.isFile()) {
                        ServiceLog.getLog().warn((Object)"CarparkCloudTrtcLib.jar \u6587\u4ef6\u4e0d\u5b58\u5728!");
                        wait.countDown();
                        isCountDonwn = true;
                        return;
                    }
                    try {
                        String line;
                        StringBuilder _command = new StringBuilder(128).append(javaExe);
                        _command.append(" -jar ").append(jarFile.getAbsolutePath()).append(" product");
                        String command = _command.toString();
                        p = TRTCCloudProcessor.exec(command);
                        output = p.getOutputStream();
                        input = p.getInputStream();
                        TRTCCloudProcessor.this.process = p;
                        TRTCCloudProcessor.this.out = new PrintStream(output);
                        TRTCCloudProcessor.this.in = new BufferedReader(new InputStreamReader(input));
                        String suceess = "The trtc native process has been started";
                        while ((line = TRTCCloudProcessor.this.in.readLine()) != null) {
                            CountDownLatch lo;
                            if (!isCountDonwn) {
                                if (line.equals(suceess)) {
                                    TRTCCloudProcessor.this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
                                    wait.countDown();
                                    isCountDonwn = true;
                                    TRTCCloudProcessor.this.handleInitSuccess();
                                    continue;
                                }
                                if (line.length() <= 0) continue;
                                ServiceLog.getLog().warn((Object)("trtc init-->" + line));
                                continue;
                            }
                            if (line.startsWith(TRTCCloudProcessor.INVOKE_CMD)) {
                                try {
                                    byte[] data = BytesTool.unCompress((String)line.substring(TRTCCloudProcessor.INVOKE_CMD.length()));
                                    ProcessPacket packet = ProcessPacket.deserialize(data, 0, data.length, "UTF-8");
                                    TRTCCloudProcessor.this.handlePacket(packet);
                                }
                                catch (Throwable ex) {
                                    ServiceLog.getLog().warn((Object)("\u5904\u7406\u5f02\u5e38! data:" + line), ex);
                                }
                                continue;
                            }
                            if (line.equals(TRTCCloudProcessor.HEARTBEAT_RES_CMD)) {
                                TRTCCloudProcessor.this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
                                TRTCCloudProcessor.this.handleHeartbeatResponse();
                                continue;
                            }
                            if (!line.equals(TRTCCloudProcessor.EXIT_CMD_RESPONSE) || (lo = TRTCCloudProcessor.this.releaseLatch) == null) continue;
                            lo.countDown();
                        }
                    }
                    catch (Throwable ex) {
                        ServiceLog.getLog().warn((Object)("trtc processor exit: " + ex.getMessage()));
                    }
                }
                finally {
                    try {
                        if (!isCountDonwn) {
                            wait.countDown();
                            isCountDonwn = true;
                        }
                    }
                    finally {
                        try {
                            TRTCCloudProcessor.this.onSdkReleaseCallback();
                        }
                        finally {
                            if (p != null) {
                                boolean closeLocal = true;
                                if (p == TRTCCloudProcessor.this.process && TRTCCloudProcessor.this.closePocess0(p)) {
                                    closeLocal = false;
                                }
                                if (closeLocal) {
                                    try {
                                        if (p != null) {
                                            p.destroy();
                                        }
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                    }
                }
            }
        });
        this.waitThead.start();
        try {
            wait.await(8L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.isStarted();
    }

    private synchronized boolean closePocess0(Process p) {
        if (p == this.process) {
            this.closePocess();
            return true;
        }
        return false;
    }

    private static Process exec(String command) throws IOException {
        if (command.length() == 0) {
            throw new IllegalArgumentException("Empty command");
        }
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdarray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdarray[i] = st.nextToken();
            ++i;
        }
        ProcessBuilder p = new ProcessBuilder(cmdarray);
        p.redirectErrorStream(true);
        return p.start();
    }

    private void handleInitSuccess() {
        ServiceLog.getLog().info((Object)"TRTCCloud \u521d\u59cb\u5316\u6210\u529f!");
        ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().setLogLevel(2);
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().setConsoleEnabled(false);
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().setLogCompressEnabled(false);
                    File trtcLogs = new File(PathFinder.findLocalDir(), "trtcLogs");
                    if (!trtcLogs.exists() || !trtcLogs.isDirectory()) {
                        trtcLogs.mkdirs();
                    }
                    ServiceUtil.getServiceContext().getTRTCCloudContext().getTRTCCloud().setLogDirPath(trtcLogs.getAbsolutePath());
                    TRTCCloudProcessor.this.trtcTest();
                }
                catch (Exception ex) {
                    ServiceLog.getLog().info((Object)("\u8bbe\u7f6eTRTC\u65e5\u5fd7\u7b49\u914d\u7f6e\u5f02\u5e38! " + ex.getMessage()));
                }
            }
        });
    }

    private void trtcTest() {
    }

    private void handleHeartbeatResponse() {
    }

    private void handlePacket(final ProcessPacket packet) {
        String invokeType = packet.getHeaderValue(INVOKE_HEAD_TYPE);
        if (invokeType == null || invokeType.length() == 0) {
            return;
        }
        if (INVOKE_HEAD_TYPE_S.equals(invokeType)) {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    TRTCCloudProcessor.this.handleRequestInvoke(packet);
                }
            });
        } else if (INVOKE_HEAD_TYPE_R.equals(invokeType)) {
            this.handleResponseInvoke(packet);
        } else {
            return;
        }
    }

    private void responseError(ProcessPacket requestPacket, String errorCode, String errMsg) {
        ProcessPacket responsePacket = new ProcessPacket();
        responsePacket.setHeader(INVOKE_HEAD_TYPE, INVOKE_HEAD_TYPE_R);
        String invokeId = requestPacket.getHeaderValue(INVOKE_HEAD_INVOKE_ID);
        String invokeClassName = requestPacket.getHeaderValue(INVOKE_HEAD_CLASS);
        String invokeMethodName = requestPacket.getHeaderValue(INVOKE_HEAD_METHOD);
        if (invokeId != null) {
            responsePacket.setHeader(INVOKE_HEAD_INVOKE_ID, invokeId);
        }
        if (invokeClassName != null) {
            responsePacket.setHeader(INVOKE_HEAD_CLASS, invokeClassName);
        }
        if (invokeMethodName != null) {
            responsePacket.setHeader(INVOKE_HEAD_METHOD, invokeMethodName);
        }
        responsePacket.setHeader(INVOKE_HEAD_RETURN_CODE, errorCode);
        responsePacket.setHeader(INVOKE_HEAD_RETURN_MSG, errMsg);
        try {
            this.send(responsePacket.serialize("UTF-8"));
        }
        catch (Exception e) {
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5f02\u5e38! " + e.getMessage()));
        }
    }

    private void handleRequestInvoke(ProcessPacket requestPacket) {
        String returnValue;
        Object resultObj;
        Object[] paramObjects;
        String className = requestPacket.getHeaderValue(INVOKE_HEAD_CLASS);
        if (className == null || className.length() == 0) {
            ServiceLog.getLog().warn((Object)"TRC\u56de\u8c03\u8bf7\u6c42\u7f3a\u5c11\u53c2\u6570: c");
            this.responseError(requestPacket, "1", "Missing head value c");
            return;
        }
        KeyValueEntry<Map<String, Method>, Object> entry = this.callbackClassMap.get(className);
        if (entry == null) {
            ServiceLog.getLog().warn((Object)("TRC\u56de\u8c03\u8bf7\u6c42, \u7c7b " + className + " \u672a\u6ce8\u518c"));
            this.responseError(requestPacket, INVOKE_HEAD_RETURN_CODE_ERROR_CLASS_NOTFOUND, "Class: " + className + " is not supported");
            return;
        }
        Map methodsMap = (Map)entry.getKey();
        if (methodsMap == null) {
            ServiceLog.getLog().warn((Object)("TRC\u56de\u8c03\u8bf7\u6c42, \u7c7b " + className + " \u65b9\u6cd5\u96c6\u5408\u672a\u6ce8\u518c"));
            this.responseError(requestPacket, INVOKE_HEAD_RETURN_CODE_ERROR_CLASS_NOTFOUND, "Class: " + className + " is not supported");
            return;
        }
        String methodName = requestPacket.getHeaderValue(INVOKE_HEAD_METHOD);
        if (methodName == null || methodName.length() == 0) {
            ServiceLog.getLog().warn((Object)"TRC\u56de\u8c03\u8bf7\u6c42\u7f3a\u5c11\u53c2\u6570: m");
            this.responseError(requestPacket, "1", "Missing head value m");
            return;
        }
        Method method = (Method)methodsMap.get(methodName);
        if (method == null) {
            ServiceLog.getLog().warn((Object)("TRC\u56de\u8c03\u8bf7\u6c42, \u7c7b " + className + "." + methodName + " \u65b9\u6cd5\u672a\u5b9a\u4e49"));
            this.responseError(requestPacket, INVOKE_HEAD_RETURN_CODE_ERROR_METHOD_NOTFOUND, "Method: " + methodName + " is not supported");
            return;
        }
        Object classIntance = entry.getValue();
        if (classIntance == null) {
            ServiceLog.getLog().warn((Object)("TRC\u56de\u8c03\u8bf7\u6c42, \u7c7b " + className + " \u5b9e\u4f8b\u672a\u6ce8\u518c!"));
            this.responseError(requestPacket, INVOKE_HEAD_RETURN_CODE_ERROR_INVOKE_ERROR, "Unable to get object instance for " + className);
            return;
        }
        Class<?> returnType = method.getReturnType();
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes == null || paramTypes.length == 0) {
            paramObjects = emptyObjects;
        } else {
            paramObjects = new Object[paramTypes.length];
            int i = 0;
            while (i < paramTypes.length) {
                Object paramValue;
                String value = requestPacket.getHeaderValue(INVOKE_HEAD_PARAM_PREFIX + i);
                if (value == null) {
                    String nullV = requestPacket.getHeaderValue(INVOKE_HEAD_PARAM_NULL_PREFIX + i);
                    if (nullV == null || !"1".equals(nullV)) {
                        ServiceLog.getLog().warn((Object)("TRC\u56de\u8c03\u8bf7\u6c42, \u7c7b " + className + "." + methodName + " \u7f3a\u5c11\u53c2\u6570: " + INVOKE_HEAD_PARAM_PREFIX + i));
                        this.responseError(requestPacket, INVOKE_HEAD_RETURN_CODE_ERROR_METHOD_PARAM_ERROR, "Missing head value " + INVOKE_HEAD_PARAM_PREFIX + i);
                        return;
                    }
                    paramValue = null;
                } else {
                    Class<?> paramType = paramTypes[i];
                    try {
                        paramValue = TRTCCloudSerializeTool.deserialize(value, paramType);
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("TRC\u56de\u8c03\u8bf7\u6c42, \u7c7b " + className + "." + methodName + " \u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25! \u503c:" + value + ", \u53c2\u6570\u7d22\u5f15: " + i + ", \u53c2\u6570\u7c7b\u578b: " + paramType));
                        this.responseError(requestPacket, INVOKE_HEAD_RETURN_CODE_ERROR_METHOD_PARAM_ERROR, "Parameter index " + i + ", value: " + value + ", cannot be resolved! invoke method: " + className + "." + methodName + ", cause: " + ex.getMessage());
                        return;
                    }
                }
                paramObjects[i] = paramValue;
                ++i;
            }
        }
        try {
            resultObj = method.invoke(classIntance, paramObjects);
        }
        catch (Throwable ex) {
            InvocationTargetException e;
            String msg = ex instanceof InvocationTargetException ? ((e = (InvocationTargetException)ex).getTargetException() != null ? "invoke error! " + e.getTargetException().getMessage() : "invoke error! " + ex.getMessage()) : "invoke error! " + ex.getMessage();
            ServiceLog.getLog().warn((Object)("TRC\u56de\u8c03\u8bf7\u6c42, \u7c7b " + className + "." + methodName + " \u5904\u7406\u5f02\u5e38!"), ex);
            this.responseError(requestPacket, INVOKE_HEAD_RETURN_CODE_ERROR_INVOKE_ERROR, msg);
            return;
        }
        if (resultObj != null) {
            if (Void.TYPE.equals(returnType) || Void.class.equals(returnType)) {
                returnValue = null;
            } else {
                try {
                    returnValue = TRTCCloudSerializeTool.serialize(resultObj);
                }
                catch (Exception ex) {
                    returnValue = ex.toString();
                    return;
                }
            }
        } else {
            returnValue = null;
        }
        ProcessPacket responsePacket = new ProcessPacket();
        responsePacket.setHeader(INVOKE_HEAD_TYPE, INVOKE_HEAD_TYPE_R);
        String invokeId = requestPacket.getHeaderValue(INVOKE_HEAD_INVOKE_ID);
        String invokeClassName = requestPacket.getHeaderValue(INVOKE_HEAD_CLASS);
        String invokeMethodName = requestPacket.getHeaderValue(INVOKE_HEAD_METHOD);
        if (invokeId != null) {
            responsePacket.setHeader(INVOKE_HEAD_INVOKE_ID, invokeId);
        }
        if (invokeClassName != null) {
            responsePacket.setHeader(INVOKE_HEAD_CLASS, invokeClassName);
        }
        if (invokeMethodName != null) {
            responsePacket.setHeader(INVOKE_HEAD_METHOD, invokeMethodName);
        }
        responsePacket.setHeader(INVOKE_HEAD_RETURN_CODE, INVOKE_HEAD_RETURN_CODE_SUCCESS);
        responsePacket.setHeader(INVOKE_HEAD_RETURN_MSG, INVOKE_HEAD_RETURN_MSG_SUCCESS);
        if (returnValue == null) {
            responsePacket.setHeader(INVOKE_HEAD_RETURN_RESULT_NULL, "1");
        } else {
            responsePacket.setHeader(INVOKE_HEAD_RETURN_RESULT, returnValue);
        }
        try {
            this.send(responsePacket.serialize("UTF-8"));
        }
        catch (Exception e) {
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5f02\u5e38! " + e.getMessage()));
        }
    }

    private void handleResponseInvoke(ProcessPacket responsePacket) {
        String invokeId = responsePacket.getHeaderValue(INVOKE_HEAD_INVOKE_ID);
        String invokeClassName = responsePacket.getHeaderValue(INVOKE_HEAD_CLASS);
        String invokeMethodName = responsePacket.getHeaderValue(INVOKE_HEAD_METHOD);
        WaitInvokeNativeSdkResponseKey waitKey = new WaitInvokeNativeSdkResponseKey(invokeClassName, invokeMethodName, invokeId);
        KeyValueEntry objf = (KeyValueEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitKey);
        if (objf == null) {
            ServiceLog.getLog().warn((Object)("\u5904\u7406" + invokeClassName + "." + invokeMethodName + "\u672c\u5730\u65b9\u6cd5\u8fd4\u56de\u7ed3\u679c\u5931\u8d25! \u539f\u56e0: \u7f13\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728! \u53ef\u80fd\u662f\u8bbe\u7f6e\u7684\u8d85\u65f6\u671f\u8fc7\u77ed\u5bfc\u81f4! \u8bf7\u68c0\u67e5\u7a0b\u5e8f"));
        } else {
            String returnCode = responsePacket.getHeaderValue(INVOKE_HEAD_RETURN_CODE);
            if (INVOKE_HEAD_RETURN_CODE_SUCCESS.equals(returnCode)) {
                if (Void.TYPE.equals(objf.getValue()) || Void.class.equals(objf.getValue())) {
                    ((OperationFutureHandler)objf.getKey()).setResult(null);
                } else {
                    String result = responsePacket.getHeaderValue(INVOKE_HEAD_RETURN_RESULT);
                    if (result == null) {
                        String vs = responsePacket.getHeaderValue(INVOKE_HEAD_RETURN_RESULT_NULL);
                        if (vs != null && "1".equals(vs)) {
                            ((OperationFutureHandler)objf.getKey()).setResult(null);
                        } else {
                            ((OperationFutureHandler)objf.getKey()).setException((Throwable)new InvokeSdkException("UNKNOWN_RETURN_VALUE", "\u7f3a\u5c11\u8fd4\u56de\u503c!"));
                        }
                    } else {
                        try {
                            Object resultV = TRTCCloudSerializeTool.deserialize(result, (Class)objf.getValue());
                            ((OperationFutureHandler)objf.getKey()).setResult(resultV);
                        }
                        catch (Exception ex) {
                            ((OperationFutureHandler)objf.getKey()).setException((Throwable)ex);
                        }
                    }
                }
            } else {
                String returnMsg = responsePacket.getHeaderValue(INVOKE_HEAD_RETURN_MSG);
                ((OperationFutureHandler)objf.getKey()).setException((Throwable)new InvokeSdkException(returnCode, returnMsg));
            }
        }
    }

    public OperationFuture<Object> invokeNativeSdk(String invokeClassName, String invokeMethodName, long waitTimeoutMills, Class<?> returnType, String ... paramValues) {
        OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            if (waitTimeoutMills < 1000L) {
                waitTimeoutMills = 1000L;
            }
            String requestId = String.valueOf(TRTCCloudProcessor.class.getSimpleName()) + "-" + ServiceUtil.getServiceContext().currentTimeMillis() + "-" + ServiceUtil.getServiceContext().createLongSeq();
            WaitInvokeNativeSdkResponseKey waitKey = new WaitInvokeNativeSdkResponseKey(invokeClassName, invokeMethodName, requestId);
            ProcessPacket packet = new ProcessPacket();
            packet.setHeader(INVOKE_HEAD_TYPE, INVOKE_HEAD_TYPE_S);
            packet.setHeader(INVOKE_HEAD_INVOKE_ID, requestId);
            packet.setHeader(INVOKE_HEAD_CLASS, invokeClassName);
            packet.setHeader(INVOKE_HEAD_METHOD, invokeMethodName);
            if (paramValues != null && paramValues.length > 0) {
                int i = 0;
                while (i < paramValues.length) {
                    if (paramValues[i] == null) {
                        packet.setHeader(INVOKE_HEAD_PARAM_NULL_PREFIX + i, "1");
                    } else {
                        packet.setHeader(INVOKE_HEAD_PARAM_PREFIX + i, paramValues[i]);
                    }
                    ++i;
                }
            }
            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)waitKey, (Object)new KeyValueEntry((Object)handler, returnType), new TimeoutObjectPool.TimeoutCallback(){

                public void onTimeout(Object key, Object value) throws Exception {
                    KeyValueEntry entry = (KeyValueEntry)value;
                    ((OperationFutureHandler)entry.getKey()).setException((Throwable)new TimeoutException("Invoke timeout excetpion"));
                }
            }, waitTimeoutMills, TimeUnit.MILLISECONDS);
            try {
                this.send(packet.serialize("UTF-8"));
            }
            catch (Throwable ex) {
                try {
                    ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)waitKey);
                }
                finally {
                    handler.setException(ex);
                }
            }
        }
        catch (Throwable ex) {
            handler.setException(ex);
        }
        return handler;
    }

    public void send(byte[] data) throws IOException {
        this.send(data, 0, data.length);
    }

    public void send(byte[] data, int offset, int length) throws IOException {
        if (this.destroyed) {
            throw new IOException("TRTCCloudProcessor\u5df2\u7ecf\u88ab\u9500\u6bc1");
        }
        if (!this.isStarted()) {
            throw new IOException("TRTCCloudProcessor\u672a\u542f\u52a8");
        }
        if (!this.isHeartBeatNormal()) {
            throw new IOException("TRTCCloudProcessor\u72b6\u6001\u4e0d\u6b63\u5e38");
        }
        String x = BytesTool.compressBytes((byte[])data, (int)offset, (int)length);
        this.out.println(INVOKE_CMD + x);
        this.out.flush();
    }

    private static class WaitInvokeNativeSdkResponseKey {
        String invokeClassName;
        String invokeMethodName;
        String requestId;

        public WaitInvokeNativeSdkResponseKey(String invokeClassName, String invokeMethodName, String requestId) {
            this.invokeClassName = invokeClassName;
            this.invokeMethodName = invokeMethodName;
            this.requestId = requestId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.invokeClassName == null ? 0 : this.invokeClassName.hashCode());
            result = 31 * result + (this.invokeMethodName == null ? 0 : this.invokeMethodName.hashCode());
            result = 31 * result + (this.requestId == null ? 0 : this.requestId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaitInvokeNativeSdkResponseKey other = (WaitInvokeNativeSdkResponseKey)obj;
            if (this.invokeClassName == null ? other.invokeClassName != null : !this.invokeClassName.equals(other.invokeClassName)) {
                return false;
            }
            if (this.invokeMethodName == null ? other.invokeMethodName != null : !this.invokeMethodName.equals(other.invokeMethodName)) {
                return false;
            }
            return !(this.requestId == null ? other.requestId != null : !this.requestId.equals(other.requestId));
        }
    }
}

