/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.trtc;

import com.wovoe.carpark.cloud.trtc.InvokeSdkException;
import com.wovoe.carpark.cloud.trtc.TRTCCloudProcessor;
import com.wovoe.carpark.cloud.trtc.TRTCCloudSerializeTool;
import com.wovoe.framework.OperationFuture;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public class TRTCCloudSdkProxy
implements InvocationHandler {
    private static final String EQUALS_METHOD = "equals";
    private static final String HASHCODE_METHOD = "hashCode";
    private static final String TOSTRING_METHOD = "toString";
    private TRTCCloudProcessor processor;
    private String className;

    private TRTCCloudSdkProxy(TRTCCloudProcessor processor, String className) {
        this.processor = processor;
        this.className = className;
    }

    public static <T> T newProxy(Class<T> iface, TRTCCloudProcessor processor) {
        TRTCCloudSdkProxy p = new TRTCCloudSdkProxy(processor, iface.getSimpleName());
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)p);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String[] params;
        String mehtodName = method.getName();
        if (EQUALS_METHOD.equals(mehtodName) && args != null && args.length == 1) {
            return this.equals(args[0]);
        }
        if (HASHCODE_METHOD.equals(mehtodName) && (args == null || args.length == 0)) {
            return this.hashCode();
        }
        if (TOSTRING_METHOD.equals(mehtodName) && (args == null || args.length == 0)) {
            return this.toString();
        }
        if (args == null || args.length == 0) {
            params = null;
        } else {
            params = new String[args.length];
            int i = 0;
            while (i < args.length) {
                params[i] = TRTCCloudSerializeTool.serialize(args[i]);
                ++i;
            }
        }
        long timeout = 6000L;
        try {
            OperationFuture<Object> op = this.processor.invokeNativeSdk(this.className, method.getName(), timeout, method.getReturnType(), params);
            Object v = op.get(timeout + 500L, TimeUnit.MILLISECONDS);
            if (v == null) {
                if (op.isDone()) {
                    return v;
                }
                throw new InvokeSdkException("\u6267\u884c" + this.className + "." + method.getName() + "\u65b9\u6cd5\u8d85\u65f6");
            }
            return v;
        }
        catch (Throwable ex) {
            if (ex instanceof InvokeSdkException) {
                throw (InvokeSdkException)ex;
            }
            if (ex instanceof ExecutionException) {
                Throwable e = ex.getCause();
                if (e != null) {
                    if (e instanceof InvokeSdkException) {
                        throw (InvokeSdkException)e;
                    }
                    String msg = e.getMessage();
                    String error = "\u6267\u884c" + this.className + "." + method.getName() + "\u65b9\u6cd5\u5f02\u5e38";
                    if (msg != null && msg.length() > 0) {
                        error = String.valueOf(error) + ", \u539f\u56e0: " + msg;
                    }
                    throw new InvokeSdkException(error, e);
                }
                throw new InvokeSdkException("\u6267\u884c" + this.className + "." + method.getName() + "\u65b9\u6cd5\u5f02\u5e38", ex);
            }
            String msg = ex.getMessage();
            String error = "\u6267\u884c" + this.className + "." + method.getName() + "\u65b9\u6cd5\u5f02\u5e38";
            if (msg != null && msg.length() > 0) {
                error = String.valueOf(error) + ", \u539f\u56e0: " + msg;
            }
            throw new InvokeSdkException(error, ex);
        }
    }
}

