/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.cloud.trtc;

import com.wovoe.carpark.cloud.trtc.InvokeSerializable;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.rpc.impl.ClassSerialize;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class TRTCCloudSerializeTool {
    public static Object deserialize(String value, Class<?> classType) {
        if (classType == null) {
            throw new NullPointerException("Deserialize classType is null");
        }
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            if (String.class.equals(classType)) {
                return value;
            }
            throw new NullPointerException("Deserialize value is empty");
        }
        if (Integer.TYPE.equals(classType) || Integer.class.equals(classType)) {
            return Integer.valueOf(value);
        }
        if (Long.TYPE.equals(classType) || Long.class.equals(classType)) {
            return Long.valueOf(value);
        }
        if (Byte.TYPE.equals(classType) || Byte.class.equals(classType)) {
            return Byte.valueOf(value);
        }
        if (Short.TYPE.equals(classType) || Short.class.equals(classType)) {
            return Short.valueOf(value);
        }
        if (Float.TYPE.equals(classType) || Float.class.equals(classType)) {
            return Float.valueOf(value);
        }
        if (Double.TYPE.equals(classType) || Double.class.equals(classType)) {
            return Double.valueOf(value);
        }
        if (Boolean.TYPE.equals(classType) || Boolean.class.equals(classType)) {
            return Boolean.valueOf(value);
        }
        if (String.class.equals(classType)) {
            return value;
        }
        if (BigDecimal.class.equals(classType)) {
            return new BigDecimal(value);
        }
        if (Date.class.equals(classType)) {
            try {
                long c = new SimpleDateFormat("yyyy-MM-dd").parse(value).getTime();
                return new Date(c);
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (Time.class.equals(classType)) {
            try {
                long c = new SimpleDateFormat("HH:mm:ss").parse(value).getTime();
                return new Time(c);
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (Timestamp.class.equals(classType)) {
            try {
                long c = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value).getTime();
                return new Timestamp(c);
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (java.util.Date.class.equals(classType)) {
            try {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (InvokeSerializable.class.isAssignableFrom(classType)) {
            try {
                Object v1 = classType.newInstance();
                ((InvokeSerializable)v1).deserialize(value);
                return v1;
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        byte[] data = BytesTool.unCompress((String)value);
        try {
            return ClassSerialize.getInstance().readObject((InputStream)new ByteArrayInputStream(data));
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String serialize(Object value) {
        if (value == null) {
            return null;
        }
        SimpleDateFormat df = null;
        if (value instanceof Date) {
            df = new SimpleDateFormat("yyyy-MM-dd");
        } else if (value instanceof Time) {
            df = new SimpleDateFormat("HH:mm:ss");
        } else if (value instanceof java.util.Date) {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return TRTCCloudSerializeTool.toStringObject(value, df);
    }

    public static String toStringObject(Object value, SimpleDateFormat df) {
        String v;
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            v = df.format((java.util.Date)value);
        } else if (value instanceof String || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof BigDecimal || value instanceof Boolean) {
            v = value.toString();
        } else {
            if (value instanceof InvokeSerializable) {
                try {
                    v = ((InvokeSerializable)value).serialize();
                }
                catch (Exception ex) {
                    if (ex instanceof RuntimeException) {
                        throw (RuntimeException)ex;
                    }
                    throw new RuntimeException(ex.getMessage(), ex);
                }
            }
            try {
                byte[] data = ClassSerialize.getInstance().toBytes(value);
                v = BytesTool.compressBytes((byte[])data);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return v;
    }
}

