/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.CommunicationHandleManger;
import com.wovoe.framework.communication.ProtocolHandler;
import com.wovoe.framework.communication.ProtocolHandlerChain;
import com.wovoe.framework.communication.ReadWriteProtocolHandlerChain;
import com.wovoe.framework.communication.RootWriteProtocolHandler;
import com.wovoe.framework.communication.SymmetricKeyGetter;
import com.wovoe.framework.communication.protocol.CryptoFactory;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.protocol.hmp.HMPAppPacket;
import com.wovoe.framework.communication.protocol.hmp.HMPAppXProtocolHandler;
import com.wovoe.framework.communication.protocol.hmp.HMPResponseSenderFactory;
import com.wovoe.framework.communication.protocol.hmp.HMPSender;
import com.wovoe.framework.communication.protocol.hmp.HMPServiceActionManager;
import com.wovoe.framework.communication.protocol.hmp.SymmetricCryptoFactory;
import com.wovoe.framework.communication.udp.MulticastUdpSocketHandle;
import com.wovoe.framework.communication.udp.UDPFrameXProtocolHandler;
import com.wovoe.framework.communication.udp.UDPKeyGetter;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.Key;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

public class BroadCastUdpSocketSender {
    private static final String NAMEPRFIX = String.valueOf(BroadCastUdpSocketSender.class.getName()) + "_";
    private volatile Map<String, Collection<String>> allValidInterfaceMap;
    private volatile long lastVs;
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Key key;

    public BroadCastUdpSocketSender(Key key) {
        this.key = key;
    }

    public synchronized List<CommunicationHandle> getBroadCastSendHandles() {
        Map<String, Collection<String>> listMap;
        if (this.shutdown.get()) {
            return new LinkedList<CommunicationHandle>();
        }
        try {
            listMap = this.getAllValidInterface();
        }
        catch (IOException e) {
            ServiceLog.getLog().error((Object)e.getMessage(), (Throwable)e);
            return new LinkedList<CommunicationHandle>();
        }
        if (listMap == null || listMap.isEmpty()) {
            this.closeAll();
            return new LinkedList<CommunicationHandle>();
        }
        Map<String, CommunicationHandle> handleMap = this.getAllHandlerMap();
        LinkedList<CommunicationHandle> rList = new LinkedList<CommunicationHandle>();
        for (Map.Entry<String, Collection<String>> entry : listMap.entrySet()) {
            for (String bindIp : entry.getValue()) {
                String name = String.valueOf(NAMEPRFIX) + entry.getKey() + "_" + bindIp;
                CommunicationHandle h = handleMap.remove(name);
                if (h != null && !h.isStart()) {
                    try {
                        h.shutdown();
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)ex.getMessage());
                    }
                    h = null;
                }
                if (h == null) {
                    h = this.createCommunicationHandle(entry.getKey(), bindIp);
                    if (h == null) continue;
                    rList.add(h);
                    continue;
                }
                rList.add(h);
            }
        }
        if (!handleMap.isEmpty()) {
            for (CommunicationHandle h : handleMap.values()) {
                try {
                    h.shutdown();
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)ex.getMessage());
                }
            }
        }
        if (this.shutdown.get()) {
            this.shutdown();
            return new LinkedList<CommunicationHandle>();
        }
        return rList;
    }

    protected ReadWriteProtocolHandlerChain createReadWriteProtocolHandlerChain(MulticastUdpSocketHandle handle, Key key) {
        ReadWriteProtocolHandlerChain rwchain = new ReadWriteProtocolHandlerChain();
        UDPResponseSenderFactory resFactory = new UDPResponseSenderFactory((CommunicationHandle)handle);
        rwchain.appendNextProtocolHandler((ProtocolHandler)new HMPAppXProtocolHandler((HMPResponseSenderFactory)resFactory, (ServiceActionManager)new HMPServiceActionManager(), String.valueOf(RandomStringGenerator.getDefaultInstance().getNewNumberString(8)) + System.currentTimeMillis(), (CryptoFactory)new SymmetricCryptoFactory((SymmetricKeyGetter)new UDPKeyGetter(key))));
        rwchain.appendNextProtocolHandler((ProtocolHandler)new UDPFrameXProtocolHandler(1004));
        rwchain.appendNextProtocolHandler((ProtocolHandler)new RootWriteProtocolHandler());
        return rwchain;
    }

    private CommunicationHandle createCommunicationHandle(String ifaceName, String bindIp) {
        try {
            String name = String.valueOf(NAMEPRFIX) + ifaceName + "_" + bindIp;
            MulticastUdpSocketHandle handle = new MulticastUdpSocketHandle(name);
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("accept.udp.port", String.valueOf(0));
            if (bindIp != null && bindIp.length() > 0) {
                config.put("accept.udp.host", bindIp);
            }
            handle.setConfig(config);
            handle.setTimeoutObjectPool(ServiceUtil.getServiceContext().getTimeoutObjectPool());
            handle.setProtocolHandlerChain((ProtocolHandlerChain)this.createReadWriteProtocolHandlerChain(handle, this.key));
            handle.start();
            if (CommunicationHandleManger.getCommunicationHandle((String)name) == null) {
                handle.shutdown();
                throw new RuntimeException("Please check! Multicastudpsockethandle started! But communication handle manger didn't find out");
            }
            return handle;
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)"Start exception! ", (Throwable)ex);
            return null;
        }
    }

    private Map<String, Collection<String>> getAllValidInterface() throws IOException {
        long mills = ServiceUtil.getServiceContext().currentTimeMillis();
        if (this.allValidInterfaceMap == null || mills - this.lastVs > 2000L) {
            HashMap<String, Collection<String>> listMap = new HashMap<String, Collection<String>>();
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            block0: while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                if (!i.isUp() || !i.supportsMulticast() || i.isLoopback() || i.isPointToPoint() || i.isVirtual()) continue;
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    TreeSet<String> list = (TreeSet<String>)listMap.get(i.getName());
                    if (list == null) {
                        list = new TreeSet<String>();
                        listMap.put(i.getName(), list);
                    }
                    list.add(addr.getHostAddress());
                    continue block0;
                }
            }
            this.lastVs = ServiceUtil.getServiceContext().currentTimeMillis();
            this.allValidInterfaceMap = listMap;
        }
        return this.allValidInterfaceMap;
    }

    private Map<String, CommunicationHandle> getAllHandlerMap() {
        HashMap<String, CommunicationHandle> vmap = new HashMap<String, CommunicationHandle>();
        Enumeration handles = CommunicationHandleManger.getCommunicationHandles();
        while (handles.hasMoreElements()) {
            CommunicationHandle handle = (CommunicationHandle)handles.nextElement();
            if (handle == null || !handle.getName().startsWith(NAMEPRFIX)) continue;
            vmap.put(handle.getName(), handle);
        }
        return vmap;
    }

    private void closeAll() {
        Enumeration handles = CommunicationHandleManger.getCommunicationHandles();
        while (handles.hasMoreElements()) {
            CommunicationHandle handle = (CommunicationHandle)handles.nextElement();
            if (handle == null || !handle.getName().startsWith(NAMEPRFIX)) continue;
            try {
                handle.shutdown();
            }
            catch (IOException e) {
                ServiceLog.getLog().warn((Object)e.getMessage());
            }
        }
    }

    public void shutdown() {
        this.shutdown.set(true);
        this.closeAll();
    }

    public static class UDPResponseSenderFactory
    implements HMPResponseSenderFactory {
        private CommunicationHandle handle;

        private UDPResponseSenderFactory(CommunicationHandle handle) {
            this.handle = handle;
        }

        public ResponseSender createResponseSender(HMPAppPacket receiverPacket) {
            HMPSender sender = new HMPSender(this.handle, (Receiver)receiverPacket);
            sender.setRemoteSendId(receiverPacket.getRemoteSendId());
            Object revType1 = receiverPacket.getAttribute("MSG_FROM_SOURCE_TYPE");
            if (revType1 != null && revType1 instanceof Integer) {
                Integer revType = (Integer)revType1;
                if (revType == 2) {
                    Object entry = receiverPacket.getAttribute("USE_CLOUD_PROXY_ENTRY");
                    if (entry != null) {
                        sender.setAttribute("USE_CLOUD_PROXY_ENTRY", entry);
                    }
                } else {
                    sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
                }
            }
            return sender;
        }
    }
}

