/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.conn.udp.CarparkUdpActionUtil;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.transfer.DataProtocol;
import com.wovoe.framework.transfer.IOResponse;
import com.wovoe.framework.transfer.ResultResponse;
import com.wovoe.framework.transfer.ResultResponseMap;
import com.wovoe.framework.transfer.ServiceActionManager;
import com.wovoe.framework.transfer.ServiceRequest;
import com.wovoe.framework.transfer.connection.WaitResultTimeout;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CaraprkDatatransferRPCAction
implements ServiceAction {
    public static final String ActionName = "/CaraprkDatatransferRPCAction";

    public void service(Receiver request) throws Exception {
        block25: {
            DataProtocol dataFrame;
            CarparkHost local_Host = ServiceUtil.getServiceContext().getLocalHost();
            if (local_Host == null) {
                CarparkUdpActionUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u7cfb\u7edf\u672a\u521d\u59cb\u5316", null);
                return;
            }
            String localHost = ServiceUtil.getServiceContext().getLocalHostNo();
            String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
            if (request.getDataLength() == 0 || request.getData() == null || request.getData().length == 0) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u6570\u636e\u57df", signKey);
                return;
            }
            String sign = request.getHeaderValue("sign");
            if (sign == null || sign.length() == 0) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u7b7e\u540d", signKey);
                return;
            }
            String srcHostNo = request.getHeaderValue("srcHostNo");
            if (srcHostNo == null || srcHostNo.length() == 0) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", signKey);
                return;
            }
            String destHostNo = request.getHeaderValue("destHostNo");
            if (destHostNo == null || destHostNo.length() == 0) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", signKey);
                return;
            }
            String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
            if (!sign.equals(checkSign)) {
                CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
                return;
            }
            CarparkHost requestHost = null;
            Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            if (hmap != null) {
                requestHost = hmap.get(srcHostNo);
            }
            if (requestHost == null) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u7981\u6b62\u8bbf\u95ee,\u4e3b\u673a\u4e0d\u5b58\u5728,\u4e3b\u673a\u7f16\u53f7\u65e0\u6548", signKey);
                return;
            }
            if (srcHostNo.equals(destHostNo)) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", signKey);
                return;
            }
            if (local_Host.getHost_use() == 2 || local_Host.getHost_use() == 3) {
                CarparkUdpClientManager.getInstance().updateClient(srcHostNo, request);
            }
            if (!destHostNo.equals(localHost)) {
                String canProxy = request.getHeaderValue("canProxy");
                if (canProxy != null && "false".equals(canProxy)) {
                    CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u9519\u8bef", signKey);
                    return;
                }
                if (local_Host.getHost_use() != 2 && local_Host.getHost_use() != 3) {
                    CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u672c\u673a\u4e0d\u662f\u505c\u8f66\u573a\u670d\u52a1\u5668\uff0c\u62d2\u7edd\u4ee3\u7406\u8f6c\u53d1\u6570\u636e", signKey);
                    return;
                }
                CarparkHost proxyHost = hmap.get(destHostNo);
                if (proxyHost == null) {
                    CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u4e0d\u5b58\u5728", signKey);
                    return;
                }
                if (proxyHost.getHost_use() != 1) {
                    CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u4ee3\u7406\u4e3b\u673a\u5fc5\u987b\u662f\u5ba2\u6237\u7aef\u4e3b\u673a", signKey);
                    return;
                }
                if (proxyHost.getNet_mode() == 2) {
                    CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u6682\u65f6\u4e0d\u652f\u6301\u4ee3\u7406\u8f6c\u53d1\u8c03\u7528", signKey);
                    return;
                }
                if (proxyHost.getNet_mode() == 1) {
                    CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u6682\u65f6\u4e0d\u652f\u6301\u4ee3\u7406\u8f6c\u53d1\u8c03\u7528", signKey);
                    return;
                }
                CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u4ee3\u7406\u4e3b\u673a\u672a\u77e5\u7684\u7f51\u7edc\u6a21\u5f0f", signKey);
                return;
            }
            try {
                String jsonString = new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8");
                dataFrame = DataProtocol.parse((String)jsonString, null, null);
            }
            catch (Throwable ex) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u4e0d\u662f\u6709\u6548\u7684JSON", signKey);
                return;
            }
            if (dataFrame.getCmd() == null || dataFrame.getCmd().length() == 0) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6570\u636e\u57df\u7f3a\u5c11cmd!", signKey);
                return;
            }
            if (dataFrame.getMsgId() == null) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6570\u636e\u57df\u7f3a\u5c11msgId!", signKey);
                return;
            }
            IOResponse9 re = new IOResponse9(request, dataFrame.getMsgId(), signKey);
            try {
                com.wovoe.framework.transfer.ServiceAction action = ServiceActionManager.getInstance().getServiceAction(dataFrame.getCmd());
                if (action != null) {
                    action.execute((ServiceRequest)dataFrame, (IOResponse)re);
                } else {
                    ResultResponse res = new ResultResponse();
                    res.setResponseCode("404");
                    res.setResponseMsg("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + dataFrame.getCmd() + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                    re.doResponse(String.valueOf(dataFrame.getCmd()) + "Result", res);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"handle error!", (Throwable)ex);
                if (re.submit.get()) break block25;
                ResultResponse res = new ResultResponse();
                res.setResponseCode("500");
                res.setResponseMsg("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
                re.doResponse(String.valueOf(dataFrame.getCmd()) + "Result", res);
            }
        }
    }

    private static class IOResponse9
    implements IOResponse {
        private Receiver request;
        private String msgId;
        private String signKey;
        private AtomicBoolean submit = new AtomicBoolean(false);

        private IOResponse9(Receiver request, String msgId, String signKey) {
            this.request = request;
            this.msgId = msgId;
            this.signKey = signKey;
        }

        private void doResponse0(String cmd, Object data) throws IOException {
            DataProtocol f = new DataProtocol();
            f.setCmd(cmd);
            f.setData(data);
            f.setTimeMills(String.valueOf(System.currentTimeMillis()));
            f.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
            f.setMsgId(this.msgId);
            String jsonStr = f.toSendString(null, null);
            byte[] jspmData = jsonStr.getBytes("UTF-8");
            ResponseSender response = this.request.createResponse();
            response.setHeader("respCode", "SUCCESS");
            response.setHeader("respMsg", "SUCCESS");
            response.setSendData(jspmData);
            response.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)response, (String)this.signKey));
            response.doResponse(null, null);
        }

        public void doResponse(final String cmd, Object data) throws IOException {
            try {
                if (this.submit.compareAndSet(false, true)) {
                    if (data instanceof OperationFuture) {
                        long waiMills = WaitResultTimeout.getAndRemove((long)15000L);
                        if (waiMills <= 0L) {
                            waiMills = 15000L;
                        }
                        OperationFuture opf = (OperationFuture)data;
                        opf.addCompleteListener(new OperationFuture.CompleteListener(){

                            public void operationComplete(OperationFuture future) {
                                if (future.isCancelled()) {
                                    this.doResponseX(new ResultResponseMap("501", "operation canceled"));
                                } else if (future.getException() != null) {
                                    LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result returns an exception"), future.getException());
                                    this.doResponseX(new ResultResponseMap("500", "Internal business processing exception"));
                                } else if (future.getResult() == null) {
                                    LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result returns NULL"));
                                    this.doResponseX(new ResultResponseMap("502", "Asynchronous processing business return null"));
                                } else {
                                    this.doResponseX(future.getResult());
                                }
                            }

                            public void waitCompleteTimeout() {
                                LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result timeout"));
                                this.doResponseX(new ResultResponseMap("501", "Asynchronous processing business timeout"));
                            }

                            private void doResponseX(Object obj) {
                                try {
                                    this.doResponse0(cmd, obj);
                                }
                                catch (Throwable ex) {
                                    LogUtil.getLog().warn((Object)("Response: " + cmd + ", Excption!" + ex.getMessage()));
                                }
                            }
                        }, waiMills, TimeUnit.MILLISECONDS);
                    } else {
                        this.doResponse0(cmd, data);
                    }
                } else {
                    ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5e94\u8be5\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801");
                }
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u9519\u8bef\uff01");
            }
        }
    }
}

