/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.conn.udp.CarparkUdpActionUtil;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.RecordSaveService;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CaraprkDownloadFileAction
implements ServiceAction {
    public static final String ActionName = "/CaraprkDownloadFileAction";
    public static final String OP_DOWNLOAD_UPGRADE_FILE = "downloadUpgradeFile";
    public static final String OP_DOWNLOAD_DB_PIC = "downloadDBPic";

    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if (OP_DOWNLOAD_UPGRADE_FILE.equals(op)) {
            this.downloadUpgradeFile(request);
        } else if (OP_DOWNLOAD_DB_PIC.equals(op)) {
            this.downloadDBPic(request);
        }
    }

    private void downloadDBPic(Receiver request) throws Exception {
        ByteArrayOutputStream os;
        CarparkHost local_Host = ServiceUtil.getServiceContext().getLocalHost();
        if (local_Host == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u7cfb\u7edf\u672a\u521d\u59cb\u5316", null);
            return;
        }
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asign", signKey);
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
        if (!sign.equals(checkSign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
            return;
        }
        String srcHostNo = request.getHeaderValue("srcHostNo");
        if (srcHostNo == null || srcHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", signKey);
            return;
        }
        String destHostNo = request.getHeaderValue("destHostNo");
        if (destHostNo == null || destHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", signKey);
            return;
        }
        if (!destHostNo.equals(localHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u9519\u8bef", signKey);
            return;
        }
        CarparkHost vHost = null;
        Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hmap != null) {
            vHost = hmap.get(srcHostNo);
        }
        if (vHost == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u4e3b\u673a\u4e0d\u5b58\u5728,\u4e3b\u673a\u7f16\u53f7\u65e0\u6548", signKey);
            return;
        }
        if (srcHostNo.equals(destHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", signKey);
            return;
        }
        String dbpath = request.getHeaderValue("dbpath");
        if (dbpath == null || dbpath.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adbpath", signKey);
            return;
        }
        RecordSaveService s = (RecordSaveService)ServiceUtil.getServiceContext().getService(RecordSaveService.class);
        String path = s.getLocalPicPath(dbpath);
        File f1 = new File(path);
        if (f1.exists() && f1.isFile()) {
            long fileLen = f1.length();
            if (fileLen == 0L) {
                CarparkUdpActionUtil.doSimpleResponse(request, "FILE_NOT_FOUND", "\u6587\u4ef6\u4e0d\u5b58\u5728", signKey);
                return;
            }
            if (fileLen > 0x500000L) {
                CarparkUdpActionUtil.doSimpleResponse(request, "FILE_NOT_FOUND", "\u56fe\u7247\u8fc7\u5927\uff0c\u5e94\u8be5\u662f\u9519\u8bef\u4e86", signKey);
                return;
            }
            os = new ByteArrayOutputStream((int)fileLen);
            try (FileInputStream is = new FileInputStream(f1);){
                int read;
                byte[] buff = new byte[8192];
                while ((read = ((InputStream)is).read(buff)) != -1) {
                    os.write(buff, 0, read);
                }
            }
        } else {
            CarparkUdpActionUtil.doSimpleResponse(request, "FILE_NOT_FOUND", "\u6587\u4ef6\u4e0d\u5b58\u5728", signKey);
            return;
        }
        byte[] dataB = os.toByteArray();
        os.close();
        ResponseSender sender = CarparkUdpActionUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
        sender.setSendData(dataB);
        sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
        sender.doResponse(null, null);
    }

    private void downloadUpgradeFile(Receiver request) throws Exception {
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asign", signKey);
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
        if (!sign.equals(checkSign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
            return;
        }
        String srcHostNo = request.getHeaderValue("srcHostNo");
        if (srcHostNo == null || srcHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", signKey);
            return;
        }
        String destHostNo = request.getHeaderValue("destHostNo");
        if (destHostNo == null || destHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", signKey);
            return;
        }
        if (!destHostNo.equals(localHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u9519\u8bef", signKey);
            return;
        }
        CarparkHost clientHost = null;
        Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hmap != null) {
            clientHost = hmap.get(srcHostNo);
        }
        if (clientHost == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u4e3b\u673a\u4e0d\u5b58\u5728,\u4e3b\u673a\u7f16\u53f7\u65e0\u6548", signKey);
            return;
        }
        if (srcHostNo.equals(destHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", signKey);
            return;
        }
        String seek = request.getHeaderValue("seek");
        String version = request.getHeaderValue("version");
        String reqId = request.getHeaderValue("reqId");
        if (version == null || version.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1aversion", signKey);
            return;
        }
        if (reqId == null || reqId.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1areqId", signKey);
            return;
        }
        File f1 = new File(PathFinder.findLocalDir(), "upgrade/download/" + version + ".zip");
        if (!f1.exists() || !f1.isFile()) {
            CarparkUdpActionUtil.doSimpleResponse(request, "FILE_NOT_FOUND", "\u6587\u4ef6\u4e0d\u5b58\u5728", signKey);
            return;
        }
        long seekPos = 0L;
        if (seek != null && seek.length() > 0) {
            try {
                seekPos = Long.parseLong(seek);
            }
            catch (Exception ex) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u53c2\u6570seek\u503c\u9519\u8bef", signKey);
                return;
            }
            if (seekPos < 0L) {
                CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u53c2\u6570seek\u503c\u9519\u8bef", signKey);
                return;
            }
        }
        try (RandomAccessFile rad = new RandomAccessFile(f1, "r");){
            Receiver rv = request;
            long fileLen = rad.length();
            if (seekPos < fileLen) {
                int read;
                rad.seek(seekPos);
                byte[] buff = new byte[5120];
                int total = 0;
                long timeMills = 15000L;
                while ((read = rad.read(buff)) != -1) {
                    OperationFuture<Receiver> opv = this.write(rv, buff, 0, read, reqId, fileLen, (long)(total += read) + seekPos, timeMills, signKey);
                    if ((rv = (Receiver)opv.get(timeMills + 1000L, TimeUnit.MILLISECONDS)) != null) continue;
                    throw new TimeoutException("\u8fdc\u7a0b\u5904\u7406\u6587\u4ef6\u54cd\u5e94\u8d85\u65f6");
                }
            }
            ResponseSender ser = rv.createResponse();
            ser.setHeader("respCode", "SUCCESS");
            ser.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            ser.setHeader("reqId", reqId);
            ser.setHeader("finish", "true");
            ser.setHeader("totalLen", String.valueOf(fileLen));
            ser.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)ser, (String)signKey));
            ser.doResponse(null, null);
        }
        catch (Throwable ex) {
            Throwable re;
            if (ex instanceof ExecutionException && (re = ((ExecutionException)ex).getCause()) != null) {
                ex = re;
            }
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5347\u7ea7\u6587\u4ef6\u5f02\u5e38\uff1a" + ex.getMessage()));
        }
    }

    private OperationFuture<Receiver> write(Receiver request, byte[] data, int offset, int len, final String reqId, long totalLen, long finishedSize, final long timeMills, final String signKey) {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            ResponseSender ser = request.createResponse();
            ser.setHeader("respCode", "SUCCESS");
            ser.setHeader("reqId", reqId);
            ser.setHeader("totalLen", String.valueOf(totalLen));
            ser.setHeader("finishedSize", String.valueOf(finishedSize));
            ser.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            ser.setSendData(data, offset, len);
            ser.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)ser, (String)signKey));
            ser.doResponse(new SendCallback(){

                public void onException(Throwable ex) {
                    f.setException(ex);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    f.setException((Throwable)new TimeoutException("\u8fdc\u7a0b\u5904\u7406\u6587\u4ef6\u54cd\u5e94\u8d85\u65f6"));
                }

                public long getWaitTimeoutMills() {
                    return timeMills;
                }

                public void doReceiver(Receiver r, int id) throws Exception {
                    String respCode = r.getHeaderValue("respCode");
                    if (!"SUCCESS".equals(respCode)) {
                        f.setException((Throwable)new IOException("\u4f20\u8f93\u6587\u4ef6\u5931\u8d25!\u5bf9\u65b9\u7ec8\u6b62\u4f20\u8f93\uff01\u7ec8\u6b62\u7801:" + respCode));
                        return;
                    }
                    String reqId0 = r.getHeaderValue("reqId");
                    if (reqId0 == null || reqId0.length() == 0) {
                        f.setException((Throwable)new IOException("\u4f20\u8f93\u6587\u4ef6\u5931\u8d25!\u54cd\u5e94\u7f3a\u5c11reqId"));
                        return;
                    }
                    if (!reqId0.equals(reqId)) {
                        f.setException((Throwable)new IOException("\u4f20\u8f93\u6587\u4ef6\u5931\u8d25!reqId\u4e0d\u4e00\u81f4"));
                        return;
                    }
                    String sign = r.getHeaderValue("sign");
                    if (sign == null || sign.length() == 0) {
                        f.setException((Throwable)new IOException("\u4f20\u8f93\u6587\u4ef6\u5931\u8d25!\u54cd\u5e94\u7f3a\u5c11\u6570\u636e\u7b7e\u540d"));
                        return;
                    }
                    String sign1 = HMPNetDataSignTool.getSign((Receiver)r, (String)signKey);
                    if (!sign.equals(sign1)) {
                        f.setException((Throwable)new IOException("\u4f20\u8f93\u6587\u4ef6\u5931\u8d25!\u6570\u636e\u7b7e\u540d\u6821\u9a8c\u4e0d\u4e00\u81f4"));
                        return;
                    }
                    f.setResult((Object)r);
                }
            });
        }
        catch (Throwable ex) {
            f.setException(ex);
        }
        return f;
    }
}

