/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.google.gson.Gson;
import com.wovoe.carpark.conn.udp.CarparkUdpActionUtil;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.Pagination;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.db.sync.DelOp;
import com.wovoe.framework.db.sync.SyncTableLog;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CarparkSyncTableDataAction
implements ServiceAction {
    public static final String ActionName = "/CarparkSyncTableDataAction";
    public static final String OP_SYNCALLDATA = "syncAllData";
    public static final String OP_SYNCLOGDATA = "syncLogData";
    private static final String ck_carpark_escape_order = "ck_carpark_escape_order";

    public void service(Receiver request) throws Exception {
        CarparkHost local_Host = ServiceUtil.getServiceContext().getLocalHost();
        if (local_Host == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u7cfb\u7edf\u672a\u521d\u59cb\u5316", null);
            return;
        }
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asign", signKey);
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
        if (!sign.equals(checkSign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
            return;
        }
        if (local_Host.getHost_use() != 2 && local_Host.getHost_use() != 3) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u672c\u673a\u4e0d\u662f\u505c\u8f66\u573a\u670d\u52a1\u5668\uff0c\u62d2\u7edd\u8bbf\u95ee\u6b64\u63a5\u53e3", signKey);
            return;
        }
        String srcHostNo = request.getHeaderValue("srcHostNo");
        if (srcHostNo == null || srcHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", signKey);
            return;
        }
        String destHostNo = request.getHeaderValue("destHostNo");
        if (destHostNo == null || destHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", signKey);
            return;
        }
        if (!destHostNo.equals(localHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u9519\u8bef", signKey);
            return;
        }
        CarparkHost clientHost = null;
        Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hmap != null) {
            clientHost = hmap.get(srcHostNo);
        }
        if (clientHost == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u4e3b\u673a\u4e0d\u5b58\u5728,\u4e3b\u673a\u7f16\u53f7\u65e0\u6548", signKey);
            return;
        }
        if (clientHost.getHost_use() != 1) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u5fc5\u987b\u662f\u5ba2\u6237\u7aef\u4e3b\u673a\u624d\u80fd\u8bbf\u95ee\u6b64\u63a5\u53e3", signKey);
            return;
        }
        if (srcHostNo.equals(destHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", signKey);
            return;
        }
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1aop", signKey);
            return;
        }
        CarparkUdpClientManager.getInstance().updateClient(srcHostNo, request);
        if (OP_SYNCALLDATA.equals(op)) {
            this.syncAllData(request, srcHostNo, signKey);
        } else if (OP_SYNCLOGDATA.equals(op)) {
            this.syncLogData(request, srcHostNo, signKey);
        } else {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u53c2\u6570\uff1aop\u503c\uff1a" + op + "\uff0c\u9519\u8bef", signKey);
            return;
        }
    }

    private void syncAllData(Receiver request, String srcHostNo, String signKey) {
        String tableName = request.getHeaderValue("tableName");
        if (tableName == null || tableName.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u8868\u540d\u79f0", signKey);
            return;
        }
        String reqId = request.getHeaderValue("reqId");
        if (reqId == null || reqId.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570reqId", signKey);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        Calendar cl = Calendar.getInstance();
        cl.set(14, 0);
        Date opTime = cl.getTime();
        String primeryKey = commonDaoService.getPrimaryKeyNames(tableName)[0];
        int fetchSize = 100;
        String idValue = "0";
        Gson gson = GsonBuilder.create();
        this.doSyncAllData0(request, primeryKey, idValue, fetchSize, commonDaoService, tableName, opTime, signKey, gson, reqId, srcHostNo);
    }

    private void doSyncAllDataFinish(Receiver request, CommonDaoService commonDaoService, String tableName, Date opTime, Gson gson, String reqId, String signKey) {
        SyncTableLog rdata;
        ArrayList<String> syncDataList;
        block9: {
            String syncLogTableName = "ck_ddl_sync_log";
            Pagination pagination = new Pagination();
            pagination.setRecordsCount(1L);
            pagination.setPageSize(1);
            pagination.setNeedQueryCount(false);
            pagination.setGotoPage(1);
            SearchParam searchParam = new SearchParam(syncLogTableName).addEQ("table_name", (Object)tableName).addLTE("op_time", (Object)opTime).setOrerbySql("id DESC");
            Map object = commonDaoService.selectOne(searchParam, pagination);
            syncDataList = null;
            rdata = new SyncTableLog();
            try {
                if (object == null) {
                    String syncLogTableSeqName = "ck_ddl_sync_log_seq";
                    CommonParam insertParam = new CommonParam(syncLogTableName);
                    insertParam.addInsert("id", (Object)commonDaoService.getSequece(syncLogTableSeqName));
                    insertParam.addInsert("table_name", (Object)tableName);
                    insertParam.addInsert("pk_value", (Object)0L);
                    insertParam.addInsert("op_type", (Object)"D");
                    insertParam.addInsert("op_time", (Object)opTime);
                    commonDaoService.insert(insertParam);
                    searchParam = new SearchParam(syncLogTableName).addEQ("table_name", (Object)tableName).addGTE("op_time", (Object)opTime).setOrerbySql("id ASC");
                    List logMapList = commonDaoService.selectList(searchParam, null);
                    syncDataList = new ArrayList<String>(logMapList.size());
                    try {
                        for (Map logMap : logMapList) {
                            String datax = this.getSyncByLogData(logMap, commonDaoService, gson);
                            syncDataList.add(datax);
                        }
                    }
                    catch (Exception ex) {
                        ServiceLog.getLog().warn((Object)("\u5ba2\u6237\u540c\u6b65\u8868\uff1a" + tableName + "\u6570\u636e\u5f02\u5e38,\u521b\u5efa\u65e5\u5fd7\u6570\u636e\u5f02\u5e38"), (Throwable)ex);
                        CarparkUdpActionUtil.doSimpleResponse(request, "RESP_CODE_SERVICE_ERROR", "\u5185\u90e8\u9519\u8bef\uff0c\u540c\u6b65\u8868" + tableName + "\u65e5\u5fd7\u5f02\u5e38", signKey);
                        return;
                    }
                    rdata.setLatest_sync_log_id((Long)((Map)logMapList.get(logMapList.size() - 1)).get("id"));
                    rdata.setLatest_sync_log_time((Date)((Map)logMapList.get(logMapList.size() - 1)).get("op_time"));
                    rdata.setOp_type((String)((Map)logMapList.get(logMapList.size() - 1)).get("op_type"));
                    rdata.setTable_name((String)((Map)logMapList.get(logMapList.size() - 1)).get("table_name"));
                    break block9;
                }
                rdata.setLatest_sync_log_id((Long)object.get("id"));
                rdata.setLatest_sync_log_time((Date)object.get("op_time"));
                rdata.setOp_type((String)object.get("op_type"));
                rdata.setTable_name((String)object.get("table_name"));
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u540c\u6b65\u6570\u636e\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff1a", (Throwable)ex);
                CarparkUdpActionUtil.doSimpleResponse(request, "RESP_CODE_SERVICE_ERROR", "\u5185\u90e8\u9519\u8bef\uff0c\u540c\u6b65\u8868" + tableName + "\u5f02\u5e38", signKey);
                return;
            }
        }
        try {
            ResponseSender sender = request.createResponse();
            sender.setHeader("respCode", "SUCCESS");
            sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            sender.setHeader("reqId", reqId);
            sender.setHeader("tableName", tableName);
            sender.setHeader("finish", "true");
            sender.setHeader("bb", gson.toJson((Object)rdata));
            if (syncDataList != null && !syncDataList.isEmpty()) {
                sender.setHeader("dataListSize", String.valueOf(syncDataList.size()));
                sender.setHeader("dataV", "ee");
                byte[] sendData = gson.toJson(syncDataList).getBytes("UTF-8");
                sender.setSendData(sendData);
            }
            sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
            sender.doResponse(new SendCallback(){

                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u54cd\u5e94\u5ba2\u6237\u7aef\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff01" + ex.getMessage()));
                }

                public void onCompleted() {
                }
            }, null);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u540c\u6b65\u6570\u636e\u670d\u52a1\u5668\u54cd\u5e94\u5f02\u5e38\uff1a" + ex.getMessage()));
        }
    }

    private void setSyncAllDataSearchParam(SearchParam sp) {
        if (ck_carpark_escape_order.equals(sp.getPhysical_table_name())) {
            sp.addEQ("order_state", (Object)0);
        }
    }

    private void doSyncAllData0(Receiver request, final String primeryKey, String idValue, final int fetchSize, final CommonDaoService commonDaoService, final String tableName, final Date opTime, final String signKey, final Gson gson, final String reqId, final String srcHostNo) {
        List list;
        Pagination pagination = new Pagination();
        pagination.setRecordsCount((long)fetchSize);
        pagination.setPageSize(fetchSize);
        pagination.setNeedQueryCount(false);
        pagination.setGotoPage(1);
        SearchParam searchParam = new SearchParam(tableName);
        searchParam.setWhereString(" AND " + primeryKey + " > " + idValue);
        searchParam.setOrder_by(String.valueOf(primeryKey) + " ASC");
        this.setSyncAllDataSearchParam(searchParam);
        try {
            list = commonDaoService.selectList(searchParam, pagination);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u5ba2\u6237\u4e0b\u8f7d\u8868\uff1a" + tableName + "\u6570\u636e\u5f02\u5e38"), (Throwable)ex);
            CarparkUdpActionUtil.doSimpleResponse(request, "RESP_CODE_SERVICE_ERROR", "\u5185\u90e8\u9519\u8bef\uff0c\u67e5\u8be2\u8868" + tableName + "\u5f02\u5e38", signKey);
            return;
        }
        if (list == null || list.isEmpty()) {
            this.doSyncAllDataFinish(request, commonDaoService, tableName, opTime, gson, reqId, signKey);
        } else {
            final String lastIdValue = ((Map)list.get(list.size() - 1)).get(primeryKey).toString();
            try {
                ResponseSender sender = request.createResponse();
                sender.setHeader("respCode", "SUCCESS");
                sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
                sender.setHeader("dataListSize", String.valueOf(list.size()));
                sender.setHeader("reqId", reqId);
                sender.setHeader("tableName", tableName);
                sender.setHeader("finish", "false");
                sender.setHeader("dataV", "cc");
                String dataListJson = gson.toJson((Object)list);
                byte[] dataBytes = dataListJson.getBytes("UTF-8");
                sender.setSendData(dataBytes);
                sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
                sender.doResponse(new SendCallback(){

                    public void onException(Throwable ex) {
                        ServiceLog.getLog().warn((Object)("\u540c\u6b65\u6570\u636e\u9519\u8bef\uff0c\u53d1\u9001\u5ba2\u6237\u7aef\u6570\u636e\u5931\u8d25!" + ex.getMessage()));
                    }

                    public void onCompleted() {
                    }
                }, new ReceiveCallback(){

                    public void onWaitTimeout() throws Exception {
                        ServiceLog.getLog().warn((Object)"\u540c\u6b65\u6570\u636e\u9519\u8bef\uff0c\u5ba2\u6237\u7aef\u54cd\u5e94\u8d85\u65f6");
                    }

                    public long getWaitTimeoutMills() {
                        return 20000L;
                    }

                    public void doReceiver(Receiver r, int id) throws Exception {
                        String respCode = r.getHeaderValue("respCode");
                        if (respCode == null || respCode.length() == 0) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u7f3a\u5c11\u54cd\u5e94\u7801", signKey);
                            return;
                        }
                        if (!"SUCCESS".equals(respCode)) {
                            ServiceLog.getLog().warn((Object)("\u5ba2\u6237\u7aef\u653e\u5f03\u8fde\u63a5\u8bf7\u6c42\u7ee7\u7eed\u540c\u6b65\u6570\u636e\u64cd\u4f5c\uff1a" + respCode));
                            return;
                        }
                        String tableName0 = r.getHeaderValue("tableName");
                        if (tableName0 == null || tableName0.length() == 0) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u7f3a\u5c11\u8868\u540d\u79f0", signKey);
                            return;
                        }
                        String reqId0 = r.getHeaderValue("reqId");
                        if (reqId0 == null || reqId0.length() == 0) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570reqId", signKey);
                            return;
                        }
                        if (!tableName0.equals(tableName)) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u8868\u540d\u79f0\u4e0d\u4e00\u81f4!", signKey);
                            return;
                        }
                        if (!reqId0.equals(reqId)) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u4e1a\u52a1ID\u4e0d\u4e00\u81f4!", signKey);
                            return;
                        }
                        String sign = r.getHeaderValue("sign");
                        if (sign == null || sign.length() == 0) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u7b7e\u540d\u5b57\u6bb5", signKey);
                            return;
                        }
                        String checkSign = HMPNetDataSignTool.getSign((Receiver)r, (String)signKey);
                        if (!sign.equals(checkSign)) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "SIGN_ERROR", "\u6570\u636e\u7b7e\u540d\u9519\u8bef", signKey);
                            return;
                        }
                        try {
                            CarparkUdpClientManager.getInstance().updateClient(srcHostNo, r);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        CarparkSyncTableDataAction.this.doSyncAllData0(r, primeryKey, lastIdValue, fetchSize, commonDaoService, tableName, opTime, signKey, gson, reqId, srcHostNo);
                    }
                });
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u4e0e\u5ba2\u6237\u7aef\u901a\u4fe1\u5f02\u5e38\uff1a" + ex.getMessage()));
            }
        }
    }

    private String getSyncByLogData(Map<String, Object> logMap, CommonDaoService service, Gson gson) throws UnsupportedEncodingException {
        boolean delete = false;
        String tableName = logMap.get("table_name").toString();
        String primeryKey = service.getPrimaryKeyNames(tableName)[0];
        String dataStr = null;
        String logStr = null;
        if ("D".equals(logMap.get("op_type"))) {
            delete = true;
        } else {
            SearchParam searchParam = new SearchParam(tableName);
            searchParam.setWhereString(" AND " + primeryKey + " = " + logMap.get("pk_value").toString());
            Map data = service.selectOne(searchParam);
            if (data == null) {
                delete = true;
            } else {
                dataStr = gson.toJson((Object)data);
                SyncTableLog vMap = new SyncTableLog();
                vMap.setLatest_sync_log_time((Date)logMap.get("op_time"));
                vMap.setLatest_sync_log_id((Long)logMap.get("id"));
                vMap.setOp_type((String)logMap.get("op_type"));
                vMap.setTable_name(tableName);
                logStr = gson.toJson((Object)vMap);
            }
        }
        if (delete) {
            DelOp delOp = new DelOp();
            delOp.setPk_value(logMap.get("pk_value").toString());
            dataStr = gson.toJson((Object)delOp);
            SyncTableLog vMap = new SyncTableLog();
            vMap.setLatest_sync_log_time((Date)logMap.get("op_time"));
            vMap.setLatest_sync_log_id((Long)logMap.get("id"));
            vMap.setOp_type("D");
            vMap.setTable_name(tableName);
            logStr = gson.toJson((Object)vMap);
        }
        return String.valueOf(dataStr) + "," + BytesTool.byteArrayToHexString((byte[])logStr.getBytes("UTF-8"));
    }

    private void syncLogData(Receiver request, String srcHostNo, String signKey) {
        Map dx;
        Long latest_sync_log_id;
        String tableName = request.getHeaderValue("tableName");
        if (tableName == null || tableName.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u8868\u540d\u79f0", signKey);
            return;
        }
        String latest_sync_log_id0 = request.getHeaderValue("latest_sync_log_id");
        if (latest_sync_log_id0 == null || latest_sync_log_id0.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u6700\u540e\u540c\u6b65\u65e5\u5fd7id", signKey);
            return;
        }
        try {
            latest_sync_log_id = Long.valueOf(latest_sync_log_id0);
        }
        catch (Exception ex) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u540e\u540c\u6b65\u65e5\u5fd7id\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff1a" + latest_sync_log_id0, signKey);
            return;
        }
        String reqId = request.getHeaderValue("reqId");
        if (reqId == null || reqId.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570reqId", signKey);
            return;
        }
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        String syncLogTableName = "ck_ddl_sync_log";
        SearchParam searchParam = new SearchParam(syncLogTableName).addEQ("table_name", (Object)tableName).addEQ("id", (Object)latest_sync_log_id);
        try {
            dx = commonDaoService.selectOne(searchParam);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u67e5\u8be2\u8868\uff1a" + syncLogTableName + "\u5f02\u5e38\uff01"), (Throwable)ex);
            CarparkUdpActionUtil.doSimpleResponse(request, "RESP_CODE_SERVICE_ERROR", "\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef\uff0c\u67e5\u8be2\u8868\u5f02\u5e38", signKey);
            return;
        }
        if (dx == null) {
            try {
                ResponseSender sender = CarparkUdpActionUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
                sender.setHeader("syncTable", "true");
                sender.setHeader("reqId", reqId);
                sender.setHeader("tableName", tableName);
                sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
                sender.doResponse(null, null);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u54cd\u5e94\u5f02\u5e38:" + ex.getMessage()));
            }
            return;
        }
        int fetchSize = 100;
        long idValue = latest_sync_log_id;
        Gson gson = GsonBuilder.create();
        this.syncLogData0(request, syncLogTableName, idValue, fetchSize, commonDaoService, tableName, signKey, gson, reqId, srcHostNo);
    }

    private void syncLogData0(Receiver request, final String syncLogTableName, long idValue, final int fetchSize, final CommonDaoService commonDaoService, final String tableName, final String signKey, final Gson gson, final String reqId, final String srcHostNo) {
        List loglist;
        Pagination pagination = new Pagination();
        pagination.setRecordsCount((long)fetchSize);
        pagination.setPageSize(fetchSize);
        pagination.setNeedQueryCount(false);
        pagination.setGotoPage(1);
        SearchParam searchParam = new SearchParam(syncLogTableName).addEQ("table_name", (Object)tableName).addGT("id", (Object)idValue);
        searchParam.setOrder_by("id ASC");
        try {
            loglist = commonDaoService.selectList(searchParam, pagination);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u5ba2\u6237\u540c\u6b65\u8868\uff1a" + tableName + "\u6570\u636e\u5f02\u5e38,\u67e5\u8be2\u65e5\u5fd7\u8868\u5f02\u5e38"), (Throwable)ex);
            CarparkUdpActionUtil.doSimpleResponse(request, "RESP_CODE_SERVICE_ERROR", "\u5185\u90e8\u9519\u8bef\uff0c\u67e5\u8be2\u8868" + tableName + "\u65e5\u5fd7\u5f02\u5e38", signKey);
            return;
        }
        if (loglist == null || loglist.isEmpty()) {
            try {
                ResponseSender sender = CarparkUdpActionUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
                sender.setHeader("finish", "true");
                sender.setHeader("reqId", reqId);
                sender.setHeader("tableName", tableName);
                sender.setHeader("dataListSize", "0");
                sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
                sender.doResponse(null, null);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u54cd\u5e94\u5f02\u5e38:" + ex.getMessage()));
            }
            return;
        }
        final long lastIdValue = (Long)((Map)loglist.get(loglist.size() - 1)).get("id");
        boolean finish = loglist.size() < fetchSize;
        ArrayList<String> syncDataList = new ArrayList<String>(loglist.size());
        try {
            for (Map logMap : loglist) {
                String datax = this.getSyncByLogData(logMap, commonDaoService, gson);
                syncDataList.add(datax);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u5ba2\u6237\u540c\u6b65\u8868\uff1a" + tableName + "\u6570\u636e\u5f02\u5e38,\u521b\u5efa\u65e5\u5fd7\u6570\u636e\u5f02\u5e38"), (Throwable)ex);
            CarparkUdpActionUtil.doSimpleResponse(request, "RESP_CODE_SERVICE_ERROR", "\u5185\u90e8\u9519\u8bef\uff0c\u540c\u6b65\u8868" + tableName + "\u65e5\u5fd7\u5f02\u5e38", signKey);
            return;
        }
        try {
            ResponseSender sender = request.createResponse();
            sender.setHeader("respCode", "SUCCESS");
            sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            sender.setHeader("dataListSize", String.valueOf(syncDataList.size()));
            sender.setHeader("reqId", reqId);
            sender.setHeader("tableName", tableName);
            sender.setHeader("dataV", "ee");
            sender.setHeader("finish", String.valueOf(finish));
            String dataListJson = gson.toJson(syncDataList);
            byte[] dataBytes = dataListJson.getBytes("UTF-8");
            sender.setSendData(dataBytes);
            sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
            ReceiveCallback revCallback = null;
            if (!finish) {
                revCallback = new ReceiveCallback(){

                    public void onWaitTimeout() throws Exception {
                        ServiceLog.getLog().warn((Object)"\u540c\u6b65\u6570\u636e\u9519\u8bef\uff0c\u5ba2\u6237\u7aef\u54cd\u5e94\u8d85\u65f6");
                    }

                    public long getWaitTimeoutMills() {
                        return 20000L;
                    }

                    public void doReceiver(Receiver r, int id) throws Exception {
                        String respCode = r.getHeaderValue("respCode");
                        if (respCode == null || respCode.length() == 0) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u7f3a\u5c11\u54cd\u5e94\u7801", signKey);
                            return;
                        }
                        if (!"SUCCESS".equals(respCode)) {
                            ServiceLog.getLog().warn((Object)("\u5ba2\u6237\u7aef\u653e\u5f03\u8fde\u63a5\u8bf7\u6c42\u7ee7\u7eed\u540c\u6b65\u6570\u636e\u64cd\u4f5c\uff1a" + respCode));
                            return;
                        }
                        String tableName0 = r.getHeaderValue("tableName");
                        if (tableName0 == null || tableName0.length() == 0) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u7f3a\u5c11\u8868\u540d\u79f0", signKey);
                            return;
                        }
                        String reqId0 = r.getHeaderValue("reqId");
                        if (reqId0 == null || reqId0.length() == 0) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570reqId", signKey);
                            return;
                        }
                        if (!tableName0.equals(tableName)) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u8868\u540d\u79f0\u4e0d\u4e00\u81f4!", signKey);
                            return;
                        }
                        if (!reqId0.equals(reqId)) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u4e1a\u52a1ID\u4e0d\u4e00\u81f4!", signKey);
                            return;
                        }
                        String sign = r.getHeaderValue("sign");
                        if (sign == null || sign.length() == 0) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\u7b7e\u540d\u5b57\u6bb5", signKey);
                            return;
                        }
                        String checkSign = HMPNetDataSignTool.getSign((Receiver)r, (String)signKey);
                        if (!sign.equals(checkSign)) {
                            CarparkUdpActionUtil.doSimpleResponse(r, "SIGN_ERROR", "\u6570\u636e\u7b7e\u540d\u9519\u8bef", signKey);
                            return;
                        }
                        try {
                            CarparkUdpClientManager.getInstance().updateClient(srcHostNo, r);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        CarparkSyncTableDataAction.this.syncLogData0(r, syncLogTableName, lastIdValue, fetchSize, commonDaoService, tableName, signKey, gson, reqId, srcHostNo);
                    }
                };
            }
            sender.doResponse(new SendCallback(){

                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u540c\u6b65\u6570\u636e\u9519\u8bef\uff0c\u53d1\u9001\u5ba2\u6237\u7aef\u6570\u636e\u5931\u8d25!" + ex.getMessage()));
                }

                public void onCompleted() {
                }
            }, revCallback);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u4e0e\u5ba2\u6237\u7aef\u901a\u4fe1\u5f02\u5e38\uff1a" + ex.getMessage()));
        }
    }
}

