/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.conn.udp.CarparkUdpActionCrypto;
import com.wovoe.carpark.conn.udp.CarparkUdpClient;
import com.wovoe.carpark.conn.udp.CarparkUdpConfig;
import com.wovoe.carpark.conn.udp.CarparkUdpConnSession;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.communication.protocol.ConnectionFactory;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.udp.UDPConfig;
import com.wovoe.framework.communication.udp.UDPEndpoint;
import com.wovoe.framework.communication.udp.UDPRemoteConnectionFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import java.util.Set;

public class CarparkUDPConnectionFactory
implements ConnectionFactory {
    private static final String acceptName = "CARPARK_HOSTTOHOST_EP";
    private UDPRemoteConnectionFactory factory;
    private int acceptPort;
    public static final String CONFIG_UDP_CARPARK_PORT = "accept.udp.carpark.port";

    private CarparkUDPConnectionFactory(UDPRemoteConnectionFactory fac, int port) {
        this.factory = fac;
        this.acceptPort = port;
    }

    public static CarparkUDPConnectionFactory createInstance(UDPEndpoint udpEndpoint, ServiceActionManager actionManager, int beginPort, int length, Set<Integer> notBindPorts) throws IOException {
        CarparkUdpConfig config;
        String v = ServiceUtil.getServiceContext().getConfig().getProperty(CONFIG_UDP_CARPARK_PORT, "").trim();
        int portp = -1;
        if (v != null && v.length() > 0) {
            try {
                portp = Integer.parseInt(v);
            }
            catch (Exception ex) {
                portp = -1;
            }
        }
        if (portp > 0 && portp <= 65535) {
            beginPort = portp;
            length = 1;
        }
        if (length < 1) {
            length = 1;
        }
        if (beginPort <= 0) {
            beginPort = 3001;
        } else if (beginPort > 65535) {
            beginPort = 65535;
        }
        int end = beginPort + length;
        if (end > 65536) {
            end = 65536;
        }
        String s1 = "ssIduewde%&*%3423287421";
        CarparkUdpActionCrypto crypto = new CarparkUdpActionCrypto();
        IOException lastex = null;
        int successPort = 0;
        if (beginPort != end && beginPort < end) {
            int rdn4 = -1;
            Random r = new Random();
            int i = 0;
            while (i < 100) {
                int rdn = CarparkUDPConnectionFactory.getRand(beginPort + 1, end, r);
                if (notBindPorts == null || !notBindPorts.contains(rdn)) {
                    rdn4 = rdn;
                    break;
                }
                ++i;
            }
            if (rdn4 > 0 && rdn4 > beginPort && rdn4 <= end) {
                try {
                    config = new CarparkUdpConfig(acceptName, rdn4, actionManager, crypto, s1);
                    config.setWaitAckTimeMills(2500);
                    udpEndpoint.bind((UDPConfig)config);
                    successPort = rdn4;
                }
                catch (IOException ex) {
                    successPort = 0;
                    String sn = "\u968f\u673a\u7aef\u53e3:" + rdn4 + "\u4e0d\u53ef\u7528\uff0c\u8fd9\u5c06\u5c1d\u8bd5\u4f7f\u7528\u7aef\u53e3:" + beginPort;
                    ServiceLog.getLog().warn((Object)sn);
                }
            }
        }
        if (successPort == 0) {
            int port = beginPort;
            while (port < end) {
                block23: {
                    try {
                        if (notBindPorts != null && notBindPorts.contains(port)) {
                            lastex = new IOException("\u7aef\u53e3:" + port + " \u88ab\u8bbe\u7f6e\u6210\u4e0d\u80fd\u88ab\u7ed1\u5b9a");
                            break block23;
                        }
                        config = new CarparkUdpConfig(acceptName, port, actionManager, crypto, s1);
                        config.setWaitAckTimeMills(2500);
                        udpEndpoint.bind((UDPConfig)config);
                        successPort = port;
                        break;
                    }
                    catch (IOException ex) {
                        lastex = ex;
                        String sn = "\u7aef\u53e3:" + port + "\u4e0d\u53ef\u7528";
                        sn = port != end - 1 ? String.valueOf(sn) + ", \u8fd9\u5c06\u5c1d\u8bd5\u4f7f\u7528\u7aef\u53e3:" + (port + 1) : (length == 1 ? String.valueOf(sn) + ", \u539f\u56e0\uff1a" + ex.getMessage() : String.valueOf(sn) + ", \u65e0\u53ef\u7528\u7aef\u53e3\u53ef\u7528,\u68c0\u6d4b\u8303\u56f4\uff1a[" + beginPort + "," + end + ")");
                        ServiceLog.getLog().warn((Object)sn);
                    }
                }
                ++port;
            }
        }
        if (successPort == 0) {
            if (lastex == null) {
                throw new IOException("\u65e0\u53ef\u7528\u7aef\u53e3\u53ef\u7528,\u68c0\u6d4b\u8303\u56f4\uff1a[" + beginPort + "," + end + ")");
            }
            if (length == 1) {
                throw lastex;
            }
            throw new IOException("\u65e0\u53ef\u7528\u7aef\u53e3\u53ef\u7528,\u68c0\u6d4b\u8303\u56f4\uff1a[" + beginPort + "," + end + ")");
        }
        UDPRemoteConnectionFactory f1 = new UDPRemoteConnectionFactory(successPort, udpEndpoint);
        return new CarparkUDPConnectionFactory(f1, successPort);
    }

    private static int getRand(int begin, int end, Random r) {
        int len;
        if (begin < 0) {
            begin = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (end > begin) {
            len = end - begin + 1;
        } else if (end < begin) {
            len = begin - end + 1;
        } else {
            return begin;
        }
        if (len <= 1) {
            return begin;
        }
        int h1 = Math.abs(r.nextInt());
        return begin + h1 % len;
    }

    public int getAcceport() {
        return this.acceptPort;
    }

    public RemoteConnection createConnection(SocketAddress address) throws IOException {
        return this.factory.createConnection(address);
    }

    public RemoteConnection createUdpConnection(SocketAddress address) throws IOException {
        return this.createConnection(address);
    }

    public RequestSender createUdpRequestSender(CarparkUdpConnSession connSession) throws IOException {
        RemoteConnection conn = this.createUdpConnection(connSession.getCarparkServerAddress());
        RequestSender sender = conn.createRequest();
        if (connSession.isUseCloudProxy()) {
            InetSocketAddress cloudAddress = connSession.getCloudSocketAddress();
            byte[] porxyToken = connSession.getProxyToken();
            if (cloudAddress != null && porxyToken != null && porxyToken.length > 0) {
                sender.setAttribute("USE_CLOUD_PROXY_ENTRY", (Object)new KeyValueEntry((Object)cloudAddress, (Object)porxyToken));
            } else {
                sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            }
        } else {
            sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
        }
        return sender;
    }

    public RequestSender createUdpRequestSender(CarparkUdpClient client) throws IOException {
        RemoteConnection conn = this.createUdpConnection(client.getClientAddress());
        RequestSender sender = conn.createRequest();
        if (client.isUseCloudProxy()) {
            InetSocketAddress cloudAddress = client.getCloudSocketAddress();
            byte[] porxyToken = client.getProxyToken();
            if (cloudAddress != null && porxyToken != null && porxyToken.length > 0) {
                sender.setAttribute("USE_CLOUD_PROXY_ENTRY", (Object)new KeyValueEntry((Object)cloudAddress, (Object)porxyToken));
            } else {
                sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            }
        } else {
            sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
        }
        return sender;
    }
}

