/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.cloud.CloudConnectTransferCrypto;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.RsaUtil;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.protocol.hmp.HMPActionCrypto;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.PublicKey;
import javax.crypto.Cipher;

public class CarparkUdpActionCrypto
implements HMPActionCrypto {
    private String CLOUDACTON_PREFIX = "/CloudCarpark_";
    private PublicKey cloudPublicKey;

    public boolean isCloudAction(String actionName) {
        return actionName != null && actionName.startsWith(this.CLOUDACTON_PREFIX);
    }

    protected Key getKey(boolean cloudAction) {
        if (cloudAction) {
            if (this.cloudPublicKey == null) {
                this.cloudPublicKey = CloudConnectTransferCrypto.getCloudPublicKey();
            }
            return this.cloudPublicKey;
        }
        return ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_CONN");
    }

    public ByteBuffer decrypt(ByteBuffer encryptBuffer, String actionName, ProtocolContext ctx) throws Exception {
        byte[] array;
        int length;
        int offset;
        if (actionName.startsWith("/CarparkUploadPicAction") || actionName.startsWith("/CaraprkDownloadFileAction")) {
            return encryptBuffer;
        }
        if (encryptBuffer == null) {
            return null;
        }
        if (!encryptBuffer.hasRemaining()) {
            return encryptBuffer;
        }
        if (encryptBuffer.hasArray()) {
            offset = encryptBuffer.position() + encryptBuffer.arrayOffset();
            length = encryptBuffer.remaining();
            array = encryptBuffer.array();
        } else {
            offset = 0;
            length = encryptBuffer.remaining();
            array = new byte[length];
            encryptBuffer.get(array);
        }
        boolean cloudAction = this.isCloudAction(actionName);
        Key key = this.getKey(cloudAction);
        if (cloudAction) {
            return RsaUtil.decrypt((byte[])array, (int)offset, (int)length, (Key)key);
        }
        return CryptoUtil.crypt((byte[])array, (int)offset, (int)length, (Cipher)CryptoUtil.getDecryptCipher((Key)key, (String)key.getAlgorithm()));
    }

    public ByteBuffer encrypt(ByteBuffer dataBuf, String actionName, ProtocolContext ctx) throws Exception {
        byte[] array;
        int length;
        int offset;
        if (actionName.startsWith("/CarparkUploadPicAction") || actionName.startsWith("/CaraprkDownloadFileAction")) {
            return dataBuf;
        }
        if (dataBuf == null) {
            return null;
        }
        if (!dataBuf.hasRemaining()) {
            return dataBuf;
        }
        if (dataBuf.hasArray()) {
            offset = dataBuf.position() + dataBuf.arrayOffset();
            length = dataBuf.remaining();
            array = dataBuf.array();
        } else {
            offset = 0;
            length = dataBuf.remaining();
            array = new byte[length];
            dataBuf.get(array);
        }
        boolean cloudAction = this.isCloudAction(actionName);
        if (cloudAction && ctx != null) {
            ctx.setAttribute("CLOUD_ACTION_HANDLE", (Object)Boolean.TRUE);
        }
        Key key = this.getKey(cloudAction);
        if (cloudAction) {
            byte[] data = RsaUtil.encrypt((byte[])array, (int)offset, (int)length, (Key)key);
            return ByteBuffer.wrap(data);
        }
        return CryptoUtil.crypt((byte[])array, (int)offset, (int)length, (Cipher)CryptoUtil.getEncryptCipher((Key)key, (String)key.getAlgorithm()));
    }
}

