/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.internel.ServiceUtil;
import java.net.InetSocketAddress;

public class CarparkUdpClient {
    private final String hostNo;
    private volatile InetSocketAddress clientAddress;
    private volatile long lastRevTimeMills;
    private volatile boolean useCloudProxy;
    private volatile InetSocketAddress cloudSocketAddress;
    private volatile byte[] proxyToken;

    public CarparkUdpClient(String hostNo) {
        this.hostNo = hostNo;
    }

    public void update(InetSocketAddress clientAddress, boolean useCloudProxy, InetSocketAddress cloudSocketAddress, byte[] proxyToken) {
        if (useCloudProxy && (cloudSocketAddress == null || proxyToken == null || proxyToken.length == 0)) {
            return;
        }
        this.clientAddress = clientAddress;
        this.useCloudProxy = useCloudProxy;
        this.cloudSocketAddress = cloudSocketAddress;
        this.proxyToken = proxyToken;
        this.lastRevTimeMills = ServiceUtil.getServiceContext().currentTimeMillis();
    }

    public InetSocketAddress getClientAddress() {
        return this.clientAddress;
    }

    public String getHostNo() {
        return this.hostNo;
    }

    public long getLastRevTimeMills() {
        return this.lastRevTimeMills;
    }

    public boolean isConnected() {
        return ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevTimeMills <= 15000L;
    }

    public boolean isUseCloudProxy() {
        return this.useCloudProxy;
    }

    public InetSocketAddress getCloudSocketAddress() {
        return this.cloudSocketAddress;
    }

    public byte[] getProxyToken() {
        return this.proxyToken;
    }
}

