/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.conn.udp.CarparkUdpClient;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.communication.protocol.Receiver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CarparkUdpClientManager {
    private final ConcurrentHashMap<String, CarparkUdpClient> manager = new ConcurrentHashMap();
    private static final CarparkUdpClientManager instance = new CarparkUdpClientManager();

    private CarparkUdpClientManager() {
    }

    public static CarparkUdpClientManager getInstance() {
        return instance;
    }

    public CarparkUdpClient getCarparkUdpClient(SocketAddress addess) {
        if (addess == null) {
            return null;
        }
        for (CarparkUdpClient c : this.manager.values()) {
            if (c.getClientAddress() == null || !c.getClientAddress().equals(addess)) continue;
            return c;
        }
        return null;
    }

    public CarparkUdpClient getConnectedClient(SocketAddress addess) {
        CarparkUdpClient c = this.getCarparkUdpClient(addess);
        if (c == null) {
            return null;
        }
        if (!c.isConnected()) {
            return null;
        }
        return c;
    }

    public CarparkUdpClient getConnectedClient(String hostNo) {
        CarparkUdpClient c = this.getCarparkUdpClient(hostNo);
        if (c == null) {
            return null;
        }
        if (!c.isConnected()) {
            return null;
        }
        return c;
    }

    public CarparkUdpClient getCarparkUdpClient(String hostNo) {
        if (hostNo == null) {
            return null;
        }
        return this.manager.get(hostNo);
    }

    public void updateClient(String hostNo, Receiver request) {
        Integer revType;
        if (request == null || hostNo == null) {
            return;
        }
        InetSocketAddress cloudPorxySocketAddress = null;
        byte[] proxyToken = null;
        InetSocketAddress clientAddress = (InetSocketAddress)request.getRemoteAddress();
        Object revType1 = request.getAttribute("MSG_FROM_SOURCE_TYPE");
        if (revType1 != null && revType1 instanceof Integer && (revType = (Integer)revType1) == 2) {
            Object entry = request.getAttribute("USE_CLOUD_PROXY_ENTRY");
            if (entry != null && entry instanceof KeyValueEntry) {
                KeyValueEntry rke = (KeyValueEntry)entry;
                try {
                    cloudPorxySocketAddress = (InetSocketAddress)rke.getKey();
                    proxyToken = (byte[])rke.getValue();
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u4ee3\u7406Entry\u9519\u8bef\uff01" + rke));
                    cloudPorxySocketAddress = null;
                    proxyToken = null;
                }
            } else {
                ServiceLog.getLog().warn((Object)"\u4e0d\u5e94\u8be5\u51fa\u73b0\u7684\u60c5\u51b5\uff0c\u6765\u81ea\u4e91\u7aef\u4ee3\u7406\u8bf7\u6c42,\u7f3a\u5c11\u4ee3\u7406\u4fe1\u606f\uff01\u8bf7\u68c0\u67e5\u3002\u3002\u3002");
            }
        }
        boolean useCloudProxy = cloudPorxySocketAddress != null && proxyToken != null && proxyToken.length > 0;
        this.updateClient(hostNo, clientAddress, useCloudProxy, cloudPorxySocketAddress, proxyToken);
    }

    public void updateClient(String hostNo, InetSocketAddress clientAddress, boolean useCloudProxy, InetSocketAddress cloudPorxySocketAddress, byte[] proxyToken) {
        if (hostNo == null || hostNo.length() == 0 || clientAddress == null) {
            return;
        }
        Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hmap == null || hmap.get(hostNo) == null) {
            if (this.manager.containsKey(hostNo)) {
                this.manager.remove(hostNo);
            }
            return;
        }
        CarparkUdpClient client = this.manager.get(hostNo);
        if (client == null) {
            CarparkUdpClient client0 = new CarparkUdpClient(hostNo);
            client0.update(clientAddress, useCloudProxy, cloudPorxySocketAddress, proxyToken);
            this.manager.put(hostNo, client0);
        } else {
            client.update(clientAddress, useCloudProxy, cloudPorxySocketAddress, proxyToken);
        }
    }
}

