/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.conn.udp.CarparkUdpProxyProtocolHandler;
import com.wovoe.framework.communication.ProtocolHandler;
import com.wovoe.framework.communication.ProtocolHandlerChain;
import com.wovoe.framework.communication.ReadWriteProtocolHandlerChain;
import com.wovoe.framework.communication.RootWriteProtocolHandler;
import com.wovoe.framework.communication.protocol.ServiceActionManager;
import com.wovoe.framework.communication.protocol.hmp.HMPActionCrypto;
import com.wovoe.framework.communication.protocol.hmp.HMPActionProtocolHandler;
import com.wovoe.framework.communication.protocol.hmp.HMPResponseSenderFactory;
import com.wovoe.framework.communication.protocol.hmp.HMPUDPFrameProtocolHandler;
import com.wovoe.framework.communication.udp.UDPConfig;
import com.wovoe.framework.communication.udp.UDPEndpoint;
import com.wovoe.framework.communication.udp.UDPResponseSenderFactory;

public class CarparkUdpConfig
implements UDPConfig {
    protected HMPActionCrypto actionCrypto;
    protected String acceptName;
    protected int port;
    protected ServiceActionManager manager;
    protected int reSendTimes = 2;
    protected int waitAckTimeMills = 1000;
    protected String waitKeyprex;

    public CarparkUdpConfig(String acceptName, int acceptPort, ServiceActionManager actionManager, HMPActionCrypto crypto, String waitKeyprex) {
        this.acceptName = acceptName;
        this.port = acceptPort;
        this.manager = actionManager;
        this.actionCrypto = crypto;
        this.waitKeyprex = waitKeyprex;
    }

    public ProtocolHandlerChain createProtocolHandlerChain(UDPEndpoint udpEndpoint) {
        ReadWriteProtocolHandlerChain rwchain = new ReadWriteProtocolHandlerChain();
        UDPResponseSenderFactory resFactory = new UDPResponseSenderFactory(this.port, udpEndpoint);
        rwchain.appendNextProtocolHandler((ProtocolHandler)new HMPActionProtocolHandler((HMPResponseSenderFactory)resFactory, this.manager, this.actionCrypto, this.waitKeyprex));
        rwchain.appendNextProtocolHandler((ProtocolHandler)new HMPUDPFrameProtocolHandler(931));
        rwchain.appendNextProtocolHandler((ProtocolHandler)new CarparkUdpProxyProtocolHandler());
        rwchain.appendNextProtocolHandler((ProtocolHandler)new RootWriteProtocolHandler());
        return rwchain;
    }

    public int getReSendTimes() {
        return this.reSendTimes;
    }

    public int getACKTimeoutMills() {
        return this.waitAckTimeMills;
    }

    public void setResendTimes(int reSendTimes) {
        if (reSendTimes > 0) {
            this.reSendTimes = reSendTimes;
        }
    }

    public void setWaitAckTimeMills(int waitAckTimeMills) {
        if (waitAckTimeMills > 0) {
            this.waitAckTimeMills = waitAckTimeMills;
        }
    }

    public HMPActionCrypto getActionCrypto() {
        return this.actionCrypto;
    }

    public void setActionCrypto(HMPActionCrypto actionCrypto) {
        this.actionCrypto = actionCrypto;
    }

    public String getWaitKeyprex() {
        return this.waitKeyprex;
    }

    public void setWaitKeyprex(String waitKeyprex) {
        this.waitKeyprex = waitKeyprex;
    }

    public String getAcceptName() {
        return this.acceptName;
    }

    public int getAcceptPort() {
        return this.port;
    }
}

