/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.conn.udp.CarparkUdpActionUtil;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkRole;
import com.wovoe.carpark.dto.CarparkUser;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.internel.SyncServerDataJob;
import com.wovoe.carpark.vo.BasicConfigVo;
import com.wovoe.carpark.vo.HostEquipmentSate;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.SearchParam;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CarparkUdpHeatBeatAction
implements ServiceAction {
    public static final String ActionName = "/CarparkUdpHeatBeatAction";
    public static final String OP_HANDSHAKE = "handshake";
    public static final String OP_obtainInstallClientVo = "obtainInstallClientVo";
    public static final String OP_KEEPALIVED = "keepAlived";
    public static final String OP_SYC_SERVER_DATA = "syncServerData";
    public static final String OP_UDP_HOLE = "udphole";

    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if (OP_HANDSHAKE.equals(op)) {
            this.handshake(request);
        } else if (OP_obtainInstallClientVo.equals(op)) {
            this.obtainInstallClientVo(request);
        } else if (OP_KEEPALIVED.equals(op)) {
            this.keepAlived(request);
        } else if (OP_SYC_SERVER_DATA.equals(op)) {
            this.syncServerData(request);
        } else if (OP_UDP_HOLE.equals(op)) {
            this.udphole(request);
        }
    }

    private void udphole(Receiver request) throws Exception {
        String srcHostNo = request.getHeaderValue("srcHostNo");
        ServiceLog.getLog().info((Object)("\u6536\u5230\u6765\u81ea\u4e3b\u673a:" + srcHostNo + "," + request.getRemoteAddress() + "\u7684\u6253\u6d1e\u4fe1\u606f"));
        ResponseSender rp = request.createResponse();
        rp.setHeader("respCode", "SUCCESS");
        rp.doResponse(null, null);
    }

    private void syncServerData(Receiver request) throws Exception {
        SyncServerDataJob job;
        CarparkHost local_Host = ServiceUtil.getServiceContext().getLocalHost();
        if (local_Host == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u7cfb\u7edf\u672a\u521d\u59cb\u5316", null);
            return;
        }
        String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asign", signKey);
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
        if (!sign.equals(checkSign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
            return;
        }
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_use() == 1 && (job = (SyncServerDataJob)((Object)ServiceUtil.getServiceContext().getAttribute(SyncServerDataJob.class.getName()))) != null && !job.isRunning()) {
            job.run();
        }
        CarparkUdpActionUtil.doSimpleResponse(request, "SUCCESS", "SUCCESS", signKey);
    }

    private void keepAlived(Receiver request) throws Exception {
        HostEquipmentSate state;
        CarparkHost local_Host = ServiceUtil.getServiceContext().getLocalHost();
        if (local_Host == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u7cfb\u7edf\u672a\u521d\u59cb\u5316", null);
            return;
        }
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asign", signKey);
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
        if (!sign.equals(checkSign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
            return;
        }
        if (local_Host.getHost_use() != 2 && local_Host.getHost_use() != 3) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u672c\u673a\u4e0d\u662f\u505c\u8f66\u573a\u670d\u52a1\u5668\uff0c\u62d2\u7edd\u8bbf\u95ee\u6b64\u63a5\u53e3", signKey);
            return;
        }
        String srcHostNo = request.getHeaderValue("srcHostNo");
        if (srcHostNo == null || srcHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", signKey);
            return;
        }
        String destHostNo = request.getHeaderValue("destHostNo");
        if (destHostNo == null || destHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", signKey);
            return;
        }
        if (!destHostNo.equals(localHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u9519\u8bef", signKey);
            return;
        }
        CarparkHost clientHost = null;
        Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hmap != null) {
            clientHost = hmap.get(srcHostNo);
        }
        if (clientHost == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u4e3b\u673a\u4e0d\u5b58\u5728,\u4e3b\u673a\u7f16\u53f7\u65e0\u6548", signKey);
            return;
        }
        if (clientHost.getHost_use() != 1) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u5fc5\u987b\u662f\u5ba2\u6237\u7aef\u4e3b\u673a\u624d\u80fd\u8bbf\u95ee\u6b64\u63a5\u53e3", signKey);
            return;
        }
        if (srcHostNo.equals(destHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", signKey);
            return;
        }
        if (request.getData() == null || request.getData().length == 0 || request.getDataLength() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u6570\u636e\u57df", signKey);
            return;
        }
        try {
            String datav = new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8");
            state = (HostEquipmentSate)((Object)GsonBuilder.create().fromJson(datav, HostEquipmentSate.class));
        }
        catch (Exception ex) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6570\u636e\u57df\u4e0d\u662f\u6709\u6548\u7684Json!", signKey);
            return;
        }
        if (!srcHostNo.equals(state.getHostNo())) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6570\u636e\u9519\u8bef\uff0c\u4e3b\u673a\u7f16\u53f7\u4e0d\u4e00\u81f4", signKey);
            return;
        }
        CarparkUdpClientManager.getInstance().updateClient(srcHostNo, request);
        ServiceUtil.getServiceContext().getHostEquipmentSateManager().setHostOnline(state);
        LinkedList<HostEquipmentSate> hostSateList = new LinkedList<HostEquipmentSate>();
        long crl = ServiceUtil.getServiceContext().currentTimeMillis();
        for (CarparkHost host : hmap.values()) {
            HostEquipmentSate so;
            if (srcHostNo.equals(host.getHost_no())) continue;
            if (localHostNo.equals(host.getHost_no())) {
                HostEquipmentSate serverSate = ServiceUtil.getServiceContext().getHostEquipmentSateManager().getLocalHostEquipmentSate();
                so = serverSate.simpleCopy();
                so.setLastConnectedMills(0L);
                hostSateList.add(so);
                continue;
            }
            HostEquipmentSate otherHostSate = ServiceUtil.getServiceContext().getHostEquipmentSateManager().getHostEquipmentSate(host.getHost_no());
            if (otherHostSate == null) continue;
            so = otherHostSate.simpleCopy();
            if (so.getLastConnectedMills() == null) {
                so.setLastConnectedMills(0L);
            } else {
                long a1 = crl - so.getLastConnectedMills();
                if (a1 < 0L) {
                    a1 = 0L;
                }
                so.setLastConnectedMills(a1);
            }
            hostSateList.add(so);
        }
        String jsonStr = GsonBuilder.create().toJson(hostSateList);
        byte[] jspmData = jsonStr.getBytes("UTF-8");
        ResponseSender sender = CarparkUdpActionUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
        sender.setHeader("cloudConnected", String.valueOf(ServiceUtil.getServiceContext().isConnectedCloud()));
        sender.setSendData(jspmData);
        sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
        sender.doResponse(null, null);
    }

    private void obtainInstallClientVo(Receiver request) throws Exception {
        CarparkHost local_Host = ServiceUtil.getServiceContext().getLocalHost();
        if (local_Host == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u7cfb\u7edf\u672a\u521d\u59cb\u5316", null);
            return;
        }
        String localHost = ServiceUtil.getServiceContext().getLocalHostNo();
        String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asign", signKey);
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
        if (!sign.equals(checkSign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
            return;
        }
        if (local_Host.getHost_use() != 2 && local_Host.getHost_use() != 3) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u672c\u673a\u4e0d\u662f\u505c\u8f66\u573a\u670d\u52a1\u5668\uff0c\u62d2\u7edd\u8bbf\u95ee\u6b64\u63a5\u53e3", signKey);
            return;
        }
        String srcHostNo = request.getHeaderValue("srcHostNo");
        if (srcHostNo == null || srcHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", signKey);
            return;
        }
        String destHostNo = request.getHeaderValue("destHostNo");
        if (destHostNo == null || destHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", signKey);
            return;
        }
        if (!destHostNo.equals(localHost)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u9519\u8bef", signKey);
            return;
        }
        CarparkHost clientHost = null;
        Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hmap != null) {
            clientHost = hmap.get(srcHostNo);
        }
        if (clientHost == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u4e3b\u673a\u4e0d\u5b58\u5728,\u4e3b\u673a\u7f16\u53f7\u65e0\u6548", signKey);
            return;
        }
        if (srcHostNo.equals(destHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", signKey);
            return;
        }
        if (request.getDataLength() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u5173\u952e\u53c2\u6570\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u7248\u672c\u662f\u5426\u9519\u8bef", signKey);
            return;
        }
        String paramJson = new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8");
        Map vmap = (Map)GsonBuilder.create().fromJson(paramJson, Map.class);
        String v_org = (String)vmap.get("v_org");
        String v_id = (String)vmap.get("v_id");
        String v_mills = (String)vmap.get("v_mills");
        String v_sign = (String)vmap.get("v_sign");
        String v_ver = (String)vmap.get("v_ver");
        if (v_org == null || v_org.length() == 0 || v_id == null || v_id.length() == 0 || v_mills == null || v_mills.length() == 0 || v_sign == null || v_sign.length() == 0 || v_ver == null || v_ver.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u5173\u952e\u53c2\u6570\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u7aef\u4e0e\u670d\u52a1\u5668\u7248\u672c\u662f\u5426\u4e00\u81f4", signKey);
            return;
        }
        if (!v_org.equals(String.valueOf(ServiceUtil.getServiceContext().getAuthInfo().getOrgId()))) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c\u5e94\u7528\u4e3b\u4f53\u4e0d\u4e00\u81f4\uff01\u8bf7\u68c0\u67e5\u5e94\u7528\u6388\u6743\u8bc1\u4e66", signKey);
            return;
        }
        if (!v_id.equals(String.valueOf(ServiceUtil.getServiceContext().getAuthInfo().getG()))) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c\u5e94\u7528\u8bc1\u4e66\u4e0d\u4e00\u81f4\uff01\u8bf7\u68c0\u67e5\u5e94\u7528\u6388\u6743\u8bc1\u4e66", signKey);
            return;
        }
        if (!v_ver.equals(ServiceUtil.getServiceContext().getVersion())) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c \u5ba2\u6237\u7aef\u7248\u672c\u4e0e\u670d\u52a1\u5668\u7248\u672c\u4e0d\u4e00\u81f4\uff0c\u670d\u52a1\u5668\u7248\u672c\uff1a" + ServiceUtil.getServiceContext().getVersion(), signKey);
            return;
        }
        String sign1 = CryptoUtil.MD5Encode((String)(String.valueOf(v_org) + "&" + v_id + "&" + v_mills + "&" + v_ver + "&" + ServiceUtil.getServiceContext().getAuthInfo().getL()));
        if (!sign1.equals(v_sign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u8fde\u63a5\u88ab\u62d2\u7edd\uff0c\u6570\u636e\u7b7e\u540d\u9519\u8bef\uff01\u8bf7\u68c0\u67e5\u5e94\u7528\u6388\u6743\u8bc1\u4e66", signKey);
            return;
        }
        CarparkUdpClientManager.getInstance().updateClient(srcHostNo, request);
        CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
        BasicConfigVo vo = new BasicConfigVo();
        List hostList = commonDaoService.selectList(new SearchParam(), CarparkHost.class, null);
        Carpark carpark = (Carpark)commonDaoService.selectOne(new SearchParam().addEQ("id", (Object)ServiceUtil.getServiceContext().getCarparkId()), Carpark.class);
        List roleList = commonDaoService.selectList(new SearchParam(), CarparkRole.class, null);
        List userList = commonDaoService.selectList(new SearchParam(), CarparkUser.class, null);
        vo.setCarpark(carpark);
        vo.setHostList(hostList);
        vo.setRoleList(roleList);
        vo.setUserList(userList);
        String jsonStr = GsonBuilder.create().toJson((Object)vo);
        byte[] jspmData = jsonStr.getBytes("UTF-8");
        ResponseSender sender = CarparkUdpActionUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
        sender.setSendData(jspmData);
        sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
        sender.doResponse(null, null);
    }

    private void handshake(Receiver request) throws Exception {
        String localHost = ServiceUtil.getServiceContext().getLocalHostNo();
        String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asign", signKey);
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
        if (!sign.equals(checkSign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
            return;
        }
        String srcHostNo = request.getHeaderValue("srcHostNo");
        if (srcHostNo == null || srcHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", signKey);
            return;
        }
        String destHostNo = request.getHeaderValue("destHostNo");
        if (destHostNo == null || destHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", signKey);
            return;
        }
        if (!destHostNo.equals(localHost)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u9519\u8bef", signKey);
            return;
        }
        CarparkHost clientHost = null;
        Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hmap != null) {
            clientHost = hmap.get(srcHostNo);
        }
        if (clientHost == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u4e3b\u673a\u4e0d\u5b58\u5728,\u4e3b\u673a\u7f16\u53f7\u65e0\u6548", signKey);
            return;
        }
        if (srcHostNo.equals(destHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", signKey);
            return;
        }
        CarparkUdpClientManager.getInstance().updateClient(srcHostNo, request);
        CarparkUdpActionUtil.doSimpleResponse(request, "SUCCESS", "SUCCESS", signKey);
    }
}

