/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.JsonListType;
import com.wovoe.carpark.conn.udp.CarparkUdpConnSession;
import com.wovoe.carpark.conn.udp.CarparkUdpP2pConnector;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.UpgradeService;
import com.wovoe.carpark.vo.HostEquipmentSate;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.dao.CommonDaoService;
import com.wovoe.framework.dao.CommonParam;
import com.wovoe.framework.dao.SearchParam;
import com.wovoe.framework.db.sync.DataSyncService;
import com.wovoe.framework.db.sync.DefaultDataSyncService;
import com.wovoe.framework.db.sync.DelOp;
import com.wovoe.framework.db.sync.SyncTableLog;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.security.Key;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class CarparkUdpP2pConnection
extends JobTask
implements DataSyncService.DataSyncHandleCallback {
    private volatile long lastRevTimeoutMills;
    private volatile long lastConnectingTimills;
    private CarparkUdpP2pConnector udpP2pConnector;
    private volatile boolean destroyed = false;
    private volatile CarparkUdpConnSession lastUdpConnSession;
    private AtomicBoolean started = new AtomicBoolean(false);
    private volatile ScheduledFuture<?> autuRunTaskH;
    private ConcurrentHashMap<String, Object> lockMap = new ConcurrentHashMap();

    public CarparkUdpP2pConnection() {
    }

    public void start() {
        if (this.destroyed) {
            return;
        }
        if (this.started.compareAndSet(false, true)) {
            this.autuRunTaskH = ServiceUtil.getServiceContext().schedule(this, 100L, 5000L, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isStarted() {
        if (this.destroyed) {
            return false;
        }
        if (!this.started.get()) {
            return false;
        }
        return this.autuRunTaskH != null;
    }

    public CarparkUdpP2pConnection(CarparkUdpConnSession connectedSession, long lastRevTimeoutMills) {
        this.lastUdpConnSession = connectedSession;
        this.lastRevTimeoutMills = lastRevTimeoutMills;
    }

    private boolean isConnected(long currentMills) {
        return currentMills - this.lastRevTimeoutMills <= 15000L;
    }

    public void updateLastRevMills(String severHostNo, Receiver r) {
        Integer revType;
        InetSocketAddress cloudPorxySocketAddress = null;
        byte[] proxyToken = null;
        InetSocketAddress carparkServerAddress = (InetSocketAddress)r.getRemoteAddress();
        Object revType1 = r.getAttribute("MSG_FROM_SOURCE_TYPE");
        if (revType1 != null && revType1 instanceof Integer && (revType = (Integer)revType1) == 2) {
            Object entry = r.getAttribute("USE_CLOUD_PROXY_ENTRY");
            if (entry != null && entry instanceof KeyValueEntry) {
                KeyValueEntry rke = (KeyValueEntry)entry;
                try {
                    cloudPorxySocketAddress = (InetSocketAddress)rke.getKey();
                    proxyToken = (byte[])rke.getValue();
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u4ee3\u7406Entry\u9519\u8bef\uff01" + rke));
                    cloudPorxySocketAddress = null;
                    proxyToken = null;
                }
            } else {
                ServiceLog.getLog().warn((Object)"\u4e0d\u5e94\u8be5\u51fa\u73b0\u7684\u60c5\u51b5\uff0c\u6765\u81ea\u4e91\u7aef\u4ee3\u7406\u8bf7\u6c42,\u7f3a\u5c11\u4ee3\u7406\u4fe1\u606f\uff01\u8bf7\u68c0\u67e5\u3002\u3002\u3002");
            }
        }
        boolean useCloudProxy = cloudPorxySocketAddress != null && proxyToken != null && proxyToken.length > 0;
        this.updateLastRevMills(severHostNo, carparkServerAddress, useCloudProxy, cloudPorxySocketAddress, proxyToken);
    }

    public void updateLastRevMills(String severHostNo, InetSocketAddress carparkServerAddress, boolean useCloudProxy, InetSocketAddress proxySocketAddress, byte[] proxyToken) {
        CarparkUdpConnSession lastUdpConnSession0 = this.lastUdpConnSession;
        if (lastUdpConnSession0 != null && severHostNo != null && severHostNo.equals(lastUdpConnSession0.getCarparkSeverHostNo())) {
            if (useCloudProxy != lastUdpConnSession0.isUseCloudProxy()) {
                if (lastUdpConnSession0.isUseCloudProxy()) {
                    ServiceLog.getLog().warn((Object)"\u8b66\u544a\uff1a\u5f53\u524d\u8fde\u63a5\u670d\u52a1\u5668\u4f7f\u7528\u4e91\u7aef\u4ee3\u7406\uff0c\u4f46\u662f\u63a5\u53d7\u5230\u4e0d\u662f\u4e91\u7aef\u4ee3\u7406\u6570\u636e\uff0c\u8fd9\u5c06\u4e0d\u66f4\u65b0\u670d\u52a1\u5668\u8fde\u63a5\u72b6\u6001\uff01");
                } else {
                    ServiceLog.getLog().warn((Object)"\u8b66\u544a\uff1a\u5f53\u524d\u8fde\u63a5\u670d\u52a1\u5668\u4f7f\u7528P2P\u901a\u4fe1\uff0c\u4f46\u662f\u63a5\u53d7\u5230\u4e91\u7aef\u4ee3\u7406\u6570\u636e\uff0c\u8fd9\u5c06\u4e0d\u66f4\u65b0\u670d\u52a1\u5668\u8fde\u63a5\u72b6\u6001\uff01");
                }
                return;
            }
            if (carparkServerAddress == null) {
                return;
            }
            if (!carparkServerAddress.equals(lastUdpConnSession0.getCarparkServerAddress())) {
                ServiceLog.getLog().warn((Object)("\u8b66\u544a\uff1a\u5df2\u8fde\u63a5\u7684\u670d\u52a1\u5668\u7f51\u7edc\u5730\u5740\uff1a" + lastUdpConnSession0.getCarparkServerAddress() + ",\u4f46\u662f\u63a5\u53d7\u5230\u7684\u4e3a:" + carparkServerAddress + ",\u5730\u5740\u53d1\u751f\u53d8\u5316\uff0c\u8fd9\u5c06\u4e0d\u66f4\u65b0\u505c\u8f66\u573a\u670d\u52a1\u5668\u66f4\u65b0\u72b6\u6001"));
                return;
            }
            if (useCloudProxy) {
                if (proxySocketAddress == null || proxyToken == null || proxyToken.length == 0) {
                    ServiceLog.getLog().warn((Object)"\u8b66\u544a\uff1a\u63a5\u53d7\u5230\u4e91\u7aef\u4ee3\u7406\u6570\u636e\uff0c\u4f46\u662f\u7f3a\u5c11\u4ee3\u7406\u53c2\u6570\uff0c\u8fd9\u5c06\u4e0d\u66f4\u65b0\u505c\u8f66\u573a\u670d\u52a1\u5668\u72b6\u6001");
                    return;
                }
                lastUdpConnSession0.setProxyInfo(proxySocketAddress, proxyToken);
            }
            this.lastRevTimeoutMills = ServiceUtil.getServiceContext().currentTimeMillis();
        }
    }

    public CarparkUdpConnSession getConnectedServerSession() {
        CarparkUdpConnSession c = this.lastUdpConnSession;
        if (c != null && this.isServerConnected()) {
            return c;
        }
        return null;
    }

    public boolean isServerConnected() {
        return this.isConnected(ServiceUtil.getServiceContext().currentTimeMillis());
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void close() {
        CarparkUdpP2pConnector udpP2pConnector0;
        this.destroyed = true;
        if (this.autuRunTaskH != null) {
            this.autuRunTaskH.cancel(true);
        }
        if ((udpP2pConnector0 = this.udpP2pConnector) != null) {
            udpP2pConnector0.destroy();
        }
    }

    protected void doRun() throws Exception {
        CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (localConfig == null) {
            return;
        }
        Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
        if (carpark == null) {
            return;
        }
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost == null) {
            return;
        }
        if (localHost.getHost_use() != 1) {
            return;
        }
        if (localHost.getNet_mode() != 2) {
            return;
        }
        if (localConfig.getCloud_host_id() == null || localConfig.getCloud_host_id().length() == 0) {
            return;
        }
        if (localConfig.getCloud_carpark_sign_key() == null || localConfig.getCloud_carpark_sign_key().length() == 0) {
            return;
        }
        long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
        if (this.destroyed) {
            return;
        }
        CarparkUdpConnSession connectedSession = this.lastUdpConnSession;
        if (connectedSession == null || !this.isConnected(currentMills)) {
            if (currentMills - this.lastConnectingTimills >= 14500L) {
                this.lastConnectingTimills = currentMills;
                CarparkUdpP2pConnector udpP2pConnector0 = this.udpP2pConnector;
                if (udpP2pConnector0 != null) {
                    udpP2pConnector0.destroy();
                }
                this.udpP2pConnector = udpP2pConnector0 = new CarparkUdpP2pConnector(localConfig.getCloud_host_id(), CarparkUdpP2pConnection.getSignKey(localConfig.getCloud_carpark_sign_key()));
                OperationFuture<CarparkUdpConnSession> f = udpP2pConnector0.connect(14500L);
                f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<CarparkUdpConnSession>(){

                    public void waitCompleteTimeout() {
                        ServiceLog.getLog().warn((Object)"\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668\u8d85\u65f6");
                    }

                    public void operationComplete(OperationFuture<CarparkUdpConnSession> cf) {
                        if (cf.getException() != null) {
                            ServiceLog.getLog().warn((Object)("\u8fde\u63a5\u505c\u8f66\u573a\u670d\u52a1\u5668\u5f02\u5e38\uff1a" + cf.getException().getMessage()));
                        } else {
                            CarparkUdpConnSession session = (CarparkUdpConnSession)cf.getResult();
                            if (session == null) {
                                this.waitCompleteTimeout();
                            } else {
                                CarparkUdpP2pConnection.this.lastUdpConnSession = session;
                                CarparkUdpP2pConnection.this.lastRevTimeoutMills = ServiceUtil.getServiceContext().currentTimeMillis();
                                if (CarparkUdpP2pConnection.this.destroyed) {
                                    return;
                                }
                                CarparkUdpP2pConnection.this.sendLocalState(session);
                                if (ServiceUtil.getServiceContext().getCarpark() != null && !session.getCarparkSignKey().equals(ServiceUtil.getServiceContext().getCarpark().getLan_sign_key())) {
                                    ServiceUtil.getServiceContext().getCarpark().setLan_sign_key(session.getCarparkSignKey());
                                }
                            }
                        }
                    }
                });
            }
        } else {
            this.sendLocalState(connectedSession);
        }
    }

    private void sendLocalState(final CarparkUdpConnSession connSession) {
        try {
            if (!connSession.getLocalHostNo().equals(ServiceUtil.getServiceContext().getLocalHostNo())) {
                ServiceLog.getLog().warn((Object)("\u4e0a\u62a5\u672c\u673a\u4e3b\u673a\u72b6\u6001\u5f02\u5e38!\u4e3b\u673a\u7f16\u53f7\u4e0d\u4e00\u81f4\uff01\u672c\u673a\u7f16\u53f7\uff1a" + ServiceUtil.getServiceContext().getLocalHostNo() + ", session.localhost=" + connSession.getLocalHostNo()));
                return;
            }
            HostEquipmentSate state = ServiceUtil.getServiceContext().getHostEquipmentSateManager().getLocalHostEquipmentSate();
            String jsonStr = GsonBuilder.create().toJson((Object)state);
            byte[] sendData = jsonStr.getBytes("UTF-8");
            RequestSender sender = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpRequestSender(connSession);
            final String signKey = connSession.getCarparkSignKey();
            final String serverHostNo = connSession.getCarparkSeverHostNo();
            sender.setRequestActionName("/CarparkUdpHeatBeatAction");
            sender.setHeader("op", "keepAlived");
            sender.setHeader("srcHostNo", connSession.getLocalHostNo());
            sender.setHeader("destHostNo", serverHostNo);
            sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            sender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            sender.setSendData(sendData);
            sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey));
            final long v34 = ServiceUtil.getServiceContext().currentTimeMillis();
            sender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u4e0a\u62a5\u672c\u673a\u4e3b\u673a\u72b6\u6001\u5f02\u5e38! \u53d1\u9001\u5f02\u5e38\uff1a" + ex.getMessage()));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    ServiceLog.getLog().warn((Object)"\u4e0a\u62a5\u672c\u673a\u4e3b\u673a\u72b6\u6001\u5f02\u5e38! \u54cd\u5e94\u8d85\u65f6");
                }

                public long getWaitTimeoutMills() {
                    return 8000L;
                }

                public void doReceiver(Receiver r, int id) throws Exception {
                    String respCode = r.getHeaderValue("respCode");
                    if ("SUCCESS".equals(respCode)) {
                        String rsign = r.getHeaderValue("sign");
                        String sign = HMPNetDataSignTool.getSign((Receiver)r, (String)signKey);
                        if (!sign.equals(rsign)) {
                            ServiceLog.getLog().warn((Object)"\u4e0a\u62a5\u672c\u673a\u4e3b\u673a\u72b6\u6001\u54cd\u5e94\u5f02\u5e38! \u6570\u636e\u9a8c\u7b7e\u5931\u8d25!");
                            return;
                        }
                        String cloudConnected = r.getHeaderValue("cloudConnected");
                        if ("true".equals(cloudConnected)) {
                            ServiceUtil.getServiceContext().setAttribute("cloudConnected", Boolean.TRUE);
                        } else {
                            ServiceUtil.getServiceContext().setAttribute("cloudConnected", Boolean.FALSE);
                        }
                        long v35 = ServiceUtil.getServiceContext().currentTimeMillis();
                        CarparkUdpP2pConnection.this.lastRevTimeoutMills = v35;
                        String tMills0 = r.getHeaderValue("tmills");
                        if (tMills0 != null && tMills0.length() > 0) {
                            try {
                                long vh = (v35 - v34) / 2L;
                                if (vh > 1500L) {
                                    vh = 1000L;
                                }
                                long serverSysMills = Long.valueOf(tMills0);
                                long now1 = serverSysMills + vh;
                                long now = System.currentTimeMillis();
                                if (Math.abs(now - now1) > 10000L) {
                                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                    ServiceLog.getLog().warn((Object)("\u53d1\u73b0\u505c\u8f66\u573a\u670d\u52a1\u5668\u65f6\u95f4\uff1a" + df.format(new Date(now1)) + ",\u4e0e\u5f53\u524d\u7cfb\u7edf\u65f6\u95f4\uff1a" + df.format(new Date(now)) + "\u5b58\u5728\u8bef\u5dee\uff0c\u8fd9\u5c06\u540c\u6b65\u670d\u52a1\u5668\u65f6\u95f4"));
                                    ServiceUtil.setSystemTime(new Date(now1));
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)"\u540c\u6b65\u7cfb\u7edf\u65f6\u95f4\u5f02\u5e38", (Throwable)ex);
                            }
                        }
                        if (r.getData() != null && r.getData().length > 0 && r.getDataLength() > 0) {
                            List sateList = null;
                            HostEquipmentSate serverState = null;
                            try {
                                String hostListJson = new String(r.getData(), r.getDataOffset(), r.getDataLength(), "UTF-8");
                                if (hostListJson != null && hostListJson.length() > 0) {
                                    sateList = (List)GsonBuilder.create().fromJson(hostListJson, new TypeToken<List<HostEquipmentSate>>(){}.getType());
                                }
                            }
                            catch (Exception ex) {
                                ServiceLog.getLog().warn((Object)"\u4e0a\u62a5\u672c\u673a\u4e3b\u673a\u72b6\u6001\u54cd\u5e94\u5f02\u5e38 \u4e0d\u662f\u6709\u6548\u7684Json\u6570\u636e");
                            }
                            Map<String, CarparkHost> hostMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
                            if (sateList != null && !sateList.isEmpty()) {
                                for (HostEquipmentSate stt : sateList) {
                                    long h4;
                                    if (stt.getHostNo() == null || stt.getHostNo().length() == 0 || !hostMap.containsKey(stt.getHostNo()) || ServiceUtil.getServiceContext().getLocalHostNo().equals(stt.getHostNo())) continue;
                                    if (serverHostNo.equals(stt.getHostNo())) {
                                        serverState = stt;
                                    }
                                    Long t3 = stt.getLastConnectedMills();
                                    ServiceUtil.getServiceContext().getHostEquipmentSateManager().setHostOnline(stt);
                                    if (t3 == null || t3 <= 0L || (h4 = ServiceUtil.getServiceContext().currentTimeMillis() - t3) <= 0L) continue;
                                    stt.setLastConnectedMills(h4);
                                }
                            }
                            if (serverState != null) {
                                CarparkHost serverHost = hostMap.get(serverState.getHostNo());
                                try {
                                    CarparkLocalConfig localConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
                                    if (localConfig.getCarpark_deploy_type() != 1 && serverHost != null && serverHost.getHost_use() != 1) {
                                        ServiceUtil.getServiceContext().setSupportSenselessPay(serverState.isSupportSenselessPay());
                                        ServiceUtil.getServiceContext().setSenselessConfigAll(serverState.getSenselessPayConfig());
                                    }
                                }
                                catch (Exception ex) {
                                    LogUtil.getLog().warn((Object)"\u8bbe\u7f6e\u65e0\u611f\u652f\u4ed8\u5f02\u5e38", (Throwable)ex);
                                }
                                if (serverHost != null && serverHost.getHost_use() != 1 && serverState.getVersion() != null && serverState.getVersion().length() > 0) {
                                    String key;
                                    String localVersion = ServiceUtil.getServiceContext().getVersion();
                                    String severVersion = serverState.getVersion();
                                    UpgradeService upgradeService = (UpgradeService)ServiceUtil.getServiceContext().getService(UpgradeService.class);
                                    int vl = upgradeService.compareVersion(localVersion, severVersion);
                                    if (vl < 0) {
                                        if (serverState.getExistUpgradeFile() != null && serverState.getExistUpgradeFile() == 1) {
                                            upgradeService.hanleLocalUpgrade(severVersion, serverHost, connSession);
                                        } else {
                                            key = "adviceNeedUpgrdeTootip2";
                                            if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key) == null) {
                                                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)Boolean.TRUE, null, 120L, TimeUnit.SECONDS);
                                                String msg = "\u8b66\u544a\uff1a\u8f6f\u4ef6\u7248\u672c\u4e0d\u4e00\u81f4\u9519\u8bef\uff01\u672c\u673a\u5c97\u4ead\u5ba2\u6237\u7aef\u8f6f\u4ef6\u7248\u672c\uff1a" + localVersion + "\uff0c\u4f4e\u4e8e \u670d\u52a1\u5668\u8f6f\u4ef6\u7248\u672c\uff1a" + severVersion + "\uff0c\u9700\u8981\u5347\u7ea7\uff0c\u4f46\u65e0\u6cd5\u5728\u670d\u52a1\u5668\u627e\u5230\u5347\u7ea7\u8f6f\u4ef6\u5305\uff0c\u65e0\u6cd5\u81ea\u52a8\u5347\u7ea7\uff0c\u8bf7\u624b\u52a8\u5c06\u8f6f\u4ef6\u5347\u7ea7\u5230 " + severVersion + "\uff01\u5426\u5219\u53ef\u80fd\u4f1a\u51fa\u73b0\u6570\u636e\u9519\u8bef\u3002 ";
                                                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 60000));
                                            }
                                        }
                                    } else if (vl > 0) {
                                        key = "adviceNeedUpgrdeTootip1";
                                        if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key) == null) {
                                            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)Boolean.TRUE, null, 120L, TimeUnit.SECONDS);
                                            String msg = "\u8b66\u544a\uff1a\u8f6f\u4ef6\u7248\u672c\u4e0d\u4e00\u81f4\u9519\u8bef\uff01\u672c\u673a\u5c97\u4ead\u5ba2\u6237\u7aef\u8f6f\u4ef6\u7248\u672c\uff1a" + localVersion + "\uff0c\u9ad8\u4e8e \u670d\u52a1\u5668\u8f6f\u4ef6\u7248\u672c\uff1a" + severVersion + "\uff0c\u8bf7\u901a\u77e5\u7ba1\u7406\u5458\u5c06\u670d\u52a1\u5668\u8f6f\u4ef6\u7248\u672c\u5347\u7ea7\u5230\uff1a" + localVersion + "\uff01\u5426\u5219\u53ef\u80fd\u4f1a\u51fa\u73b0\u6570\u636e\u9519\u8bef\u3002 ";
                                            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(this, msg, 4, 60000));
                                        }
                                    }
                                }
                            }
                        }
                    } else {
                        String respMsg = r.getHeaderValue("respMsg");
                        if (respMsg == null || respMsg.length() == 0) {
                            respMsg = "\u9519\u8bef\uff1a" + respCode;
                        }
                        ServiceLog.getLog().warn((Object)("\u4e0a\u62a5\u672c\u673a\u4e3b\u673a\u72b6\u6001\u54cd\u5e94\u5f02\u5e38! \u9519\u8bef\u4ee3\u7801:" + respCode + ",\u9519\u8bef\u63cf\u8ff0\uff1a" + respMsg));
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u4e0a\u62a5\u672c\u673a\u4e3b\u673a\u72b6\u6001\u5f02\u5e38!" + ex.getMessage()));
        }
    }

    public static String getSignKey(String signKey) {
        if (signKey == null || signKey.length() == 0) {
            return signKey;
        }
        if (signKey.length() != 32) {
            try {
                Key key = ServiceUtil.getServiceContext().getKeyManager().getKey("KEY_NAME_COMMOM");
                signKey = CryptoUtil.decrypt((String)signKey, (String)"UTF-8", (Key)key, (String)key.getAlgorithm());
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"\u8f66\u573a\u4e91api\u79d8\u94a5\u914d\u7f6e\u9519\u8bef\uff01");
                return null;
            }
        }
        return signKey;
    }

    public void doSyncRemoteData(DataSyncService.DataSyncHandleCallback callback0, int threadCount, List<DataSyncService.SyncTable> syncTables) {
        String synlogTableName = "ck_ddl_sync_table_log";
        if (syncTables == null || syncTables.isEmpty()) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(syncTables.size());
        if (threadCount <= 0) {
            threadCount = 1;
        }
        if (threadCount > 5) {
            threadCount = 5;
        }
        if (syncTables.size() < threadCount) {
            threadCount = syncTables.size();
        }
        CarparkUdpP2pConnection callback = callback0 == null ? this : callback0;
        final ConcurrentLinkedQueue<Task> queue = new ConcurrentLinkedQueue<Task>();
        for (DataSyncService.SyncTable table : syncTables) {
            Object lock = this.lockMap.get(table.getTableName());
            if (lock == null) {
                lock = new Object();
                Object old = this.lockMap.putIfAbsent(table.getTableName(), lock);
                if (old != null) {
                    lock = old;
                }
            }
            CommonDaoService commonDaoService = (CommonDaoService)ServiceUtil.getServiceContext().getService(CommonDaoService.class);
            Task task = new Task(this, countDownLatch, table, callback, lock, synlogTableName, commonDaoService);
            if (threadCount == 1) {
                task.run();
                continue;
            }
            queue.offer(task);
        }
        if (queue.peek() != null) {
            Task t;
            int i = 1;
            while (i < threadCount) {
                ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                    @Override
                    public void run() {
                        Task t;
                        while ((t = (Task)queue.poll()) != null) {
                            t.run();
                        }
                    }
                });
                ++i;
            }
            while ((t = (Task)queue.poll()) != null) {
                t.run();
            }
        }
        try {
            if (!countDownLatch.await(1L, TimeUnit.HOURS)) {
                ServiceLog.getLog().warn((Object)"\u6570\u636e\u540c\u6b65\u8d85\u8fc71\u5c0f\u65f6\u90fd\u672a\u80fd\u540c\u6b65\u5b8c\u6210\u3002\u3002\u3002\u3002\u3002");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void onFinishARecord(String tableName) {
    }

    public void onFinishATable(String tableName) {
    }

    public void onSynException(String tableName, Throwable exception) {
        if (exception instanceof SocketTimeoutException) {
            ServiceLog.getLog().warn((Object)("\u540c\u6b65\u8868" + tableName + "\u5f02\u5e38! \u8fde\u63a5\u670d\u52a1\u5668\u8d85\u65f6!"));
        } else {
            ServiceLog.getLog().warn((Object)("\u540c\u6b65\u8868\u51fa\u73b0\u5f02\u5e38! \u8868\u540d:" + tableName), exception);
        }
    }

    private static final class Task
    implements Runnable {
        private CountDownLatch countDownLatch;
        private DataSyncService.SyncTable table;
        private CarparkUdpP2pConnection conn;
        private DataSyncService.DataSyncHandleCallback callback;
        private Object lock;
        private String synlogTableName;
        private CommonDaoService commonDaoService;

        public Task(CarparkUdpP2pConnection conn, CountDownLatch countDownLatch, DataSyncService.SyncTable table, DataSyncService.DataSyncHandleCallback callback, Object lock, String synlogTableName, CommonDaoService commonDaoService) {
            this.countDownLatch = countDownLatch;
            this.table = table;
            this.conn = conn;
            this.callback = callback;
            this.lock = lock;
            this.synlogTableName = synlogTableName;
            this.commonDaoService = commonDaoService;
        }

        private void syncAllData() throws Throwable {
            CarparkUdpConnSession session = this.conn.getConnectedServerSession();
            if (session == null) {
                throw new IOException("\u672a\u80fd\u6210\u529f\u8fde\u63a5\u670d\u52a1\u5668");
            }
            String reqId = String.valueOf(ServiceUtil.getServiceContext().currentTimeMillis()) + "-" + ServiceUtil.getServiceContext().createLongSeq();
            String tableName = this.table.getTableName();
            RequestSender rsender = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpRequestSender(session);
            rsender.setRequestActionName("/CarparkSyncTableDataAction");
            rsender.setHeader("op", "syncAllData");
            rsender.setHeader("srcHostNo", session.getLocalHostNo());
            rsender.setHeader("destHostNo", session.getCarparkSeverHostNo());
            rsender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            long timeoutMills = 20000L;
            RequestSender sender = rsender;
            Gson gson = GsonBuilder.create();
            String DATA = "cc";
            String SYNC = "ee";
            int loopCounter = 0;
            int totalSyncCount = 0;
            while (sender != null) {
                Receiver r;
                ++loopCounter;
                sender.setHeader("reqId", reqId);
                sender.setHeader("tableName", tableName);
                sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
                sender.setHeader("respCode", "SUCCESS");
                sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)session.getCarparkSignKey()));
                final OperationFutureHandler fh = ServiceUtil.getServiceContext().createOperationFuture();
                SendCallback sendCallback = new SendCallback(){

                    public void onException(Throwable ex) {
                        fh.setException(ex);
                    }

                    public void onCompleted() {
                    }
                };
                ReceiveCallback revCallback = new ReceiveCallback(){

                    public void onWaitTimeout() throws Exception {
                        fh.setException((Throwable)new TimeoutException("\u8bf7\u6c42\u540c\u6b65\u6570\u636e\u54cd\u5e94\u8d85\u65f6"));
                    }

                    public long getWaitTimeoutMills() {
                        return 20000L;
                    }

                    public void doReceiver(Receiver r, int arg1) throws Exception {
                        fh.setResult((Object)r);
                    }
                };
                if (sender == rsender) {
                    rsender.doRequest(sendCallback, revCallback);
                } else {
                    ((ResponseSender)sender).doResponse(sendCallback, revCallback);
                }
                try {
                    r = (Receiver)fh.get(21000L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable ex) {
                    Throwable e;
                    if (ex instanceof ExecutionException && (e = ((ExecutionException)ex).getCause()) != null) {
                        ex = e;
                    }
                    throw ex;
                }
                if (r == null) {
                    throw new TimeoutException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u54cd\u5e94\u8d85\u65f6");
                }
                String repcode = r.getHeaderValue("respCode");
                if (!"SUCCESS".equals(repcode)) {
                    String errmsg = r.getHeaderValue("respMsg");
                    if (errmsg == null) {
                        errmsg = "\u9519\u8bef:" + repcode;
                    }
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u539f\u56e0\uff1a" + errmsg);
                }
                String rreqId = r.getHeaderValue("reqId");
                String rtableName = r.getHeaderValue("tableName");
                if (rreqId == null) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u54cd\u5e94\u7f3a\u5c11\u53c2\u6570\u4e1a\u52a1ID");
                }
                if (rtableName == null) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u54cd\u5e94\u7f3a\u5c11\u53c2\u6570\u8868\u540d");
                }
                String rsign = r.getHeaderValue("sign");
                if (rsign == null || rsign.length() == 0) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d\u53c2\u6570");
                }
                String rchekSign = HMPNetDataSignTool.getSign((Receiver)r, (String)session.getCarparkSignKey());
                if (!rchekSign.equals(rsign)) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u9519\u8bef");
                }
                if (!reqId.equals(rreqId)) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u4e1a\u52a1ID\u4e0d\u4e00\u81f4");
                }
                if (!tableName.equals(rtableName)) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u8868\u540d\u4e0d\u4e00\u81f4");
                }
                try {
                    this.conn.updateLastRevMills(session.getCarparkSeverHostNo(), r);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (loopCounter == 1) {
                    this.commonDaoService.delete(new SearchParam(this.table.getTableName()));
                }
                String finish = r.getHeaderValue("finish");
                String dataV = r.getHeaderValue("dataV");
                if (dataV != null && dataV.length() > 0 && r.getData() != null && r.getDataLength() > 0 && r.getData().length > 0) {
                    List dataList;
                    String jsonRdata = new String(r.getData(), r.getDataOffset(), r.getDataLength(), "UTF-8");
                    if ("ee".equals(dataV)) {
                        List eeList = (List)gson.fromJson(jsonRdata, new TypeToken<List<String>>(){}.getType());
                        if (eeList != null && !eeList.isEmpty()) {
                            for (String ee : eeList) {
                                this.syncData(ee, gson);
                                ++totalSyncCount;
                            }
                        }
                    } else if ("cc".equals(dataV) && (dataList = (List)gson.fromJson(jsonRdata, new JsonListType(this.table.getPoClass()))) != null && !dataList.isEmpty()) {
                        for (Object obj : dataList) {
                            this.commonDaoService.insert(obj, this.table.getTableName());
                            ++totalSyncCount;
                            if (this.callback == null) continue;
                            try {
                                this.callback.onFinishARecord(this.table.getTableName());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (finish != null && "true".equals(finish)) {
                    String bb = r.getHeaderValue("bb");
                    if (bb == null || bb.length() == 0) {
                        throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u54cd\u5e94\u7f3a\u5c11\u7ed3\u675f\u540c\u6b65\u8868\u6570\u636e");
                    }
                    SyncTableLog slog = (SyncTableLog)gson.fromJson(bb, SyncTableLog.class);
                    CommonParam param = new CommonParam(this.synlogTableName);
                    param.addUpdate("latest_sync_log_id", (Object)slog.getLatest_sync_log_id());
                    param.addUpdate("latest_sync_log_time", (Object)slog.getLatest_sync_log_time());
                    param.addEQ("table_name", (Object)this.table.getTableName());
                    this.commonDaoService.update(param);
                    sender = null;
                    ServiceLog.getLog().info((Object)("\u5168\u8868\u540c\u6b65\u8868\uff1a" + this.table.getTableName() + "\u6210\u529f\uff0c\u540c\u6b65\u8bb0\u5f55\u6570\uff1a" + totalSyncCount + "\uff0c\u5e76\u66f4\u65b0\u589e\u91cf\u540c\u6b65\u65e5\u5fd7\uff01"));
                    break;
                }
                sender = r.createResponse();
            }
        }

        private void syncLogData(Map<String, Object> dataMap) throws Throwable {
            CarparkUdpConnSession session = this.conn.getConnectedServerSession();
            if (session == null) {
                throw new IOException("\u672a\u80fd\u6210\u529f\u8fde\u63a5\u670d\u52a1\u5668");
            }
            String reqId = String.valueOf(ServiceUtil.getServiceContext().currentTimeMillis()) + "-" + ServiceUtil.getServiceContext().createLongSeq();
            String tableName = this.table.getTableName();
            RequestSender rsender = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpRequestSender(session);
            rsender.setRequestActionName("/CarparkSyncTableDataAction");
            rsender.setHeader("op", "syncLogData");
            rsender.setHeader("srcHostNo", session.getLocalHostNo());
            rsender.setHeader("destHostNo", session.getCarparkSeverHostNo());
            rsender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            rsender.setHeader("latest_sync_log_id", dataMap.get("latest_sync_log_id").toString());
            long timeoutMills = 20000L;
            RequestSender sender = rsender;
            boolean needSyncAllTableData = false;
            Gson gson = GsonBuilder.create();
            while (sender != null) {
                String jsonRdata;
                List eeList;
                Receiver r;
                sender.setHeader("reqId", reqId);
                sender.setHeader("tableName", tableName);
                sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
                sender.setHeader("respCode", "SUCCESS");
                sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)session.getCarparkSignKey()));
                final OperationFutureHandler fh = ServiceUtil.getServiceContext().createOperationFuture();
                SendCallback sendCallback = new SendCallback(){

                    public void onException(Throwable ex) {
                        fh.setException(ex);
                    }

                    public void onCompleted() {
                    }
                };
                ReceiveCallback revCallback = new ReceiveCallback(){

                    public void onWaitTimeout() throws Exception {
                        fh.setException((Throwable)new TimeoutException("\u8bf7\u6c42\u540c\u6b65\u6570\u636e\u54cd\u5e94\u8d85\u65f6"));
                    }

                    public long getWaitTimeoutMills() {
                        return 20000L;
                    }

                    public void doReceiver(Receiver r, int arg1) throws Exception {
                        fh.setResult((Object)r);
                    }
                };
                if (sender == rsender) {
                    rsender.doRequest(sendCallback, revCallback);
                } else {
                    ((ResponseSender)sender).doResponse(sendCallback, revCallback);
                }
                try {
                    r = (Receiver)fh.get(21000L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable ex) {
                    Throwable e;
                    if (ex instanceof ExecutionException && (e = ((ExecutionException)ex).getCause()) != null) {
                        ex = e;
                    }
                    throw ex;
                }
                if (r == null) {
                    throw new TimeoutException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u54cd\u5e94\u8d85\u65f6");
                }
                String repcode = r.getHeaderValue("respCode");
                if (!"SUCCESS".equals(repcode)) {
                    String errmsg = r.getHeaderValue("respMsg");
                    if (errmsg == null) {
                        errmsg = "\u9519\u8bef:" + repcode;
                    }
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u539f\u56e0\uff1a" + errmsg);
                }
                String rreqId = r.getHeaderValue("reqId");
                String rtableName = r.getHeaderValue("tableName");
                if (rreqId == null) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u54cd\u5e94\u7f3a\u5c11\u53c2\u6570\u4e1a\u52a1ID");
                }
                if (rtableName == null) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u54cd\u5e94\u7f3a\u5c11\u53c2\u6570\u8868\u540d");
                }
                String rsign = r.getHeaderValue("sign");
                if (rsign == null || rsign.length() == 0) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d\u53c2\u6570");
                }
                String rchekSign = HMPNetDataSignTool.getSign((Receiver)r, (String)session.getCarparkSignKey());
                if (!rchekSign.equals(rsign)) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u6570\u636e\u7b7e\u540d\u9a8c\u8bc1\u9519\u8bef");
                }
                if (!reqId.equals(rreqId)) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u4e1a\u52a1ID\u4e0d\u4e00\u81f4");
                }
                if (!tableName.equals(rtableName)) {
                    throw new IOException("\u8bf7\u6c42\u540c\u6b65\u8868\u6570\u636e\u5931\u8d25\uff01\u8868\u540d\u4e0d\u4e00\u81f4");
                }
                try {
                    this.conn.updateLastRevMills(session.getCarparkSeverHostNo(), r);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String syncTable = r.getHeaderValue("syncTable");
                if (syncTable != null && "true".equals(syncTable)) {
                    needSyncAllTableData = true;
                    sender = null;
                    break;
                }
                String finish = r.getHeaderValue("finish");
                if (r.getData() != null && r.getDataLength() > 0 && r.getData().length > 0 && (eeList = (List)gson.fromJson(jsonRdata = new String(r.getData(), r.getDataOffset(), r.getDataLength(), "UTF-8"), new TypeToken<List<String>>(){}.getType())) != null && !eeList.isEmpty()) {
                    for (String ee : eeList) {
                        this.syncData(ee, gson);
                    }
                }
                if (finish != null && "true".equals(finish)) {
                    sender = null;
                    break;
                }
                sender = r.createResponse();
            }
            if (needSyncAllTableData) {
                ServiceLog.getLog().info((Object)("\u8868" + this.table.getTableName() + "\u592a\u4e45\u672a\u4e0e\u670d\u52a1\u5668\u540c\u6b65\u8fc7\u4e86\uff0c\u5bfc\u81f4\u540c\u6b65\u65e5\u5fd7\u8fc7\u671f\uff0c\u8fd9\u5c06\u5168\u8868\u4e0b\u8f7d\u540c\u6b65\u4e00\u6b21\uff0c\u5e76\u66f4\u65b0\u540c\u6b65\u65e5\u5fd7"));
                this.syncAllData();
                return;
            }
        }

        private void syncData(String line, Gson gson) throws Exception {
            int h = line.lastIndexOf(44);
            String dataStr = line.substring(0, h);
            String vaule = new String(BytesTool.hexStringToByteArray((String)line.substring(h + 1)));
            SyncTableLog slog = (SyncTableLog)gson.fromJson(vaule, SyncTableLog.class);
            if ("D".equals(slog.getOp_type())) {
                String primeryKey = this.commonDaoService.getPrimaryKeyNames(this.table.getTableName())[0];
                DelOp objMap = (DelOp)gson.fromJson(dataStr, DelOp.class);
                String idValue = objMap.getPk_value();
                SearchParam whereParam = new SearchParam(this.table.getTableName());
                whereParam.setWhereString("AND " + primeryKey + " = " + idValue);
                this.commonDaoService.delete(whereParam);
            } else {
                Object obj = gson.fromJson(dataStr, this.table.getPoClass());
                this.commonDaoService.synDataByPrimeryKey(obj, this.table.getTableName());
            }
            CommonParam param = new CommonParam(this.synlogTableName);
            param.addUpdate("latest_sync_log_id", (Object)slog.getLatest_sync_log_id());
            param.addUpdate("latest_sync_log_time", (Object)slog.getLatest_sync_log_time());
            param.addEQ("table_name", (Object)this.table.getTableName());
            this.commonDaoService.update(param);
            if (this.callback != null) {
                this.callback.onFinishARecord(this.table.getTableName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        LinkedHashMap<String, Object> dataMap = this.commonDaoService.selectOne(new SearchParam(this.synlogTableName).addEQ("table_name", (Object)this.table.getTableName()));
                        if (dataMap == null) {
                            dataMap = new LinkedHashMap<String, Object>();
                            dataMap.put("table_name", this.table.getTableName());
                            dataMap.put("latest_sync_log_id", 0L);
                            Calendar cl = Calendar.getInstance();
                            cl.set(1, 2010);
                            cl.set(2, 0);
                            cl.set(5, 1);
                            dataMap.put("latest_sync_log_time", new Timestamp(cl.getTimeInMillis()));
                            this.commonDaoService.insert(dataMap, this.synlogTableName);
                        }
                        if (this.table.getOp_type() == 1) {
                            ServiceLog.getLog().info((Object)("\u8868" + this.table.getTableName() + "\u672a\u5b8c\u5168\u8868\u540c\u6b65\u6210\u529f\u8fc7\uff0c\u8fd9\u5c06\u5168\u8868\u4e0b\u8f7d\u540c\u6b65\u4e00\u6b21"));
                            this.syncAllData();
                        } else {
                            this.syncLogData(dataMap);
                        }
                    }
                }
                catch (Throwable ex) {
                    try {
                        if (this.callback == null || !(this.callback instanceof DefaultDataSyncService)) {
                            if (ex instanceof SocketTimeoutException) {
                                ServiceLog.getLog().warn((Object)("\u540c\u6b65\u8868" + this.table.getTableName() + "\u5f02\u5e38! \u8fde\u63a5\u670d\u52a1\u5668\u8d85\u65f6!"));
                            } else {
                                ServiceLog.getLog().warn((Object)("\u540c\u6b65\u8868\u51fa\u73b0\u5f02\u5e38! \u8868\u540d:" + this.table.getTableName()), ex);
                            }
                        }
                        if (this.callback != null) {
                            this.callback.onSynException(this.table.getTableName(), ex);
                        }
                    }
                    catch (Throwable ex1) {
                        try {
                            ServiceLog.getLog().warn((Object)"", ex1);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        try {
                            if (this.countDownLatch != null) {
                                this.countDownLatch.countDown();
                            }
                        }
                        finally {
                            if (this.callback != null) {
                                this.callback.onFinishATable(this.table.getTableName());
                            }
                        }
                    }
                    catch (Throwable ex1) {
                        try {
                            ServiceLog.getLog().warn((Object)"", ex1);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            finally {
                try {
                    try {
                        if (this.countDownLatch != null) {
                            this.countDownLatch.countDown();
                        }
                    }
                    finally {
                        if (this.callback != null) {
                            this.callback.onFinishATable(this.table.getTableName());
                        }
                    }
                }
                catch (Throwable ex1) {
                    try {
                        ServiceLog.getLog().warn((Object)"", ex1);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

