/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wovoe.carpark.cloud.CloudConnectTransferCrypto;
import com.wovoe.carpark.conn.udp.CarparkUdpConnSession;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.http.HttpResponseCallback;
import com.wovoe.framework.http.HttpUtil;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class CarparkUdpP2pConnector {
    private AtomicReference<OperationFutureHandler<CarparkUdpConnSession>> connectFutreRef = new AtomicReference();
    private volatile boolean destroyed = false;
    private volatile long successConnectMills;
    private volatile CarparkUdpConnSession carparkUdpConnSession;
    private String cloudHostId;
    private String cloudSignKey;

    public CarparkUdpP2pConnector(String cloudHostId, String cloudSignKey) {
        this.cloudHostId = cloudHostId;
        this.cloudSignKey = cloudSignKey;
    }

    public String getCloudHostId() {
        return this.cloudHostId;
    }

    public String getCloudSignKey() {
        return this.cloudSignKey;
    }

    public OperationFuture<CarparkUdpConnSession> connect() {
        return this.connect(15000L);
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void destroy() {
        this.destroyed = true;
    }

    public OperationFuture<CarparkUdpConnSession> connect(long timeoutMills) {
        OperationFutureHandler<CarparkUdpConnSession> connectF;
        if (timeoutMills < 10000L) {
            timeoutMills = 10000L;
        }
        if ((connectF = this.connectFutreRef.get()) != null) {
            return connectF;
        }
        do {
            connectF = ServiceUtil.getServiceContext().createOperationFuture();
            if (this.isDestroyed()) {
                connectF.setException((Throwable)new ConnectException("connection has bean destroyed!"));
                return connectF;
            }
            if (!this.connectFutreRef.compareAndSet(null, connectF)) continue;
            this.doConnect(connectF, timeoutMills);
            return connectF;
        } while ((connectF = this.connectFutreRef.get()) == null);
        return connectF;
    }

    private void doConnect(final OperationFutureHandler<CarparkUdpConnSession> conectFutre, final long timeoutMills) {
        try {
            ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        CarparkUdpP2pConnector.this.doConnect1((OperationFutureHandler<CarparkUdpConnSession>)conectFutre, timeoutMills);
                    }
                    catch (Throwable ex) {
                        conectFutre.setException(ex);
                    }
                }
            });
        }
        catch (Throwable ex) {
            conectFutre.setException(ex);
        }
    }

    private void doConnect1(final OperationFutureHandler<CarparkUdpConnSession> conectFutre, long timeoutMills) throws Exception {
        long t1 = ServiceUtil.getServiceContext().currentTimeMillis();
        KeyValueEntry<String, Object> keyValueEntry = this.obtianCloudUdpAddress(timeoutMills);
        long rt = ServiceUtil.getServiceContext().currentTimeMillis() - t1;
        if (!"SUCCESS".equals(keyValueEntry.getKey())) {
            Object v = keyValueEntry.getValue();
            throw new ConnectException(v == null ? "" : v.toString());
        }
        final InetSocketAddress cloudSocketAddress = (InetSocketAddress)keyValueEntry.getValue();
        RemoteConnection connection = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(cloudSocketAddress);
        RequestSender sender = connection.createRequest();
        sender.setRequestActionName("/CloudCarpark_P2PUdpConnectAction");
        sender.setHeader("op", "connectCarparkServer");
        sender.setHeader("a", this.cloudHostId);
        String ram = RandomStringGenerator.getDefaultInstance().getNewString(16);
        sender.setHeader("r", ram);
        String sign = HMPNetDataSignTool.getSign((Receiver)sender, (String)this.cloudSignKey);
        sender.setHeader("sign", sign);
        sender.setAttribute("CLOUD_ACTION_HANDLE", (Object)Boolean.TRUE);
        timeoutMills = timeoutMills > rt ? (timeoutMills -= rt) : 0L;
        final long watiRmills = timeoutMills < 6000L ? 6000L : timeoutMills;
        if (this.isDestroyed()) {
            throw new IOException("\u8fde\u63a5\u5df2\u5173\u95ed");
        }
        final long rtmills = ServiceUtil.getServiceContext().currentTimeMillis();
        sender.doRequest(new SendCallback(){

            public void onException(Throwable ex) {
                try {
                    ServiceLog.getLog().warn((Object)("\u8bf7\u6c42\u670d\u52a1\u5668\u5efa\u7acbP2P\u8fde\u63a5\u5931\u8d25! \u53d1\u9001\u5931\u8d25\uff1a" + ex.getMessage()));
                }
                finally {
                    conectFutre.setException((Throwable)new ConnectException("\u8bf7\u6c42\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5\u5931\u8d25\uff0c\u53d1\u9001\u5931\u8d25!"));
                }
            }

            public void onCompleted() {
            }
        }, new ReceiveCallback(){

            public void onWaitTimeout() throws Exception {
                try {
                    ServiceLog.getLog().warn((Object)"\u8bf7\u6c42\u670d\u52a1\u5668\u5efa\u7acbP2P\u8fde\u63a5\u5931\u8d25! \u7b49\u5f85\u54cd\u5e94\u8d85\u65f6");
                }
                finally {
                    conectFutre.setException((Throwable)new TimeoutException("\u7b49\u5f85\u670d\u52a1\u5668\u54cd\u5e94\u8d85\u65f6!"));
                }
            }

            public long getWaitTimeoutMills() {
                return watiRmills;
            }

            public void doReceiver(Receiver r, int id) throws Exception {
                long remt;
                long rmtl;
                InetSocketAddress carparkSeverNetAddress;
                String result = r.getHeaderValue("result");
                String msg = r.getHeaderValue("msg");
                if (msg == null || msg.length() == 0) {
                    msg = "\u8bf7\u6c42\u5efa\u7acb\u8fde\u63a5\u5931\u8d25";
                }
                if ("REQUEST_ERROR".equals(result)) {
                    conectFutre.setException((Throwable)new ConnectException(msg));
                    return;
                }
                String sign1 = r.getHeaderValue("sign");
                if (sign1 == null || sign1.length() == 0) {
                    conectFutre.setException((Throwable)new ConnectException("\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u7f3a\u5931\u7b7e\u540d\u5b57\u6bb5"));
                    return;
                }
                String sign2 = HMPNetDataSignTool.getSign((Receiver)r, (String)CarparkUdpP2pConnector.this.cloudSignKey);
                if (!sign1.equals(sign2)) {
                    conectFutre.setException((Throwable)new ConnectException("\u6570\u636e\u9a8c\u7b7e\u5931\u8d25!"));
                    return;
                }
                if (!"ALLOW_CONNECT".equals(result)) {
                    conectFutre.setException((Throwable)new ConnectException(msg));
                    return;
                }
                String carparkServerUdpPort = r.getHeaderValue("carparkServerUdpPort");
                String carparkServerHostArress = r.getHeaderValue("carparkServerHostArress");
                if (carparkServerHostArress == null || carparkServerHostArress.length() == 0 || carparkServerUdpPort == null || carparkServerUdpPort.length() == 0) {
                    conectFutre.setException((Throwable)new ConnectException("\u670d\u52a1\u5668\u54cd\u5e94\u7f3a\u5c11\u70b9\u5bf9\u70b9\u5730\u5740!"));
                    return;
                }
                try {
                    carparkSeverNetAddress = new InetSocketAddress(carparkServerHostArress, Integer.parseInt(carparkServerUdpPort));
                }
                catch (Exception ex) {
                    try {
                        ServiceLog.getLog().warn((Object)("\u4e91\u7aef\u8fd4\u56de\u7684\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740\u9519\u8bef! " + carparkServerHostArress + ":" + carparkServerUdpPort));
                    }
                    finally {
                        conectFutre.setException((Throwable)new ConnectException("\u4e91\u7aef\u8fd4\u56de\u7684\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740\u9519\u8bef!"));
                    }
                    return;
                }
                String chostNo = r.getHeaderValue("transiss_chostNo");
                String shostNo = r.getHeaderValue("transiss_shostNo");
                String carparkSignKey = r.getHeaderValue("transiss_sk");
                String proxyToken = r.getHeaderValue("proxyToken");
                if (chostNo == null || chostNo.length() == 0) {
                    conectFutre.setException((Throwable)new ConnectException("\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fd4\u56de\u7f3a\u5c11\u53c2\u6570:chostNo"));
                }
                if (shostNo == null || shostNo.length() == 0) {
                    conectFutre.setException((Throwable)new ConnectException("\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fd4\u56de\u7f3a\u5c11\u53c2\u6570:shostNo"));
                }
                if (carparkSignKey == null || carparkSignKey.length() == 0) {
                    conectFutre.setException((Throwable)new ConnectException("\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fd4\u56de\u7f3a\u5c11\u53c2\u6570:sk"));
                }
                if ((rmtl = watiRmills > (remt = ServiceUtil.getServiceContext().currentTimeMillis() - rtmills) ? watiRmills - remt : 0L) < 8000L) {
                    rmtl = 8000L;
                }
                if (CarparkUdpP2pConnector.this.isDestroyed()) {
                    throw new ConnectException("\u8fde\u63a5\u5df2\u5173\u95ed");
                }
                byte[] proxyTokenBytes = null;
                if (proxyToken != null && proxyToken.length() > 0) {
                    proxyTokenBytes = BytesTool.unCompress((String)proxyToken);
                }
                CarparkUdpConnSession session = new CarparkUdpConnSession(carparkSeverNetAddress, carparkSignKey, shostNo, chostNo, cloudSocketAddress, proxyTokenBytes);
                if (CarparkUdpP2pConnector.this.isDestroyed()) {
                    throw new ConnectException("\u8fde\u63a5\u5df2\u5173\u95ed");
                }
                CarparkUdpP2pConnector.this.doUdpHole(session, (OperationFutureHandler<CarparkUdpConnSession>)conectFutre, rmtl);
                ServiceUtil.getServiceContext().delay(new JobTask(){
                    int counter = 0;

                    protected void doRun() throws Exception {
                        ++this.counter;
                        if (conectFutre.isDone()) {
                            return;
                        }
                        RemoteConnection connection = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(cloudSocketAddress);
                        RequestSender sender = connection.createRequest();
                        sender.setRequestActionName("/CloudCarpark_P2PUdpConnectAction");
                        sender.setHeader("op", "keepAlived");
                        String ram = RandomStringGenerator.getDefaultInstance().getNewString(16);
                        sender.setHeader("r", ram);
                        String sign = HMPNetDataSignTool.getSign((Receiver)sender, (String)CarparkUdpP2pConnector.this.cloudSignKey);
                        sender.setHeader("sign", sign);
                        sender.setAttribute("send.wait.ack.timeout", (Object)2800L);
                        sender.setAttribute("send.attempt.times", (Object)1);
                        sender.setAttribute("CLOUD_ACTION_HANDLE", (Object)Boolean.TRUE);
                        sender.doRequest(null, null);
                        if (this.counter < 2) {
                            1 t = this;
                            ServiceUtil.getServiceContext().delay(t, 3L, TimeUnit.SECONDS);
                        }
                    }
                }, 3L, TimeUnit.SECONDS);
            }
        });
    }

    private void doUdpHole(final CarparkUdpConnSession connSession, final OperationFutureHandler<CarparkUdpConnSession> conectFutre, final long timeoutMills0) {
        try {
            RemoteConnection udpConn = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(connSession.getCarparkServerAddress());
            RequestSender usender = udpConn.createRequest();
            usender.setRequestActionName("/CarparkUdpHeatBeatAction");
            usender.setHeader("op", "udphole");
            usender.setHeader("srcHostNo", connSession.getLocalHostNo());
            usender.setHeader("destHostNo", connSession.getCarparkSeverHostNo());
            usender.setAttribute("send.wait.ack.timeout", (Object)1000L);
            usender.setAttribute("send.attempt.times", (Object)7);
            usender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            final long t23 = ServiceUtil.getServiceContext().currentTimeMillis();
            usender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    try {
                        ServiceLog.getLog().warn((Object)("\u5411\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u53d1\u9001P2P\u6253\u6d1e\u4fe1\u606f\u6570\u636e\u5931\u8d25! " + ex.getMessage() + ", \u8fd9\u5c06\u5c1d\u8bd5\u4f7f\u7528\u4e91\u7aef\u4ee3\u7406\u8fde\u63a5\u3002\u3002\u3002"));
                    }
                    finally {
                        if (connSession.getProxyToken() != null && connSession.getProxyToken().length > 0) {
                            long sq = ServiceUtil.getServiceContext().currentTimeMillis();
                            long re = sq - t23;
                            long tvf = timeoutMills0 - re;
                            if (tvf < 7000L) {
                                tvf = 7000L;
                            }
                            CarparkUdpP2pConnector.this.doHandShake(connSession, (OperationFutureHandler<CarparkUdpConnSession>)conectFutre, tvf, true);
                        } else {
                            conectFutre.setException(ex);
                        }
                    }
                }

                public void onCompleted() {
                    long sq = ServiceUtil.getServiceContext().currentTimeMillis();
                    long re = sq - t23;
                    try {
                        ServiceLog.getLog().info((Object)("\u5411\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u53d1\u9001P2P\u6253\u6d1e\u6570\u636e\u6210\u529f \u8017\u65f6:" + re + "\u6beb\u79d2\uff0c\u8fd9\u5c06\u4f7f\u7528P2P\u8fdb\u884c\u63e1\u624b\u5c1d\u8bd5"));
                    }
                    finally {
                        long tvf = timeoutMills0 - re;
                        if (tvf < 7000L) {
                            tvf = 7000L;
                        }
                        CarparkUdpP2pConnector.this.doHandShake(connSession, (OperationFutureHandler<CarparkUdpConnSession>)conectFutre, tvf, false);
                    }
                }
            }, null);
        }
        catch (Exception ex) {
            try {
                ServiceLog.getLog().warn((Object)("\u5411\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u53d1\u9001P2P\u6253\u6d1e\u4fe1\u606f\u64cd\u4f5c\u5931\u8d25! " + ex.getMessage()));
            }
            finally {
                conectFutre.setException((Throwable)ex);
            }
        }
    }

    private void doHandShake(final CarparkUdpConnSession connSession, final OperationFutureHandler<CarparkUdpConnSession> conectFutre, final long timeoutMills, final boolean useCloudProxy) {
        try {
            RemoteConnection conn = ServiceUtil.getServiceContext().getCarparkUdpConnectionFactory().createUdpConnection(connSession.getCarparkServerAddress());
            RequestSender sender = conn.createRequest();
            sender.setRequestActionName("/CarparkUdpHeatBeatAction");
            sender.setHeader("op", "handshake");
            sender.setHeader("srcHostNo", connSession.getLocalHostNo());
            sender.setHeader("destHostNo", connSession.getCarparkSeverHostNo());
            sender.setHeader("tmills", String.valueOf(System.currentTimeMillis()));
            sender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            sender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)sender, (String)connSession.getCarparkSignKey()));
            if (!useCloudProxy) {
                sender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            } else {
                sender.setAttribute("USE_CLOUD_PROXY_ENTRY", (Object)new KeyValueEntry((Object)connSession.getCloudSocketAddress(), (Object)connSession.getProxyToken()));
            }
            sender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    try {
                        ServiceLog.getLog().warn((Object)("\u5411\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u53d1\u9001\u63e1\u624b\u6570\u636e\u5931\u8d25! " + ex.getMessage()));
                    }
                    finally {
                        conectFutre.setException(ex);
                    }
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    try {
                        ServiceLog.getLog().warn((Object)("\u7b49\u5f85\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u54cd\u5e94\u63e1\u624b\u6d88\u606f\u5931\u8d25! "));
                    }
                    finally {
                        conectFutre.setException((Throwable)new TimeoutException("\u7b49\u5f85\u505c\u8f66\u573a\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5\u54cd\u5e94\u8d85\u65f6"));
                    }
                }

                public long getWaitTimeoutMills() {
                    return timeoutMills;
                }

                public void doReceiver(Receiver r, int id) throws Exception {
                    String code = r.getHeaderValue("respCode");
                    String sign = r.getHeaderValue("sign");
                    if (sign == null || sign.length() == 0) {
                        try {
                            ServiceLog.getLog().warn((Object)"\u505c\u8f66\u573a\u670d\u52a1\u5668\u54cd\u5e94\u7684\u63e1\u624b\u6570\u636e\u7f3a\u5931\u6570\u636e\u7b7e\u540d");
                        }
                        finally {
                            conectFutre.setException((Throwable)new ConnectException("\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d\u6570\u636e"));
                        }
                        return;
                    }
                    String checkSign = HMPNetDataSignTool.getSign((Receiver)r, (String)connSession.getCarparkSignKey());
                    if (!sign.equals(checkSign)) {
                        try {
                            ServiceLog.getLog().warn((Object)"\u505c\u8f66\u573a\u670d\u52a1\u5668\u54cd\u5e94\u7684\u63e1\u624b\u6570\u636e\u6821\u9a8c\u7b7e\u540d\u5931\u8d25");
                        }
                        finally {
                            conectFutre.setException((Throwable)new ConnectException("\u8fde\u63a5\u54cd\u5e94\u6570\u636e\u9a8c\u7b7e\u5931\u8d25"));
                        }
                        return;
                    }
                    if ("SUCCESS".equals(code)) {
                        connSession.setUseCloudProxy(useCloudProxy);
                        CarparkUdpP2pConnector.this.successConnectMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        CarparkUdpP2pConnector.this.carparkUdpConnSession = connSession;
                        conectFutre.setResult((Object)connSession);
                    } else {
                        String msg = r.getHeaderValue("respMsg");
                        if (msg == null) {
                            msg = "\u8fde\u63a5\u5931\u8d25";
                        }
                        try {
                            ServiceLog.getLog().warn((Object)("\u4e0e\u505c\u8f66\u573a\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5\u5931\u8d25\uff1a\u9519\u8bef\u4ee3\u7801\uff1a " + code + ", \u9519\u8bef\u539f\u56e0\uff1a" + msg));
                        }
                        finally {
                            conectFutre.setException((Throwable)new ConnectException("\u4e0e\u505c\u8f66\u573a\u670d\u52a1\u5668\u5efa\u7acb\u8fde\u63a5\u5931\u8d25:" + msg));
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            try {
                ServiceLog.getLog().warn((Object)("\u5411\u505c\u8f66\u573a\u670d\u52a1\u5668\u8fdc\u7a0b\u5730\u5740 \uff1a" + connSession.getCarparkServerAddress() + " \u8bf7\u6c42\u63e1\u624b\u64cd\u4f5c\u5931\u8d25! " + ex.getMessage()));
            }
            finally {
                conectFutre.setException((Throwable)ex);
            }
        }
    }

    private static String getSign(Map<String, String> pMap, String signKey) {
        TreeMap<String, String> t;
        if (pMap instanceof TreeMap) {
            t = (TreeMap<String, String>)pMap;
        } else {
            t = new TreeMap<String, String>();
            t.putAll(pMap);
        }
        char a = '=';
        char b = '&';
        String sigK = "sign";
        StringBuilder sbr1 = new StringBuilder(128);
        for (Map.Entry v : t.entrySet()) {
            if (v.getKey() == null || ((String)v.getKey()).length() <= 0 || ((String)v.getKey()).equals(sigK) || v.getValue() == null) continue;
            if (sbr1.length() > 0) {
                sbr1.append(b);
            }
            sbr1.append((String)v.getKey()).append(a).append((String)v.getValue());
        }
        return CryptoUtil.MD5Encode((String)(String.valueOf(sbr1.toString()) + "," + signKey));
    }

    public static String getObtainConnectDomain() {
        return ServiceUtil.getCloudConnectDomain();
    }

    private KeyValueEntry<String, Object> obtianCloudUdpAddress(long timeOutMills) throws Exception {
        long serverMills;
        Map responseMap;
        String responseJon;
        String resutTxt;
        if (this.cloudHostId == null || this.cloudHostId.length() == 0) {
            throw new NullPointerException("cloudHostId is null or empty!");
        }
        if (this.cloudSignKey == null || this.cloudSignKey.length() == 0) {
            throw new NullPointerException("cloudSignKey is null or empty!");
        }
        CloudConnectTransferCrypto transferCrypto = new CloudConnectTransferCrypto();
        TreeMap<String, String> requestMap = new TreeMap<String, String>();
        requestMap.put("hostId", this.cloudHostId);
        String requstRand = RandomStringGenerator.getDefaultInstance().getNewString(32);
        requestMap.put("rand", requstRand);
        String requestMills = String.valueOf(System.currentTimeMillis());
        requestMap.put("reqMills", requestMills);
        requestMap.put("sign", CarparkUdpP2pConnector.getSign(requestMap, this.cloudSignKey));
        Gson gson = GsonBuilder.create();
        String vw = transferCrypto.encrypt(gson.toJson(requestMap));
        HashMap<String, String> postParam = new HashMap<String, String>();
        postParam.put("vw", vw);
        String requestHost = CarparkUdpP2pConnector.getObtainConnectDomain();
        long vMills = ServiceUtil.getServiceContext().currentTimeMillis();
        String url = "http://" + requestHost + "/core/gateway/carpark/obtainP2PConectParkServerAddrPort";
        try {
            long tout = 8000L;
            if (timeOutMills < tout) {
                tout = timeOutMills;
            }
            resutTxt = (String)HttpUtil.doRequest((String)url, null, postParam, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)((int)tout), (int)((int)tout));
            long x1 = ServiceUtil.getServiceContext().currentTimeMillis() - vMills;
            timeOutMills = timeOutMills > x1 ? (timeOutMills -= x1) : 0L;
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01\u539f\u56e0: " + ex.getMessage()));
            return new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
        }
        if (resutTxt == null || resutTxt.length() == 0) {
            ServiceLog.getLog().error((Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u503c!");
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u7a7a\u503c!");
        }
        try {
            responseJon = transferCrypto.decrypt(resutTxt);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e,\u53ef\u80fd\u79d8\u94a5\u9519\u8bef,\u6570\u636e: " + resutTxt));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u6570\u636e!");
        }
        try {
            responseMap = (Map)GsonBuilder.create().fromJson(responseJon, new TypeToken<TreeMap<String, String>>(){}.getType());
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u4e0d\u662f\u6709\u6548\u7684json\u6570\u636e: " + responseJon));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684\u683c\u5f0f\u9519\u8bef!");
        }
        String code = (String)responseMap.get("code");
        if ("URLEXPIRE_ERROR".equals(code)) {
            try {
                serverMills = Long.parseLong((String)responseMap.get("sMills"));
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)"\u7cfb\u7edf\u65f6\u95f4\u4e0e\u4e91\u7aef\u65f6\u95f4\u8bef\u5dee\u8fc7\u5927,\u88ab\u62d2\u7edd\u8fde\u63a5!");
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u7cfb\u7edf\u65f6\u95f4\u4e0e\u670d\u52a1\u5668\u65f6\u95f4\u8bef\u5dee\u8fc7\u5927\uff01\u8bf7\u4fee\u540c\u6b65\u64cd\u4f5c\u7cfb\u7edf\u65f6\u95f4\u4e3a\u5317\u4eac\u65f6\u95f4!");
            }
            ServiceLog.getLog().warn((Object)("\u7cfb\u7edf\u65f6\u95f4\u4e0e\u4e91\u7aef\u65f6\u95f4\u8bef\u5dee\u8fc7\u5927,\u88ab\u62d2\u7edd\u8fde\u63a5!\u8fd9\u5c06\u540c\u6b65\u7cfb\u7edf\u65f6\u95f4\u91cd\u65b0\u5c1d\u8bd5\uff0c\u4e91\u670d\u52a1\u5668\u65f6\u95f4:" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(serverMills))));
            ServiceUtil.setSystemTime(new Date(serverMills));
            requestMap.put("reqMills", String.valueOf(serverMills));
            requestMap.put("sign", CarparkUdpP2pConnector.getSign(requestMap, this.cloudSignKey));
            vw = transferCrypto.encrypt(gson.toJson(requestMap));
            postParam.put("vw", vw);
            if (timeOutMills < 3000L) {
                timeOutMills = 3000L;
            }
            if (this.isDestroyed()) {
                return new KeyValueEntry((Object)"CONNECT_FAIL", (Object)"\u8fde\u63a5\u5df2\u5173\u95ed");
            }
            vMills = ServiceUtil.getServiceContext().currentTimeMillis();
            url = "http://" + requestHost + "/core/gateway/carpark/obtainP2PConectParkServerAddrPort";
            try {
                long tout = 8000L;
                if (timeOutMills < tout) {
                    tout = timeOutMills;
                }
                resutTxt = (String)HttpUtil.doRequest((String)url, null, postParam, null, null, (HttpResponseCallback)HttpUtil.createSimpleStringCallback(), (int)((int)tout), (int)((int)tout));
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668\uff01\u539f\u56e0: " + ex.getMessage()));
                return new KeyValueEntry((Object)"CONNECT_ERROR", (Object)"\u65e0\u6cd5\u8fde\u63a5\u4e91\u7aef\u670d\u52a1\u5668!");
            }
            try {
                responseJon = transferCrypto.decrypt(resutTxt);
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u7684\u6570\u636e,\u53ef\u80fd\u79d8\u94a5\u9519\u8bef,\u6570\u636e: " + resutTxt));
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u65e0\u6cd5\u89e3\u6790\u6570\u636e!");
            }
            try {
                responseMap = (Map)GsonBuilder.create().fromJson(responseJon, new TypeToken<TreeMap<String, String>>(){}.getType());
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u4e0d\u662f\u6709\u6548\u7684json\u6570\u636e: " + responseJon));
                return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u4e91\u7aef\u670d\u52a1\u5668\u8fd4\u56de\u6570\u636e\u7684\u683c\u5f0f\u9519\u8bef!");
            }
            code = (String)responseMap.get("code");
        } else {
            try {
                String sMills = (String)responseMap.get("sMills");
                if (sMills != null && sMills.length() > 0) {
                    serverMills = Long.parseLong((String)responseMap.get("sMills"));
                    long av = Math.abs(System.currentTimeMillis() - serverMills);
                    if (av > TimeUnit.SECONDS.toMillis(30L)) {
                        ServiceUtil.setSystemTime(new Date(serverMills));
                    }
                }
            }
            catch (Exception sMills) {
                // empty catch block
            }
        }
        String msg = (String)responseMap.get("msg");
        if ("REQUEST_ERROR".equals(code) || "URLEXPIRE_ERROR".equals(code)) {
            return new KeyValueEntry((Object)code, (Object)(msg == null ? "\u8fde\u63a5\u5931\u8d25" : msg));
        }
        String respSign = (String)responseMap.get("sign");
        if (respSign == null || respSign.length() == 0) {
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u7f3a\u5931\u7b7e\u540d");
        }
        String checkSign = CarparkUdpP2pConnector.getSign(responseMap, this.cloudSignKey);
        if (!respSign.equals(checkSign)) {
            return new KeyValueEntry((Object)"SIGN_ERROR", (Object)"\u9a8c\u7b7e\u670d\u52a1\u5668\u54cd\u5e94\u6570\u636e\u5931\u8d25!");
        }
        if (!"SUCCESS".equals(code)) {
            if (code == null || code.length() == 0) {
                code = "ERROR";
            }
            return new KeyValueEntry((Object)code, (Object)(msg == null ? "\u8fde\u63a5\u5931\u8d25" : msg));
        }
        String p2pHost = (String)responseMap.get("p2pHost");
        String p2pPort = (String)responseMap.get("p2pPort");
        if (p2pHost == null || p2pHost.length() == 0 || p2pPort == null || p2pPort.length() == 0) {
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u670d\u52a1\u5668\u672a\u8fd4\u56de\u8fde\u63a5\u5730\u5740");
        }
        try {
            InetSocketAddress remoteAddress = new InetSocketAddress(p2pHost, Integer.parseInt(p2pPort));
            return new KeyValueEntry((Object)"SUCCESS", (Object)remoteAddress);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u670d\u52a1\u5668\u8fd4\u56de\u9519\u8bef\u7684\u8fde\u63a5\u5730\u5740:" + responseJon));
            return new KeyValueEntry((Object)"RESPONSE_ERROR", (Object)"\u670d\u52a1\u5668\u8fd4\u56de\u9519\u8bef\u7684\u8fde\u63a5\u5730\u5740");
        }
    }

    public long getSuccessConnectMills() {
        return this.successConnectMills;
    }

    public CarparkUdpConnSession getCarparkUdpConnSession() {
        return this.carparkUdpConnSession;
    }
}

