/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.ByteBufferPacket;
import com.wovoe.framework.communication.ProtocolContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public class CarparkUdpProxyProtocolHandler
extends AbstractProtocolHandler {
    protected boolean handleRead(ProtocolContext ctx) throws Exception {
        ByteBuffer byteBuf = null;
        Object byteArray1 = ctx.getMessage();
        if (byteArray1 != null) {
            if (byteArray1 instanceof ByteArrayPacket) {
                ByteArrayPacket byteArray = (ByteArrayPacket)byteArray1;
                byteBuf = byteArray instanceof ByteBufferPacket ? ((ByteBufferPacket)byteArray).getByteBuffer() : ByteBuffer.wrap(byteArray.getByteArray(), byteArray.getByteArrayOffset(), byteArray.getByteArrayLength());
            } else if (byteArray1 instanceof ByteBuffer) {
                byteBuf = (ByteBuffer)byteArray1;
            } else {
                ctx.getCommunicationHandle().getLogger().warning(" unknown receive message type!" + byteArray1.getClass());
                return false;
            }
        }
        if (byteBuf == null) {
            ctx.getCommunicationHandle().getLogger().warning("receive bytebuffer is null!");
            return false;
        }
        InetSocketAddress receiveAddress = (InetSocketAddress)ctx.getAttribute("receive.source.address");
        if (receiveAddress == null) {
            ctx.getCommunicationHandle().getLogger().warning("receive source address is null!");
            return false;
        }
        if (!byteBuf.hasRemaining()) {
            return false;
        }
        ctx.setMessage((Object)byteBuf);
        int handeType = byteBuf.get() & 0xFF;
        if (handeType == 0) {
            ctx.setAttribute("MSG_FROM_SOURCE_TYPE", (Object)0);
            return true;
        }
        if (handeType == 64) {
            ctx.setAttribute("MSG_FROM_SOURCE_TYPE", (Object)1);
            return true;
        }
        if (handeType == 128) {
            InetSocketAddress srcAddr;
            if (!byteBuf.hasRemaining()) {
                return false;
            }
            int FF = 255;
            int srcPortLen = byteBuf.get() & FF;
            if (srcPortLen < 3) {
                return false;
            }
            if (byteBuf.remaining() < srcPortLen) {
                return false;
            }
            byte[] srcA = new byte[srcPortLen - 2];
            byteBuf.get(srcA);
            int srcAPort0 = byteBuf.get() & FF;
            int srcAPort1 = byteBuf.get() & FF;
            int srcAPort = srcAPort0 << 8 | srcAPort1;
            if (!byteBuf.hasRemaining()) {
                return false;
            }
            int responseTokenLen = byteBuf.get() & FF;
            if (responseTokenLen < 1) {
                return false;
            }
            if (byteBuf.remaining() < responseTokenLen) {
                return false;
            }
            byte[] responseTokenBytes = new byte[responseTokenLen];
            byteBuf.get(responseTokenBytes);
            try {
                srcAddr = new InetSocketAddress(InetAddress.getByAddress(srcA), srcAPort);
            }
            catch (Exception ex) {
                return false;
            }
            if (!byteBuf.hasRemaining()) {
                return false;
            }
            ctx.setAttribute("MSG_FROM_SOURCE_TYPE", (Object)2);
            ctx.setAttribute("receive.source.address", (Object)srcAddr);
            ctx.setAttribute("DISPATH_PROXY_ADDRESS", (Object)receiveAddress);
            ctx.setAttribute("USE_CLOUD_PROXY_ENTRY", (Object)new KeyValueEntry((Object)receiveAddress, (Object)responseTokenBytes));
            return true;
        }
        return false;
    }

    protected boolean handleWrite(ProtocolContext context) throws Exception {
        ByteBufferPacket[] packets = (ByteBufferPacket[])context.getMessage();
        if (packets == null || packets.length == 0) {
            return false;
        }
        Boolean isCloudAction = (Boolean)context.getAttribute("CLOUD_ACTION_HANDLE");
        boolean needCloudProxy = false;
        InetSocketAddress cloudAddress = null;
        byte[] proxyToken = null;
        if (isCloudAction == null || !isCloudAction.booleanValue()) {
            Boolean noCloudProxy = (Boolean)context.getAttribute("NO_CLOUD_PROXY");
            if (noCloudProxy != null && noCloudProxy.booleanValue()) {
                needCloudProxy = false;
            } else {
                KeyValueEntry cloudProxyEntry = (KeyValueEntry)context.getAttribute("USE_CLOUD_PROXY_ENTRY");
                if (cloudProxyEntry != null && cloudProxyEntry.getKey() != null && cloudProxyEntry.getValue() != null) {
                    needCloudProxy = true;
                    cloudAddress = (InetSocketAddress)cloudProxyEntry.getKey();
                    proxyToken = (byte[])cloudProxyEntry.getValue();
                }
            }
        }
        ByteBufferPacket[] coprys = new ByteBufferPacket[packets.length];
        int i = 0;
        while (i < packets.length) {
            ByteBuffer buf;
            ByteBufferPacket old = packets[i];
            ByteBuffer buf1 = old.getByteBuffer();
            int pos = buf1.position();
            int limit = buf1.limit();
            InetSocketAddress destAddr = (InetSocketAddress)old.getSocketAddress();
            if (isCloudAction != null && isCloudAction.booleanValue()) {
                buf = ByteBuffer.allocate(buf1.remaining() + 1);
                buf.put((byte)64);
            } else if (!needCloudProxy) {
                buf = ByteBuffer.allocate(buf1.remaining() + 1);
                buf.put((byte)0);
            } else {
                byte[] destAddressBytes = destAddr.getAddress().getAddress();
                int destPort = destAddr.getPort();
                byte[] dvp = new byte[5 + destAddressBytes.length + proxyToken.length];
                int srIndex = 0;
                dvp[srIndex++] = -128;
                dvp[srIndex++] = (byte)(destAddressBytes.length + 2);
                System.arraycopy(destAddressBytes, 0, dvp, srIndex, destAddressBytes.length);
                srIndex += destAddressBytes.length;
                dvp[srIndex++] = (byte)(destPort >> 8);
                dvp[srIndex++] = (byte)destPort;
                dvp[srIndex++] = (byte)proxyToken.length;
                System.arraycopy(proxyToken, 0, dvp, srIndex, proxyToken.length);
                buf = ByteBuffer.allocate(buf1.remaining() + dvp.length);
                buf.put(dvp);
                destAddr = cloudAddress;
            }
            buf.put(buf1);
            buf.flip();
            buf1.position(pos);
            buf1.limit(limit);
            coprys[i] = new ByteBufferPacket(buf, (SocketAddress)destAddr);
            ++i;
        }
        context.setMessage((Object)coprys);
        return true;
    }
}

