/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.conn.udp.CarparkUdpP2pConnection;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JavaBeanMap;
import com.wovoe.framework.JavaBeanUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ConnectionFactory;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.rpc.RPCRemoteException;
import com.wovoe.framework.transfer.DataProtocol;
import com.wovoe.framework.transfer.ReceiveClassManager;
import com.wovoe.framework.transfer.connection.TimeoutSetter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class CarparkUdpRemoteServiceProxy
implements InvocationHandler {
    private static final String EQUALS_METHOD = "equals";
    private static final String HASHCODE_METHOD = "hashCode";
    private static final String TOSTRING_METHOD = "toString";
    private final InetSocketAddress destAddress;
    private final String destHostNo;
    private final String serviceName;
    private static final AtomicLong msgIds = new AtomicLong(0L);
    private final int timeoutMills;
    private final String signKey;
    private final String srcHostNo;
    private final ConnectionFactory udpconnectFactory;
    private final String requestActionName;
    private final boolean canProxy;
    private final boolean useCloudProxy;
    private final InetSocketAddress cloudProxySocketAddress;
    private final byte[] proxyToken;

    private CarparkUdpRemoteServiceProxy(ConnectionFactory udpconnectFactory, InetSocketAddress destAddress, String destHostNo, String serviceName, int timeoutMills, String signKey, String srcHostNo, String requestActionName, boolean canProxy, boolean useCloudProxy, InetSocketAddress cloudProxySocketAddress, byte[] proxyToken) {
        this.udpconnectFactory = udpconnectFactory;
        this.destAddress = destAddress;
        this.destHostNo = destHostNo;
        this.serviceName = serviceName;
        this.timeoutMills = timeoutMills <= 0 ? 10000 : timeoutMills;
        this.signKey = signKey;
        this.srcHostNo = srcHostNo;
        this.requestActionName = requestActionName;
        this.canProxy = canProxy;
        this.useCloudProxy = useCloudProxy;
        this.cloudProxySocketAddress = cloudProxySocketAddress;
        this.proxyToken = proxyToken;
    }

    private static String getMsgId() {
        byte[] array;
        int length;
        int offset;
        byte[] xv = ("U" + RandomStringGenerator.getDefaultInstance().getNewString(3)).getBytes();
        ByteBuffer buf = ByteBuffer.allocate(xv.length + 12);
        buf.put(xv);
        buf.putInt((int)(System.currentTimeMillis() / 1000L));
        buf.putLong(msgIds.incrementAndGet());
        buf.flip();
        if (buf.hasArray()) {
            offset = buf.position() + buf.arrayOffset();
            length = buf.remaining();
            array = buf.array();
        } else {
            offset = 0;
            length = buf.remaining();
            array = new byte[length];
            buf.get(array);
        }
        return BytesTool.compressBytes((byte[])array, (int)offset, (int)length);
    }

    public static <T> T newProxy(Class<T> iface, ConnectionFactory udpconnectFactory, InetSocketAddress destAddress, String destHostNo, String serviceName, int timeoutMills, String signKey, String srcHostNo, String requestActionName, boolean canProxy, boolean useCloudProxy, InetSocketAddress cloudProxySocketAddress, byte[] proxyToken) {
        CarparkUdpRemoteServiceProxy p = new CarparkUdpRemoteServiceProxy(udpconnectFactory, destAddress, destHostNo, serviceName, timeoutMills, signKey, srcHostNo, requestActionName, canProxy, useCloudProxy, cloudProxySocketAddress, proxyToken);
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)p);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue = null;
        String mehtodName = method.getName();
        if (EQUALS_METHOD.equals(mehtodName) && args != null && args.length == 1) {
            if (proxy == args[0]) {
                return true;
            }
            return false;
        }
        if (HASHCODE_METHOD.equals(mehtodName) && (args == null || args.length == 0)) {
            return this.hashCode();
        }
        if (TOSTRING_METHOD.equals(mehtodName) && (args == null || args.length == 0)) {
            return this.toString();
        }
        try {
            DataProtocol pol;
            Object beanValue;
            int readTimeMills = TimeoutSetter.getReadTimeoutMills();
            Class<?>[] cls = method.getParameterTypes();
            if (cls == null || cls.length == 0) {
                throw new UnsupportedOperationException("method: " + mehtodName + " not supported yet!");
            }
            String cmd = String.valueOf(this.serviceName) + "." + mehtodName;
            String resultCmd = String.valueOf(cmd) + "Result";
            Class<?> returnCls = method.getReturnType();
            boolean isVoid = Void.class.equals(returnCls);
            boolean isBoolean = !isVoid ? Boolean.TYPE.equals(returnCls) || Boolean.class.equals(returnCls) : false;
            if (!(isVoid || isBoolean || Map.class.equals(returnCls))) {
                if (!Map.class.isAssignableFrom(returnCls)) {
                    Map map = JavaBeanUtil.getGetSetMethods(returnCls);
                    if (map.get("responseCode") == null) {
                        throw new IllegalArgumentException("request class must contains get and set method on filed responseCode");
                    }
                    if (map.get("responseMsg") == null) {
                        throw new IllegalArgumentException("request class must contains get and set method on filed responseMsg");
                    }
                }
                if (ReceiveClassManager.getInstance().getDataClass(resultCmd) == null) {
                    ReceiveClassManager.getInstance().addDataClass(resultCmd, returnCls);
                }
            }
            if ((beanValue = args[0]) == null) {
                throw new NullPointerException("request parameter is null!");
            }
            RemoteConnection remoteConnecton = this.udpconnectFactory.createConnection((SocketAddress)this.destAddress);
            RequestSender requestSender = remoteConnecton.createRequest();
            requestSender.setRequestActionName(this.requestActionName);
            requestSender.setHeader("srcHostNo", this.srcHostNo);
            requestSender.setHeader("destHostNo", this.destHostNo);
            requestSender.setHeader("canProxy", String.valueOf(this.canProxy));
            if (this.useCloudProxy) {
                if (this.cloudProxySocketAddress != null && this.proxyToken != null && this.proxyToken.length > 0) {
                    requestSender.setAttribute("USE_CLOUD_PROXY_ENTRY", (Object)new KeyValueEntry((Object)this.cloudProxySocketAddress, (Object)this.proxyToken));
                } else {
                    requestSender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
                }
            } else {
                requestSender.setAttribute("NO_CLOUD_PROXY", (Object)Boolean.TRUE);
            }
            DataProtocol f = new DataProtocol();
            f.setCmd(cmd);
            f.setData(beanValue);
            f.setTimeMills(String.valueOf(System.currentTimeMillis()));
            f.setNonce(RandomStringGenerator.getDefaultInstance().getNewString(16));
            String msgId = CarparkUdpRemoteServiceProxy.getMsgId();
            f.setMsgId(msgId);
            String sendJson = f.toSendString(null, null);
            if (readTimeMills <= 0) {
                readTimeMills = this.timeoutMills;
            }
            requestSender.setSendData(sendJson.getBytes("UTF-8"));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)this.signKey));
            final long revTimeOutMills = readTimeMills;
            final OperationFutureHandler fh = ServiceUtil.getServiceContext().createOperationFuture();
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable ex) {
                    fh.setException(ex);
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                    fh.setException((Throwable)new TimeoutException("\u8bf7\u6c42\u8d85\u65f6"));
                }

                public long getWaitTimeoutMills() {
                    return revTimeOutMills;
                }

                public void doReceiver(Receiver r, int id) throws Exception {
                    String respCode = r.getHeaderValue("respCode");
                    String respMsg = r.getHeaderValue("respMsg");
                    if (respCode == null || respCode.length() == 0) {
                        fh.setException((Throwable)new RPCRemoteException("\u54cd\u5e94\u7f3a\u5c11\u72b6\u6001\u7801"));
                        return;
                    }
                    if ("REQUEST_ERROR".equals(respCode) || "SIGN_ERROR".equals(respCode)) {
                        if (respMsg == null) {
                            respMsg = "\u9519\u8bef:" + respCode;
                        }
                        fh.setException((Throwable)new RPCRemoteException(respMsg));
                        return;
                    }
                    String sign = r.getHeaderValue("sign");
                    if (sign == null || sign.length() == 0) {
                        fh.setException((Throwable)new RPCRemoteException("\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d\u6570\u636e"));
                        return;
                    }
                    String checkSign = HMPNetDataSignTool.getSign((Receiver)r, (String)CarparkUdpRemoteServiceProxy.this.signKey);
                    if (!sign.equals(checkSign)) {
                        fh.setException((Throwable)new RPCRemoteException("\u54cd\u5e94\u9a8c\u7b7e\u5931\u8d25!"));
                        return;
                    }
                    if (!"SUCCESS".equals(respCode)) {
                        if (respMsg == null) {
                            respMsg = "\u9519\u8bef:" + respCode;
                        }
                        fh.setException((Throwable)new RPCRemoteException(respMsg));
                        return;
                    }
                    try {
                        CarparkHost localhost = ServiceUtil.getServiceContext().getLocalHost();
                        CarparkHost remoteHost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(CarparkUdpRemoteServiceProxy.this.destHostNo);
                        if (localhost.getHost_use() == 1 && localhost.getNet_mode() == 2) {
                            CarparkUdpP2pConnection conn;
                            if (remoteHost != null && remoteHost.getHost_use() != 1 && (conn = ServiceUtil.getServiceContext().getCarparkUdpP2pConnection()) != null) {
                                conn.updateLastRevMills(CarparkUdpRemoteServiceProxy.this.destHostNo, r);
                            }
                        } else if (remoteHost != null && remoteHost.getHost_use() == 1 && remoteHost.getNet_mode() == 2) {
                            CarparkUdpClientManager.getInstance().updateClient(CarparkUdpRemoteServiceProxy.this.destHostNo, r);
                        }
                    }
                    catch (Exception localhost) {
                        // empty catch block
                    }
                    if (r.getData() == null || r.getData().length == 0 || r.getDataLength() == 0) {
                        fh.setException((Throwable)new RPCRemoteException("\u54cd\u5e94\u7f3a\u5c11\u6570\u636e"));
                    } else {
                        DataProtocol pl;
                        try {
                            String jsonD = new String(r.getData(), r.getDataOffset(), r.getDataLength(), "UTF-8");
                            pl = DataProtocol.parse((String)jsonD, null, null);
                        }
                        catch (Throwable ex) {
                            fh.setException((Throwable)new RPCRemoteException("\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u9519\u8bef"));
                            return;
                        }
                        fh.setResult((Object)pl);
                    }
                }
            });
            try {
                pol = (DataProtocol)fh.get(revTimeOutMills + 1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                if (fh.isDone() && fh.getException() != null) {
                    if (fh.getException() instanceof RPCRemoteException) {
                        throw (RPCRemoteException)fh.getException();
                    }
                    throw new RPCRemoteException("invoke error! " + fh.getException().getMessage(), fh.getException());
                }
                throw new RPCRemoteException("invoke error!", (Throwable)ex);
            }
            if (pol == null) {
                throw new RPCRemoteException("invoke error! response timeout!");
            }
            if (!msgId.equals(pol.getMsgId())) {
                throw new RPCRemoteException(" error msgId! request:" + msgId + ", response:" + pol.getMsgId());
            }
            if (!resultCmd.equals(pol.getCmd())) {
                throw new RPCRemoteException(" error cmd! request:" + cmd + ", response:" + pol.getCmd());
            }
            Object returnData = pol.getData();
            if (returnData == null) {
                throw new RPCRemoteException(" error response! cmd:" + pol.getCmd() + ", miss data!");
            }
            Map map = returnData instanceof Map ? (Map)returnData : new JavaBeanMap(returnData);
            Object responseCode = map.get("responseCode");
            if (responseCode == null) {
                throw new RPCRemoteException(" error response! cmd:" + pol.getCmd() + ", miss data field responseCode!");
            }
            boolean success = "0".equals(responseCode.toString());
            if (!success) {
                String msg0 = (String)map.get("responseMsg");
                if (msg0 == null) {
                    msg0 = "";
                }
                throw new RPCRemoteException(" error response! errcode:" + responseCode + ", cause:" + msg0);
            }
            if (!isVoid) {
                returnValue = isBoolean ? Boolean.valueOf(success) : returnData;
            }
        }
        finally {
            TimeoutSetter.clear();
        }
        return returnValue;
    }
}

