/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.KeyLockManager;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.conn.udp.CarparkUdpActionUtil;
import com.wovoe.carpark.conn.udp.CarparkUdpClientManager;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;

public class CarparkUploadPicAction
implements ServiceAction {
    public static final String ActionName = "/CarparkUploadPicAction";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Receiver request) throws Exception {
        CarparkHost local_Host = ServiceUtil.getServiceContext().getLocalHost();
        if (local_Host == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u7cfb\u7edf\u672a\u521d\u59cb\u5316", null);
            return;
        }
        String localHostNo = ServiceUtil.getServiceContext().getLocalHostNo();
        String signKey = ServiceUtil.getServiceContext().getCarpark().getLan_sign_key();
        if (request.getDataLength() == 0 || request.getData() == null || request.getData().length == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u6570\u636e\u57df", signKey);
            return;
        }
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u7b7e\u540d", signKey);
            return;
        }
        String srcHostNo = request.getHeaderValue("srcHostNo");
        if (srcHostNo == null || srcHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", signKey);
            return;
        }
        String destHostNo = request.getHeaderValue("destHostNo");
        if (destHostNo == null || destHostNo.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", signKey);
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey);
        if (!sign.equals(checkSign)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", signKey);
            return;
        }
        CarparkHost requestHost = null;
        Map<String, CarparkHost> hmap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
        if (hmap != null) {
            requestHost = hmap.get(srcHostNo);
        }
        if (requestHost == null) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u7981\u6b62\u8bbf\u95ee,\u4e3b\u673a\u4e0d\u5b58\u5728,\u4e3b\u673a\u7f16\u53f7\u65e0\u6548", signKey);
            return;
        }
        if (srcHostNo.equals(destHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", signKey);
            return;
        }
        if (!destHostNo.equals(localHostNo)) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u76ee\u6807\u4e3b\u673a\u4e0d\u662f\u672c\u673a\uff01", signKey);
            return;
        }
        String path = request.getHeaderValue("path");
        if (path == null || path.length() == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570path\uff01", signKey);
            return;
        }
        if (request.getData() == null || request.getDataLength() == 0 || request.getData().length == 0) {
            CarparkUdpActionUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u56fe\u7247\u6570\u636e\uff01", signKey);
            return;
        }
        if (local_Host.getHost_use() == 2 || local_Host.getHost_use() == 3) {
            CarparkUdpClientManager.getInstance().updateClient(srcHostNo, request);
        }
        KeyLockManager lockManager = ServiceUtil.getServiceContext().getKeyLockManager();
        Object lock = lockManager.getLock("CarparkUploadPicAction." + path);
        try {
            Object object = lock;
            synchronized (object) {
                try {
                    File file1 = new File(PathFinder.findLocalPicDir(), path);
                    File pf = file1.getParentFile();
                    if (!pf.exists() || !pf.isDirectory()) {
                        pf.mkdirs();
                    }
                    try (FileOutputStream out = new FileOutputStream(file1);){
                        out.write(request.getData(), request.getDataOffset(), request.getDataLength());
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u4fdd\u5b58\u6587\u4ef6\u5f02\u5e38\uff1a" + ex.getMessage()));
                    CarparkUdpActionUtil.doSimpleResponse(request, "RESP_CODE_SERVICE_ERROR", "\u4fdd\u5b58\u56fe\u7247\u5931\u8d25\uff01", signKey);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 8] lbl70 : MonitorExitStatement: MONITOREXIT : var14_14
                    lockManager.releaseLock(lock);
                    return;
                }
            }
        }
        finally {
            lockManager.releaseLock(lock);
        }
        CarparkUdpActionUtil.doSimpleResponse(request, "SUCCESS", "SUCCESS", signKey);
    }
}

