/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp;

import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.ParkingDisplayNetwork;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.udp.UDPRemoteConnection;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ParkingDisplayLanBroadcastServiceAction
implements ServiceAction {
    public static final String ACTION_NAME = "/ParkingDisplayLanBroadcastServiceAction";
    private static Map<String, Method> methodsMap = new HashMap<String, Method>();

    static {
        Method[] methods = ParkingDisplayLanBroadcastServiceAction.class.getMethods();
        String inv = "service";
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> rtp;
            Method method = methodArray[n2];
            String methodName = method.getName();
            Class<?>[] pty = method.getParameterTypes();
            if (pty != null && pty.length == 1 && pty[0].equals(Receiver.class) && (Void.TYPE.equals(rtp = method.getReturnType()) || Void.class.equals(rtp)) && !inv.equals(methodName)) {
                methodsMap.put(methodName, method);
            }
            ++n2;
        }
    }

    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            return;
        }
        Method method = methodsMap.get(op);
        if (method == null) {
            return;
        }
        method.invoke((Object)this, request);
    }

    public void searchParkingDisplayNetwork(Receiver request) throws Exception {
    }

    public void configParkingDisplayNetwork(Receiver request) throws Exception {
    }

    public void configParkingDisplayNetworkRsp(Receiver request) throws Exception {
        String name = request.getHeaderValue("name");
        if (!"ParkingDisplay".equals(name)) {
            return;
        }
        String operationId = request.getHeaderValue("operationId");
        if (operationId == null || operationId.length() == 0) {
            return;
        }
        String respCode = request.getHeaderValue("respCode");
        if (respCode == null || respCode.length() == 0) {
            return;
        }
        Integer result = Integer.valueOf(respCode);
        String key = "setParkingDisplayNetworks-" + operationId;
        OperationFutureHandler fu = (OperationFutureHandler)ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key);
        if (fu == null) {
            return;
        }
        fu = (OperationFutureHandler)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)key);
        if (fu == null) {
            return;
        }
        fu.setResult((Object)result);
    }

    public void searchParkingDisplayNetworkRsp(Receiver request) throws Exception {
        String respCode = request.getHeaderValue("respCode");
        if (!"SUCCESS".equals(respCode)) {
            return;
        }
        String searchId = request.getHeaderValue("searchId");
        if (searchId == null || searchId.length() == 0) {
            return;
        }
        if (!"ParkingDisplay".equals(request.getHeaderValue("name"))) {
            return;
        }
        if (request.getData() == null || request.getData().length == 0 || request.getDataLength() == 0) {
            return;
        }
        String json = new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8");
        ParkingDisplayNetwork network = (ParkingDisplayNetwork)GsonBuilder.create().fromJson(json, ParkingDisplayNetwork.class);
        if (network.getDeviceId() == null || network.getDeviceId().length() == 0) {
            return;
        }
        if (network.getMacHex() == null || network.getMacHex().length() == 0) {
            return;
        }
        SearchWanEntry entry = (SearchWanEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)(String.valueOf(SearchWanEntry.class.getName()) + "-" + searchId));
        if (entry == null) {
            return;
        }
        entry.addParkingDisplayNetwork(network);
    }

    public static BlockingQueue<ParkingDisplayNetwork> findParkingDisplayNetworks(long waitMills, int remoteBroadcastPort, SearchCallbak callback) {
        if (waitMills <= 0L) {
            waitMills = 5000L;
        }
        if (waitMills > 20000L) {
            waitMills = 20000L;
        }
        SearchWanEntry entry = new SearchWanEntry();
        entry.callback = callback;
        String searchId = String.valueOf(System.currentTimeMillis()) + "-" + ServiceUtil.getServiceContext().createLongSeq() + "-" + RandomStringGenerator.getDefaultInstance().getNewString(16);
        ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)(String.valueOf(SearchWanEntry.class.getName()) + "-" + searchId), (Object)entry, new TimeoutObjectPool.TimeoutCallback(){

            public void onTimeout(Object arg0, Object arg1) throws Exception {
                SearchWanEntry entry;
                if (arg1 instanceof SearchWanEntry && (entry = (SearchWanEntry)arg1).callback != null) {
                    entry.callback.onFinish();
                }
            }
        }, waitMills, TimeUnit.MILLISECONDS);
        InetSocketAddress[] address = new InetSocketAddress[]{new InetSocketAddress(ServiceUtil.getServiceContext().getBroadcastAddress(), remoteBroadcastPort), new InetSocketAddress(ServiceUtil.getServiceContext().getGroupInetAddress(), remoteBroadcastPort)};
        List<CommunicationHandle> list = ServiceUtil.getServiceContext().getWlykLcdBroadCastUdpSocketSender().getBroadCastSendHandles();
        for (CommunicationHandle h : list) {
            InetSocketAddress[] inetSocketAddressArray = address;
            int n = address.length;
            int n2 = 0;
            while (n2 < n) {
                InetSocketAddress destAddress = inetSocketAddressArray[n2];
                try {
                    RequestSender sender = new UDPRemoteConnection(h, (SocketAddress)destAddress).createRequest();
                    sender.setRequestActionName(ACTION_NAME);
                    sender.setHeader("op", "searchParkingDisplayNetwork");
                    sender.setHeader("searchId", searchId);
                    sender.setHeader("responsePort", String.valueOf(ServiceUtil.getServiceContext().getWlykLcdbroadcastPort()));
                    sender.setBroadcast(true);
                    sender.doRequest(null, null);
                }
                catch (IOException e) {
                    ServiceLog.getLog().warn((Object)("Abnormal broadcast transmission! " + e.getMessage()));
                }
                ++n2;
            }
        }
        return entry.queue;
    }

    public static List<ParkingDisplayNetwork> findParkingDisplayNetworksList(long waitMills, int remoteBroadcastPort, SearchCallbak callback) {
        if (waitMills <= 0L) {
            waitMills = 5000L;
        }
        if (waitMills > 20000L) {
            waitMills = 20000L;
        }
        LinkedList<ParkingDisplayNetwork> list = new LinkedList<ParkingDisplayNetwork>();
        BlockingQueue<ParkingDisplayNetwork> q = ParkingDisplayLanBroadcastServiceAction.findParkingDisplayNetworks(waitMills, remoteBroadcastPort, callback);
        long x = ServiceUtil.getServiceContext().currentTimeMillis();
        while (waitMills > 0L) {
            try {
                long x1;
                ParkingDisplayNetwork host = q.poll(waitMills, TimeUnit.MILLISECONDS);
                if (host != null) {
                    list.add(host);
                }
                if ((x1 = ServiceUtil.getServiceContext().currentTimeMillis() - x) >= waitMills) break;
                waitMills -= x1;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return list;
    }

    public static OperationFuture<Integer> setParkingDisplayNetworks(long waitMills, int remoteBroadcastPort, ParkingDisplayNetwork network) {
        OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            if (waitMills < 6000L) {
                waitMills = 6000L;
            }
            InetSocketAddress[] address = new InetSocketAddress[]{new InetSocketAddress(ServiceUtil.getServiceContext().getBroadcastAddress(), remoteBroadcastPort), new InetSocketAddress(ServiceUtil.getServiceContext().getGroupInetAddress(), remoteBroadcastPort)};
            List<CommunicationHandle> list = ServiceUtil.getServiceContext().getWlykLcdBroadCastUdpSocketSender().getBroadCastSendHandles();
            if (list == null || list.isEmpty()) {
                handler.setResult((Object)100);
                return handler;
            }
            String operationId = String.valueOf(System.currentTimeMillis()) + "-" + ServiceUtil.getServiceContext().createLongSeq() + "-" + RandomStringGenerator.getDefaultInstance().getNewString(16) + "-" + network.getDeviceId();
            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)("setParkingDisplayNetworks-" + operationId), (Object)handler, new TimeoutObjectPool.TimeoutCallback(){

                public void onTimeout(Object arg0, Object arg1) throws Exception {
                    if (arg1 instanceof OperationFutureHandler) {
                        ((OperationFutureHandler)arg1).setResult((Object)101);
                    }
                }
            }, waitMills, TimeUnit.MILLISECONDS);
            for (CommunicationHandle h : list) {
                InetSocketAddress[] inetSocketAddressArray = address;
                int n = address.length;
                int n2 = 0;
                while (n2 < n) {
                    InetSocketAddress destAddress = inetSocketAddressArray[n2];
                    try {
                        RequestSender sender = new UDPRemoteConnection(h, (SocketAddress)destAddress).createRequest();
                        sender.setRequestActionName(ACTION_NAME);
                        sender.setHeader("op", "configParkingDisplayNetwork");
                        sender.setHeader("operationId", operationId);
                        sender.setHeader("responsePort", String.valueOf(ServiceUtil.getServiceContext().getWlykLcdbroadcastPort()));
                        sender.setHeader("deviceId", network.getDeviceId());
                        sender.setHeader("macHex", network.getMacHex());
                        sender.setHeader("netMode", network.getNetMode());
                        if ("0".equals(network.getNetMode())) {
                            sender.setHeader("ipAddress", network.getIpV4());
                            sender.setHeader("netMask", network.getMask());
                            sender.setHeader("gateway", network.getGateway());
                            sender.setHeader("dns1", network.getDns1());
                            sender.setHeader("dns2", network.getDns2());
                        }
                        sender.setBroadcast(true);
                        sender.doRequest(null, null);
                    }
                    catch (IOException e) {
                        ServiceLog.getLog().warn((Object)("Abnormal broadcast transmission! " + e.getMessage()));
                    }
                    ++n2;
                }
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)ex.getMessage());
            handler.setResult((Object)102);
        }
        return handler;
    }

    public static interface SearchCallbak {
        public void onFind(ParkingDisplayNetwork var1);

        public void onFinish();
    }

    private static class SearchWanEntry {
        private BlockingQueue<ParkingDisplayNetwork> queue = new LinkedBlockingQueue<ParkingDisplayNetwork>();
        private Map<String, ParkingDisplayNetwork> networkMap = new ConcurrentHashMap<String, ParkingDisplayNetwork>();
        private SearchCallbak callback;

        private SearchWanEntry() {
        }

        private void addParkingDisplayNetwork(ParkingDisplayNetwork network) throws Exception {
            if (network == null) {
                return;
            }
            String key = String.valueOf(network.getDeviceId()) + "," + network.getMacHex();
            if (this.networkMap.containsKey(key)) {
                return;
            }
            this.networkMap.put(key, network);
            this.queue.offer(network);
            if (this.callback != null) {
                this.callback.onFind(network);
            }
        }
    }
}

