/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.conn.udp.net.LanMethodServiceAction;
import com.wovoe.carpark.conn.udp.net.TransferRpcUtil;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public abstract class LanAuthMethodServiceAction
extends LanMethodServiceAction {
    protected LanAuthMethodServiceAction() {
    }

    @Override
    public void service(Receiver request) throws Exception {
        InetAddress remoteAddress;
        CarparkLocalConfig config = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        if (config == null || config.getHost_no() == null || config.getHost_no().length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "RESP_CODE_NOT_FULLY_STATRED", "\u8fdc\u7a0b\u8bbe\u5907\u8f6f\u4ef6\u672a\u7ed1\u5b9a\u8f66\u573a\u4e3b\u673a\uff0c\u62d2\u7edd\u8bbf\u95ee", this.getSignKey());
            return;
        }
        String srcHostNo = request.getHeaderValue("srcHostNo");
        if (srcHostNo == null || srcHostNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1asrcHostNo", this.getSignKey());
            return;
        }
        String destHostNo = request.getHeaderValue("destHostNo");
        if (destHostNo == null || destHostNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570\uff1adestHostNo", this.getSignKey());
            return;
        }
        if (srcHostNo.equals(destHostNo)) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6e90\u4e0e\u76ee\u6807\u7684\u4e3b\u673a\u7f16\u53f7\u4e0d\u80fd\u76f8\u540c", this.getSignKey());
            return;
        }
        CarparkHost localHost = ServiceUtil.getServiceContext().getLocalHost();
        if (localHost == null) {
            TransferRpcUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u8bbf\u95ee\u7684\u8bbe\u5907\u5df2\u88ab\u4e3b\u8bbe\u5907\u79fb\u9664\uff0c\u4e0d\u53ef\u8bbf\u95ee\uff01", this.getSignKey());
            return;
        }
        CarparkHost srcHost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(srcHostNo);
        if (srcHost == null) {
            TransferRpcUtil.doSimpleResponse(request, "PERMISSION_ERROR", "\u6e90\u4e3b\u673a\u7f16\u53f7\u9519\u8bef\uff01\u62d2\u7edd\u8bbf\u95ee", this.getSignKey());
            return;
        }
        if (!destHostNo.equals(localHost.getHost_no())) {
            TransferRpcUtil.doSimpleResponse(request, "ROUTE_ERROR", "\u76ee\u6807\u4e3b\u673a\u7f16\u53f7\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5", this.getSignKey());
            return;
        }
        String sign = request.getHeaderValue("sign");
        if (sign == null || sign.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u7b7e\u540d", this.getSignKey());
            return;
        }
        String checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)this.getSignKey());
        if (!sign.equals(checkSign)) {
            TransferRpcUtil.doSimpleResponse(request, "SIGN_ERROR", "\u7b7e\u540d\u9519\u8bef", this.getSignKey());
            return;
        }
        SocketAddress remoteSocektAddress = request.getRemoteAddress();
        if (remoteSocektAddress instanceof InetSocketAddress && !(remoteAddress = ((InetSocketAddress)remoteSocektAddress).getAddress()).isLoopbackAddress()) {
            InetSocketAddress socketAddress = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanSocektAddress(srcHostNo);
            InetAddress address = null;
            if (socketAddress != null) {
                address = socketAddress.getAddress();
            }
            if (address != null && !address.equals(remoteAddress)) {
                TransferRpcUtil.doSimpleResponse(request, "REQUEST_ERROR", "\u7f16\u53f7\uff1a" + srcHostNo + "\u7684\u4e3b\u673a\u5df2\u6709\u7f51\u7edc\u5730\u5740\u8fdb\u884c\u8fde\u63a5" + address + "\uff01\u8fd9\u5c06\u62d2\u7edd\u6765\u81ea" + remoteAddress + "\u8bf7\u6c42", this.getSignKey());
                return;
            }
        }
        super.service(request);
    }
}

