/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.conn.udp.net.LanHeartBeatHandleAction;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LanBroadcastHandleAction
implements ServiceAction,
Runnable {
    public static final String ACTION_NAME = "/CarparkLanBrodcastHandleAction";
    private static Map<String, Method> methodsMap = new HashMap<String, Method>();

    static {
        Method[] methods = LanBroadcastHandleAction.class.getMethods();
        String inv = "service";
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> rtp;
            Method method = methodArray[n2];
            String methodName = method.getName();
            Class<?>[] pty = method.getParameterTypes();
            if (pty != null && pty.length == 1 && pty[0].equals(Receiver.class) && (Void.TYPE.equals(rtp = method.getReturnType()) || Void.class.equals(rtp)) && !inv.equals(methodName)) {
                methodsMap.put(methodName, method);
            }
            ++n2;
        }
    }

    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            return;
        }
        Method method = methodsMap.get(op);
        if (method == null) {
            return;
        }
        method.invoke((Object)this, request);
    }

    public void refreshHostNet(Receiver request) throws Exception {
        int lanUdpPort;
        String checkSign;
        CarparkLocalConfig localHostConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
        Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
        if (localHostConfig == null || localHostConfig.getHost_no() == null || localHostConfig.getHost_no().length() == 0 || carpark == null || carpark.getLan_sign_key() == null || carpark.getLan_sign_key().length() == 0) {
            return;
        }
        String signKey = carpark.getLan_sign_key();
        String sign = request.getHeaderValue("sign");
        if (!sign.equals(checkSign = HMPNetDataSignTool.getSign((Receiver)request, (String)signKey))) {
            return;
        }
        String remoteHostNo = request.getHeaderValue("rHostNo");
        if (remoteHostNo == null || remoteHostNo.length() == 0) {
            return;
        }
        try {
            lanUdpPort = Integer.parseInt(request.getHeaderValue("lanUdpPort"));
        }
        catch (Exception ex) {
            return;
        }
        SocketAddress remoteAddress = request.getRemoteAddress();
        if (remoteAddress == null) {
            return;
        }
        if (!(remoteAddress instanceof InetSocketAddress)) {
            return;
        }
        if (ServiceUtil.getServiceContext().getDBConfigCache() == null) {
            return;
        }
        if (remoteHostNo.equals(localHostConfig.getHost_no())) {
            return;
        }
        CarparkHost remoteHost = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(remoteHostNo);
        if (remoteHost == null) {
            return;
        }
        InetSocketAddress netAdr = (InetSocketAddress)remoteAddress;
        InetAddress inetAddress = netAdr.getAddress();
        if (inetAddress.isLoopbackAddress()) {
            return;
        }
        InetSocketAddress p2pScoketdress = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanSocektAddress(remoteHostNo);
        if (p2pScoketdress != null) {
            if (p2pScoketdress.getAddress().equals(inetAddress)) {
                ServiceUtil.getServiceContext().getOtherHostSateManager().updateLanBroadcastNetAddress(remoteHostNo, inetAddress, lanUdpPort);
            }
        } else {
            ServiceUtil.getServiceContext().getOtherHostSateManager().updateLanBroadcastNetAddress(remoteHostNo, inetAddress, lanUdpPort);
            try {
                if (lanUdpPort > 0) {
                    LanHeartBeatHandleAction.sendHeartbeat(remoteHostNo, new InetSocketAddress(inetAddress, lanUdpPort), true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void lanReportLocalHostBrodcast() {
        try {
            CarparkLocalConfig localHostConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
            Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
            if (localHostConfig == null || localHostConfig.getHost_no() == null || localHostConfig.getHost_no().length() == 0 || carpark == null || carpark.getLan_sign_key() == null || carpark.getLan_sign_key().length() == 0) {
                return;
            }
            Set<String> localIpset = ServiceUtil.getServiceContext().getLocalIpv4(true);
            if (localIpset == null || localIpset.isEmpty()) {
                return;
            }
            String signKey = carpark.getLan_sign_key();
            String hostNo = localHostConfig.getHost_no();
            InetAddress[] addresss = new InetAddress[]{ServiceUtil.getServiceContext().getBroadcastAddress(), ServiceUtil.getServiceContext().getGroupInetAddress()};
            int port = ServiceUtil.getServiceContext().getBroadcastAndMutiRevPort();
            if (port == 0) {
                return;
            }
            InetAddress[] inetAddressArray = addresss;
            int n = addresss.length;
            int n2 = 0;
            while (n2 < n) {
                InetAddress address = inetAddressArray[n2];
                if (address != null) {
                    RequestSender request = ServiceUtil.getServiceContext().getLanBroadCastUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(address, port)).createRequest();
                    request.setRequestActionName(ACTION_NAME);
                    request.setBroadcast(true);
                    request.setHeader("op", "refreshHostNet");
                    request.setHeader("rHostNo", hostNo);
                    request.setHeader("lanUdpPort", String.valueOf(ServiceUtil.getServiceContext().getLanUdpPort()));
                    request.setHeader("random", RandomStringGenerator.getDefaultInstance().getNewString(16));
                    request.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)request, (String)signKey));
                    request.doRequest(null, null);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5e7f\u64ad\u4e0a\u62a5\u4e3b\u673a\u4fe1\u606f\u5f02\u5e38! " + ex.getMessage()));
        }
    }

    @Override
    public void run() {
        LanBroadcastHandleAction.lanReportLocalHostBrodcast();
    }
}

