/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ServiceAction;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class LanBroadcastServiceAction
implements ServiceAction {
    public static final String ACTION_NAME = "/LanBroadcastServiceAction";
    private static Map<String, Method> methodsMap = new HashMap<String, Method>();

    static {
        Method[] methods = LanBroadcastServiceAction.class.getMethods();
        String inv = "service";
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> rtp;
            Method method = methodArray[n2];
            String methodName = method.getName();
            Class<?>[] pty = method.getParameterTypes();
            if (pty != null && pty.length == 1 && pty[0].equals(Receiver.class) && (Void.TYPE.equals(rtp = method.getReturnType()) || Void.class.equals(rtp)) && !inv.equals(methodName)) {
                methodsMap.put(methodName, method);
            }
            ++n2;
        }
    }

    public void service(Receiver request) throws Exception {
        String op = request.getHeaderValue("op");
        if (op == null || op.length() == 0) {
            return;
        }
        Method method = methodsMap.get(op);
        if (method == null) {
            return;
        }
        method.invoke((Object)this, request);
    }

    public void searchNetwork(Receiver request) throws Exception {
    }

    public void searchNetworkRsp(Receiver request) throws Exception {
        String respCode = request.getHeaderValue("respCode");
        if (!"SUCCESS".equals(respCode)) {
            return;
        }
        String searchId = request.getHeaderValue("searchId");
        if (searchId == null || searchId.length() == 0) {
            return;
        }
        if (!"true".equals(request.getHeaderValue("connectWan"))) {
            return;
        }
        String _socks5Port = request.getHeaderValue("socks5Port");
        if (_socks5Port == null || _socks5Port.length() == 0) {
            return;
        }
        SearchWanEntry entry = (SearchWanEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)(String.valueOf(SearchWanEntry.class.getName()) + "-" + searchId));
        if (entry == null) {
            return;
        }
        String ips = request.getHeaderValue("ips");
        if (ips == null || ips.length() == 0) {
            return;
        }
        String _httpPort = request.getHeaderValue("httpPort");
        if (_httpPort == null || _httpPort.length() == 0) {
            return;
        }
        int httpPort = Integer.parseInt(_httpPort);
        String _udpPort = request.getHeaderValue("udpPort");
        if (_udpPort == null || _udpPort.length() == 0) {
            return;
        }
        int udpPort = Integer.parseInt(_udpPort);
        int socks5Port = Integer.parseInt(_socks5Port);
        String _httpsPort = request.getHeaderValue("httpsPort");
        int httpsPort = -1;
        try {
            if (_httpsPort != null && _httpsPort.length() > 0) {
                httpsPort = Integer.parseInt(_httpsPort);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String sn = request.getHeaderValue("sn");
        String name = request.getHeaderValue("name");
        String[] _ips = ips.split(",");
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        String t = ((InetSocketAddress)request.getRemoteAddress()).getAddress().getHostAddress();
        if (!ServiceUtil.getServiceContext().getLocalIPSet().contains(t)) {
            ipSet.add(t);
        }
        String[] stringArray = _ips;
        int n = _ips.length;
        int n2 = 0;
        while (n2 < n) {
            String rIp = stringArray[n2];
            if ((rIp = rIp.trim()).length() != 0 && !ServiceUtil.getServiceContext().getLocalIPSet().contains(rIp)) {
                ipSet.add(rIp);
            }
            ++n2;
        }
        for (String rIp : ipSet) {
            if ((rIp = rIp.trim()).length() == 0 || ServiceUtil.getServiceContext().getLocalIPSet().contains(rIp)) continue;
            LanWanProxyHost host = new LanWanProxyHost();
            host.lanAddress = rIp;
            host.httpPort = httpPort;
            host.httpsPort = httpsPort;
            host.udpPort = udpPort;
            host.sn = sn;
            host.name = name;
            host.socks5Port = socks5Port;
            try {
                entry.checkLanHost(host);
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)("\u5c1d\u8bd5\u70b9\u5bf9\u70b9\u6d4b\u8bd5\u5f02\u5e38: " + host.lanAddress + ":" + host.udpPort + "! " + ex.getMessage()));
            }
        }
    }

    public static BlockingQueue<LanWanProxyHost> findLanWanProxyHosts(long waitMills) {
        InetSocketAddress[] address;
        if (waitMills <= 0L) {
            waitMills = 5000L;
        }
        if (waitMills > 10000L) {
            waitMills = 10000L;
        }
        SearchWanEntry entry = new SearchWanEntry();
        String searchId = String.valueOf(System.currentTimeMillis()) + "-" + ServiceUtil.getServiceContext().createLongSeq();
        ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)(String.valueOf(SearchWanEntry.class.getName()) + "-" + searchId), (Object)entry, null, waitMills, TimeUnit.MILLISECONDS);
        InetSocketAddress[] inetSocketAddressArray = address = new InetSocketAddress[]{new InetSocketAddress(ServiceUtil.getServiceContext().getBroadcastAddress(), ServiceUtil.getServiceContext().getSearchRemoteNetPort()), new InetSocketAddress(ServiceUtil.getServiceContext().getGroupInetAddress(), ServiceUtil.getServiceContext().getSearchRemoteNetPort())};
        int n = address.length;
        int n2 = 0;
        while (n2 < n) {
            InetSocketAddress add = inetSocketAddressArray[n2];
            try {
                RequestSender sender = ServiceUtil.getServiceContext().getLanBroadCastUdpConnectionFactory().createConnection((SocketAddress)add).createRequest();
                sender.setRequestActionName(ACTION_NAME);
                sender.setHeader("op", "searchNetwork");
                sender.setHeader("searchId", searchId);
                sender.setHeader("responseAddress", add.getAddress().getHostAddress());
                sender.setHeader("responsePort", String.valueOf(ServiceUtil.getServiceContext().getBroadcastAndMutiRevPort()));
                sender.setBroadcast(true);
                sender.doRequest(null, null);
            }
            catch (IOException e) {
                ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5e7f\u64ad\u5f02\u5e38! " + e.getMessage()));
            }
            ++n2;
        }
        return entry.queue;
    }

    public static List<LanWanProxyHost> findLanWanProxyHostsList(long waitMills) {
        if (waitMills <= 0L) {
            waitMills = 5000L;
        }
        if (waitMills > 10000L) {
            waitMills = 10000L;
        }
        LinkedList<LanWanProxyHost> list = new LinkedList<LanWanProxyHost>();
        BlockingQueue<LanWanProxyHost> q = LanBroadcastServiceAction.findLanWanProxyHosts(waitMills);
        long x = ServiceUtil.getServiceContext().currentTimeMillis();
        while (waitMills > 0L) {
            try {
                long x1;
                LanWanProxyHost host = q.poll(waitMills, TimeUnit.MILLISECONDS);
                if (host != null) {
                    list.add(host);
                }
                if ((x1 = ServiceUtil.getServiceContext().currentTimeMillis() - x) >= waitMills) break;
                waitMills -= x1;
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return list;
    }

    public static class LanWanProxyHost {
        public String lanAddress;
        public String name;
        public int httpPort = 0;
        public int httpsPort = 0;
        public int udpPort = 0;
        public int socks5Port = 0;
        public String sn;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LanWanProxyHost [lanAddress=");
            builder.append(this.lanAddress);
            builder.append(", name=");
            builder.append(this.name);
            builder.append(", httpPort=");
            builder.append(this.httpPort);
            builder.append(", httpsPort=");
            builder.append(this.httpsPort);
            builder.append(", udpPort=");
            builder.append(this.udpPort);
            builder.append(", socks5Port=");
            builder.append(this.socks5Port);
            builder.append(", sn=");
            builder.append(this.sn);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lanAddress == null ? 0 : this.lanAddress.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.sn == null ? 0 : this.sn.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LanWanProxyHost other = (LanWanProxyHost)obj;
            if (this.lanAddress == null ? other.lanAddress != null : !this.lanAddress.equals(other.lanAddress)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.sn == null ? other.sn != null : !this.sn.equals(other.sn));
        }
    }

    private static class SearchWanEntry {
        private BlockingQueue<LanWanProxyHost> queue = new LinkedBlockingQueue<LanWanProxyHost>();
        private Set<LanWanProxyHost> hostSet = Collections.synchronizedSet(new HashSet());

        private SearchWanEntry() {
        }

        private void checkLanHost(final LanWanProxyHost host) throws Exception {
            if (this.hostSet.contains(host)) {
                return;
            }
            this.hostSet.add(host);
            InetAddress ress = InetAddress.getByName(host.lanAddress);
            if (ress.isLoopbackAddress()) {
                return;
            }
            RequestSender sender = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)new InetSocketAddress(ress, host.udpPort)).createRequest();
            sender.setRequestActionName("/LanNetTestServiceAction");
            sender.doRequest(null, new ReceiveCallback(){

                public void onWaitTimeout() throws Exception {
                }

                public long getWaitTimeoutMills() {
                    return 3000L;
                }

                public void doReceiver(Receiver r, int id) throws Exception {
                    String respCode = r.getHeaderValue("respCode");
                    if ("SUCCESS".equals(respCode)) {
                        queue.offer(host);
                    }
                }
            });
        }
    }
}

