/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.UserSession;
import com.wovoe.carpark.cloud.client.HostSate;
import com.wovoe.carpark.conn.udp.net.LanAuthMethodServiceAction;
import com.wovoe.carpark.conn.udp.net.TransferRpcUtil;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.dto.CarparkHost;
import com.wovoe.carpark.dto.CarparkLocalConfig;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.AlwaysOpenAction;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LanHeartBeatHandleAction
extends LanAuthMethodServiceAction
implements Runnable {
    public static final String ACTION_NAME = "/CarparkLanHeartBeatHandleAction";

    public void heartbeat(Receiver request) throws Exception {
        Heartbeat heartbeatV = new Heartbeat();
        heartbeatV.setLanVersion(ServiceUtil.getServiceContext().getVersion());
        HashMap<String, String> lanConnectedEqSatesMap = new HashMap<String, String>();
        if (ServiceUtil.getServiceContext().getEquipmentManager() != null) {
            Enumeration<Equipment> eqs = ServiceUtil.getServiceContext().getEquipmentManager().getAllEquipments();
            while (eqs.hasMoreElements()) {
                Equipment eq = eqs.nextElement();
                EquipmentState state = eq.getEquipmentState();
                if (state == null || EquipmentState.DISCONNECTED == state) continue;
                lanConnectedEqSatesMap.put(eq.getEquipmentNo(), state.name());
            }
        }
        heartbeatV.setLanConnectedEqSatesMap(lanConnectedEqSatesMap);
        String _testConn = request.getHeaderValue("testConn");
        boolean testConn = _testConn != null && "true".equals(_testConn);
        String srcHostNo = request.getHeaderValue("srcHostNo");
        SocketAddress remoteAddress = request.getRemoteAddress();
        String jsonStr = GsonBuilder.create().toJson((Object)heartbeatV);
        byte[] aData = jsonStr.getBytes("UTF-8");
        ResponseSender response = TransferRpcUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
        boolean connectWan = ServiceUtil.getServiceContext().getCloudContext() != null && ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection() != null && ServiceUtil.getServiceContext().getCloudContext().getCarparkCloudConnection().isConnected() ? true : ServiceUtil.getServiceContext().isWanOk();
        response.setHeader("httpPort", String.valueOf(ServiceUtil.getServiceContext().getHttpServiceServer().getPort()));
        response.setHeader("httpsPort", "0");
        response.setHeader("udpPort", String.valueOf(ServiceUtil.getServiceContext().getLanUdpPort()));
        response.setHeader("socks5Port", "0");
        response.setHeader("connectWan", String.valueOf(connectWan));
        response.setHeader("ver", ServiceUtil.getServiceContext().getVersion());
        ApplicationService appService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
        UserSession userSession = appService.getUserSession();
        if (userSession != null) {
            if (userSession.getUser() != null) {
                if (userSession.getUser().getUser_code() != null) {
                    response.setHeader("userCode", userSession.getUser().getUser_code());
                }
                if (userSession.getUser().getUser_name() != null) {
                    response.setHeader("userName", userSession.getUser().getUser_name());
                }
            }
            if (userSession.getDutyNumber() != null && userSession.getDutyNumber() != null) {
                response.setHeader("dutyNo", userSession.getDutyNumber().getDuty_no());
            }
        }
        response.setSendData(aData);
        response.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)response, (String)this.getSignKey()));
        response.doResponse(null, null);
        if (testConn && remoteAddress instanceof InetSocketAddress && !((InetSocketAddress)remoteAddress).getAddress().isLoopbackAddress()) {
            LanHeartBeatHandleAction.sendHeartbeat(srcHostNo, (InetSocketAddress)remoteAddress, false);
        }
    }

    public static void sendHeartbeat(String hostNo) {
        LanHeartBeatHandleAction.sendHeartbeat(hostNo, null, false);
    }

    static void sendHeartbeat(String hostNo, InetSocketAddress hostAddress, final boolean testConn) {
        try {
            CarparkLocalConfig localHostConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
            Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
            if (localHostConfig == null || localHostConfig.getHost_no() == null || localHostConfig.getHost_no().length() == 0 || carpark == null || carpark.getLan_sign_key() == null || carpark.getLan_sign_key().length() == 0 || localHostConfig.getCarpark_deploy_type() == null) {
                return;
            }
            if (hostNo.equals(localHostConfig.getHost_no())) {
                return;
            }
            if (ServiceUtil.getServiceContext().getDBConfigCache() == null) {
                return;
            }
            final CarparkHost host = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap().get(hostNo);
            if (host == null) {
                return;
            }
            if (host.getHost_use() == null) {
                return;
            }
            if (host.getNet_mode() == null) {
                return;
            }
            if (host.getHost_use() != 1) {
                if (host.getNet_mode() == 2) {
                    return;
                }
                if (localHostConfig.getCarpark_deploy_type() == 1) {
                    return;
                }
            }
            if (hostAddress == null && (hostAddress = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanSocektAddress(hostNo)) == null) {
                hostAddress = ServiceUtil.getServiceContext().getOtherHostSateManager().getBroadcastReportLanSocketAddress(hostNo);
            }
            if (hostAddress == null) {
                return;
            }
            Set<String> localIpSet = ServiceUtil.getServiceContext().getLocalIpv4(true);
            if (localIpSet == null || localIpSet.isEmpty()) {
                return;
            }
            final InetSocketAddress remoteHostAddress = hostAddress;
            RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)remoteHostAddress);
            RequestSender requestSender = connection.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "heartbeat");
            requestSender.setHeader("srcHostNo", localHostConfig.getHost_no());
            requestSender.setHeader("destHostNo", hostNo);
            requestSender.setHeader("testConn", String.valueOf(testConn));
            requestSender.setHeader("SYSTEM_MILLS", String.valueOf(System.currentTimeMillis()));
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.setAttribute("send.attempt.times", (Object)2);
            final String remoteHostNo = hostNo;
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    try {
                        String respCode = receiver.getHeaderValue("respCode");
                        if (respCode == null || respCode.length() == 0) {
                            return;
                        }
                        if (!"SUCCESS".equals(respCode)) {
                            return;
                        }
                        String sign = receiver.getHeaderValue("sign");
                        if (sign == null || sign.length() == 0) {
                            return;
                        }
                        String checkSign = HMPNetDataSignTool.getSign((Receiver)receiver, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key());
                        if (!sign.equals(checkSign)) {
                            return;
                        }
                        byte[] data = receiver.getData();
                        if (data == null || data.length == 0 || receiver.getDataLength() == 0) {
                            return;
                        }
                        try {
                            String _connectWan;
                            InetSocketAddress lanSocketAddress;
                            HostSate hostSate;
                            if (testConn && (hostSate = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(remoteHostNo)) != null && (lanSocketAddress = hostSate.getLanSocketAddress()) != null && !lanSocketAddress.equals(remoteHostAddress) && ServiceUtil.getServiceContext().currentTimeMillis() - hostSate.getLanHostMills() < 2000L) {
                                return;
                            }
                            String json = new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength(), "UTF-8");
                            Heartbeat result = (Heartbeat)GsonBuilder.create().fromJson(json, Heartbeat.class);
                            ServiceUtil.getServiceContext().getOtherHostSateManager().updateLanHeartbeat(remoteHostNo, result.getLanVersion(), remoteHostAddress, result.getLanConnectedEqSatesMap());
                            int httpPort = this.getIntValue(receiver, "httpPort", 0);
                            int httpsPort = this.getIntValue(receiver, "httpsPort", 0);
                            int socks5Port = this.getIntValue(receiver, "socks5Port", 0);
                            String ver = receiver.getHeaderValue("ver");
                            String qrValue = receiver.getHeaderValue("qrValue");
                            if (qrValue == null || qrValue.length() == 0) {
                                qrValue = Constants.YES_STR;
                            }
                            boolean connectWan = (_connectWan = receiver.getHeaderValue("connectWan")) != null && "true".equals(_connectWan);
                            HostSate hostSate2 = ServiceUtil.getServiceContext().getOtherHostSateManager().getConnectedLanHostSate(remoteHostNo);
                            if (hostSate2 != null) {
                                hostSate2.setHttpPort(httpPort);
                                hostSate2.setHttpsPort(httpsPort);
                                hostSate2.setSocks5Port(socks5Port);
                                hostSate2.setVer(ver);
                                hostSate2.setConnectWan(connectWan);
                                hostSate2.setQrValue(qrValue);
                            }
                            if (host.getHost_type() != null && host.getHost_type() == 3 && result.getAlwaysOpens() != null && !result.getAlwaysOpens().isEmpty()) {
                                for (Map.Entry<String, String> entry : result.getAlwaysOpens().entrySet()) {
                                    Equipment equipment = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(entry.getKey());
                                    if (equipment == null || !(equipment.getEquipmentAction() instanceof AlwaysOpenAction)) continue;
                                    AlwaysOpenAction action = (AlwaysOpenAction)equipment.getEquipmentAction();
                                    action.setAlwaysOpenBoxValue(Constants.YES_STR.equals(entry.getValue()));
                                }
                            }
                        }
                        catch (Exception ex) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }

                private int getIntValue(Receiver receiver, String name, int defaultValue) {
                    if (name == null || name.length() == 0 || receiver == null) {
                        return defaultValue;
                    }
                    try {
                        String v = receiver.getHeaderValue(name);
                        if (v != null && v.length() > 0) {
                            return Integer.parseInt(v);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return defaultValue;
                }

                public void onWaitTimeout() throws Exception {
                }

                public long getWaitTimeoutMills() {
                    return 3000L;
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\u5fc3\u8df3\u68c0\u6d4b\u5c40\u57df\u7f51\u4e3b\u673a" + hostNo + "\u5f02\u5e38!"), (Throwable)ex);
        }
    }

    @Override
    public void run() {
        try {
            CarparkLocalConfig localHostConfig = ServiceUtil.getServiceContext().getCarparkLocalConfig();
            Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
            if (localHostConfig == null || localHostConfig.getHost_no() == null || localHostConfig.getHost_no().length() == 0 || carpark == null || carpark.getLan_sign_key() == null || carpark.getLan_sign_key().length() == 0 || localHostConfig.getCarpark_deploy_type() == null) {
                return;
            }
            if (ServiceUtil.getServiceContext().getDBConfigCache() == null) {
                return;
            }
            Map<String, CarparkHost> hostsMap = ServiceUtil.getServiceContext().getDBConfigCache().getHostsMap();
            if (hostsMap == null) {
                return;
            }
            for (String hostNo : hostsMap.keySet()) {
                LanHeartBeatHandleAction.sendHeartbeat(hostNo);
            }
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u68c0\u6d4b\u5c40\u57df\u7f51\u7edc\u5f02\u5e38! " + ex.getMessage()));
        }
    }

    public static class Heartbeat {
        private String lanVersion;
        private Map<String, String> lanConnectedEqSatesMap;
        private Map<String, String> alwaysOpens;

        public String getLanVersion() {
            return this.lanVersion;
        }

        public void setLanVersion(String lanVersion) {
            this.lanVersion = lanVersion;
        }

        public Map<String, String> getLanConnectedEqSatesMap() {
            return this.lanConnectedEqSatesMap;
        }

        public void setLanConnectedEqSatesMap(Map<String, String> lanConnectedEqSatesMap) {
            this.lanConnectedEqSatesMap = lanConnectedEqSatesMap;
        }

        public Map<String, String> getAlwaysOpens() {
            return this.alwaysOpens;
        }

        public void setAlwaysOpens(Map<String, String> alwaysOpens) {
            this.alwaysOpens = alwaysOpens;
        }
    }
}

