/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.conn.udp.net.TransferRpcUtil;
import com.wovoe.carpark.dto.Carpark;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ServiceAction;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class LanMethodServiceAction
implements ServiceAction {
    private Map<String, Method> methodsMap = new HashMap<String, Method>();

    protected LanMethodServiceAction() {
        Method[] methods = this.getClass().getMethods();
        String inv = "service";
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> rtp;
            Method method = methodArray[n2];
            String methodName = method.getName();
            Class<?>[] pty = method.getParameterTypes();
            if (pty != null && pty.length == 1 && pty[0].equals(Receiver.class) && (Void.TYPE.equals(rtp = method.getReturnType()) || Void.class.equals(rtp)) && !inv.equals(methodName)) {
                this.methodsMap.put(methodName, method);
            }
            ++n2;
        }
    }

    protected String getMethodHeadName() {
        return "op";
    }

    protected String getSignKey() {
        Carpark carpark = ServiceUtil.getServiceContext().getCarpark();
        if (carpark != null) {
            return carpark.getLan_sign_key();
        }
        return RandomStringGenerator.getDefaultInstance().getNewString(32);
    }

    public void service(Receiver request) throws Exception {
        String methodName = request.getHeaderValue(this.getMethodHeadName());
        if (methodName == null || methodName.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570:" + this.getMethodHeadName(), this.getSignKey());
            return;
        }
        Method method = this.methodsMap.get(methodName);
        if (method == null) {
            TransferRpcUtil.doSimpleResponse(request, "RESP_CODE_METHOD_NOTFOUND", "\u670d\u52a1\u65b9\u6cd5:" + methodName + "\u672a\u627e\u5230", this.getSignKey());
            return;
        }
        try {
            method.invoke((Object)this, request);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u6267\u884c\u65b9\u6cd5\uff1a" + methodName + ",\u5185\u90e8\u9519\u8bef"), (Throwable)ex);
            TransferRpcUtil.doSimpleResponse(request, "SYS_ERROR", "\u8fdc\u7a0b\u5185\u90e8\u670d\u52a1\u9519\u8bef", this.getSignKey());
            return;
        }
    }
}

