/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.ConfirmPassDialogCallback;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.conn.udp.net.LanAuthMethodServiceAction;
import com.wovoe.carpark.conn.udp.net.TransferRpcUtil;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.driver.DnctChannelBoardActtion;
import com.wovoe.carpark.event.app.CaptureEvent;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.event.app.PlateRecognizedEvent;
import com.wovoe.carpark.event.app.ReadPassportNumberEvent;
import com.wovoe.carpark.event.equipment.DetectedPassEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.MainHostPassFilter;
import com.wovoe.carpark.service.remote.CarparkCloudMessageHandler;
import com.wovoe.carpark.vo.PassSessionData;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LanPassChannelHandleAction
extends LanAuthMethodServiceAction {
    public static final String ACTION_NAME = "/LanCarparkPassChannelHandleAction";

    public void passSessionConfirmResult(Receiver request) throws Exception {
        long sessionId;
        String passSessionId = request.getHeaderValue("passSessionId");
        if (passSessionId == null || passSessionId.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11passSessionId", this.getSignKey());
            return;
        }
        String channelNo = request.getHeaderValue("channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11channelNo", this.getSignKey());
            return;
        }
        try {
            sessionId = Long.parseLong(passSessionId);
        }
        catch (Exception ex) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "passSessionId\u9519\u8bef", this.getSignKey());
            return;
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u4e0d\u662f\u672c\u673a\u7ba1\u7406\u7684\u901a\u9053", this.getSignKey());
            return;
        }
        PassSession passSession = passChannel.getPassSession(sessionId);
        if (passSession == null) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u65e0\u6548sessionID:" + sessionId, this.getSignKey());
            return;
        }
        if (passSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG || passSession.getSessionState() == PassSession.SessionState.WAIT_PAY) {
            String tipMsg;
            block37: {
                passSession.removeCancelPassRecord();
                int opType = Integer.parseInt(request.getHeaderValue("opType"));
                int opResult = Integer.parseInt(request.getHeaderValue("opResult"));
                String opUserName = request.getHeaderValue("opUserName");
                PassSessionData passSessionData = null;
                try {
                    if (request.getData() != null && request.getDataLength() > 0) {
                        passSessionData = (PassSessionData)GsonBuilder.create().fromJson(new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8"), PassSessionData.class);
                    }
                }
                catch (Exception ex) {
                    ServiceLog.getLog().warn((Object)("\u4e0d\u662f\u6709\u6548\u7684PassSessionData\u6570\u636e: " + ex.getMessage()));
                }
                if (passSessionData == null) {
                    passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    passSession.setSessionState(PassSession.SessionState.CANCELED);
                } else if (PassSession.SessionState.WAIT_CAR_LEAVE.name().equals(passSessionData.getSessionStateName()) || PassSession.SessionState.CAR_LEAVING.name().equals(passSessionData.getSessionStateName()) || PassSession.SessionState.CAR_LEFT.name().equals(passSessionData.getSessionStateName())) {
                    MainHostPassFilter.setPassSessionData(passSession, passSessionData, false, false, passSession.getPassPlate());
                    if (passSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG || passSession.getSessionState() == PassSession.SessionState.WAIT_PAY) {
                        passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                        passSession.setSessionState(PassSession.SessionState.CANCELED);
                    }
                } else {
                    passSession.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    passSession.setSessionState(PassSession.SessionState.CANCELED);
                }
                ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                if (callback != null) {
                    callback.doClosePassDialog(passSession);
                }
                tipMsg = String.valueOf(passSession.getPassChannel().getChannel().getChannel_name()) + ": ";
                if (passSession.getPassPlate() != null) {
                    tipMsg = String.valueOf(tipMsg) + passSession.getPassPlate();
                }
                if (opResult == 0) {
                    tipMsg = opType == 0 ? (opUserName != null && opUserName.length() > 0 ? String.valueOf(tipMsg) + "\uff0c\u5df2\u88ab\u64cd\u4f5c\u5458" + opUserName + "\u53d6\u6d88\u653e\u884c" : String.valueOf(tipMsg) + "\uff0c\u5df2\u88ab\u64cd\u4f5c\u5458\u53d6\u6d88\u653e\u884c") : (opType == 2 ? String.valueOf(tipMsg) + "\uff0c\u5904\u7406\u5f39\u6846\u8d85\u65f6\uff0c\u81ea\u52a8\u53d6\u6d88\u653e\u884c" : (opType == 4 ? String.valueOf(tipMsg) + "\uff0c\u8f66\u8f86\u5df2\u79bb\u5f00\uff0c\u53d6\u6d88\u653e\u884c" : (opType == 6 ? String.valueOf(tipMsg) + "\uff0c\u63a7\u5236\u4e3b\u673a\u7cfb\u7edf\u9519\u8bef\uff0c\u53d6\u6d88\u653e\u884c" : String.valueOf(tipMsg) + "\uff0c\u5df2\u53d6\u6d88\u653e\u884c")));
                } else if (opType == 0) {
                    tipMsg = opUserName != null && opUserName.length() > 0 ? String.valueOf(tipMsg) + "\uff0c\u5df2\u88ab\u64cd\u4f5c\u5458" + opUserName + "\u786e\u8ba4\u653e\u884c" : String.valueOf(tipMsg) + "\uff0c\u5df2\u88ab\u64cd\u4f5c\u5458\u786e\u8ba4\u653e\u884c";
                } else if (opType == 1) {
                    String _payMethod = request.getHeaderValue("payMethod");
                    String _payScene = request.getHeaderValue("payScene");
                    String _payMoney = request.getHeaderValue("payMoney");
                    if (_payMethod != null && _payMethod.length() > 0 && _payScene != null && _payScene.length() > 0 && _payMoney != null && _payMoney.length() > 0) {
                        try {
                            int payMethod = Integer.parseInt(_payMethod);
                            int payScene = Integer.parseInt(_payScene);
                            BigDecimal payMoney = new BigDecimal(_payMoney);
                            if (payMoney.doubleValue() > 0.0) {
                                String payMethodName = ServiceUtil.getServiceContext().getDBConfigCache().getPayMethodMap().get(payMethod);
                                if (payScene == 5) {
                                    if (payMethod == 6) {
                                        tipMsg = String.valueOf(tipMsg) + "\uff0cETC\u652f\u4ed8" + payMoney + "\u6210\u529f";
                                    } else if (payMethodName == null || payMethodName.length() == 0) {
                                        tipMsg = String.valueOf(tipMsg) + "\uff0c\u65e0\u611f\u652f\u4ed8" + payMoney + "\u6210\u529f";
                                    } else {
                                        payMethodName = payMethodName.endsWith("\u652f\u4ed8") ? String.valueOf(payMethodName.substring(0, payMethodName.length() - 2)) + "\u65e0\u611f\u652f\u4ed8" : String.valueOf(payMethodName) + "\u65e0\u611f\u652f\u4ed8";
                                        tipMsg = String.valueOf(tipMsg) + "\uff0c" + payMethodName + payMoney + "\u6210\u529f";
                                    }
                                } else if (payMethodName == null || payMethodName.length() == 0) {
                                    tipMsg = String.valueOf(tipMsg) + "\uff0c\u7ebf\u4e0a\u652f\u4ed8" + payMoney + "\u6210\u529f";
                                } else {
                                    if (!payMethodName.endsWith("\u652f\u4ed8")) {
                                        payMethodName = String.valueOf(payMethodName) + "\u652f\u4ed8";
                                    }
                                    tipMsg = String.valueOf(tipMsg) + "\uff0c" + payMethodName + payMoney + "\u6210\u529f";
                                }
                                break block37;
                            }
                            tipMsg = String.valueOf(tipMsg) + "\uff0c\u7ebf\u4e0a\u7f34\u8d39\u6210\u529f";
                        }
                        catch (Exception ex) {
                            tipMsg = String.valueOf(tipMsg) + "\uff0c\u7ebf\u4e0a\u7f34\u8d39\u6210\u529f";
                        }
                    } else {
                        tipMsg = String.valueOf(tipMsg) + "\uff0c\u7ebf\u4e0a\u7f34\u8d39\u6210\u529f";
                    }
                } else {
                    tipMsg = opType == 3 ? String.valueOf(tipMsg) + "\uff0c\u5df2\u88ab\u64cd\u4f5c\u5458\u9065\u63a7\u5668\u5f00\u95f8\u653e\u884c" : (opType == 5 ? String.valueOf(tipMsg) + "\uff0c\u5df2\u5728\u5176\u4ed6\u901a\u9053\u7f34\u8d39\u79bb\u573a" : String.valueOf(tipMsg) + "\uff0c\u5df2\u786e\u8ba4\u653e\u884c");
                }
            }
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession.getPassChannel(), tipMsg, 2));
        }
        TransferRpcUtil.doSimpleResponse(request, "SUCCESS", "SUCCESS", this.getSignKey());
    }

    public void updatePassSessionData(Receiver request) throws Exception {
        long sessionId;
        String passSessionId = request.getHeaderValue("passSessionId");
        if (passSessionId == null || passSessionId.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11passSessionId", this.getSignKey());
            return;
        }
        String channelNo = request.getHeaderValue("channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11channelNo", this.getSignKey());
            return;
        }
        String updateByPlate = request.getHeaderValue("updateByPlate");
        try {
            sessionId = Long.parseLong(passSessionId);
        }
        catch (Exception ex) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "passSessionId\u9519\u8bef", this.getSignKey());
            return;
        }
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel == null) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u4e0d\u662f\u672c\u673a\u7ba1\u7406\u7684\u901a\u9053", this.getSignKey());
            return;
        }
        PassSession passSession = passChannel.getPassSession(sessionId);
        if (passSession == null) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u65e0\u6548sessionID:" + sessionId, this.getSignKey());
            return;
        }
        if (passSession.getSessionState() == PassSession.SessionState.OPEN_DIALOG || passSession.getSessionState() == PassSession.SessionState.WAIT_PAY) {
            PassSessionData passSessionData;
            if (request.getData() == null || request.getData().length == 0 || request.getDataLength() == 0) {
                TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u8981\u66f4\u65b0\u7684\u6570\u636e", this.getSignKey());
                return;
            }
            try {
                passSessionData = (PassSessionData)GsonBuilder.create().fromJson(new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8"), PassSessionData.class);
            }
            catch (Exception ex) {
                TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u66f4\u65b0\u7684\u6570\u636e\u683c\u5f0f\u9519\u8bef", this.getSignKey());
                return;
            }
            boolean setSuccess = MainHostPassFilter.setPassSessionData(passSession, passSessionData, false, false, passSession.getPassPlate());
            if (setSuccess) {
                ConfirmPassDialogCallback callback;
                if (updateByPlate != null && "true".equals(updateByPlate)) {
                    passSession.removeAttribute("GUI_SELECT_DISCOUNT");
                    CaptureEvent certCapture = null;
                    List<CaptureEvent> clist = passSession.getReadPassportNumberEvent().getCaptures();
                    if (clist != null && !clist.isEmpty()) {
                        for (CaptureEvent e : clist) {
                            if (e.getPicture_use() != 8) continue;
                            certCapture = e;
                            break;
                        }
                    }
                    if (certCapture != null && clist != null) {
                        clist.remove(certCapture);
                    }
                }
                if ((callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback()) != null) {
                    callback.doUpdateSession(passSession);
                }
                String tipMsg = String.valueOf(passSession.getPassChannel().getChannel().getChannel_name()) + ": \u4e91\u7aef\u7528\u6237\u4fee\u6539\u4e86";
                if (passSession.getPassChannel().isSwipeCard(passSession)) {
                    tipMsg = String.valueOf(tipMsg) + "\u5237\u5361\uff1a[" + passSession.getReadPassportNumberEvent().getPassportNumber() + "]";
                } else {
                    PlateRecognizedEvent event = passSession.getPlateRecognizedEvent();
                    if (event == null && passSession.getReadPassportNumberEvent() != null && passSession.getReadPassportNumberEvent().getPlateRecognizedEvent() != null) {
                        event = passSession.getReadPassportNumberEvent().getPlateRecognizedEvent();
                    }
                    if (event != null) {
                        tipMsg = String.valueOf(tipMsg) + "\u8bc6\u522b\u8f66\u724c\uff1a[" + event.getPlateNumber() + "]";
                    }
                }
                tipMsg = String.valueOf(tipMsg) + "\u653e\u884c\u4fe1\u606f";
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(passSession.getPassChannel(), tipMsg, 2));
            }
        }
        TransferRpcUtil.doSimpleResponse(request, "SUCCESS", "SUCCESS", this.getSignKey());
    }

    public void queryPassSession(Receiver request) throws Exception {
        String channelNo = request.getHeaderValue("channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u901a\u9053\u53f7", this.getSignKey());
            return;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("channelNo", channelNo);
        String plateNumber0 = request.getHeaderValue("plateNumber0");
        String passportNumber0 = request.getHeaderValue("passportNumber0");
        String mediumType0 = request.getHeaderValue("mediumType0");
        String scanPassportNumber0 = request.getHeaderValue("scanPassportNumber0");
        if (plateNumber0 != null && plateNumber0.length() > 0) {
            paramMap.put("plateNumber0", plateNumber0);
        }
        if (passportNumber0 != null && passportNumber0.length() > 0) {
            paramMap.put("passportNumber0", passportNumber0);
        }
        if (mediumType0 != null && mediumType0.length() > 0) {
            paramMap.put("mediumType0", mediumType0);
        }
        if (scanPassportNumber0 != null && scanPassportNumber0.length() > 0) {
            paramMap.put("scanPassportNumber0", mediumType0);
        }
        CarparkCloudMessageHandler carparkCloudMessageHandler = (CarparkCloudMessageHandler)ServiceUtil.getServiceContext().getService("carparkCloudMessageHandler");
        CloudResultResponse r = carparkCloudMessageHandler.queryPassSession(paramMap, new HashMap<String, Object>());
        ResponseSender sender = TransferRpcUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
        sender.setSendData(GsonBuilder.create().toJson((Object)r).getBytes("UTF-8"));
        String sign = HMPNetDataSignTool.getSign((Receiver)sender, (String)this.getSignKey());
        sender.setHeader("sign", sign);
        sender.doResponse(null, null);
    }

    @Deprecated
    public void dnctChannelBoardOnlineAction(Receiver request) throws Exception {
        Map jsonMap;
        String json;
        String channelNo = request.getHeaderValue("channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u901a\u9053\u53f7", this.getSignKey());
            return;
        }
        String eqNo = request.getHeaderValue("eqNo");
        if (eqNo == null || eqNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u8bbe\u5907\u7f16\u53f7", this.getSignKey());
            return;
        }
        PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (channel == null) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u975e\u672c\u673a\u7ba1\u7406\u8f66\u9053", this.getSignKey());
            return;
        }
        Equipment equipment = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(eqNo);
        if (equipment == null) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u672c\u673a\u672a\u7ba1\u7406\u6b64\u8bbe\u5907", this.getSignKey());
            return;
        }
        if (request.getDataLength() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u6570\u636e", this.getSignKey());
            return;
        }
        Object action = equipment.getEquipmentAction();
        if (!(action instanceof DnctChannelBoardActtion)) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u8bbe\u5907\u7c7b\u578b\u9519\u8bef", this.getSignKey());
            return;
        }
        try {
            json = new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8");
        }
        catch (Exception ex) {
            json = new String(request.getData(), request.getDataOffset(), request.getDataLength());
        }
        try {
            jsonMap = (Map)ServiceUtil.getHtmlEscapingGson().fromJson(json, Map.class);
        }
        catch (Exception ex) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6570\u636e\u4e0d\u662fjson", this.getSignKey());
            return;
        }
        ((DnctChannelBoardActtion)action).handleJsonMessageMap(jsonMap, json);
        TransferRpcUtil.doSimpleResponse(request, "SUCCESS", "SUCCESS", this.getSignKey());
    }

    public void lanUploadPassSession(Receiver request) throws Exception {
        List<String> list;
        Equipment equipment;
        PassSessionData passSessionData;
        String channelNo = request.getHeaderValue("channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u901a\u9053\u53f7", this.getSignKey());
            return;
        }
        PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (channel == null) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u975e\u672c\u673a\u7ba1\u7406\u8f66\u9053", this.getSignKey());
            return;
        }
        if (request.getDataLength() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u6570\u636e", this.getSignKey());
            return;
        }
        try {
            passSessionData = (PassSessionData)GsonBuilder.create().fromJson(new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8"), PassSessionData.class);
        }
        catch (Exception ex) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6570\u636e\u4e0d\u662fjson", this.getSignKey());
            return;
        }
        if (passSessionData.getPassportMediumType() != null && (passSessionData.getPassportMediumType() == 1 || passSessionData.getPassportMediumType() == 0) && passSessionData.getPassportNumber() != null && passSessionData.getPassportNumber().length() > 0 && passSessionData.getDetectCardNoEqNo() != null && passSessionData.getDetectCardNoEqNo().length() > 0 && (equipment = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(passSessionData.getDetectCardNoEqNo())) != null && (list = equipment.getChannelNos()) != null && list.contains(channelNo) && (PassSession.SessionState.WAIT_PAY.name().equals(passSessionData.getSessionStateName()) || PassSession.SessionState.OPEN_DIALOG.name().equals(passSessionData.getSessionStateName()))) {
            DetectedPassEvent detectedPassEvent = new DetectedPassEvent(equipment, passSessionData.getPassportNumber(), passSessionData.getPassportMediumType() == 1 ? DetectedPassEvent.MediaType.ID : DetectedPassEvent.MediaType.IC);
            boolean isLongDistance = Constants.YES_STR.equals(passSessionData.getLongDistance());
            detectedPassEvent.setLongDistance(isLongDistance);
            detectedPassEvent.setChannelNo(channelNo);
            ReadPassportNumberEvent readPassportNumberEvent = new ReadPassportNumberEvent(this, passSessionData.getPassportNumber(), passSessionData.getPassportMediumType(), channelNo);
            readPassportNumberEvent.setDetectedPassEvent(detectedPassEvent);
            Collection<PassSession> cls = channel.getSessions();
            if (cls != null) {
                for (PassSession session : cls) {
                    if (session.getReadPassportNumberEvent() == null || !session.getPassChannel().isSwipeCard(session) || passSessionData.getPassportMediumType().intValue() != session.getReadPassportNumberEvent().getPassportMediumType() || !passSessionData.getPassportNumber().equals(session.getReadPassportNumberEvent().getPassportNumber()) || session.getSessionState() != PassSession.SessionState.OPEN_DIALOG && session.getSessionState() != PassSession.SessionState.WAIT_PAY) continue;
                    session.removeCancelPassRecord();
                    session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                    if (callback != null) {
                        callback.doClosePassDialog(session);
                    }
                    channel.invalidateSession(session);
                }
            }
            readPassportNumberEvent.setPassSessionData(passSessionData);
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            readPassportNumberEvent.setSetPassSessionDataHandler((OperationFutureHandler<PassSession>)xf);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(readPassportNumberEvent);
            try {
                PassSession passSession = (PassSession)xf.get(5000L, TimeUnit.MILLISECONDS);
                if (passSession != null) {
                    String srcHostNo = request.getHeaderValue("srcHostNo");
                    passSession.setAttribute("SLAVE_HOST_SESSIONID_" + srcHostNo, String.valueOf(passSessionData.getSessionId()));
                    ResponseSender sender = TransferRpcUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
                    sender.setHeader("refSessionId", String.valueOf(passSession.getSessionId()));
                    String signKey = this.getSignKey();
                    if (signKey != null && signKey.length() > 0) {
                        String sign = HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey);
                        sender.setHeader("sign", sign);
                    }
                    sender.doResponse(null, null);
                    return;
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)"\u5904\u7406\u5237\u5361\u5f39\u6846\u5f02\u5e38", (Throwable)ex);
            }
            finally {
                readPassportNumberEvent.setPassSessionData(null);
                readPassportNumberEvent.setSetPassSessionDataHandler(null);
            }
        }
        TransferRpcUtil.doSimpleResponse(request, "SUCCESS", "SUCCESS", this.getSignKey());
    }

    public void lanScanConfirm(Receiver request) throws Exception {
        int mediumType;
        PassSessionData passSessionData;
        String channelNo = request.getHeaderValue("channelNo");
        if (channelNo == null || channelNo.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u901a\u9053\u53f7", this.getSignKey());
            return;
        }
        PassChannel channel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (channel == null) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u975e\u672c\u673a\u7ba1\u7406\u8f66\u9053", this.getSignKey());
            return;
        }
        if (request.getDataLength() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u6570\u636e", this.getSignKey());
            return;
        }
        try {
            passSessionData = (PassSessionData)GsonBuilder.create().fromJson(new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8"), PassSessionData.class);
        }
        catch (Exception ex) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u6570\u636e\u4e0d\u662fjson", this.getSignKey());
            return;
        }
        String passportNumber = request.getHeaderValue("passportNumber");
        String _mediumType = request.getHeaderValue("mediumType");
        if (passportNumber == null || passportNumber.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11passportNumber", this.getSignKey());
            return;
        }
        if (_mediumType == null || _mediumType.length() == 0) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11mediumType", this.getSignKey());
            return;
        }
        if (!passportNumber.equals(passSessionData.getPassportNumber())) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "passportNumber\u4e0e\u6570\u636e\u7684\u4e0d\u5339\u914d", this.getSignKey());
            return;
        }
        try {
            mediumType = Integer.parseInt(_mediumType);
        }
        catch (Exception ex) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u65e0\u6548mediumType", this.getSignKey());
            return;
        }
        if (passSessionData.getPassportMediumType() == null || mediumType != passSessionData.getPassportMediumType()) {
            TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "mediumType\u4e0e\u6570\u636e\u7684\u4e0d\u5339\u914d", this.getSignKey());
            return;
        }
        String scanCode = request.getHeaderValue("scanCode");
        String plateNumber = request.getHeaderValue("plateNumber");
        String forceTemp = request.getHeaderValue("forceTemp");
        if (PassSession.SessionState.WAIT_PAY.name().equals(passSessionData.getSessionStateName()) || PassSession.SessionState.OPEN_DIALOG.name().equals(passSessionData.getSessionStateName())) {
            ReadPassportNumberEvent readPassportNumberEvent = new ReadPassportNumberEvent(channel, passportNumber, mediumType, channelNo);
            readPassportNumberEvent.setScanCode(scanCode);
            readPassportNumberEvent.setPlateNumber(plateNumber);
            readPassportNumberEvent.setUserScan(true);
            readPassportNumberEvent.setForceTemp(Constants.YES_STR.equals(forceTemp));
            Collection<PassSession> cls = channel.getSessions();
            if (cls != null) {
                for (PassSession session : cls) {
                    if (session.getReadPassportNumberEvent() == null || passSessionData.getPassportMediumType().intValue() != session.getReadPassportNumberEvent().getPassportMediumType() || !passSessionData.getPassportNumber().equals(session.getReadPassportNumberEvent().getPassportNumber()) || session.getSessionState() != PassSession.SessionState.OPEN_DIALOG && session.getSessionState() != PassSession.SessionState.WAIT_PAY) continue;
                    session.removeCancelPassRecord();
                    session.setAttribute("GUI_CANCEL", Boolean.TRUE);
                    session.setSessionState(PassSession.SessionState.CANCELED);
                    ConfirmPassDialogCallback callback = ServiceUtil.getServiceContext().getConfirmPassDialogCallback();
                    if (callback != null) {
                        callback.doClosePassDialog(session);
                    }
                    channel.invalidateSession(session);
                }
            }
            readPassportNumberEvent.setPassSessionData(passSessionData);
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            readPassportNumberEvent.setSetPassSessionDataHandler((OperationFutureHandler<PassSession>)xf);
            ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(readPassportNumberEvent);
            try {
                PassSession passSession = (PassSession)xf.get(5000L, TimeUnit.MILLISECONDS);
                if (passSession != null) {
                    String srcHostNo = request.getHeaderValue("srcHostNo");
                    passSession.setAttribute("SLAVE_HOST_SESSIONID_" + srcHostNo, String.valueOf(passSessionData.getSessionId()));
                    ResponseSender sender = TransferRpcUtil.createBasicResponse(request, "SUCCESS", "SUCCESS");
                    sender.setHeader("refSessionId", String.valueOf(passSession.getSessionId()));
                    String signKey = this.getSignKey();
                    if (signKey != null && signKey.length() > 0) {
                        String sign = HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey);
                        sender.setHeader("sign", sign);
                    }
                    sender.doResponse(null, null);
                    return;
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)"\u5904\u7406\u626b\u7801\u5f39\u6846\u5f02\u5e38", (Throwable)ex);
            }
            finally {
                readPassportNumberEvent.setPassSessionData(null);
                readPassportNumberEvent.setSetPassSessionDataHandler(null);
            }
        }
    }

    public static OperationFuture<KeyValueEntry<String, String>> doLanConfirmPassOption(String remoteHostNo, InetSocketAddress lanRemoteAddress, Map<String, String> paramMap, PassSessionData passSessionData) {
        final OperationFutureHandler entryHandler = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)lanRemoteAddress);
            RequestSender requestSender = connection.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "lanConfirmPassOption");
            requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            requestSender.setHeader("destHostNo", remoteHostNo);
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                requestSender.setHeader(entry.getKey(), entry.getValue());
            }
            if (passSessionData != null) {
                byte[] data = GsonBuilder.create().toJson((Object)passSessionData).getBytes("UTF-8");
                requestSender.setSendData(data);
            }
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"SEND_ERROR", (Object)"\u53d1\u9001\u5f02\u5e38"));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    try {
                        String respCode = receiver.getHeaderValue("respCode");
                        if (respCode == null || respCode.length() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"RESP_ERROR", (Object)"\u7f3a\u5c11\u54cd\u5e94\u7801"));
                            return;
                        }
                        if (!"SUCCESS".equals(respCode)) {
                            String respMsg = receiver.getHeaderValue("respMsg");
                            if (respMsg == null || respMsg.length() == 0) {
                                respMsg = "\u9519\u8bef\u4ee3\u7801\uff1a" + respCode;
                            }
                            entryHandler.setResult((Object)new KeyValueEntry((Object)respCode, (Object)respMsg));
                            return;
                        }
                        String sign = receiver.getHeaderValue("sign");
                        if (sign == null || sign.length() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"RESP_ERROR", (Object)"\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d"));
                            return;
                        }
                        String checkSign = HMPNetDataSignTool.getSign((Receiver)receiver, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key());
                        if (!sign.equals(checkSign)) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"RESP_ERROR", (Object)"\u54cd\u5e94\u7b7e\u540d\u6821\u9a8c\u9519\u8bef"));
                            return;
                        }
                        entryHandler.setResult((Object)new KeyValueEntry((Object)"SUCCESS", (Object)"\u64cd\u4f5c\u6210\u529f"));
                    }
                    catch (Exception ex) {
                        entryHandler.setException((Throwable)ex);
                    }
                }

                public void onWaitTimeout() throws Exception {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"RESP_TIMOUT", (Object)"\u54cd\u5e94\u8d85\u65f6"));
                }

                public long getWaitTimeoutMills() {
                    return 5000L;
                }
            });
        }
        catch (Exception ex) {
            entryHandler.setException((Throwable)ex);
        }
        return entryHandler;
    }

    public static OperationFuture<KeyValueEntry<String, String>> doLanOpenGate(String remoteHostNo, InetSocketAddress lanRemoteAddress, Map<String, String> paramMap) {
        final OperationFutureHandler entryHandler = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)lanRemoteAddress);
            RequestSender requestSender = connection.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "lanOpenGate");
            requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            requestSender.setHeader("destHostNo", remoteHostNo);
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                requestSender.setHeader(entry.getKey(), entry.getValue());
            }
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"SEND_ERROR", (Object)"\u53d1\u9001\u5f02\u5e38"));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    try {
                        String respCode = receiver.getHeaderValue("respCode");
                        if (respCode == null || respCode.length() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"RESP_ERROR", (Object)"\u7f3a\u5c11\u54cd\u5e94\u7801"));
                            return;
                        }
                        if (!"SUCCESS".equals(respCode)) {
                            String respMsg = receiver.getHeaderValue("respMsg");
                            if (respMsg == null || respMsg.length() == 0) {
                                respMsg = "\u9519\u8bef\u4ee3\u7801\uff1a" + respCode;
                            }
                            entryHandler.setResult((Object)new KeyValueEntry((Object)respCode, (Object)respMsg));
                            return;
                        }
                        String sign = receiver.getHeaderValue("sign");
                        if (sign == null || sign.length() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"RESP_ERROR", (Object)"\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d"));
                            return;
                        }
                        String checkSign = HMPNetDataSignTool.getSign((Receiver)receiver, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key());
                        if (!sign.equals(checkSign)) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"RESP_ERROR", (Object)"\u54cd\u5e94\u7b7e\u540d\u6821\u9a8c\u9519\u8bef"));
                            return;
                        }
                        entryHandler.setResult((Object)new KeyValueEntry((Object)"SUCCESS", (Object)"\u64cd\u4f5c\u6210\u529f"));
                    }
                    catch (Exception ex) {
                        entryHandler.setException((Throwable)ex);
                    }
                }

                public void onWaitTimeout() throws Exception {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"RESP_TIMOUT", (Object)"\u54cd\u5e94\u8d85\u65f6"));
                }

                public long getWaitTimeoutMills() {
                    return 6000L;
                }
            });
        }
        catch (Exception ex) {
            entryHandler.setException((Throwable)ex);
        }
        return entryHandler;
    }

    public static OperationFuture<KeyValueEntry<String, PassSessionData>> doLanStartManualConfirmSession(String remoteHostNo, InetSocketAddress lanRemoteAddress, Map<String, String> paramMap) {
        final OperationFutureHandler entryHandler = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)lanRemoteAddress);
            RequestSender requestSender = connection.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "lanStartManualConfirmSession");
            requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            requestSender.setHeader("destHostNo", remoteHostNo);
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                requestSender.setHeader(entry.getKey(), entry.getValue());
            }
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"\u53d1\u9001\u5f02\u5e38", null));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    try {
                        PassSessionData passSessionData;
                        String respCode = receiver.getHeaderValue("respCode");
                        if (respCode == null || respCode.length() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u7801", null));
                            return;
                        }
                        if (!"SUCCESS".equals(respCode)) {
                            String respMsg = receiver.getHeaderValue("respMsg");
                            if (respMsg == null || respMsg.length() == 0) {
                                respMsg = "\u9519\u8bef\u4ee3\u7801\uff1a" + respCode;
                            }
                            entryHandler.setResult((Object)new KeyValueEntry((Object)respMsg, null));
                            return;
                        }
                        String sign = receiver.getHeaderValue("sign");
                        if (sign == null || sign.length() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d", null));
                            return;
                        }
                        String checkSign = HMPNetDataSignTool.getSign((Receiver)receiver, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key());
                        if (!sign.equals(checkSign)) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7b7e\u540d\u6821\u9a8c\u9519\u8bef", null));
                            return;
                        }
                        if (receiver.getData() == null || receiver.getData().length == 0 || receiver.getDataLength() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u653e\u884c\u6570\u636e", null));
                            return;
                        }
                        try {
                            passSessionData = (PassSessionData)GsonBuilder.create().fromJson(new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength(), "UTF-8"), PassSessionData.class);
                        }
                        catch (Exception ex) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u653e\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef", null));
                            return;
                        }
                        entryHandler.setResult((Object)new KeyValueEntry((Object)"SUCCESS", (Object)passSessionData));
                    }
                    catch (Exception ex) {
                        entryHandler.setException((Throwable)ex);
                    }
                }

                public void onWaitTimeout() throws Exception {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u8d85\u65f6", null));
                }

                public long getWaitTimeoutMills() {
                    return 5000L;
                }
            });
        }
        catch (Throwable ex) {
            entryHandler.setException(ex);
        }
        return entryHandler;
    }

    public static void doDisplayPaySession(String remoteHostNo, InetSocketAddress lanRemoteAddress, Map<String, String> paramMap) {
        try {
            RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)lanRemoteAddress);
            RequestSender requestSender = connection.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "displayPaySession");
            requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            requestSender.setHeader("destHostNo", remoteHostNo);
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                requestSender.setHeader(entry.getKey(), entry.getValue());
            }
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.doRequest(null, null);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u64ad\u653e\u8bed\u97f3\u5931\u8d25\uff01" + ex.getMessage()));
        }
    }

    public static void doDisplayPassMessage(String remoteHostNo, InetSocketAddress lanRemoteAddress, Map<String, String> paramMap) {
        try {
            RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)lanRemoteAddress);
            RequestSender requestSender = connection.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "displayPassMessage");
            requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            requestSender.setHeader("destHostNo", remoteHostNo);
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                if (entry.getValue() == null) continue;
                requestSender.setHeader(entry.getKey(), entry.getValue());
            }
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.doRequest(null, null);
        }
        catch (Exception ex) {
            ServiceLog.getLog().warn((Object)("\u64ad\u653e\u8bed\u97f3\u5931\u8d25\uff01" + ex.getMessage()));
        }
    }

    public static OperationFuture<KeyValueEntry<String, PassSessionData>> doLanUpdateConfirmPassInfo(String remoteHostNo, InetSocketAddress lanRemoteAddress, Map<String, String> paramMap) {
        final OperationFutureHandler entryHandler = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)lanRemoteAddress);
            RequestSender requestSender = connection.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "lanUpdateConfirmPassInfo");
            requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            requestSender.setHeader("destHostNo", remoteHostNo);
            for (Map.Entry<String, String> entry : paramMap.entrySet()) {
                requestSender.setHeader(entry.getKey(), entry.getValue());
            }
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"\u53d1\u9001\u5f02\u5e38", null));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    try {
                        PassSessionData passSessionData;
                        String respCode = receiver.getHeaderValue("respCode");
                        if (respCode == null || respCode.length() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u7801", null));
                            return;
                        }
                        if (!"SUCCESS".equals(respCode)) {
                            String respMsg = receiver.getHeaderValue("respMsg");
                            if (respMsg == null || respMsg.length() == 0) {
                                respMsg = "\u9519\u8bef\u4ee3\u7801\uff1a" + respCode;
                            }
                            entryHandler.setResult((Object)new KeyValueEntry((Object)respMsg, null));
                            return;
                        }
                        String sign = receiver.getHeaderValue("sign");
                        if (sign == null || sign.length() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d", null));
                            return;
                        }
                        String checkSign = HMPNetDataSignTool.getSign((Receiver)receiver, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key());
                        if (!sign.equals(checkSign)) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7b7e\u540d\u6821\u9a8c\u9519\u8bef", null));
                            return;
                        }
                        if (receiver.getData() == null || receiver.getData().length == 0 || receiver.getDataLength() == 0) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u653e\u884c\u6570\u636e", null));
                            return;
                        }
                        try {
                            passSessionData = (PassSessionData)GsonBuilder.create().fromJson(new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength(), "UTF-8"), PassSessionData.class);
                        }
                        catch (Exception ex) {
                            entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u653e\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef", null));
                            return;
                        }
                        entryHandler.setResult((Object)new KeyValueEntry((Object)"SUCCESS", (Object)passSessionData));
                    }
                    catch (Exception ex) {
                        entryHandler.setException((Throwable)ex);
                    }
                }

                public void onWaitTimeout() throws Exception {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u8d85\u65f6", null));
                }

                public long getWaitTimeoutMills() {
                    return 5000L;
                }
            });
        }
        catch (Throwable ex) {
            entryHandler.setException(ex);
        }
        return entryHandler;
    }

    public static OperationFuture<KeyValueEntry<String, PassSessionData>> queryPassSessionData(String remoteHostNo, InetSocketAddress lanRemoteAddress, final String channelNo, final String regPlate, long localSessionId, Long cameraRegPlateMills) {
        final OperationFutureHandler entryHandler = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            RemoteConnection connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection((SocketAddress)lanRemoteAddress);
            RequestSender requestSender = connection.createRequest();
            requestSender.setRequestActionName(ACTION_NAME);
            requestSender.setHeader("op", "obtainChannelPassResult");
            requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getLocalHostNo());
            requestSender.setHeader("destHostNo", remoteHostNo);
            requestSender.setHeader("channelNo", channelNo);
            requestSender.setHeader("regPlate", regPlate);
            requestSender.setHeader("refSessionId", String.valueOf(localSessionId));
            if (cameraRegPlateMills != null) {
                requestSender.setHeader("cameraRegPlateMills", cameraRegPlateMills.toString());
            }
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"\u53d1\u9001\u5f02\u5e38", null));
                }

                public void onCompleted() {
                }
            }, new ReceiveCallback(){

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    block18: {
                        try {
                            String respCode = receiver.getHeaderValue("respCode");
                            if (respCode == null || respCode.length() == 0) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u7801", null));
                                return;
                            }
                            if (!"SUCCESS".equals(respCode)) {
                                String respMsg = receiver.getHeaderValue("respMsg");
                                if (respMsg == null || respMsg.length() == 0) {
                                    respMsg = "\u9519\u8bef\u4ee3\u7801\uff1a" + respCode;
                                }
                                entryHandler.setResult((Object)new KeyValueEntry((Object)respMsg, null));
                                return;
                            }
                            String sign = receiver.getHeaderValue("sign");
                            if (sign == null || sign.length() == 0) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d", null));
                                return;
                            }
                            String checkSign = HMPNetDataSignTool.getSign((Receiver)receiver, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key());
                            if (!sign.equals(checkSign)) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7b7e\u540d\u6821\u9a8c\u9519\u8bef", null));
                                return;
                            }
                            String _channelNo = receiver.getHeaderValue("channelNo");
                            if (_channelNo == null || _channelNo.length() == 0) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7f3a\u5c11\u901a\u9053\u7f16\u53f7", null));
                                return;
                            }
                            if (!_channelNo.equals(channelNo)) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7684\u901a\u9053\u7f16\u53f7\u4e0d\u4e00\u81f4", null));
                                return;
                            }
                            String _regPlate = receiver.getHeaderValue("regPlate");
                            if (_regPlate == null || _regPlate.length() == 0) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7f3a\u5c11\u8bc6\u522b\u8f66\u724c", null));
                                return;
                            }
                            if (!_regPlate.equals(regPlate)) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u7684\u8f66\u724c\u4e0d\u4e00\u81f4", null));
                                return;
                            }
                            String returnCode = receiver.getHeaderValue("returnCode");
                            if (returnCode == null) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u72b6\u6001\u7801", null));
                                return;
                            }
                            if ("0".equals(returnCode)) {
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"\u672a\u80fd\u68c0\u6d4b\u5230\u8f66\u724c", null));
                                break block18;
                            }
                            if ("1".equals(returnCode)) {
                                PassSessionData passSessionData;
                                if (receiver.getData() == null || receiver.getData().length == 0 || receiver.getDataLength() == 0) {
                                    entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u653e\u884c\u6570\u636e", null));
                                    return;
                                }
                                try {
                                    passSessionData = (PassSessionData)GsonBuilder.create().fromJson(new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength(), "UTF-8"), PassSessionData.class);
                                }
                                catch (Exception ex) {
                                    entryHandler.setResult((Object)new KeyValueEntry((Object)"\u7f3a\u5c11\u54cd\u5e94\u653e\u884c\u6570\u636e\u683c\u5f0f\u9519\u8bef", null));
                                    return;
                                }
                                entryHandler.setResult((Object)new KeyValueEntry((Object)"SUCCESS", (Object)passSessionData));
                                break block18;
                            }
                            if ("2".contentEquals(returnCode)) {
                                String returnMsg = receiver.getHeaderValue("returnMsg");
                                String rk = "discard:" + (returnMsg == null ? "\u5df2\u5904\u7406\uff0c\u4e22\u5f03\u8f66\u724c" : returnMsg);
                                entryHandler.setResult((Object)new KeyValueEntry((Object)rk, null));
                                break block18;
                            }
                            entryHandler.setResult((Object)new KeyValueEntry((Object)("\u672a\u77e5\u54cd\u5e94\u72b6\u6001\u7801\uff1a" + returnCode), null));
                            return;
                        }
                        catch (Exception ex) {
                            entryHandler.setException((Throwable)ex);
                        }
                    }
                }

                public void onWaitTimeout() throws Exception {
                    entryHandler.setResult((Object)new KeyValueEntry((Object)"\u54cd\u5e94\u8d85\u65f6", null));
                }

                public long getWaitTimeoutMills() {
                    return 6500L;
                }
            });
        }
        catch (Throwable ex) {
            entryHandler.setException(ex);
        }
        return entryHandler;
    }
}

