/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.conn.udp.net.LanAuthMethodServiceAction;
import com.wovoe.carpark.conn.udp.net.TransferRpcUtil;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.transfer.DataProtocol;
import com.wovoe.framework.transfer.IOResponse;
import com.wovoe.framework.transfer.ReceiveClassManager;
import com.wovoe.framework.transfer.ResultResponse;
import com.wovoe.framework.transfer.ResultResponseMap;
import com.wovoe.framework.transfer.ServiceAction;
import com.wovoe.framework.transfer.ServiceActionManager;
import com.wovoe.framework.transfer.ServiceRequest;
import com.wovoe.framework.transfer.connection.WaitResultTimeout;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class LanRemoteServiceInvokeAction
extends LanAuthMethodServiceAction {
    public static final String ACTION_NAME = "/CarparkLanRemoteServiceInvokeAction";
    private static final String RESPONSE_END_STR = ".response";

    public void invoke(Receiver request) throws Exception {
        block9: {
            Object data;
            String cmd = request.getHeaderValue("cmd");
            if (cmd == null || cmd.length() == 0) {
                TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u53c2\u6570" + cmd, this.getSignKey());
                return;
            }
            if (request.getDataLength() == 0 || request.getData() == null || request.getData().length == 0) {
                TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u7f3a\u5c11\u6570\u636e\u57df", this.getSignKey());
                return;
            }
            try {
                String jsonString = new String(request.getData(), request.getDataOffset(), request.getDataLength(), "UTF-8");
                Class<LinkedHashMap> dataType = ReceiveClassManager.getInstance().getDataClass(cmd);
                if (dataType == null) {
                    dataType = LinkedHashMap.class;
                }
                data = GsonBuilder.create().fromJson(jsonString, dataType);
            }
            catch (Throwable ex) {
                TransferRpcUtil.doSimpleResponse(request, "PARAM_ERROR", "\u4e0d\u662f\u6709\u6548\u7684JSON", this.getSignKey());
                return;
            }
            DataProtocol dataFrame = new DataProtocol();
            dataFrame.setCmd(cmd);
            dataFrame.setData(data);
            dataFrame.setTimeMills(String.valueOf(System.currentTimeMillis()));
            dataFrame.setNonce(request.getHeaderValue("rand"));
            dataFrame.setMsgId(String.valueOf(request.getRemoteSendId()));
            dataFrame.getContext().put("localAddress", request.getLocalAddress());
            dataFrame.getContext().put("remoteAddress", request.getRemoteAddress());
            dataFrame.getContext().put("remoteHostNo", request.getHeaderValue("srcHostNo"));
            RpcIOResponse re = new RpcIOResponse(request, this.getSignKey());
            try {
                ServiceAction action = ServiceActionManager.getInstance().getServiceAction(dataFrame.getCmd());
                if (action != null) {
                    action.execute((ServiceRequest)dataFrame, (IOResponse)re);
                } else {
                    ResultResponse res = new ResultResponse();
                    res.setResponseCode("404");
                    res.setResponseMsg("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u547d\u4ee4: " + dataFrame.getCmd() + ", \u6b64\u670d\u52a1\u4e0d\u6388\u652f\u6301\uff01");
                    re.doResponse(String.valueOf(dataFrame.getCmd()) + RESPONSE_END_STR, res);
                }
            }
            catch (Exception ex) {
                ServiceLog.getLog().warn((Object)"handle error!", (Throwable)ex);
                if (re.submit.get()) break block9;
                ResultResponse res = new ResultResponse();
                res.setResponseCode("500");
                res.setResponseMsg("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
                re.doResponse(String.valueOf(dataFrame.getCmd()) + RESPONSE_END_STR, res);
            }
        }
    }

    protected static class RpcIOResponse
    implements IOResponse {
        private Receiver request;
        private String signKey;
        private AtomicBoolean submit;

        private RpcIOResponse(Receiver request, String signKey) {
            this.request = request;
            this.signKey = signKey;
            this.submit = new AtomicBoolean(false);
        }

        private void doResponse0(String cmd, Object data) throws IOException {
            String jsonStr = GsonBuilder.create().toJson(data);
            byte[] aData = jsonStr.getBytes("UTF-8");
            ResponseSender response = TransferRpcUtil.createBasicResponse(this.request, "SUCCESS", "SUCCESS");
            response.setSendData(aData);
            response.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)response, (String)this.signKey));
            response.doResponse(null, null);
        }

        public void doResponse(final String cmd, Object data) throws IOException {
            try {
                if (this.submit.compareAndSet(false, true)) {
                    if (data instanceof OperationFuture) {
                        long waiMills = WaitResultTimeout.getAndRemove((long)15000L);
                        if (waiMills <= 0L) {
                            waiMills = 15000L;
                        }
                        OperationFuture opf = (OperationFuture)data;
                        opf.addCompleteListener(new OperationFuture.CompleteListener(){

                            public void operationComplete(OperationFuture future) {
                                if (future.isCancelled()) {
                                    this.doResponseX(new ResultResponseMap("501", "operation canceled"));
                                } else if (future.getException() != null) {
                                    LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result returns an exception"), future.getException());
                                    this.doResponseX(new ResultResponseMap("500", "Internal business processing exception"));
                                } else if (future.getResult() == null) {
                                    LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result returns NULL"));
                                    this.doResponseX(new ResultResponseMap("502", "Asynchronous processing business return null"));
                                } else {
                                    this.doResponseX(future.getResult());
                                }
                            }

                            public void waitCompleteTimeout() {
                                LogUtil.getLog().warn((Object)("Service: " + cmd + " Asynchronous processing result timeout"));
                                this.doResponseX(new ResultResponseMap("501", "Asynchronous processing business timeout"));
                            }

                            private void doResponseX(Object obj) {
                                try {
                                    this.doResponse0(cmd, obj);
                                }
                                catch (Throwable ex) {
                                    LogUtil.getLog().warn((Object)("Response: " + cmd + ", Excption!" + ex.getMessage()));
                                }
                            }
                        }, waiMills, TimeUnit.MILLISECONDS);
                    } else {
                        this.doResponse0(cmd, data);
                    }
                } else {
                    ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u5df2\u63d0\u4ea4\uff0c\u4e0d\u5e94\u8be5\u91cd\u590d\u63d0\u4ea4\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801");
                }
            }
            catch (Throwable ex) {
                ServiceLog.getLog().warn((Object)"\u54cd\u5e94\u9519\u8bef\uff01");
            }
        }
    }
}

