/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.GsonBuilder;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.ReceiveCallback;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.RemoteConnection;
import com.wovoe.framework.communication.protocol.RequestSender;
import com.wovoe.framework.communication.protocol.SendCallback;
import com.wovoe.framework.communication.protocol.TCPConnection;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import com.wovoe.framework.transfer.MessageResult;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.util.Set;
import java.util.concurrent.TimeoutException;

public class LanRpcRemoteServiceInvoker {
    private String destHostNo;
    private SocketAddress destSocketAddress;
    private long defaultWaitTimeoutMills;
    private static final String OP_INVOKE = "invoke";

    public LanRpcRemoteServiceInvoker(String destHostNo, SocketAddress destSocketAddress) {
        this(destHostNo, destSocketAddress, 10000L);
    }

    public SocketAddress getDestSocketAddress() {
        return this.destSocketAddress;
    }

    public LanRpcRemoteServiceInvoker(String destHostNo, SocketAddress destSocketAddress, long defaultWaitTimeoutMills) {
        this.destHostNo = destHostNo;
        this.destSocketAddress = destSocketAddress;
        this.defaultWaitTimeoutMills = defaultWaitTimeoutMills;
    }

    public <T extends MessageResult> OperationFuture<T> invoke(String serviceName, Object param, Class<T> resultType) {
        return this.invoke(serviceName, param, resultType, this.defaultWaitTimeoutMills);
    }

    public <T extends MessageResult> OperationFuture<T> invoke(String serviceName, Object param, Class<T> resultType, long timeoutMills) {
        return this.invoke(serviceName, param, resultType, timeoutMills, null);
    }

    public <T extends MessageResult> OperationFuture<T> invoke(final String serviceName, Object param, final Class<T> resultType, long timeoutMills, final Runnable sendCompletedCallback) {
        RemoteConnection connection;
        Set<String> localIpSet;
        final OperationFutureHandler operationFuture = ServiceUtil.getServiceContext().createOperationFuture();
        if (this.destHostNo == null || this.destHostNo.length() == 0) {
            operationFuture.setException((Throwable)new NullPointerException("\u76ee\u6807\u4e3b\u673a\u4e3aNULL\u6216\u8005\u7a7a"));
            return operationFuture;
        }
        if (this.destSocketAddress == null) {
            operationFuture.setException((Throwable)new NullPointerException("\u76ee\u6807\u5730\u5740\u4e3aNULL"));
            return operationFuture;
        }
        if (serviceName == null || serviceName.length() == 0) {
            operationFuture.setException((Throwable)new NullPointerException("\u8fdc\u7a0b\u670d\u52a1\u540d\u79f0\u4e3aNULL\u6216\u8005\u7a7a"));
            return operationFuture;
        }
        if (param == null) {
            operationFuture.setException((Throwable)new NullPointerException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a"));
            return operationFuture;
        }
        if (resultType == null) {
            operationFuture.setException((Throwable)new NullPointerException("\u8fd4\u56de\u7c7b\u578b\u53c2\u6570\u4e3a\u7a7a"));
            return operationFuture;
        }
        if (timeoutMills < 3000L) {
            timeoutMills = 3000L;
        }
        if ((localIpSet = ServiceUtil.getServiceContext().getLocalIpv4(true)) == null || localIpSet.isEmpty()) {
            operationFuture.setException((Throwable)new ConnectException("\u7f51\u7edc\u5df2\u65ad\u5f00"));
            return operationFuture;
        }
        try {
            connection = ServiceUtil.getServiceContext().getLanUdpConnectionFactory().createConnection(this.destSocketAddress);
        }
        catch (Exception ex) {
            operationFuture.setException((Throwable)ex);
            return operationFuture;
        }
        if (connection instanceof TCPConnection) {
            operationFuture.addCompleteListener(new OperationFuture.CompleteListener<T>(){

                public void operationComplete(OperationFuture<T> futrue) {
                    this.waitCompleteTimeout();
                }

                public void waitCompleteTimeout() {
                    try {
                        ((TCPConnection)connection).close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        try {
            final long xtime = timeoutMills;
            RequestSender requestSender = connection.createRequest();
            String json = GsonBuilder.create().toJson(param);
            byte[] data = json.getBytes("UTF-8");
            requestSender.setRequestActionName("/CarparkLanRemoteServiceInvokeAction");
            requestSender.setHeader("op", OP_INVOKE);
            requestSender.setHeader("srcHostNo", ServiceUtil.getServiceContext().getCarparkLocalConfig().getHost_no());
            requestSender.setHeader("destHostNo", this.destHostNo);
            requestSender.setHeader("rand", RandomStringGenerator.getDefaultInstance().getNewString(16));
            requestSender.setHeader("cmd", serviceName);
            requestSender.setSendData(data);
            requestSender.setHeader("sign", HMPNetDataSignTool.getSign((Receiver)requestSender, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key()));
            requestSender.doRequest(new SendCallback(){

                public void onException(Throwable exception) {
                    try {
                        ServiceLog.getLog().warn((Object)("\u8bf7\u6c42" + serviceName + "\u7f51\u7edc\u5f02\u5e38\uff01\u539f\u56e0: " + exception.getMessage()));
                    }
                    finally {
                        CloudResultResponse result;
                        try {
                            result = resultType.isInterface() ? new CloudResultResponse() : (MessageResult)resultType.newInstance();
                        }
                        catch (Exception ex) {
                            result = null;
                        }
                        if (result == null) {
                            operationFuture.setException(exception);
                        } else {
                            result.setResponseCode("601");
                            result.setResponseMsg("\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u6c42\u5931\u8d25");
                            operationFuture.setResult((Object)result);
                        }
                    }
                }

                public void onCompleted() {
                    if (sendCompletedCallback != null) {
                        try {
                            sendCompletedCallback.run();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }, new ReceiveCallback(){

                private T createResult() throws Exception {
                    CloudResultResponse result = resultType.isInterface() ? new CloudResultResponse() : (MessageResult)resultType.newInstance();
                    return result;
                }

                public void doReceiver(Receiver receiver, int sendId) throws Exception {
                    try {
                        MessageResult result;
                        String resposeCode = receiver.getHeaderValue("respCode");
                        if (resposeCode == null || resposeCode.length() == 0) {
                            Object result2 = this.createResult();
                            result2.setResponseCode("600");
                            result2.setResponseMsg("\u7f3a\u5c11\u54cd\u5e94code");
                            operationFuture.setResult(result2);
                            return;
                        }
                        if (!"SUCCESS".equals(resposeCode)) {
                            String resposeMsg = receiver.getHeaderValue("respMsg");
                            if (resposeMsg == null || resposeMsg.length() == 0) {
                                resposeMsg = "\u64cd\u4f5c\u5931\u8d25";
                            }
                            Object result3 = this.createResult();
                            result3.setResponseCode("600");
                            result3.setResponseMsg(String.valueOf(resposeMsg) + ",\u9519\u8bef\u4ee3\u7801:" + resposeCode);
                            operationFuture.setResult(result3);
                            return;
                        }
                        String sign = receiver.getHeaderValue("sign");
                        if (sign == null || sign.length() == 0) {
                            Object result4 = this.createResult();
                            result4.setResponseCode("600");
                            result4.setResponseMsg("\u54cd\u5e94\u7f3a\u5c11\u7b7e\u540d");
                            operationFuture.setResult(result4);
                            return;
                        }
                        String checkSign = HMPNetDataSignTool.getSign((Receiver)receiver, (String)ServiceUtil.getServiceContext().getCarpark().getLan_sign_key());
                        if (!sign.equals(checkSign)) {
                            Object result5 = this.createResult();
                            result5.setResponseCode("600");
                            result5.setResponseMsg("\u54cd\u5e94\u7b7e\u540d\u9519\u8bef");
                            operationFuture.setResult(result5);
                            return;
                        }
                        byte[] data = receiver.getData();
                        if (data == null || data.length == 0 || receiver.getDataLength() == 0) {
                            Object result6 = this.createResult();
                            result6.setResponseCode("600");
                            result6.setResponseMsg("\u54cd\u5e94\u7f3a\u5c11\u6570\u636e");
                            operationFuture.setResult(result6);
                            return;
                        }
                        try {
                            String json = new String(receiver.getData(), receiver.getDataOffset(), receiver.getDataLength(), "UTF-8");
                            Class type = resultType.isInterface() ? CloudResultResponse.class : resultType;
                            result = (MessageResult)GsonBuilder.create().fromJson(json, type);
                            if (result.getResponseCode() == null || result.getResponseCode().length() == 0) {
                                result.setResponseCode("600");
                                result.setResponseMsg("\u7f3a\u5c11\u4e1a\u52a1\u5904\u7406\u54cd\u5e94\u7801");
                            } else if (!(result.isSuccess() || result.getResponseMsg() != null && result.getResponseMsg().length() != 0)) {
                                result.setResponseMsg("\u64cd\u4f5c\u5931\u8d25");
                            }
                        }
                        catch (Exception ex) {
                            Object result7 = this.createResult();
                            result7.setResponseCode("600");
                            result7.setResponseMsg("\u54cd\u5e94\u6570\u636e\u4e0d\u662f\u6709\u6548\u7684Json");
                            return;
                        }
                        operationFuture.setResult((Object)result);
                    }
                    catch (Exception ex) {
                        operationFuture.setException((Throwable)ex);
                    }
                }

                public void onWaitTimeout() throws Exception {
                    Object result;
                    try {
                        result = this.createResult();
                    }
                    catch (Exception ex) {
                        result = null;
                    }
                    if (result == null) {
                        operationFuture.setException((Throwable)new TimeoutException("\u7b49\u5f85\u4e3b\u673a:" + LanRpcRemoteServiceInvoker.this.destSocketAddress + "\u54cd\u5e94\u8d85\u65f6!"));
                    } else {
                        result.setResponseCode("602");
                        result.setResponseMsg("\u54cd\u5e94\u8d85\u65f6");
                        operationFuture.setResult(result);
                    }
                }

                public long getWaitTimeoutMills() {
                    return xtime;
                }
            });
        }
        catch (Throwable ex) {
            operationFuture.setException(ex);
        }
        return operationFuture;
    }
}

