/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.cloud.CloudResultResponse;
import com.wovoe.carpark.conn.udp.net.LanRpcRemoteServiceInvoker;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.rpc.RPCRemoteException;
import com.wovoe.framework.transfer.MessageResult;
import com.wovoe.framework.transfer.connection.TimeoutSetter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LanRpcRemoteServiceInvokerProxy
implements InvocationHandler {
    private static final String EQUALS_METHOD = "equals";
    private static final String HASHCODE_METHOD = "hashCode";
    private static final String TOSTRING_METHOD = "toString";
    private String serviceName;
    private String destHostNo;
    private SocketAddress destSocketAddress;
    private long timeoutMills;

    private LanRpcRemoteServiceInvokerProxy(String serviceName, String destHostNo, SocketAddress destSocketAddress, long timeoutMills) {
        this.destSocketAddress = destSocketAddress;
        this.destHostNo = destHostNo;
        this.serviceName = serviceName;
        this.timeoutMills = timeoutMills <= 0L ? 10000L : timeoutMills;
    }

    public static <T> T newProxy(Class<T> iface, String serviceName, String destHostNo, SocketAddress destSocketAddress, long timeoutMills) {
        LanRpcRemoteServiceInvokerProxy p = new LanRpcRemoteServiceInvokerProxy(serviceName, destHostNo, destSocketAddress, timeoutMills);
        return (T)Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, (InvocationHandler)p);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String mehtodName = method.getName();
        if (EQUALS_METHOD.equals(mehtodName) && args != null && args.length == 1) {
            if (proxy == args[0]) {
                return true;
            }
            return false;
        }
        if (HASHCODE_METHOD.equals(mehtodName) && (args == null || args.length == 0)) {
            return this.hashCode();
        }
        if (TOSTRING_METHOD.equals(mehtodName) && (args == null || args.length == 0)) {
            return this.toString();
        }
        Object returnValue = null;
        try {
            MessageResult result;
            Class cl;
            long readTimeMills = TimeoutSetter.getReadTimeoutMills();
            Class<?>[] cls = method.getParameterTypes();
            if (cls == null || cls.length == 0) {
                throw new UnsupportedOperationException("method: " + mehtodName + " not supported yet!");
            }
            String cmd = String.valueOf(this.serviceName) + "." + mehtodName;
            Class<?> returnCls = method.getReturnType();
            boolean isVoid = Void.class.equals(returnCls);
            boolean isBoolean = !isVoid ? Boolean.TYPE.equals(returnCls) || Boolean.class.equals(returnCls) : false;
            if (isVoid || isBoolean) {
                cl = CloudResultResponse.class;
            } else if (MessageResult.class.isAssignableFrom(returnCls)) {
                if (MessageResult.class.equals(returnCls)) {
                    cl = CloudResultResponse.class;
                } else {
                    if (returnCls.isInterface()) {
                        throw new IllegalArgumentException("\u8fd4\u56de\u7c7b\u578b\u5982\u679c\u4f7f\u7528MessageResult\u63a5\u53e3\u53ea\u80fd\u662f\uff1a" + MessageResult.class.getName() + ", \u4e0d\u80fd\u4e3a\u5b50\u63a5\u53e3\u6216\u62bd\u8c61\u7c7b, \u4f46\u662f\u4e3a: " + returnCls.getName());
                    }
                    cl = returnCls;
                }
            } else if (Map.class.isAssignableFrom(returnCls)) {
                if (returnCls.isInterface() && !Map.class.equals(returnCls)) {
                    throw new IllegalArgumentException("\u8fd4\u56de\u7c7b\u578b\u5982\u679c\u4f7f\u7528Map\u63a5\u53e3\u53ea\u80fd\u662f\uff1a" + Map.class.getName() + ", \u4f46\u662f\u4e3a: " + returnCls.getName());
                }
                cl = CloudResultResponse.class;
            } else {
                throw new IllegalArgumentException(String.valueOf(returnCls.getName()) + " \u4e0d\u662fMap\u6216\u5176\u5b9e\u73b0\u7c7b,\u4e5f\u4e0d\u662fMessageResult\u63a5\u53e3\u6216\u5176\u5b9e\u73b0\u7c7b, \u4e5f\u4e0d\u662fboolean, \u4e5f\u4e0d\u662fvoid");
            }
            Object beanValue = args[0];
            if (beanValue == null) {
                throw new NullPointerException("request parameter is null!");
            }
            if (readTimeMills <= 0L) {
                readTimeMills = this.timeoutMills;
            }
            LanRpcRemoteServiceInvoker invoker = new LanRpcRemoteServiceInvoker(this.destHostNo, this.destSocketAddress, readTimeMills);
            OperationFuture<CloudResultResponse> fh = invoker.invoke(cmd, beanValue, cl);
            try {
                result = (MessageResult)fh.get(readTimeMills + 1000L, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                if (fh.isDone() && fh.getException() != null) {
                    if (fh.getException() instanceof RPCRemoteException) {
                        throw (RPCRemoteException)fh.getException();
                    }
                    throw new RPCRemoteException("invoke error! " + fh.getException().getMessage(), fh.getException());
                }
                throw new RPCRemoteException("invoke error!", (Throwable)ex);
            }
            if (result == null) {
                throw new RPCRemoteException("invoke error! response timeout!");
            }
            if (!result.isSuccess()) {
                throw new RPCRemoteException("error response! errcode:" + result.getResponseCode() + ", cause:" + result.getResponseMsg());
            }
            if (isBoolean) {
                returnValue = true;
            } else if (!isVoid) {
                if (MessageResult.class.isAssignableFrom(returnCls)) {
                    returnValue = result;
                } else if (returnCls.isInterface()) {
                    returnValue = result;
                } else {
                    Map map = (Map)returnCls.newInstance();
                    map.putAll((CloudResultResponse)result);
                    returnValue = map;
                }
            }
        }
        finally {
            TimeoutSetter.clear();
        }
        return returnValue;
    }
}

