/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.carpark.RpcReomtecServiceFactory;
import com.wovoe.carpark.conn.udp.net.LanRpcRemoteServiceInvokerProxy;
import java.net.SocketAddress;

public class LanRpcReomtecServiceFactory
implements RpcReomtecServiceFactory {
    private String destHostNo;
    private SocketAddress destSocketAddress;
    private int connectTimeoutMills;
    private int readTimeoutMills;

    public LanRpcReomtecServiceFactory(String destHostNo, SocketAddress destSocketAddress, int timeoutMills) {
        this.destHostNo = destHostNo;
        this.destSocketAddress = destSocketAddress;
        this.connectTimeoutMills = timeoutMills;
        this.readTimeoutMills = timeoutMills;
    }

    @Override
    public <T> T crateRemoteService(Class<T> remoteServiceClass) {
        String className = remoteServiceClass.getSimpleName();
        String remoteSerivceName = String.valueOf(className.substring(0, 1).toLowerCase()) + className.substring(1);
        return this.crateRemoteService(remoteServiceClass, remoteSerivceName);
    }

    @Override
    public <T> T crateRemoteService(Class<T> remoteServiceClass, String remoteSerivceName) {
        T t = LanRpcRemoteServiceInvokerProxy.newProxy(remoteServiceClass, remoteSerivceName, this.destHostNo, this.destSocketAddress, this.getReadTimeoutMills());
        return t;
    }

    @Override
    public int getConnectTimeoutMills() {
        return this.connectTimeoutMills;
    }

    @Override
    public void setConnectTimeoutMills(int connectTimeoutMills) {
        this.connectTimeoutMills = connectTimeoutMills;
    }

    @Override
    public int getReadTimeoutMills() {
        return this.readTimeoutMills;
    }

    @Override
    public void setReadTimeoutMills(int readTimeoutMills) {
        this.readTimeoutMills = readTimeoutMills;
    }
}

