/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.conn.udp.net;

import com.wovoe.framework.LogUtil;
import com.wovoe.framework.RandomStringGenerator;
import com.wovoe.framework.communication.protocol.Receiver;
import com.wovoe.framework.communication.protocol.ResponseSender;
import com.wovoe.framework.communication.protocol.hmp.HMPNetDataSignTool;
import java.io.IOException;

public class TransferRpcUtil {
    public static final String HEAD_NAME_SIGN = "sign";
    public static final String HEAD_NAME_OPTION = "op";
    public static final String HEAD_NAME_SRC_HOST_NO = "srcHostNo";
    public static final String HEAD_NAME_DEST_HOST_NO = "destHostNo";
    public static final String HEAD_NAME_RESPCODE = "respCode";
    public static final String HEAD_NAME_RESPMSG = "respMsg";
    public static final String HEAD_NAME_RAND = "rand";
    public static final String HEAD_NAME_TIMEMILLS = "tmills";
    public static final String HEAD_NAME_CMD = "cmd";
    public static final String RESP_CODE_SUCCESS = "SUCCESS";
    public static final String RESP_CODE_PARAM_ERROR = "PARAM_ERROR";
    public static final String RESP_CODE_SIGN_ERROR = "SIGN_ERROR";
    public static final String RESP_CODE_PERMISSION_ERROR = "PERMISSION_ERROR";
    public static final String RESP_CODE_ROUTE_ERROR = "ROUTE_ERROR";
    public static final String RESP_CODE_SYS_ERROR = "SYS_ERROR";
    public static final String RESP_CODE_REQUEST_ERROR = "REQUEST_ERROR";
    public static final String RESP_CODE_FILE_NOT_FOUND = "FILE_NOT_FOUND";
    public static final String RESP_CODE_SERVICE_ERROR = "RESP_CODE_SERVICE_ERROR";
    public static final String RESP_CODE_NOT_FULLY_STATRED = "RESP_CODE_NOT_FULLY_STATRED";
    public static final String RESP_CODE_NOT_RESTORING_SETTINGS = "RESP_CODE_NOT_RESTORING_SETTINGS";
    public static final String RESP_CODE_METHOD_NOTFOUND = "RESP_CODE_METHOD_NOTFOUND";
    public static final String CTX_REQ_LOCAL_ADDRESS = "localAddress";
    public static final String CTX_REQ_REMOTE_ADDRESS = "remoteAddress";
    public static final String CTX_REQ_REMOTE_HOST_NO = "remoteHostNo";

    public static ResponseSender createBasicResponse(Receiver receiver, String respCode, String respMsg) throws IOException {
        ResponseSender response = receiver.createResponse();
        response.setHeader(HEAD_NAME_RESPCODE, respCode);
        response.setHeader(HEAD_NAME_RESPMSG, respMsg);
        response.setHeader(HEAD_NAME_RAND, RandomStringGenerator.getDefaultInstance().getNewString(16));
        response.setHeader(HEAD_NAME_TIMEMILLS, String.valueOf(System.currentTimeMillis()));
        return response;
    }

    public static void doSimpleResponse(Receiver receiver, String respCode, String respMsg, String signKey) {
        try {
            ResponseSender sender = TransferRpcUtil.createBasicResponse(receiver, respCode, respMsg);
            if (signKey != null && signKey.length() > 0) {
                String sign = HMPNetDataSignTool.getSign((Receiver)sender, (String)signKey);
                sender.setHeader(HEAD_NAME_SIGN, sign);
            }
            sender.doResponse(null, null);
        }
        catch (Exception ex) {
            LogUtil.getLog().warn((Object)("\u54cd\u5e94\u5f02\u5e38:" + ex.getMessage()));
        }
    }
}

