/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentAction;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractEquipmentAction
implements EquipmentAction {
    private static Map<Class<?>, Map<String, Method>> classMethodsMap = new ConcurrentHashMap();
    protected Equipment equipment;
    protected EquipmentDriver driver;

    @Override
    public Equipment getEquipment() {
        return this.equipment;
    }

    @Override
    public EquipmentDriver getDriver() {
        return this.driver;
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
    }

    public void setDriver(EquipmentDriver driver) {
        this.driver = driver;
    }

    @Override
    public <R> OperationFuture<R> doAction(String actionName, Map<?, ?> paramMap) {
        try {
            Map<String, Method> methodMap = this.getActionMethodMap();
            Method method = methodMap.get(actionName);
            if (method == null) {
                throw new UnsupportedOperationException("action:" + actionName + " not supported yet!");
            }
            return (OperationFuture)method.invoke((Object)this, paramMap);
        }
        catch (Throwable ex) {
            OperationFutureHandler op = ServiceUtil.getServiceContext().createOperationFuture();
            op.setException(ex);
            return op;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Method> loadMethod0(Class<?> cl) {
        Class<?> clazz = cl;
        synchronized (clazz) {
            Map<String, Method> mp = classMethodsMap.get(cl);
            if (mp == null) {
                mp = new HashMap<String, Method>();
                Method[] methods = cl.getMethods();
                if (methods != null && methods.length > 0) {
                    Method[] methodArray = methods;
                    int n = methods.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Method m = methodArray[n2];
                        Class<?>[] cla = m.getParameterTypes();
                        Class<?> returnType = m.getReturnType();
                        if (cla != null && returnType != null && cla.length == 1 && OperationFuture.class.equals(returnType) && Map.class.equals(cla[0])) {
                            mp.put(m.getName(), m);
                        }
                        ++n2;
                    }
                }
                classMethodsMap.put(cl, Collections.unmodifiableMap(mp));
            }
            return mp;
        }
    }

    protected Map<String, Method> getActionMethodMap() {
        Class<?> cl = this.getClass();
        Map<String, Method> methodMap = classMethodsMap.get(cl);
        if (methodMap == null) {
            methodMap = AbstractEquipmentAction.loadMethod0(cl);
        }
        return methodMap;
    }

    @Override
    public boolean isSupportAction(String anctionName) {
        return this.getActionMethodMap().containsKey(anctionName);
    }

    @Override
    public Collection<String> getSupportActionNames() {
        return this.getActionMethodMap().keySet();
    }

    @Override
    public <T extends EquipmentAction> T getParentEquipmentAction() {
        Equipment p;
        String pid = this.equipment.getParentEquipmentNo();
        if (pid != null && pid.length() > 0 && (p = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentNo(pid)) != null) {
            return p.getEquipmentAction();
        }
        return null;
    }
}

