/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment;

import com.wovoe.carpark.equipment.DefaultEquipment;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentAction;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentDefinition;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.EquipmentSearcher;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class AbstractEquipmentDriver
implements EquipmentDriver,
EquipmentDefinition {
    protected String name;
    protected String alias;
    protected String supplier;
    protected String version;
    protected String description;
    protected int equipmentType;
    protected int driverType = 0;
    protected String[] parentDriverNames;
    protected boolean pcEquipment;
    protected boolean channelEquipment;
    protected int defaultUse = 1;
    private List<KeyValueEntry<String, String>> supportModelsList;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        if (alias != null && alias.length() > 0) {
            this.alias = alias;
        }
    }

    @Override
    public String getSupplier() {
        return this.supplier;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void startEquipment(Equipment equipment, Map<String, String> config) {
        this.doStartEquipment(equipment, config);
        ServiceUtil.getServiceContext().getEquipmentManager().registerEquipment(equipment);
    }

    @Override
    public void stopEquipment(Equipment equipment) {
        this.doStopEquipment(equipment);
        ServiceUtil.getServiceContext().getEquipmentManager().unRegisterEquipment(equipment);
    }

    @Override
    public EquipmentConfig createEquipmentConfig(Map<String, String> config) {
        List<EquipmentParameter> list;
        EquipmentDefinition d = this.getEquipmentDefinition();
        HashMap<String, String> defaultParamMap = null;
        if (d != null && (list = d.getParameterDefinition()) != null && !list.isEmpty()) {
            defaultParamMap = new HashMap<String, String>();
            for (EquipmentParameter p : list) {
                defaultParamMap.put(p.getParameterName(), p.getParameterDefaultValue());
            }
        }
        return new DefaultEquipmentConfig(config, defaultParamMap);
    }

    protected abstract void doStartEquipment(Equipment var1, Map<String, String> var2);

    protected abstract void doStopEquipment(Equipment var1);

    @Override
    public Equipment createEquipment(String equipmentNo) {
        DefaultEquipment df = new DefaultEquipment();
        df.setEquipmentNo(equipmentNo);
        df.setEquipmentDriver(this);
        df.setType(this.getEquipmentType());
        return df;
    }

    @Override
    public int getUseInputType() {
        return 0;
    }

    protected void setAction(Equipment e, EquipmentAction action) {
        ((DefaultEquipment)e).setEquipmentAction(action);
    }

    @Override
    public EquipmentDefinition getEquipmentDefinition() {
        return this;
    }

    @Override
    public List<EquipmentParameter> getParameterDefinition() {
        LinkedList<EquipmentParameter> list = new LinkedList<EquipmentParameter>();
        this.addParameterDefinitionList(list);
        return list;
    }

    @Override
    public List<KeyValueEntry<String, String>> getSupportModels() {
        if (this.supportModelsList == null) {
            LinkedList<KeyValueEntry<String, String>> list = new LinkedList<KeyValueEntry<String, String>>();
            this.addSupportModelsList(list);
            this.supportModelsList = list;
        }
        return this.supportModelsList;
    }

    @Override
    public int getEquipmentType() {
        return this.equipmentType;
    }

    @Override
    public int getDriverType() {
        return this.driverType;
    }

    @Override
    public String[] getParentDriverNames() {
        return this.parentDriverNames;
    }

    @Override
    public boolean isChannelEquipment() {
        return this.channelEquipment;
    }

    @Override
    public boolean isPcEquipment() {
        return this.pcEquipment;
    }

    protected abstract void addParameterDefinitionList(List<EquipmentParameter> var1);

    protected void addSupportModelsList(List<KeyValueEntry<String, String>> list) {
    }

    @Override
    public int getDefaultUse() {
        return this.defaultUse;
    }

    @Override
    public boolean isSupportMultiChannel() {
        return true;
    }

    @Override
    public Map<Integer, String> getUseMap() {
        return null;
    }

    @Override
    public boolean isSupportParentDriveName(String driveName) {
        if (driveName == null || driveName.length() == 0) {
            return false;
        }
        String[] sa = this.getParentDriverNames();
        if (sa == null || sa.length == 0) {
            return false;
        }
        String[] stringArray = sa;
        int n = sa.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            if (driveName.equals(a)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected String getAlisTypeName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (ServiceUtil.getServiceContext() != null && ServiceUtil.getServiceContext().getConfig() != null) {
            return ServiceUtil.getServiceContext().getConfig().getProperty(String.valueOf(name) + ".alias", name);
        }
        return name;
    }

    @Override
    public EquipmentSearcher getEquipmentSearcher() {
        return null;
    }

    private static class DefaultEquipmentConfig
    implements EquipmentConfig {
        private Map<String, String> config0;
        private Map<String, String> defaultParamMap0;

        private DefaultEquipmentConfig(Map<String, String> config, Map<String, String> defaultParamMap) {
            if (config != null && !config.isEmpty()) {
                this.config0 = new LinkedHashMap<String, String>(config);
            }
            this.defaultParamMap0 = defaultParamMap;
        }

        @Override
        public String getConfigValue(String configKey) {
            if (configKey == null) {
                return null;
            }
            String v = null;
            if (this.config0 != null) {
                v = this.config0.get(configKey);
            }
            if ((v == null || v.length() == 0) && this.defaultParamMap0 != null) {
                v = this.defaultParamMap0.get(configKey);
            }
            return v;
        }

        @Override
        public Enumeration<String> getConfigKeys() {
            if (this.defaultParamMap0 != null) {
                return Collections.enumeration(this.defaultParamMap0.keySet());
            }
            return Collections.enumeration(new ArrayList(0));
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("config=");
            builder.append(this.config0);
            return builder.toString();
        }

        @Override
        public Integer getConfigIntValue(String configKey) {
            String v;
            if (configKey == null) {
                return null;
            }
            Integer r = null;
            if (this.config0 != null && (v = this.config0.get(configKey)) != null && v.length() > 0) {
                try {
                    r = Integer.valueOf(v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (r == null && this.defaultParamMap0 != null && (v = this.defaultParamMap0.get(configKey)) != null && v.length() > 0) {
                try {
                    r = Integer.valueOf(v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return r;
        }

        @Override
        public Long getConfigLongValue(String configKey) {
            String v;
            if (configKey == null) {
                return null;
            }
            Long r = null;
            if (this.config0 != null && (v = this.config0.get(configKey)) != null && v.length() > 0) {
                try {
                    r = Long.valueOf(v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (r == null && this.defaultParamMap0 != null && (v = this.defaultParamMap0.get(configKey)) != null && v.length() > 0) {
                try {
                    r = Long.valueOf(v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return r;
        }
    }
}

