/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment;

import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentDriverManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CarparkEquipmentDriverManager
implements EquipmentDriverManager {
    private ConcurrentHashMap<String, EquipmentDriver> managerMap = new ConcurrentHashMap();

    @Override
    public List<EquipmentDriver> getDriversByEquipmentType(int equipmentType) {
        LinkedList<EquipmentDriver> list = new LinkedList<EquipmentDriver>();
        for (EquipmentDriver dirver : this.managerMap.values()) {
            if (dirver.getEquipmentType() != equipmentType) continue;
            list.add(dirver);
        }
        return list;
    }

    @Override
    public EquipmentDriver getByDrivrName(String driverName) {
        if (driverName != null) {
            return this.managerMap.get(driverName);
        }
        return null;
    }

    @Override
    public void registerDriver(EquipmentDriver driver) {
        if (driver != null && driver.getName() != null) {
            this.managerMap.putIfAbsent(driver.getName(), driver);
        }
    }

    @Override
    public void unRegisterDriver(EquipmentDriver driver) {
        if (driver != null && driver.getName() != null) {
            this.managerMap.remove(driver.getName());
        }
    }

    @Override
    public Enumeration<EquipmentDriver> getAllDrivers() {
        return Collections.enumeration(this.managerMap.values());
    }

    @Override
    public Map<Integer, String> getAllSurportEquipmentTypeMap() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (EquipmentDriver d : this.managerMap.values()) {
            Integer eqType = d.getEquipmentType();
            String nameV = eqType != null && eqType == 33 ? "\u76f8\u673a(\u8f66\u724c\u8bc6\u522b/\u73af\u5883\u76d1\u63a7)" : (d.getEquipmentDefinition() != null && d.getEquipmentDefinition().getEquipmentTypeName() != null ? d.getEquipmentDefinition().getEquipmentTypeName() : "");
            String oldv = (String)map.get(eqType);
            if (oldv == null) {
                map.put(eqType, nameV);
                continue;
            }
            if (nameV.length() <= 0 || nameV.equals(oldv)) continue;
            map.put(eqType, nameV);
        }
        return map;
    }

    @Override
    public List<EquipmentDriver> getByDrivrNames(String[] driverNames) {
        if (driverNames == null || driverNames.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<EquipmentDriver> linkedList = new ArrayList<EquipmentDriver>(driverNames.length);
        String[] stringArray = driverNames;
        int n = driverNames.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            EquipmentDriver d = this.getByDrivrName(s);
            if (d != null) {
                linkedList.add(d);
            }
            ++n2;
        }
        return linkedList;
    }
}

