/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentManager;
import com.wovoe.framework.KeyValueEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CarparkEquipmentManager
implements EquipmentManager {
    private Map<Integer, Collection<Equipment>> typeMap = new ConcurrentHashMap<Integer, Collection<Equipment>>();
    private Map<String, Equipment> idsMap = new ConcurrentHashMap<String, Equipment>();

    @Override
    public Equipment getByEquipmentNo(String eqNo) {
        if (eqNo == null) {
            return null;
        }
        return this.idsMap.get(eqNo);
    }

    @Override
    public Collection<Equipment> getByEquipmentType(int equipmentType) {
        Collection<Equipment> list = this.typeMap.get(equipmentType);
        if (list != null) {
            return Collections.unmodifiableCollection(list);
        }
        return null;
    }

    @Override
    public List<Equipment> getByEquipmentsTypes(int ... equipmentTypes) {
        LinkedList<Equipment> list = null;
        if (equipmentTypes != null && equipmentTypes.length > 0) {
            int[] nArray = equipmentTypes;
            int n = equipmentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray[n2];
                Collection<Equipment> l = this.typeMap.get(type);
                if (l != null && !l.isEmpty()) {
                    if (list == null) {
                        list = new LinkedList<Equipment>();
                    }
                    list.addAll(l);
                }
                ++n2;
            }
        }
        return list == null ? Collections.emptyList() : list;
    }

    @Override
    public List<Equipment> getEquipmentsByActionClass(Class<?> actionClass) {
        if (actionClass == null) {
            return Collections.emptyList();
        }
        LinkedList<Equipment> list = null;
        for (Equipment eq : this.idsMap.values()) {
            if (eq.getEquipmentAction() == null || !actionClass.isAssignableFrom(eq.getEquipmentAction().getClass())) continue;
            if (list == null) {
                list = new LinkedList<Equipment>();
            }
            list.add(eq);
        }
        return list == null ? Collections.emptyList() : list;
    }

    @Override
    public List<Equipment> getEquipmentsByActionClasses(Class<?> ... actionClasses) {
        LinkedList<Equipment> list = null;
        if (actionClasses != null && actionClasses.length > 0) {
            block0: for (Equipment eq : this.idsMap.values()) {
                if (eq.getEquipmentAction() == null) continue;
                Class<?>[] classArray = actionClasses;
                int n = actionClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> actionClass = classArray[n2];
                    if (actionClass != null && actionClass.isAssignableFrom(eq.getEquipmentAction().getClass())) {
                        if (list == null) {
                            list = new LinkedList<Equipment>();
                        }
                        list.add(eq);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return list == null ? Collections.emptyList() : list;
    }

    @Override
    public List<Equipment> getEquipmentsByActionClasses(String channelNo, Class<?> ... actionClasses) {
        LinkedList<Equipment> list = null;
        if (actionClasses != null && actionClasses.length > 0 && channelNo != null && channelNo.length() > 0) {
            block0: for (Equipment eq : this.idsMap.values()) {
                if (eq.getEquipmentAction() == null) continue;
                Class<?>[] classArray = actionClasses;
                int n = actionClasses.length;
                int n2 = 0;
                while (n2 < n) {
                    List<String> chs;
                    Class<?> actionClass = classArray[n2];
                    if (actionClass != null && actionClass.isAssignableFrom(eq.getEquipmentAction().getClass()) && (chs = eq.getChannelNos()) != null && chs.contains(channelNo)) {
                        if (list == null) {
                            list = new LinkedList<Equipment>();
                        }
                        list.add(eq);
                        continue block0;
                    }
                    ++n2;
                }
            }
        }
        return list == null ? Collections.emptyList() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEquipment(Equipment equipment) {
        if (equipment != null) {
            CarparkEquipmentManager carparkEquipmentManager = this;
            synchronized (carparkEquipmentManager) {
                if (this.idsMap.get(equipment.getEquipmentNo()) == null) {
                    this.idsMap.put(equipment.getEquipmentNo(), equipment);
                    Collection<Equipment> l = this.typeMap.get(equipment.getType());
                    if (l == null) {
                        l = new ConcurrentLinkedQueue<Equipment>();
                        this.typeMap.put(equipment.getType(), l);
                    }
                    l.add(equipment);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterEquipment(Equipment equipment) {
        if (equipment != null) {
            CarparkEquipmentManager carparkEquipmentManager = this;
            synchronized (carparkEquipmentManager) {
                Collection<Equipment> cl = this.typeMap.get(equipment.getType());
                if (cl != null) {
                    Iterator<Equipment> it = cl.iterator();
                    while (it.hasNext()) {
                        Equipment e1 = it.next();
                        if (equipment != e1 && !e1.getEquipmentNo().equals(equipment.getEquipmentNo())) continue;
                        it.remove();
                        break;
                    }
                }
                if (cl.isEmpty()) {
                    this.typeMap.remove(equipment.getType());
                }
                this.idsMap.remove(equipment.getEquipmentNo());
            }
        }
    }

    @Override
    public Enumeration<Equipment> getAllEquipments() {
        return Collections.enumeration(this.idsMap.values());
    }

    @Override
    public List<Equipment> findByConfig(KeyValueEntry<String, String>[] configs) {
        return this.findByConfig(configs, this.idsMap.values());
    }

    @Override
    public List<Equipment> findByConfig(KeyValueEntry<String, String>[] configs, int equipmentType) {
        return this.findByConfig(configs, this.typeMap.get(equipmentType));
    }

    protected List<Equipment> findByConfig(KeyValueEntry<String, String>[] configs, Collection<Equipment> cls) {
        if (configs == null || configs.length == 0) {
            return null;
        }
        if (cls == null) {
            return null;
        }
        LinkedList<Equipment> list = null;
        for (Equipment e : cls) {
            EquipmentConfig config = e.getEquipmentConfig();
            if (config == null) continue;
            int sameCount = 0;
            KeyValueEntry<String, String>[] keyValueEntryArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                KeyValueEntry<String, String> c = keyValueEntryArray[n2];
                String configV = config.getConfigValue((String)c.getKey());
                if (configV == null || configV.length() == 0) break;
                if (configV.equals(c.getValue())) {
                    ++sameCount;
                }
                ++n2;
            }
            if (sameCount != configs.length) continue;
            if (list == null) {
                list = new LinkedList<Equipment>();
            }
            list.add(e);
        }
        return list;
    }
}

