/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment;

import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentAction;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class DefaultEquipment
implements Equipment {
    private String equipmentNo;
    private String parentEquipmentNo;
    private String name;
    private String manufacturer;
    private String description;
    private int type;
    private int use;
    private String model;
    private String serialNo;
    private List<String> channelNos;
    private Map<String, Object> atrributes;
    private EquipmentDriver equipmentDriver;
    private EquipmentConfig equipmentConfig;
    private EquipmentAction equipmentAction;
    private CopyOnWriteArraySet<EquipmentConfigChanngedListener> equipmentConfigChanngedListeners;
    private static final String ipconfigKey = "ip";

    @Override
    public String getEquipmentNo() {
        return this.equipmentNo;
    }

    public void setEquipmentNo(String equipmentNo) {
        this.equipmentNo = equipmentNo;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getManufacturer() {
        return this.manufacturer;
    }

    @Override
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getUse() {
        return this.use;
    }

    @Override
    public void setUse(int use) {
        this.use = use;
    }

    @Override
    public String getModel() {
        return this.model;
    }

    @Override
    public void setModel(String model) {
        this.model = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getAtrributesMap() {
        if (this.atrributes == null) {
            DefaultEquipment defaultEquipment = this;
            synchronized (defaultEquipment) {
                if (this.atrributes == null) {
                    this.atrributes = new ConcurrentHashMap<String, Object>();
                }
            }
        }
        return this.atrributes;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name != null && value != null) {
            this.getAtrributesMap().put(name, value);
        }
    }

    @Override
    public Object getAttribute(String name) {
        Map<String, Object> atrributes1 = this.atrributes;
        if (name != null && atrributes1 != null) {
            return atrributes1.get(name);
        }
        return null;
    }

    @Override
    public Object removeAttribute(String name) {
        Map<String, Object> atrributes1 = this.atrributes;
        if (name != null && atrributes1 != null) {
            return atrributes1.remove(name);
        }
        return null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Map<String, Object> atrributes1 = this.atrributes;
        Collection<String> cl = null;
        cl = atrributes1 == null ? new ArrayList(0) : atrributes1.keySet();
        return Collections.enumeration(cl);
    }

    @Override
    public String getSerialNo() {
        return this.serialNo;
    }

    @Override
    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    @Override
    public EquipmentDriver getDriver() {
        return this.equipmentDriver;
    }

    public void setEquipmentDriver(EquipmentDriver equipmentDriver) {
        this.equipmentDriver = equipmentDriver;
    }

    @Override
    public EquipmentConfig getEquipmentConfig() {
        return this.equipmentConfig;
    }

    @Override
    public void setEquipmentConfig(EquipmentConfig equipmentConfig) {
        CopyOnWriteArraySet<EquipmentConfigChanngedListener> es;
        EquipmentConfig old = this.equipmentConfig;
        this.equipmentConfig = equipmentConfig;
        if (equipmentConfig != null && old != null && (es = this.equipmentConfigChanngedListeners) != null && !es.isEmpty()) {
            LinkedHashMap<String, KeyValueEntry> changedProperties = null;
            Enumeration<String> els = equipmentConfig.getConfigKeys();
            if (els != null) {
                while (els.hasMoreElements()) {
                    String name = els.nextElement();
                    String oldValue = old.getConfigValue(name);
                    String newValue = equipmentConfig.getConfigValue(name);
                    if (oldValue == null) {
                        oldValue = "";
                    }
                    if (newValue == null) {
                        newValue = "";
                    }
                    if (oldValue.equals(newValue)) continue;
                    if (changedProperties == null) {
                        changedProperties = new LinkedHashMap<String, KeyValueEntry>();
                    }
                    changedProperties.put(name, new KeyValueEntry((Object)oldValue, (Object)newValue));
                }
            }
            if (changedProperties != null && !changedProperties.isEmpty()) {
                for (EquipmentConfigChanngedListener l : es) {
                    l.onConfigPropertyChange((Map<String, KeyValueEntry<String, String>>)changedProperties);
                }
            }
        }
    }

    @Override
    public <T extends EquipmentAction> T getEquipmentAction() {
        return (T)this.equipmentAction;
    }

    public void setEquipmentAction(EquipmentAction equipmentAction) {
        this.equipmentAction = equipmentAction;
    }

    @Override
    public String getParentEquipmentNo() {
        return this.parentEquipmentNo;
    }

    @Override
    public void setParentEquipmentNo(String parentEquipmentNo) {
        this.parentEquipmentNo = parentEquipmentNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEquipmentConfigChanngedListener(EquipmentConfigChanngedListener l) {
        if (l != null) {
            if (this.equipmentConfigChanngedListeners == null) {
                DefaultEquipment defaultEquipment = this;
                synchronized (defaultEquipment) {
                    if (this.equipmentConfigChanngedListeners == null) {
                        this.equipmentConfigChanngedListeners = new CopyOnWriteArraySet();
                    }
                }
            }
            this.equipmentConfigChanngedListeners.add(l);
        }
    }

    @Override
    public void removeEquipmentConfigChanngedListener(EquipmentConfigChanngedListener l) {
        if (this.equipmentConfigChanngedListeners != null && l != null) {
            this.equipmentConfigChanngedListeners.remove(l);
        }
    }

    @Override
    public List<String> getChannelNos() {
        return this.channelNos;
    }

    @Override
    public void setChannelNos(List<String> channelNos) {
        this.channelNos = channelNos;
    }

    @Override
    public String getIp() {
        EquipmentConfig config = this.getEquipmentConfig();
        if (config != null) {
            return config.getConfigValue(ipconfigKey);
        }
        return null;
    }

    @Override
    public EquipmentState getEquipmentState() {
        Object action = this.getEquipmentAction();
        if (action == null) {
            return EquipmentState.DISCONNECTED;
        }
        EquipmentState s = action.getEquipmentState();
        if (s == null) {
            s = EquipmentState.DISCONNECTED;
        }
        return s;
    }
}

