/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment;

import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.AppProtocolPacketHandler;
import com.wovoe.framework.communication.AppResponseListener;
import com.wovoe.framework.communication.CommunicationLog;
import com.wovoe.framework.communication.Condition;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class PacketHandleEquipmentAction
extends AbstractEquipmentAction
implements AppProtocolPacketHandler {
    private ConcurrentLinkedQueue<AppResponseWrapper> interstResponseQueue = new ConcurrentLinkedQueue();

    @Override
    public EquipmentState getEquipmentState() {
        boolean workp = this.isWorkingProperly();
        if (workp) {
            return EquipmentState.CONNECTED;
        }
        return EquipmentState.DISCONNECTED;
    }

    protected void handleAppPacket(AppProtocolPacket receivePacket) throws Exception {
    }

    protected void preHandleAppPacket(AppProtocolPacket receivePacket) throws Exception {
    }

    public void handleAppProtocolPacket(AppProtocolPacket receivePacket) throws Exception {
        this.preHandleAppPacket(receivePacket);
        if (!this.interest(receivePacket)) {
            this.handleAppPacket(receivePacket);
        }
    }

    protected boolean interest(AppProtocolPacket receivePacket) {
        if (receivePacket != null) {
            Iterator<AppResponseWrapper> its = this.interstResponseQueue.iterator();
            while (its.hasNext()) {
                try {
                    AppResponseWrapper w = its.next();
                    if (!w.response.checkReceiveDataIsWaitData(receivePacket)) continue;
                    if (w.response.checkReceiveCompleted(receivePacket) != Condition.Result.FALSE) {
                        try {
                            its.remove();
                            ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)w);
                        }
                        finally {
                            w.response.handleResponse(receivePacket);
                        }
                    }
                    return true;
                }
                catch (Throwable e1) {
                    CommunicationLog.getLog().error((Object)"\u6761\u4ef6\u5224\u65ad\u5305\u662f\u5426\u662f\u9700\u8981\u65f6\u51fa\u73b0\u5f02\u5e38!", e1);
                }
            }
        }
        return false;
    }

    protected void cancelInterestResponseListener(AppResponseListener<?> response) {
        if (response.getWaitkey() != null) {
            this.interstResponseQueue.remove(response.getWaitkey());
            ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(response.getWaitkey());
        }
    }

    protected void offerInterestResponseListener(AppResponseListener<?> response) {
        if (response != null) {
            AppResponseWrapper w = new AppResponseWrapper(response);
            response.setWaitkey((Object)w);
            this.interstResponseQueue.offer(w);
            ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)w, (Object)w, new TimeoutObjectPool.TimeoutCallback(){

                public void onTimeout(Object key, Object object) throws Exception {
                    AppResponseWrapper w = (AppResponseWrapper)key;
                    try {
                        PacketHandleEquipmentAction.this.interstResponseQueue.remove(w);
                    }
                    finally {
                        w.response.handleException((Throwable)new TimeoutException("Wait response data timeout!"));
                    }
                }
            }, response.getWaitTimeout(), TimeUnit.NANOSECONDS);
        }
    }

    private static class AppResponseWrapper {
        private final AppResponseListener<?> response;

        public AppResponseWrapper(AppResponseListener<?> rp) {
            this.response = rp;
        }
    }
}

