/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.BCDCompression;
import com.wovoe.carpark.Constants;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.PacketHandleEquipmentAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceActionA0;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CRC16;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CA6ChannelDisplayAction
extends PacketHandleEquipmentAction
implements CarChannelDisplayAction,
CarparkLoudspeakerAction,
DynLoudspeakerAction,
EquipmentConfigChanngedListener {
    private static ConcurrentHashMap<String, Properties> synConMap = new ConcurrentHashMap();
    private volatile long receiveheardbeatTimemills;
    private ScheduledFuture<?> shedule;
    private boolean checkSeriaSetingok = false;
    private AtomicBoolean checkingConfig = new AtomicBoolean(false);
    private Hashtable<Integer, Long> dispLayInfoTimeTable = new Hashtable();
    private Object displayLock = new Object();
    private volatile boolean needLightRed = false;
    private volatile long lightRedTimemills = 0L;
    private static StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction;
    private ReceiveDataHandler<Integer> rReceiveDataHandler = new ReceiveDataHandler<Integer>(){
        int result;

        @Override
        public boolean handleData(byte[] data, int offset, int len) {
            CA6ChannelDisplayAction.this.receiveheardbeatTimemills = ServiceUtil.getServiceContext().currentTimeMillis();
            return true;
        }

        @Override
        public Integer getResponseResult() {
            return this.result;
        }
    };

    public CA6ChannelDisplayAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                try {
                    CA6ChannelDisplayAction.this.connectIfNotConnected1();
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u663e\u793a\u5c4f[" + CA6ChannelDisplayAction.this.equipment.getName() + "]\u5f02\u5e38"), ex);
                }
            }
        }, 2000L, 5000L, TimeUnit.MILLISECONDS);
        this.equipment.addEquipmentConfigChanngedListener(this);
    }

    synchronized void stop() {
        if (this.shedule != null) {
            this.shedule.cancel(true);
        }
        this.equipment.removeEquipmentConfigChanngedListener(this);
    }

    protected CameraUartAction getWorkingCameraUartAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action instanceof CameraUartAction && action.isWorkingProperly()) {
            return (CameraUartAction)action;
        }
        return null;
    }

    public void connectIfNotConnected1() {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            if (this.checkSeriaSetingok) {
                this.checkSeriaSetingok = false;
            }
            return;
        }
        if (!this.checkSeriaSetingok) {
            EquipmentConfig config = this.equipment.getEquipmentConfig();
            Integer uatIndex = config.getConfigIntValue("uatIndex");
            if (uatIndex == null) {
                uatIndex = 0;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("uatIndex", uatIndex);
            param.put("dataBits", 8);
            param.put("baudRate", 9600);
            param.put("stopBits", 1);
            param.put("screen_mode", 2);
            param.put("parity", "PARITY_NONE");
            param.put("flowControl", "NONE");
            OperationFuture<Integer> operf = action.setSerialIfNeed(param);
            try {
                Integer ok = (Integer)operf.get(8L, TimeUnit.SECONDS);
                if (ok == null || ok != 0) {
                    return;
                }
                this.checkSeriaSetingok = true;
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)ex.getMessage());
                return;
            }
        }
        if (!this.checkSeriaSetingok) {
            return;
        }
        byte[] heartBitdata = CA6ChannelDisplayAction.toSendBytes(this.getAddress(), (byte)17, CA6ChannelDisplayAction.getUpdateTimeData(null));
        OperationFuture<Integer> result = action.sendHaveResponseRS485Data(this.getUatIndex(), heartBitdata, this.rReceiveDataHandler);
        if (!this.isWorkingProperly()) {
            try {
                Integer t = (Integer)result.get(3L, TimeUnit.SECONDS);
                if (t == null) {
                    result.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                        public void waitCompleteTimeout() {
                            LogUtil.getLog().warn((Object)(String.valueOf(CA6ChannelDisplayAction.this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u5bf9\u65b9\u65e0\u5e94\u7b54"));
                        }

                        public void operationComplete(OperationFuture<Integer> f) {
                            if (f.isDone()) {
                                if (f.getException() != null) {
                                    LogUtil.getLog().warn((Object)(String.valueOf(CA6ChannelDisplayAction.this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u539f\u56e0:" + f.getException().getMessage()));
                                } else {
                                    Integer a = (Integer)f.getResult();
                                    if (a == null) {
                                        LogUtil.getLog().warn((Object)(String.valueOf(CA6ChannelDisplayAction.this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u9519\u8bef:\u8d85\u65f6"));
                                    } else if (a != 0) {
                                        LogUtil.getLog().warn((Object)(String.valueOf(CA6ChannelDisplayAction.this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u9519\u8bef\u4ee3\u7801:" + a));
                                    }
                                }
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                LogUtil.getLog().warn((Object)(String.valueOf(this.equipment.getName()) + "\u8fde\u63a5\u5931\u8d25!\u539f\u56e0:" + e.getMessage()));
            }
        }
        if (this.isWorkingProperly()) {
            this.checkConfig();
            if (this.needLightRed && ServiceUtil.getServiceContext().currentTimeMillis() > this.lightRedTimemills) {
                OperationFuture<Integer> f = this.lightRedORGreen((byte)0);
                f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void operationComplete(OperationFuture<Integer> f) {
                        if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0 && ServiceUtil.getServiceContext().currentTimeMillis() > CA6ChannelDisplayAction.this.lightRedTimemills) {
                            CA6ChannelDisplayAction.this.needLightRed = false;
                        }
                    }

                    public void waitCompleteTimeout() {
                    }
                });
            }
        } else if (this.isSupportTrafficLights()) {
            this.needLightRed = true;
        }
    }

    private void doSynConfig(Properties config) throws Throwable {
        Properties synP = synConMap.get(this.equipment.getEquipmentNo());
        if (synP == null || !config.equals(synP)) {
            if (!this.isWorkingProperly()) {
                return;
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                return;
            }
            byte address = this.getAddress();
            byte fun = -112;
            LinkedHashMap<String, OperationFuture<Integer>> sendMap = new LinkedHashMap<String, OperationFuture<Integer>>();
            for (Map.Entry<Object, Object> e : config.entrySet()) {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                byte[] paramData = BytesTool.hexStringToByteArray((String)(String.valueOf(key) + value));
                byte[] sendData = CA6ChannelDisplayAction.toSendBytes(address, fun, paramData);
                OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData);
                sendMap.put(String.valueOf(key) + value, result);
            }
            byte[] saveConfigData = CA6ChannelDisplayAction.toSendBytes(address, fun, new byte[]{3});
            OperationFuture<Integer> result = action.sendHaveResponseRS485Data(this.getUatIndex(), saveConfigData, this.rReceiveDataHandler);
            sendMap.put("03", result);
            for (Map.Entry e : sendMap.entrySet()) {
                try {
                    Integer s = (Integer)((OperationFuture)e.getValue()).get(5L, TimeUnit.SECONDS);
                    if (s != null && s == 0) continue;
                    throw new Exception("\u8d85\u65f6");
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5c4f\u53c2\u6570\u5f02\u5e38\uff1a\u539f\u56e0:" + ex.getMessage() + ",\u53c2\u6570\u6570\u636e:" + (String)e.getKey()), ex);
                    return;
                }
            }
            synConMap.put(this.equipment.getEquipmentNo(), config);
        }
    }

    private void checkConfig() {
        if (!this.isWorkingProperly()) {
            return;
        }
        if (this.checkingConfig.compareAndSet(false, true)) {
            try {
                final Properties curentP = this.getconfig();
                Properties synP = synConMap.get(this.equipment.getEquipmentNo());
                if (synP == null || !curentP.equals(synP)) {
                    ServiceUtil.getServiceContext().getWorkThreadPool().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                try {
                                    CA6ChannelDisplayAction.this.doSynConfig(curentP);
                                }
                                catch (Throwable ex) {
                                    ServiceLog.getLog().warn((Object)"\u540c\u6b65\u914d\u7f6e\u5f02\u5e38", ex);
                                    CA6ChannelDisplayAction.this.checkingConfig.set(false);
                                }
                            }
                            finally {
                                CA6ChannelDisplayAction.this.checkingConfig.set(false);
                            }
                        }
                    });
                } else {
                    this.checkingConfig.set(false);
                }
            }
            catch (Throwable ex) {
                this.checkingConfig.set(false);
                ServiceLog.getLog().warn((Object)"\u68c0\u67e5\u914d\u7f6e\u5f02\u5e38", ex);
            }
        }
    }

    private byte getconfigByteValue(EquipmentConfig config, String key, byte defualtValue) {
        if (config == null) {
            return defualtValue;
        }
        Integer v = config.getConfigIntValue(key);
        if (v == null) {
            return defualtValue;
        }
        return v.byteValue();
    }

    private Properties getconfig() {
        Integer display_tyle;
        Properties p = new Properties();
        p.setProperty("02", "00");
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        byte display_type = this.getconfigByteValue(config, "display_type", (byte)0);
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        int sc_count = 0;
        if (display_count == 4) {
            sc_count = 1;
        }
        if ((display_tyle = config.getConfigIntValue("display_tyle")) == null) {
            display_tyle = 0;
        }
        if (display_tyle == 1) {
            sc_count = 2;
        }
        byte[] x0e = null;
        byte[] x0f = null;
        byte[] x04 = null;
        byte[] x05 = null;
        byte[] x06 = null;
        byte[] x0d = null;
        if (this.equipment.getUse() == 1) {
            x0e = new byte[10];
            x0f = new byte[4];
            x0e[0] = display_type;
            x0e[1] = sc_count;
            int index = 2;
            int i = 1;
            while (i <= 4) {
                byte[] textd;
                String text;
                byte color = this.getconfigByteValue(config, "display_position_" + i + "_color", (byte)0);
                byte ac = this.getconfigByteValue(config, "display_position_" + i + "_action", (byte)0);
                x0e[index++] = color;
                x0e[index++] = ac;
                byte showType = this.getconfigByteValue(config, "display_position_" + i + "_free_type", (byte)0);
                if (showType == 0) {
                    x0f[i - 1] = 7;
                    text = config.getConfigValue("display_position_" + i + "_free_type" + 0);
                    textd = null;
                    if (text != null && text.length() > 0) {
                        text = ServiceUtil.getString(text, 199, "GBK");
                        try {
                            textd = text.getBytes("GBK");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    if (i == 1) {
                        if (textd != null) {
                            x04 = textd;
                        }
                    } else if (i == 2) {
                        if (textd != null) {
                            x05 = textd;
                        }
                    } else if (i == 3) {
                        if (sc_count != 0 && textd != null) {
                            x06 = textd;
                        }
                    } else if (i == 4 && sc_count != 0 && textd != null) {
                        x0d = textd;
                    }
                } else if (showType == 1) {
                    x0f[i - 1] = 0;
                    text = config.getConfigValue("display_position_" + i + "_free_type" + 1);
                    textd = null;
                    if (text != null && text.length() > 0) {
                        text = ServiceUtil.getString(text, 199, "GBK");
                        try {
                            textd = text.getBytes("GBK");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    if (i == 1) {
                        if (textd != null) {
                            x04 = textd;
                        }
                    } else if (i == 2) {
                        if (textd != null) {
                            x05 = textd;
                        }
                    } else if (i == 3) {
                        if (sc_count != 0 && textd != null) {
                            x06 = textd;
                        }
                    } else if (i == 4 && sc_count != 0 && textd != null) {
                        x0d = textd;
                    }
                } else if (showType == 2) {
                    x0f[i - 1] = 0;
                } else if (showType == 3) {
                    x0f[i - 1] = 15;
                }
                ++i;
            }
        } else if (this.equipment.getUse() == 2) {
            x0e = new byte[10];
            x0f = new byte[4];
            x0e[0] = display_type;
            x0e[1] = sc_count;
            int index = 2;
            int i = 1;
            while (i <= 4) {
                byte[] textd;
                String text;
                byte color = this.getconfigByteValue(config, "display_position_" + i + "_color1", (byte)0);
                byte ac = this.getconfigByteValue(config, "display_position_" + i + "_action1", (byte)0);
                x0e[index++] = color;
                x0e[index++] = ac;
                byte showType = this.getconfigByteValue(config, "display_position_" + i + "_type", (byte)0);
                if (showType == 0) {
                    x0f[i - 1] = 7;
                    text = config.getConfigValue("display_position_" + i + "_type" + 0);
                    textd = null;
                    if (text != null && text.length() > 0) {
                        text = ServiceUtil.getString(text, 199, "GBK");
                        try {
                            textd = text.getBytes("GBK");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    if (i == 1) {
                        if (textd != null) {
                            x04 = textd;
                        }
                    } else if (i == 2) {
                        if (textd != null) {
                            x05 = textd;
                        }
                    } else if (i == 3) {
                        if (sc_count != 0 && textd != null) {
                            x06 = textd;
                        }
                    } else if (i == 4 && sc_count != 0 && textd != null) {
                        x0d = textd;
                    }
                } else if (showType == 1) {
                    x0f[i - 1] = 0;
                    text = config.getConfigValue("display_position_" + i + "_type" + 1);
                    textd = null;
                    if (text != null && text.length() > 0) {
                        text = ServiceUtil.getString(text, 199, "GBK");
                        try {
                            textd = text.getBytes("GBK");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            // empty catch block
                        }
                    }
                    if (i == 1) {
                        if (textd != null) {
                            x04 = textd;
                        }
                    } else if (i == 2) {
                        if (textd != null) {
                            x05 = textd;
                        }
                    } else if (i == 3) {
                        if (sc_count != 0 && textd != null) {
                            x06 = textd;
                        }
                    } else if (i == 4 && sc_count != 0 && textd != null) {
                        x0d = textd;
                    }
                } else if (showType == 2) {
                    x0f[i - 1] = 0;
                } else if (showType == 3) {
                    x0f[i - 1] = 15;
                }
                ++i;
            }
        }
        if (x0e != null && x0e.length > 0) {
            p.setProperty("0e", BytesTool.byteArrayToHexString((byte[])x0e));
        }
        if (x0f != null && x0f.length > 0) {
            p.setProperty("0f", BytesTool.byteArrayToHexString((byte[])x0f));
        }
        if (x04 != null && x04.length > 0) {
            p.setProperty("04", BytesTool.byteArrayToHexString(x04));
        }
        if (x05 != null && x05.length > 0) {
            p.setProperty("05", BytesTool.byteArrayToHexString(x05));
        }
        if (x06 != null && x06.length > 0) {
            p.setProperty("06", BytesTool.byteArrayToHexString(x06));
        }
        if (x0d != null && x0d.length > 0) {
            p.setProperty("0d", BytesTool.byteArrayToHexString(x0d));
        }
        return p;
    }

    private byte getAddress() {
        Integer x = this.equipment.getEquipmentConfig().getConfigIntValue("RS485_ADDR");
        if (x == null) {
            return 3;
        }
        return x.byteValue();
    }

    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (remainSpaceMap == null || remainSpaceMap.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        List<DisplaySpaceConfig> list = this.getSpaceCofigList();
        if (list == null || list.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        OperationFuture<Integer> f = null;
        for (DisplaySpaceConfig config : list) {
            Integer v = remainSpaceMap.get(config.spaceTypeNo);
            if (v == null) continue;
            f = this.display0(60, config.screenIndex, String.valueOf(config.spacefix) + v, true);
        }
        if (f == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        return f;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        List<DisplaySpaceConfig> x = this.getSpaceCofigList();
        if (x == null || x.isEmpty()) {
            return null;
        }
        HashSet<String> plateSet = new HashSet<String>();
        for (DisplaySpaceConfig c : x) {
            plateSet.add(c.spaceTypeNo);
        }
        return plateSet;
    }

    public List<DisplaySpaceConfig> getSpaceCofigList() {
        LinkedList<DisplaySpaceConfig> list;
        block12: {
            EquipmentConfig config;
            int screenCount;
            block11: {
                screenCount = this.getDisplayCount();
                list = null;
                config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() != 1) break block11;
                int i = 1;
                while (i <= screenCount) {
                    Integer displayType = config.getConfigIntValue("display_position_" + i + "_free_type");
                    if (displayType != null && displayType == 2) {
                        String prefix;
                        String spaceTypeNo = config.getConfigValue("display_position_" + i + "_free_type2");
                        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                            spaceTypeNo = "0";
                        }
                        if ((prefix = config.getConfigValue("display_position_" + i + "_free_type2_prefix")) == null || prefix.length() == 0) {
                            prefix = "\u4f59\u4f4d";
                        }
                        if (list == null) {
                            list = new LinkedList<DisplaySpaceConfig>();
                        }
                        DisplaySpaceConfig c = new DisplaySpaceConfig();
                        c.screenIndex = i;
                        c.spacefix = prefix;
                        c.spaceTypeNo = spaceTypeNo;
                        list.add(c);
                    }
                    ++i;
                }
                break block12;
            }
            if (this.equipment.getUse() != 2) break block12;
            int i = 1;
            while (i <= screenCount) {
                Integer displayType = config.getConfigIntValue("display_position_" + i + "_type");
                if (displayType == null) {
                    displayType = 2;
                }
                if (displayType == 2) {
                    String prefix;
                    String spaceTypeNo = config.getConfigValue("display_position_" + i + "_type2");
                    if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                        spaceTypeNo = "0";
                    }
                    if ((prefix = config.getConfigValue("display_position_" + i + "_type2_prefix")) == null || prefix.length() == 0) {
                        prefix = "\u4f59\u4f4d";
                    }
                    if (list == null) {
                        list = new LinkedList();
                    }
                    DisplaySpaceConfig c = new DisplaySpaceConfig();
                    c.screenIndex = i;
                    c.spacefix = prefix;
                    c.spaceTypeNo = spaceTypeNo;
                    list.add(c);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public boolean isWorkingProperly() {
        Object action = this.getParentEquipmentAction();
        if (action == null) {
            return false;
        }
        if (!action.isWorkingProperly()) {
            return false;
        }
        long timeMills = ServiceUtil.getServiceContext().currentTimeMillis();
        return timeMills - this.receiveheardbeatTimemills <= 7000L;
    }

    @Override
    public boolean isVerticalScreen() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_tyle = config.getConfigIntValue("display_tyle");
        if (display_tyle == null) {
            display_tyle = 0;
        }
        return display_tyle == 1;
    }

    @Override
    public int getDisplayCount() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        return display_count;
    }

    @Override
    public boolean isSupportTrafficLights() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String v = config.getConfigValue("trafficLights");
        return v != null && "1".equals(v);
    }

    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        if (sec < 1) {
            sec = 1;
        } else if (sec > 255) {
            sec = 255;
        }
        final int tex = sec * 1000;
        this.lightRedTimemills = ServiceUtil.getServiceContext().currentTimeMillis() + (long)tex;
        OperationFuture<Integer> f = this.lightRedORGreen((byte)1);
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> f) {
                if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                    CA6ChannelDisplayAction.this.lightRedTimemills = ServiceUtil.getServiceContext().currentTimeMillis() + (long)tex;
                    CA6ChannelDisplayAction.this.needLightRed = true;
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return f;
    }

    public OperationFuture<Integer> lightRedORGreen(byte redOrGreen) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (redOrGreen != 0) {
            redOrGreen = 1;
        }
        byte[] sendData = CA6ChannelDisplayAction.toSendBytes(this.getAddress(), (byte)48, new byte[]{redOrGreen});
        OperationFuture<Integer> op = action.sendNoResponseRS485Data(this.getUatIndex(), sendData);
        return op;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        OperationFuture<Integer> pf = null;
        if (texts != null && texts.length > 0) {
            int position = 1;
            String[] stringArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    pf = this.display(displayTimes, position, s);
                    ++position;
                }
                ++n2;
            }
        }
        return pf;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        return this.display0(displayTimes, position, text, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationFuture<Integer> display0(int displayTimes, int position, String text, boolean spaceInfo) {
        Object object = this.displayLock;
        synchronized (object) {
            Long x;
            byte[] sendText;
            if (!this.isWorkingProperly()) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            if (text == null || text.length() == 0) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setResult((Object)0);
                return h;
            }
            text = ServiceUtil.getString(text, 198, "GBK");
            try {
                sendText = text.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)e);
                return h;
            }
            if (!spaceInfo) {
                this.dispLayInfoTimeTable.put(position, ServiceUtil.getServiceContext().currentTimeMillis());
            } else if (this.equipment.getUse() == 1 && (x = this.dispLayInfoTimeTable.get(position)) != null && ServiceUtil.getServiceContext().currentTimeMillis() - x < 15000L) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setResult((Object)0);
                return h;
            }
            byte[] dx = new byte[sendText.length + 2];
            dx[0] = (byte)position;
            if (displayTimes < 1) {
                displayTimes = 1;
            } else if (displayTimes > 255) {
                displayTimes = 255;
            }
            dx[1] = (byte)displayTimes;
            System.arraycopy(sendText, 0, dx, 2, sendText.length);
            byte[] sendData = CA6ChannelDisplayAction.toSendBytes(this.getAddress(), (byte)16, dx);
            OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData);
            return result;
        }
    }

    public static byte[] getUpdateTimeData(Date datetime) {
        int year;
        Calendar calendar = Calendar.getInstance();
        if (datetime != null) {
            calendar.setTime(datetime);
        }
        if ((year = calendar.get(1) - 2000) < 0) {
            year = 0;
        }
        int week = calendar.get(7) - 1;
        int moth = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        byte[] data = new byte[]{BCDCompression.intToBCD(sec)[0], BCDCompression.intToBCD(min)[0], BCDCompression.intToBCD(hour)[0], BCDCompression.intToBCD(day)[0], BCDCompression.intToBCD(moth)[0], BCDCompression.intToBCD(week)[0], BCDCompression.intToBCD(year)[0]};
        return data;
    }

    public static byte[] toSendBytes(byte address, byte fun, byte[] data) {
        byte len = (byte)(data.length + 2);
        byte[] sendb = new byte[8 + data.length];
        sendb[0] = -86;
        sendb[1] = 85;
        sendb[2] = -1;
        sendb[3] = address;
        sendb[4] = fun;
        sendb[5] = len;
        System.arraycopy(data, 0, sendb, 6, data.length);
        int crc = CRC16.calculate((byte[])sendb, (int)2, (int)(sendb.length - 4));
        sendb[sendb.length - 2] = (byte)(crc << 16 >>> 24);
        sendb[sendb.length - 1] = (byte)crc;
        return sendb;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        this.checkConfig();
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        DynLoudspeakerAction a = this.getDynLoudspeakerAction();
        if (a != null) {
            return null;
        }
        return this;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        boolean isSuportDyn = Constants.YES_STR.equals(this.equipment.getEquipmentConfig().getConfigValue("voice_type"));
        if (isSuportDyn) {
            return this;
        }
        return null;
    }

    @Override
    public OperationFuture<Integer> play(String text) {
        return this.play(text, null, null);
    }

    @Override
    public OperationFuture<Integer> play(String text, Integer volume, DynLoudspeakerAction.PlayFinishCallback finishCallback) {
        byte[] sendText;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (text == null || text.length() == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        text = ServiceUtil.getString(text, 199, "GBK");
        try {
            sendText = text.getBytes("GBK");
        }
        catch (UnsupportedEncodingException e) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)e);
            return h;
        }
        byte[] sendData = CA6ChannelDisplayAction.toSendBytes(this.getAddress(), (byte)64, sendText);
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData);
        return result;
    }

    @Override
    public boolean isSurpportFinishCallback() {
        return false;
    }

    @Override
    public OperationFuture<Integer> play(byte ... codes) {
        byte[] sendd;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (codes == null || codes.length == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        if (codes.length > 199) {
            sendd = new byte[199];
            System.arraycopy(codes, 0, sendd, 0, sendd.length);
        } else {
            sendd = codes;
        }
        byte[] sendData = CA6ChannelDisplayAction.toSendBytes(this.getAddress(), (byte)67, sendd);
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData);
        return result;
    }

    @Override
    public OperationFuture<Integer> setVolume(Volume volume) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        byte[] xl = new byte[]{(byte)volume.getDayBeginHour(), (byte)volume.getDayBeginMins(), (byte)volume.getDayEndHour(), (byte)volume.getDayEndMins(), (byte)Math.round((float)volume.getDayVolume() / 10.0f), (byte)Math.round((float)volume.getNightVolume() / 10.0f)};
        byte[] sendData = CA6ChannelDisplayAction.toSendBytes(this.getAddress(), (byte)65, xl);
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData);
        result.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> f) {
                if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                    if (CA6ChannelDisplayAction.this.getDynLoudspeakerAction() != null) {
                        CA6ChannelDisplayAction.this.play("\u97f3\u91cf\u8bbe\u7f6e\u6210\u529f");
                    } else {
                        CA6ChannelDisplayAction.this.play(-79);
                    }
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return result;
    }

    private int getUatIndex() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer uatIndex = config.getConfigIntValue("uatIndex");
        if (uatIndex == null) {
            uatIndex = 0;
        }
        return uatIndex;
    }

    @Override
    public OperationFuture<Integer> displayQrCode(int displaySec, String qrContent, String lineMsg) {
        OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
        opHander.setResult((Object)1);
        return opHander;
    }

    @Override
    public int getDisplayQrCodeType() {
        Integer codeType = this.equipment.getEquipmentConfig().getConfigIntValue("display_qrcode");
        if (codeType != null) {
            return codeType;
        }
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return this.equipment.getEquipmentConfig().getConfigValue("qrcode_content");
    }

    @Override
    public StaticLoudSpeakerServiceAction getStaticLoudSpeakerServiceAction() {
        if (staticLoudSpeakerServiceAction == null) {
            staticLoudSpeakerServiceAction = new StaticLoudSpeakerServiceActionA0();
        }
        return staticLoudSpeakerServiceAction;
    }

    private static class DisplaySpaceConfig {
        int screenIndex;
        String spacefix;
        String spaceTypeNo;

        private DisplaySpaceConfig() {
        }
    }
}

