/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.framework.BytesTool;
import com.wovoe.framework.CryptoUtil;
import java.nio.ByteBuffer;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;

public class CameraSign {
    private byte productType;
    private byte deviceType;
    private String serialNo;
    private int orgId;
    private int licenceId;
    private String ecncryptStr;

    private CameraSign() {
    }

    public CameraSign(byte productType, byte deviceType, String serialNo, int orgId, int licenceId) {
        this.productType = productType;
        this.deviceType = deviceType;
        this.serialNo = serialNo;
        this.orgId = orgId;
        this.licenceId = licenceId;
    }

    private byte[] toSignDataBytes() {
        byte[] serialNoBytes;
        try {
            serialNoBytes = this.serialNo.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        byte[] totalBytes = new byte[2 + serialNoBytes.length + 4 + 4];
        int index = 0;
        totalBytes[index++] = this.deviceType;
        totalBytes[index++] = (byte)serialNoBytes.length;
        System.arraycopy(serialNoBytes, 0, totalBytes, index, serialNoBytes.length);
        byte[] orgIdBytes = BytesTool.intToBytes((int)this.orgId);
        byte[] licenceIdBytes = BytesTool.intToBytes((int)this.licenceId);
        System.arraycopy(orgIdBytes, 0, totalBytes, index += serialNoBytes.length, orgIdBytes.length);
        System.arraycopy(licenceIdBytes, 0, totalBytes, index += orgIdBytes.length, licenceIdBytes.length);
        return totalBytes;
    }

    public static byte[] toSignBytes(byte[] dataBytes, String signKey) {
        byte[] signKeyBytes;
        try {
            signKeyBytes = signKey.getBytes("UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        byte[] totalBytes = new byte[dataBytes.length + signKeyBytes.length];
        System.arraycopy(dataBytes, 0, totalBytes, 0, dataBytes.length);
        System.arraycopy(signKeyBytes, 0, totalBytes, dataBytes.length, signKeyBytes.length);
        return CryptoUtil.MD5Encode((byte[])totalBytes);
    }

    public String toWriteData(Key key, String signKey) {
        byte[] dataBytes = this.toSignDataBytes();
        byte[] signBytes = CameraSign.toSignBytes(dataBytes, signKey);
        byte[] sBytes = new byte[dataBytes.length + signBytes.length];
        System.arraycopy(signBytes, 0, sBytes, 0, signBytes.length);
        System.arraycopy(dataBytes, 0, sBytes, signBytes.length, dataBytes.length);
        try {
            String str;
            byte[] array;
            int length;
            int offset;
            byte[] input = sBytes;
            ByteBuffer buf = CryptoUtil.crypt((byte[])input, (int)0, (int)input.length, (Cipher)CryptoUtil.getEncryptCipher((Key)key, (String)key.getAlgorithm()));
            if (buf.hasArray()) {
                offset = buf.position() + buf.arrayOffset();
                length = buf.remaining();
                array = buf.array();
            } else {
                offset = 0;
                length = buf.remaining();
                array = new byte[length];
                buf.get(array);
            }
            byte[] finalBytes = new byte[length + 1];
            finalBytes[0] = this.productType;
            System.arraycopy(array, offset, finalBytes, 1, length);
            this.ecncryptStr = str = BytesTool.compressBytes((byte[])finalBytes);
            return this.ecncryptStr;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static int getProductType(String encryptData) {
        block3: {
            try {
                if (encryptData != null && encryptData.length() != 0) break block3;
                return -1;
            }
            catch (Exception ex) {
                return -1;
            }
        }
        byte[] data = BytesTool.unCompress((String)encryptData);
        return data[0] & 0xFF;
    }

    public static boolean checkSign(String encryptData, Key key, String signKey) {
        try {
            byte[] data = BytesTool.unCompress((String)encryptData);
            byte[] dataBytes = CryptoUtil.decrypt((byte[])data, (int)1, (int)(data.length - 1), (Key)key);
            byte[] oldSignBytes = new byte[16];
            System.arraycopy(dataBytes, 0, oldSignBytes, 0, oldSignBytes.length);
            byte[] dataV = new byte[dataBytes.length - oldSignBytes.length];
            System.arraycopy(dataBytes, oldSignBytes.length, dataV, 0, dataV.length);
            byte[] signData = CameraSign.toSignBytes(dataV, signKey);
            return Arrays.equals(signData, oldSignBytes);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static CameraSign parse(String encryptData, Key key) {
        try {
            byte[] data = BytesTool.unCompress((String)encryptData);
            byte[] dataBytes = CryptoUtil.decrypt((byte[])data, (int)1, (int)(data.length - 1), (Key)key);
            int offset = 16;
            CameraSign cameraSign = new CameraSign();
            cameraSign.ecncryptStr = encryptData;
            cameraSign.productType = data[0];
            cameraSign.deviceType = dataBytes[offset++];
            int serialIdLen = dataBytes[offset++] & 0xFF;
            cameraSign.serialNo = new String(dataBytes, offset, serialIdLen, "UTF-8");
            cameraSign.orgId = BytesTool.bytesToInt((byte[])dataBytes, (int)(offset += serialIdLen));
            cameraSign.licenceId = BytesTool.bytesToInt((byte[])dataBytes, (int)(offset += 4));
            offset += 4;
            int cfr_ignored_0 = dataBytes.length;
            return cameraSign;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public byte getProductType() {
        return this.productType;
    }

    public void setProductType(byte productType) {
        this.productType = productType;
    }

    public byte getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(byte deviceType) {
        this.deviceType = deviceType;
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public void setOrgId(int orgId) {
        this.orgId = orgId;
    }

    public int getLicenceId() {
        return this.licenceId;
    }

    public void setLicenceId(int licenceId) {
        this.licenceId = licenceId;
    }

    public String getEcncryptStr() {
        return this.ecncryptStr;
    }

    public void setEcncryptStr(String ecncryptStr) {
        this.ecncryptStr = ecncryptStr;
    }
}

