/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.PassChannel;
import com.wovoe.carpark.PassSession;
import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.action.InputIoDetectedAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.action.RoadBarrierAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceAction;
import com.wovoe.carpark.equipment.action.StaticLoudSpeakerServiceActionE0;
import com.wovoe.carpark.event.equipment.DetectedPassEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.pass.filter.PassSuccessFilter;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.future.ConnectFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionInitializer;

public class DnctChannelBoardActtion
extends AbstractEquipmentAction
implements IoHandler,
EquipmentConfigChanngedListener,
RoadBarrierAction,
CarparkLoudspeakerAction,
DynLoudspeakerAction,
InputIoDetectedAction,
CameraUartAction {
    private ScheduledFuture<?> jobTaskHandle;
    private JobTask jobTask;
    private volatile IoSession iosession;
    private volatile long lastRevMills;
    private String connectIp;
    private int connectPort;
    private InetSocketAddress connAddress;
    private long connectingMills;
    private ConnectFuture connectFuture;
    private boolean stopped;
    private static final String CMD_OnLineAction = "OnLineAction";
    private static final String CMD_HeartBeat = "HeartBeat";
    private LinkedList<SendEntry> sendList = new LinkedList();
    private volatile boolean sending;
    private static final String BoardProtocolName = "BoardProtocol";
    private volatile IoStatus ioStatus;
    private static StaticLoudSpeakerServiceAction staticLoudSpeakerServiceAction;
    private Volume currentVolume;
    private Map<?, ?> eqConfig;
    private volatile long volumeSettingMills;

    private boolean canPlayVoice() {
        Volume volume0 = this.currentVolume;
        if (volume0 == null) {
            return true;
        }
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume0.getDayBeginHour() * 60 + volume0.getDayBeginMins();
        int end = volume0.getDayEndHour() * 60 + volume0.getDayEndMins();
        boolean night = v < begin || v > end;
        return !(night ? volume0.getNightVolume() == 0 : volume0.getDayVolume() == 0);
    }

    public DnctChannelBoardActtion(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
        this.stopped = false;
        if (this.jobTaskHandle == null) {
            this.jobTask = new JobTask(){

                protected void doRun() throws Exception {
                    DnctChannelBoardActtion.this.doJobRun();
                }
            };
            this.jobTaskHandle = ServiceUtil.getServiceContext().schedule(this.jobTask, 100L, 3000L, TimeUnit.MILLISECONDS);
        }
    }

    synchronized void stop() {
        if (!this.stopped) {
            ConnectFuture connectFuture0;
            this.stopped = true;
            if (this.jobTaskHandle != null) {
                this.jobTaskHandle.cancel(true);
                this.jobTaskHandle = null;
            }
            if (this.iosession != null && this.iosession.isConnected()) {
                this.iosession.close(true);
            }
            if ((connectFuture0 = this.connectFuture) != null && !connectFuture0.isDone()) {
                connectFuture0.cancel();
            }
        }
    }

    private int getPort() {
        int port = 1007;
        Integer _connPort = this.equipment.getEquipmentConfig().getConfigIntValue("port");
        if (_connPort != null && _connPort > 0 && _connPort < 65535) {
            port = _connPort;
        }
        return port;
    }

    private void doJobRun() {
        boolean connected;
        String connIp = this.equipment.getIp();
        int port = this.getPort();
        IoSession session = this.iosession;
        boolean bl = connected = session != null && session.isConnected();
        if (connected) {
            if (connIp == null || !connIp.equals(this.connectIp) || port != this.connectPort) {
                session.close(true);
                connected = false;
            } else if (ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevMills >= 7000L) {
                session.close(true);
                connected = false;
            }
        }
        if (!connected) {
            ConnectFuture connectFuture0 = this.connectFuture;
            if (connectFuture0 != null && !connectFuture0.isDone()) {
                if (ServiceUtil.getServiceContext().currentTimeMillis() - this.connectingMills >= 20000L) {
                    connectFuture0.cancel();
                    this.connectFuture = null;
                } else {
                    return;
                }
            }
            if (connIp == null || connIp.length() == 0) {
                return;
            }
            try {
                this.connectIp = connIp;
                this.connectPort = port;
                this.connAddress = new InetSocketAddress(connIp, port);
            }
            catch (Exception ex) {
                return;
            }
            this.doConnect(this.connAddress);
        } else {
            if (ServiceUtil.getServiceContext().currentTimeMillis() - this.lastRevMills >= 2500L) {
                this.sendHeartBeat();
            }
            if (this.eqConfig == null) {
                this.getConfigFromEq();
            } else {
                int voiceVaule0;
                int openDelay = this.getOpenDelayValue();
                int readCardDelay = this.getReadCardDelayValue();
                int readCardDelay0 = this.getEqConfigIntValue(this.eqConfig, "ReadCardDelay", -1);
                int openDelay0 = this.getEqConfigIntValue(this.eqConfig, "OpenDelay", -1);
                int voiceVaule = voiceVaule0 = this.getEqConfigIntValue(this.eqConfig, "VoiceVaule", -1);
                ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
                Volume volume = applicationService.getVolume(this.equipment);
                if (volume != null) {
                    if (this.currentVolume == null) {
                        this.currentVolume = volume;
                    }
                    if (ServiceUtil.getServiceContext().currentTimeMillis() - this.volumeSettingMills > 6000L) {
                        voiceVaule = this.getVolumeBytes(volume);
                    }
                }
                if (openDelay != openDelay0 || readCardDelay != readCardDelay0 || voiceVaule != voiceVaule0) {
                    String Cmd = "SetSysternParam";
                    String MsgId = this.newMsgId();
                    StringBuilder sbr = new StringBuilder();
                    LinkedHashMap<String, String> MsgData = new LinkedHashMap<String, String>();
                    if (openDelay != openDelay0) {
                        MsgData.put("OpenDelay", String.valueOf(openDelay));
                        sbr.append("OpenDelay \u53d8\u5316\uff0c\u8bbe\u5907\u503c\u662f\uff1a" + openDelay0 + ", \u4fee\u6539\u4e3a\uff1a" + openDelay);
                    }
                    if (readCardDelay != readCardDelay0) {
                        MsgData.put("ReadCardDelay", String.valueOf(readCardDelay));
                        if (sbr.length() > 0) {
                            sbr.append(", ");
                        }
                        sbr.append("ReadCardDelay \u53d8\u5316\uff0c\u8bbe\u5907\u503c\u662f\uff1a" + readCardDelay0 + ", \u4fee\u6539\u4e3a\uff1a" + readCardDelay);
                    }
                    if (voiceVaule != voiceVaule0) {
                        MsgData.put("VoiceVaule", String.valueOf(voiceVaule));
                        if (sbr.length() > 0) {
                            sbr.append(", ");
                        }
                        sbr.append("VoiceVaule \u53d8\u5316\uff0c\u8bbe\u5907\u503c\u662f\uff1a" + voiceVaule0 + ", \u4fee\u6539\u4e3a\uff1a" + voiceVaule);
                    }
                    ServiceLog.getLog().info((Object)("\u53d1\u73b0\u53c2\u6570\u53d8\u5316! \u8fd9\u5c06\u8bbe\u7f6e SetSysternParam\uff0c " + sbr));
                    MsgData.put("MsgId", MsgId);
                    final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
                    this.doSend(session, Cmd, MsgId, MsgData, 5000L, new ControllAction(){

                        @Override
                        public void onResult(IoSession session, Map<?, ?> jsonMap, Map<?, ?> MsgData, String MsgId) {
                            Object obj = jsonMap.get("Code");
                            if (obj == null) {
                                ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", SetSysternParam \u8bbe\u7f6e\u53c2\u6570\u8fd4\u56de\u7f3a\u5c11Code! " + jsonMap));
                                handler.setResult((Object)1);
                            } else {
                                String Code = obj instanceof Number ? String.valueOf(((Number)obj).intValue()) : obj.toString();
                                if (Constants.YES_STR.equals(Code)) {
                                    handler.setResult((Object)0);
                                } else {
                                    handler.setResult((Object)1);
                                    ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", SetSysternParam \u8bbe\u7f6e\u53c2\u6570\u64cd\u4f5c\u5931\u8d25! " + jsonMap));
                                }
                            }
                        }

                        @Override
                        public void Exception(int errType, Throwable ex) {
                            handler.setException(ex);
                        }
                    });
                    try {
                        Integer a = (Integer)handler.get(6L, TimeUnit.SECONDS);
                        if (a != null && a == 0) {
                            ServiceLog.getLog().info((Object)"\u8bbe\u7f6e\u53c2\u6570\u6210\u529f! SetSysternParam success");
                            Map map = (Map)this.getConfigFromEq().get(6L, TimeUnit.SECONDS);
                            if (map != null) {
                                ServiceLog.getLog().info((Object)("\u91cd\u65b0\u88c5\u8f7d\u914d\u7f6e! " + map));
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private int getOpenDelayValue() {
        block4: {
            Integer a;
            block6: {
                block5: {
                    a = this.equipment.getEquipmentConfig().getConfigIntValue("openDelay");
                    if (a == null) break block4;
                    if (a >= 1) break block5;
                    return 1;
                }
                if (a <= 255) break block6;
                return 255;
            }
            try {
                return a;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    private int getReadCardDelayValue() {
        block4: {
            Integer a;
            block6: {
                block5: {
                    a = this.equipment.getEquipmentConfig().getConfigIntValue("readCardDelay");
                    if (a == null) break block4;
                    if (a >= 1) break block5;
                    return 1;
                }
                if (a <= 60) break block6;
                return 60;
            }
            try {
                return a;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    private void doConnect(final InetSocketAddress address) {
        ConnectFuture connectFuture0 = this.connectFuture;
        if (connectFuture0 != null && !connectFuture0.isDone()) {
            connectFuture0.cancel();
        }
        this.connectingMills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.eqConfig = null;
        this.connectFuture = ServiceUtil.getServiceContext().getTcpConnectContext().getNioSocketConnector().connect((SocketAddress)address, (IoSessionInitializer)new IoSessionInitializer<ConnectFuture>(){

            public void initializeSession(IoSession session, ConnectFuture f) {
                DnctChannelBoardActtion.this.setSession(session);
                DnctChannelBoardActtion.this.sendHeartBeat();
                DnctChannelBoardActtion.this.getConfigFromEq();
            }
        });
        this.connectFuture.addListener((IoFutureListener)new IoFutureListener<ConnectFuture>(){

            public void operationComplete(ConnectFuture f) {
                try {
                    if (f.getException() != null) {
                        ServiceLog.getLog().error((Object)("\u8fde\u63a5\u8bbe\u5907\uff1a" + address + " \u5931\u8d25!  " + f.getException().getMessage()));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                DnctChannelBoardActtion.this.connectFuture = null;
            }
        });
    }

    private synchronized void setSession(IoSession session) {
        if (this.stopped) {
            session.close(true);
            return;
        }
        this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
        session.setAttribute((Object)BoardProtocolName, (Object)new BoardProtocol());
        session.setAttribute((Object)"WOVOE_TCPCONNECTIOHANLER", (Object)this);
        this.iosession = session;
    }

    @Override
    public boolean isWorkingProperly() {
        IoSession session = this.iosession;
        return session != null && session.isConnected();
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    private int getOpenGateIo() {
        return 0;
    }

    private int getCloseGateIo() {
        return 1;
    }

    public OperationFuture<Integer> doAlwaysOpen(boolean open) {
        int io = this.getOpenGateIo();
        if (!this.isWorkingProperly()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)1);
            return a;
        }
        String v = open ? "2" : "0";
        return this.doControlAction("0", io == 0 ? v : "3", io == 1 ? v : "3", "", "", "");
    }

    @Override
    public OperationFuture<Integer> doRaisePoleAction() {
        int io = this.getOpenGateIo();
        if (!this.isWorkingProperly()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)1);
            return a;
        }
        Ax ax = this.getAx();
        if (ax != null) {
            ax.openGate = true;
            return ax.handler;
        }
        return this.doControlAction("0", io == 0 ? "1" : "3", io == 1 ? "1" : "3", "", "", "");
    }

    @Override
    public OperationFuture<Integer> doDownPoleAction() {
        int io = this.getCloseGateIo();
        if (!this.isWorkingProperly()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)1);
            return a;
        }
        return this.doControlAction("0", io == 0 ? "1" : "3", io == 1 ? "1" : "3", "", "", "");
    }

    @Override
    public OperationFuture<Integer> doStopPoleAction() {
        OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
        a.setResult((Object)1);
        return a;
    }

    @Override
    public boolean isSupportStopPole() {
        return false;
    }

    @Override
    public boolean isSupportDownPole() {
        return true;
    }

    @Override
    public void setPoleSate(EquipmentState state) {
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        if (this.jobTask != null) {
            this.jobTask.run();
        }
    }

    public OperationFuture<Integer> doControlAction(String RemoteAction, String Relay1Action, String Relay2Action, String Combined_Voice, String Multi_Voice, String Led_Dis) {
        IoSession session = this.iosession;
        if (session == null || !session.isConnected()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)1);
            return a;
        }
        String Cmd = "RomoteOpen";
        String MsgId = this.newMsgId();
        LinkedHashMap<String, String> MsgData = new LinkedHashMap<String, String>();
        MsgData.put("RemoteAction", RemoteAction);
        if (Relay1Action != null && Relay1Action.length() > 0) {
            MsgData.put("Relay1Action", Relay1Action);
        }
        if (Relay2Action != null) {
            MsgData.put("Relay2Action", Relay2Action);
        }
        if (Combined_Voice != null) {
            MsgData.put("Combined_Voice", Combined_Voice);
        }
        if (Multi_Voice != null) {
            MsgData.put("Multi_Voice", Multi_Voice);
        }
        if (Led_Dis != null) {
            MsgData.put("Led_Dis", Led_Dis);
        }
        MsgData.put("MsgId", MsgId);
        final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        this.doSend(session, Cmd, MsgId, MsgData, 5000L, new ControllAction(){

            @Override
            public void onResult(IoSession session, Map<?, ?> jsonMap, Map<?, ?> MsgData, String MsgId) {
                String Code;
                Object obj = jsonMap.get("Code");
                if (obj == null) {
                    ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", RomoteOpen \u8fd4\u56de\u7f3a\u5c11Code! " + jsonMap));
                }
                if (Constants.YES_STR.equals(Code = obj instanceof Number ? String.valueOf(((Number)obj).intValue()) : obj.toString())) {
                    handler.setResult((Object)0);
                } else {
                    handler.setResult((Object)1);
                    ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", RomoteOpen \u64cd\u4f5c\u5931\u8d25! " + jsonMap));
                }
            }

            @Override
            public void Exception(int errType, Throwable ex) {
                handler.setException(ex);
            }
        });
        return handler;
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        if (this.getVoiceType() == 2) {
            return this;
        }
        return null;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        if (this.getCarparkLoudspeakerAction() == null) {
            return this;
        }
        return null;
    }

    private OperationFuture<Map<?, ?>> getConfigFromEq() {
        IoSession session = this.iosession;
        if (session == null || !session.isConnected()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setException((Throwable)new Exception("Unconnect"));
            return a;
        }
        String Cmd = "GetSysternParam";
        String MsgId = this.newMsgId();
        LinkedHashMap<String, String> MsgData = new LinkedHashMap<String, String>();
        MsgData.put("MsgId", MsgId);
        final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        this.doSend(session, Cmd, MsgId, MsgData, 5000L, new ControllAction(){

            @Override
            public void onResult(IoSession session, Map<?, ?> jsonMap, Map<?, ?> MsgData, String MsgId) {
                String Code;
                Object obj = jsonMap.get("Code");
                if (obj == null) {
                    ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", GetSysternParam \u8fd4\u56de\u7f3a\u5c11Code! " + jsonMap));
                }
                if (Constants.YES_STR.equals(Code = obj instanceof Number ? String.valueOf(((Number)obj).intValue()) : obj.toString())) {
                    DnctChannelBoardActtion.this.eqConfig = MsgData;
                    handler.setResult(MsgData);
                } else {
                    handler.setException((Throwable)new Exception("GetSysternParam error"));
                    ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", GetSysternParam \u64cd\u4f5c\u5931\u8d25! " + jsonMap));
                }
            }

            @Override
            public void Exception(int errType, Throwable ex) {
                handler.setException(ex);
            }
        });
        return handler;
    }

    private OperationFuture<Integer> setVolume0(final int volumeValue, final boolean playVoiceWhenSuccess) {
        IoSession session = this.iosession;
        if (session == null || !session.isConnected()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)1);
            return a;
        }
        String Cmd = "SetSysternParam";
        String MsgId = this.newMsgId();
        LinkedHashMap<String, String> MsgData = new LinkedHashMap<String, String>();
        MsgData.put("VoiceVaule", String.valueOf(volumeValue));
        MsgData.put("MsgId", MsgId);
        final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
        this.volumeSettingMills = ServiceUtil.getServiceContext().currentTimeMillis();
        this.doSend(session, Cmd, MsgId, MsgData, 5000L, new ControllAction(){

            @Override
            public void onResult(IoSession session, Map<?, ?> jsonMap, Map<?, ?> MsgData, String MsgId) {
                String Code;
                Object obj = jsonMap.get("Code");
                if (obj == null) {
                    ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", SetSysternParam \u8fd4\u56de\u7f3a\u5c11Code! " + jsonMap));
                }
                if (Constants.YES_STR.equals(Code = obj instanceof Number ? String.valueOf(((Number)obj).intValue()) : obj.toString())) {
                    handler.setResult((Object)0);
                    DnctChannelBoardActtion.this.getConfigFromEq();
                    if (playVoiceWhenSuccess) {
                        DnctChannelBoardActtion.this.play("\u97f3\u91cf:" + volumeValue);
                    }
                } else {
                    handler.setResult((Object)1);
                    ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", SetSysternParam \u64cd\u4f5c\u5931\u8d25! " + jsonMap));
                }
            }

            @Override
            public void Exception(int errType, Throwable ex) {
                handler.setException(ex);
            }
        });
        return handler;
    }

    private int getVolumeBytes(Volume volume) {
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume.getDayBeginHour() * 60 + volume.getDayBeginMins();
        int end = volume.getDayEndHour() * 60 + volume.getDayEndMins();
        boolean night = v < begin || v > end;
        int vk = night ? volume.getNightVolume() : volume.getDayVolume();
        int r = Math.round((float)vk / 100.0f * 10.0f);
        if (r <= 0) {
            r = 1;
        } else if (r > 10) {
            r = 10;
        }
        return r;
    }

    @Override
    public OperationFuture<Integer> setVolume(final Volume volume) {
        if (volume == null) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)1);
            return a;
        }
        OperationFuture<Integer> f = this.setVolume0(this.getVolumeBytes(volume), true);
        f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void operationComplete(OperationFuture<Integer> z) {
                if (z.getException() == null && z.getResult() != null && (Integer)z.getResult() == 0) {
                    DnctChannelBoardActtion.this.currentVolume = volume;
                }
            }

            public void waitCompleteTimeout() {
            }
        });
        return f;
    }

    @Override
    public OperationFuture<Integer> play(String text) {
        return this.play(text, null, null);
    }

    @Override
    public OperationFuture<Integer> play(String text, Integer volume, DynLoudspeakerAction.PlayFinishCallback finishCallback) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)1);
            return a;
        }
        if (this.getVoiceType() == 0 || text == null || text.length() == 0 || !this.canPlayVoice()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)0);
            return a;
        }
        Ax ax = this.getAx();
        if (ax != null) {
            ax.dynVoice = text;
            return ax.handler;
        }
        return this.doControlAction("0", "3", "3", "", text, "");
    }

    @Override
    public boolean isSurpportFinishCallback() {
        return false;
    }

    private int getVoiceType() {
        Integer a = this.equipment.getEquipmentConfig().getConfigIntValue("voice_type");
        if (a == null) {
            return 1;
        }
        return a;
    }

    @Override
    public OperationFuture<Integer> play(byte ... codes) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)1);
            return a;
        }
        if (this.getVoiceType() == 0 || !this.canPlayVoice() || codes == null || codes.length == 0) {
            OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
            a.setResult((Object)0);
            return a;
        }
        StringBuilder sbr = new StringBuilder();
        int i = 0;
        while (i < codes.length) {
            if (sbr.length() > 0) {
                sbr.append(',');
            }
            sbr.append(codes[i] & 0xFF);
            ++i;
        }
        String sTxt = String.valueOf(codes.length) + ":" + sbr.toString();
        Ax ax = this.getAx();
        if (ax != null) {
            ax.staticVoice = sTxt;
            return ax.handler;
        }
        return this.doControlAction("0", "3", "3", sTxt, "", "");
    }

    public void exceptionCaught(IoSession session, Throwable e) throws Exception {
        try {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": " + e.getMessage()));
        }
        finally {
            if (session != null && session.isConnected() && !session.isClosing()) {
                session.close(true);
            }
        }
    }

    public void messageReceived(IoSession session, Object message) throws Exception {
        BoardProtocol jsonProtocol;
        IoBuffer buf;
        if (message instanceof IoBuffer && (buf = (IoBuffer)message) != null && buf.hasRemaining() && (jsonProtocol = (BoardProtocol)session.getAttribute((Object)BoardProtocolName)) != null) {
            jsonProtocol.parse(session, buf, this);
        }
    }

    public void messageSent(IoSession session, Object message) throws Exception {
    }

    public void sessionClosed(IoSession session) throws Exception {
        ServiceLog.getLog().info((Object)("\u4e0e\u8bbe\u5907\uff1a" + this.equipment.getName() + "[" + this.equipment.getIp() + "] \u5931\u53bb\u8fde\u63a5 "));
    }

    public void sessionCreated(IoSession session) throws Exception {
    }

    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
    }

    public void sessionOpened(IoSession session) throws Exception {
    }

    private String getCharset() {
        return "GBK";
    }

    public void handleJson(IoSession session, byte[] data, int offset, int length) {
        Map jsonMap;
        String json;
        try {
            json = new String(data, offset, length, this.getCharset());
        }
        catch (Exception ex) {
            json = new String(data, offset, length);
        }
        try {
            jsonMap = (Map)ServiceUtil.getHtmlEscapingGson().fromJson(json, Map.class);
        }
        catch (Exception ex) {
            ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f\uff1a" + json));
            return;
        }
        try {
            Map dataMap;
            String Cmd = (String)jsonMap.get("Cmd");
            if (Cmd == null || Cmd.length() == 0) {
                Cmd = (String)jsonMap.get("ReCmd");
            }
            if (Cmd == null || Cmd.length() == 0) {
                ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(\u7f3a\u5c11Cmd\u6216ReCmd)\uff1a" + json));
                return;
            }
            Object MsgDataObj = jsonMap.get("MsgData");
            if (MsgDataObj == null) {
                ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(\u7f3a\u5c11MsgData)\uff1a" + json));
                return;
            }
            if (MsgDataObj instanceof String) {
                try {
                    String msgDataStr = (String)MsgDataObj;
                    if (msgDataStr.length() == 0) {
                        ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u7a7a)\uff1a" + json));
                        return;
                    }
                    if ("null".equalsIgnoreCase(msgDataStr)) {
                        ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u7a7a)\uff1a" + json));
                        return;
                    }
                    dataMap = (Map)ServiceUtil.getHtmlEscapingGson().fromJson(msgDataStr, Map.class);
                }
                catch (Exception ex) {
                    ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u9519\u8bef)\uff1a" + json));
                    return;
                }
            } else if (MsgDataObj instanceof Map) {
                dataMap = (Map)MsgDataObj;
            } else {
                ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u9519\u8bef)\uff1a" + json));
                return;
            }
            String MsgId = (String)dataMap.get("MsgId");
            if (MsgId == null || MsgId.length() == 0) {
                ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u9519\u8bef,\u7f3a\u5c11MsgId)\uff1a" + json));
                return;
            }
            this.lastRevMills = ServiceUtil.getServiceContext().currentTimeMillis();
            if (CMD_OnLineAction.equals(Cmd)) {
                this.handleOnLineAction(session, jsonMap, dataMap, MsgId);
            } else if (CMD_HeartBeat.equals(Cmd)) {
                this.handleHeartbeat(session, jsonMap, dataMap, MsgId);
            } else {
                WaitResultKey key = new WaitResultKey(session.getId(), Cmd, MsgId);
                SendEntry sendEntry = (SendEntry)ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)key);
                if (sendEntry == null) {
                    ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u6d88\u606f\uff1a" + json + ", \u65e0\u6cd5\u627e\u5230\u5339\u914d\u7684MsgId\u5904\u7406\u8005\uff0c\u53ef\u80fd\u8bf7\u6c42\u5df2\u8d85\u65f6\uff0c\u8fd9\u5c06\u4e22\u5f03\u6b64\u6d88\u606f"));
                } else if (sendEntry.action != null) {
                    sendEntry.action.onResult(session, jsonMap, dataMap, MsgId);
                }
            }
        }
        catch (Throwable ex) {
            ServiceLog.getLog().error((Object)("\u5904\u7406" + this.connectIp + "\u6d88\u606f\u5f02\u5e38\uff1a" + json), ex);
            return;
        }
    }

    @Deprecated
    public void handleJsonMessageMap(Map<?, ?> jsonMap, String json) {
        Map dataMap;
        String Cmd = (String)jsonMap.get("Cmd");
        if (Cmd == null || Cmd.length() == 0) {
            Cmd = (String)jsonMap.get("ReCmd");
        }
        if (Cmd == null || Cmd.length() == 0) {
            ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(\u7f3a\u5c11Cmd\u6216ReCmd)\uff1a" + json));
            return;
        }
        Object MsgDataObj = jsonMap.get("MsgData");
        if (MsgDataObj == null) {
            ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(\u7f3a\u5c11MsgData)\uff1a" + json));
            return;
        }
        if (MsgDataObj instanceof String) {
            try {
                String msgDataStr = (String)MsgDataObj;
                if (msgDataStr.length() == 0) {
                    ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u7a7a)\uff1a" + json));
                    return;
                }
                if ("null".equalsIgnoreCase(msgDataStr)) {
                    ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u7a7a)\uff1a" + json));
                    return;
                }
                dataMap = (Map)ServiceUtil.getHtmlEscapingGson().fromJson(msgDataStr, Map.class);
            }
            catch (Exception ex) {
                ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u9519\u8bef)\uff1a" + json));
                return;
            }
        } else if (MsgDataObj instanceof Map) {
            dataMap = (Map)MsgDataObj;
        } else {
            ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u9519\u8bef)\uff1a" + json));
            return;
        }
        String MsgId = (String)dataMap.get("MsgId");
        if (MsgId == null || MsgId.length() == 0) {
            ServiceLog.getLog().error((Object)("\u63a5\u6536\u5230" + this.connectIp + "\u4e00\u4e2a\u65e0\u6cd5\u5904\u7406\u7684\u6d88\u606f(MsgData\u9519\u8bef,\u7f3a\u5c11MsgId)\uff1a" + json));
            return;
        }
    }

    private String getSN() {
        String sn = this.equipment.getEquipmentConfig().getConfigValue("eq_serial_id");
        if (sn == null || sn.length() == 0) {
            sn = "1";
        }
        return sn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend(IoSession session, String cmd, String msgId, Object MsgData, long waitResponseMills, ControllAction action) {
        LinkedList<SendEntry> linkedList = this.sendList;
        synchronized (linkedList) {
            SendEntry sendEntry = new SendEntry(session, MsgData, cmd, action, msgId, waitResponseMills);
            this.sendList.offer(sendEntry);
        }
        this.trySend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySend() {
        SendEntry s = null;
        LinkedList<SendEntry> linkedList = this.sendList;
        synchronized (linkedList) {
            if (!this.sending && !this.sendList.isEmpty() && (s = this.sendList.poll()) != null) {
                this.sending = true;
            }
        }
        if (s != null) {
            s.doSend().addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(OperationFuture<Boolean> f) {
                    LinkedList linkedList = DnctChannelBoardActtion.this.sendList;
                    synchronized (linkedList) {
                        DnctChannelBoardActtion.this.sending = false;
                    }
                    DnctChannelBoardActtion.this.trySend();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void waitCompleteTimeout() {
                    LinkedList linkedList = DnctChannelBoardActtion.this.sendList;
                    synchronized (linkedList) {
                        DnctChannelBoardActtion.this.sending = false;
                    }
                    DnctChannelBoardActtion.this.trySend();
                }
            });
        }
    }

    private String newMsgId() {
        return String.valueOf(ServiceUtil.getServiceContext().createLongSeq());
    }

    private void onIoStatus(IoStatus ioStatusNew) {
        IoStatus ioStatus0 = this.ioStatus;
        this.ioStatus = ioStatusNew;
        if (ioStatus0 != null) {
            ioStatusNew.equals(ioStatus0);
        }
    }

    private void onReadCardNumber(int index, String cardNo) {
        String passportNumber = ServiceUtil.getPassportNumber(cardNo);
        DetectedPassEvent event = new DetectedPassEvent(this.equipment, passportNumber, DetectedPassEvent.MediaType.ID);
        String channelNo = this.getReadChannelNo(index);
        PassChannel passChannel = ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo);
        if (passChannel != null && passChannel.getLanConnectManageHostState() != null) {
            return;
        }
        if (channelNo == null || channelNo.length() == 0) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u4e22\u5f03\u5361\u53f7\uff1a" + cardNo + ", \u65e0\u6cd5\u627e\u5230\u8bfb\u5934" + index + "\u5bf9\u5e94\u7684\u8f66\u9053"));
            return;
        }
        if (ServiceUtil.getServiceContext().getPassChannelManager().getPassChannel(channelNo) == null) {
            ServiceLog.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u4e22\u5f03\u5361\u53f7\uff1a" + cardNo + ", \u65e0\u6cd5\u627e\u5230\u8bfb\u5934" + index + "\u5bf9\u5e94\u7684\u8f66\u9053\uff0c\u7ed1\u5b9a\u7684\u8f66\u9053\u4e0d\u5c5e\u4e8e\u672c\u673a\u7ba1\u7406"));
            return;
        }
        boolean isLongDistance = Constants.YES_STR.equals(this.equipment.getEquipmentConfig().getConfigValue("wg" + index + "_type"));
        event.setLongDistance(isLongDistance);
        event.setChannelNo(channelNo);
        ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(event);
    }

    String getReadChannelNo(int readIndex) {
        List<String> list = this.equipment.getChannelNos();
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public void handleOnLineAction(IoSession session, Map<?, ?> jsonMap, Map<?, ?> MsgData, final String MsgId) {
        String Wg2_CardId;
        try {
            byte[] sendBytes;
            LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>();
            responseMap.put("Code", "1");
            responseMap.put("Timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
            responseMap.put("ReCmd", CMD_OnLineAction);
            LinkedHashMap<String, String> responseMsgData = new LinkedHashMap<String, String>();
            responseMap.put("MsgData", responseMsgData);
            responseMsgData.put("Relay1Action", "3");
            responseMsgData.put("Relay2Action", "3");
            responseMsgData.put("Combined_Voice", "");
            responseMsgData.put("Multi_Voice", "");
            responseMsgData.put("Led_Dis", "");
            responseMsgData.put("MsgId", MsgId);
            responseMsgData.put("Msg", "Success");
            String sendJson = ServiceUtil.getHtmlEscapingGson().toJson(responseMsgData);
            try {
                sendBytes = sendJson.getBytes(this.getCharset());
            }
            catch (Exception ex) {
                sendBytes = sendJson.getBytes();
            }
            int sendLength = sendBytes.length + 4;
            IoBuffer buf = IoBuffer.allocate((int)sendLength);
            buf.putInt(sendBytes.length);
            buf.put(sendBytes);
            buf.flip();
            WriteFuture wf = session.write((Object)buf);
            wf.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                public void operationComplete(WriteFuture s) {
                    if (s.getException() != null) {
                        try {
                            if (s.getSession() != null && s.getSession().isConnected()) {
                                s.getSession().close(true);
                            }
                        }
                        finally {
                            ServiceLog.getLog().warn((Object)("\u5411\u8bbe\u5907\uff1a" + DnctChannelBoardActtion.this.connectIp + "\u56de\u590d OnLineAction \u6307\u4ee4\u5f02\u5e38\uff01MsgId\uff1a" + MsgId));
                        }
                    }
                }
            });
        }
        catch (Exception ex) {
            ServiceLog.getLog().info((Object)("\u56de\u590d OnLineAction \u6307\u4ee4\u5f02\u5e38\uff01MsgId\uff1a" + MsgId), (Throwable)ex);
        }
        String Wg1_CardId = (String)MsgData.get("Wg1_CardId");
        if (Wg1_CardId != null && Wg1_CardId.length() > 0) {
            this.onReadCardNumber(1, Wg1_CardId);
        }
        if ((Wg2_CardId = (String)MsgData.get("Wg2_CardId")) != null && Wg2_CardId.length() > 0) {
            this.onReadCardNumber(2, Wg2_CardId);
        }
        IoStatus ioStatusNew = new IoStatus().setIo(MsgData);
        this.onIoStatus(ioStatusNew);
    }

    public void handleHeartbeat(IoSession session, Map<?, ?> jsonMap, Map<?, ?> MsgData, String MsgId) {
        IoStatus ioStatusNew = new IoStatus().setIo(MsgData);
        this.onIoStatus(ioStatusNew);
    }

    private void sendHeartBeat() {
        IoSession session = this.iosession;
        if (session == null || !session.isConnected()) {
            return;
        }
        String Cmd = CMD_HeartBeat;
        String MsgId = this.newMsgId();
        LinkedHashMap<String, String> MsgData = new LinkedHashMap<String, String>();
        MsgData.put("MsgId", MsgId);
        this.doSend(session, Cmd, MsgId, MsgData, 5000L, null);
    }

    @Override
    public boolean isConnGround(String channelNo) {
        String channelNo1;
        String channelNo12;
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        String input_io1_value = this.equipment.getEquipmentConfig().getConfigValue("input_io1");
        if ("1".equals(input_io1_value) && (channelNo12 = this.getReadChannelNo(1)) != null && channelNo12.length() > 0 && channelNo12.equals(channelNo)) {
            return true;
        }
        String input_io2_value = this.equipment.getEquipmentConfig().getConfigValue("input_io2");
        return "2".equals(input_io2_value) && (channelNo1 = this.getReadChannelNo(2)) != null && channelNo1.length() > 0 && channelNo1.equals(channelNo);
    }

    @Override
    public boolean isGroundPressure(String channelNo) {
        IoStatus ioStatus0;
        String channelNo1;
        IoStatus ioStatus02;
        String channelNo12;
        if (!this.isWorkingProperly()) {
            return false;
        }
        if (channelNo == null || channelNo.length() == 0) {
            return false;
        }
        String input_io1_value = this.equipment.getEquipmentConfig().getConfigValue("input_io1");
        if ("1".equals(input_io1_value) && (channelNo12 = this.getReadChannelNo(1)) != null && channelNo12.length() > 0 && channelNo12.equals(channelNo) && (ioStatus02 = this.ioStatus) != null && ioStatus02.inIo1Value == 0) {
            return true;
        }
        String input_io2_value = this.equipment.getEquipmentConfig().getConfigValue("input_io2");
        return "2".equals(input_io2_value) && (channelNo1 = this.getReadChannelNo(2)) != null && channelNo1.length() > 0 && channelNo1.equals(channelNo) && (ioStatus0 = this.ioStatus) != null && ioStatus0.inIo2Value == 0;
    }

    private int getEqConfigIntValue(Map<?, ?> eqConfig, String name, int defualtV) {
        Object obj;
        if (eqConfig != null && (obj = eqConfig.get(name)) != null) {
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            try {
                String a = obj.toString();
                if (a != null && a.length() > 0) {
                    return Integer.parseInt(a);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defualtV;
    }

    @Override
    public OperationFuture<Integer> setSerialIfNeed(Map<String, Object> param) {
        int baudRate1;
        if (param == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570"));
            return xf;
        }
        Object baudRate0 = param.get("baudRate");
        if (baudRate0 == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setException((Throwable)new Exception("\u7f3a\u5c11\u53c2\u6570baudRate"));
            return xf;
        }
        if (baudRate0 instanceof Number) {
            baudRate1 = ((Number)baudRate0).intValue();
        } else {
            try {
                baudRate1 = Integer.parseInt(baudRate0.toString());
            }
            catch (Exception ex) {
                OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
                xf.setException((Throwable)new Exception("\u53c2\u6570baudRate\u5fc5\u987b\u662f\u6574\u6570"));
                return xf;
            }
        }
        int baudRate = baudRate1;
        Map<?, ?> eqConfig = this.eqConfig;
        if (eqConfig == null) {
            OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
            xf.setResult((Object)1);
            return xf;
        }
        Object BaudRata = eqConfig.get("BaudRata");
        int br = -1;
        if (BaudRata != null) {
            if (BaudRata instanceof Number) {
                br = ((Number)BaudRata).intValue();
            } else {
                try {
                    String z = BaudRata.toString();
                    if (z.length() > 0) {
                        br = Integer.parseInt(z);
                    }
                }
                catch (Exception z) {
                    // empty catch block
                }
            }
        }
        if (br != baudRate) {
            IoSession session = this.iosession;
            if (session == null || !session.isConnected()) {
                OperationFutureHandler a = ServiceUtil.getServiceContext().createOperationFuture();
                a.setResult((Object)1);
                return a;
            }
            String Cmd = "SetSysternParam";
            String MsgId = this.newMsgId();
            LinkedHashMap<String, String> MsgData = new LinkedHashMap<String, String>();
            MsgData.put("BaudRata", String.valueOf(baudRate));
            MsgData.put("MsgId", MsgId);
            final OperationFutureHandler handler = ServiceUtil.getServiceContext().createOperationFuture();
            this.doSend(session, Cmd, MsgId, MsgData, 5000L, new ControllAction(){

                @Override
                public void onResult(IoSession session, Map<?, ?> jsonMap, Map<?, ?> MsgData, String MsgId) {
                    String Code;
                    Object obj = jsonMap.get("Code");
                    if (obj == null) {
                        ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", SetSysternParam \u6ce2\u7279\u7387\u8fd4\u56de\u7f3a\u5c11Code! " + jsonMap));
                    }
                    if (Constants.YES_STR.equals(Code = obj instanceof Number ? String.valueOf(((Number)obj).intValue()) : obj.toString())) {
                        handler.setResult((Object)0);
                        DnctChannelBoardActtion.this.getConfigFromEq();
                    } else {
                        handler.setResult((Object)1);
                        ServiceLog.getLog().error((Object)("\u8bbe\u5907: " + DnctChannelBoardActtion.this.equipment.getIp() + ", SetSysternParam \u6ce2\u7279\u7387\u64cd\u4f5c\u5931\u8d25! " + jsonMap));
                    }
                }

                @Override
                public void Exception(int errType, Throwable ex) {
                    handler.setException(ex);
                }
            });
            return handler;
        }
        OperationFutureHandler xf = ServiceUtil.getServiceContext().createOperationFuture();
        xf.setResult((Object)0);
        return xf;
    }

    @Override
    public <R> OperationFuture<R> sendHaveResponseRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        if (handler == null) {
            f.setException((Throwable)new NullPointerException("ReceiveDataHandler \u4e0d\u80fd\u4e3a\u7a7a"));
            return f;
        }
        return this.sendRS485Data(portIndex, data, handler, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data) {
        return this.sendRS485Data(portIndex, data, null, 0L);
    }

    @Override
    public OperationFuture<Integer> sendNoResponseRS485Data(int portIndex, byte[] data, long waitMills) {
        return this.sendRS485Data(portIndex, data, null, waitMills);
    }

    private <R> OperationFuture<R> sendRS485Data(int portIndex, byte[] data, ReceiveDataHandler<R> handler, long waitMills) {
        if (data == null || data.length == 0) {
            OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
            f.setException((Throwable)new RuntimeException("\u53d1\u9001\u6570\u636e\u4e3a\u7a7a!"));
            return f;
        }
        Ax ax = this.getAx();
        if (ax != null) {
            if (ax.rs485Data == null) {
                ax.rs485Data = new LinkedList<byte[]>();
            }
            ax.rs485Data.add(data);
            return ax.handler;
        }
        return this.doControlAction("0", "3", "3", "", "", BytesTool.byteArrayToHexString((byte[])data));
    }

    @Override
    public StaticLoudSpeakerServiceAction getStaticLoudSpeakerServiceAction() {
        if (staticLoudSpeakerServiceAction == null) {
            staticLoudSpeakerServiceAction = new StaticLoudSpeakerServiceActionE0();
        }
        return staticLoudSpeakerServiceAction;
    }

    private Ax getAx() {
        Collection<PassSuccessFilter.PassSuccessFilterInterceptor> collections = PassSuccessFilter.InterceptorsLocal.get();
        if (collections == null) {
            return null;
        }
        for (PassSuccessFilter.PassSuccessFilterInterceptor l : collections) {
            if (!(l instanceof Ax)) continue;
            return (Ax)l;
        }
        Ax ax = new Ax();
        collections.add(ax);
        return ax;
    }

    private class Ax
    implements PassSuccessFilter.PassSuccessFilterInterceptor {
        OperationFutureHandler<Integer> handler = ServiceUtil.getServiceContext().createOperationFuture();
        boolean openGate;
        List<byte[]> rs485Data;
        String dynVoice;
        String staticVoice;

        @Override
        public void doFilterNext(PassSession session) {
            boolean needSend = false;
            String RemoteAction = "0";
            String Relay1Action = "3";
            String Relay2Action = "3";
            String Combined_Voice = "";
            String Multi_Voice = "";
            String Led_Dis = "";
            if (this.openGate) {
                needSend = true;
                EquipmentConfig config = DnctChannelBoardActtion.this.equipment.getEquipmentConfig();
                Integer openIo = config.getConfigIntValue("roadGateIO");
                if (openIo == null) {
                    openIo = 0;
                }
                if (openIo == 0) {
                    Relay1Action = "1";
                } else {
                    Relay2Action = "1";
                }
            }
            if (this.staticVoice != null && this.staticVoice.length() > 0) {
                Combined_Voice = this.staticVoice;
                needSend = true;
            }
            if (this.dynVoice != null && this.dynVoice.length() > 0) {
                Multi_Voice = this.dynVoice;
                needSend = true;
            }
            OperationFuture<Integer> f = null;
            if (needSend) {
                f = DnctChannelBoardActtion.this.doControlAction(RemoteAction, Relay1Action, Relay2Action, Combined_Voice, Multi_Voice, Led_Dis);
            }
            OperationFuture<Integer> f1 = null;
            if (this.rs485Data != null && !this.rs485Data.isEmpty()) {
                for (byte[] d : this.rs485Data) {
                    if (d == null || d.length <= 0) continue;
                    f = DnctChannelBoardActtion.this.doControlAction("0", "3", "3", "", "", BytesTool.byteArrayToHexString((byte[])d));
                }
            }
            if (f == null) {
                f = f1;
            }
            if (f == null) {
                this.handler.setResult((Object)0);
            } else {
                f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void operationComplete(OperationFuture<Integer> z) {
                        if (z.isCancelled()) {
                            Ax.this.handler.cancel(true);
                        } else if (z.getException() != null) {
                            Ax.this.handler.setException(z.getException());
                        } else {
                            Ax.this.handler.setResult((Object)((Integer)z.getResult()));
                        }
                    }

                    public void waitCompleteTimeout() {
                        Ax.this.handler.setException((Throwable)new TimeoutException());
                    }
                });
            }
        }
    }

    public static class BoardProtocol {
        private static final int WAIT_LENGTH = 0;
        private static final int WAIT_DATTA = 1;
        private static int maxLength = 102400;
        private byte[] dataBuf = new byte[8192];
        private int state = 0;
        private volatile int offset;
        private volatile int length;
        private volatile long lockMills;
        private volatile long beignDataMills;

        public synchronized void parse(IoSession session, IoBuffer buf, DnctChannelBoardActtion action) {
            if (buf == null) {
                return;
            }
            if (this.lockMills > 0L) {
                if (ServiceUtil.getServiceContext().currentTimeMillis() < this.lockMills) {
                    return;
                }
                this.lockMills = 0L;
            }
            if (this.beignDataMills > 0L && ServiceUtil.getServiceContext().currentTimeMillis() - this.beignDataMills > 2000L) {
                ServiceLog.getLog().warn((Object)("\u51fa\u73b0" + action.connectIp + "\u4e22\u5305\uff0c\u4e4b\u524d\u7684\u6570\u636e\u4e22\u5f03\uff01" + BytesTool.byteArrayToHexString((byte[])this.dataBuf, (int)0, (int)this.offset)));
                this.offset = 0;
                this.length = 0;
                this.state = 0;
                this.beignDataMills = 0L;
            }
            block6: while (buf.hasRemaining()) {
                byte b = buf.get();
                switch (this.state) {
                    case 0: {
                        if (this.offset == 0) {
                            this.beignDataMills = ServiceUtil.getServiceContext().currentTimeMillis();
                        }
                        this.dataBuf[this.offset++] = b;
                        if (this.offset != 4) continue block6;
                        this.length = BytesTool.bytesToInt((byte[])this.dataBuf, (int)0);
                        if (this.length > maxLength) {
                            this.offset = 0;
                            this.length = 0;
                            this.state = 0;
                            this.beignDataMills = 0L;
                            this.lockMills = ServiceUtil.getServiceContext().currentTimeMillis() + 2000L;
                            ServiceLog.getLog().warn((Object)("\u63a5\u6536\u5230" + action.connectIp + "\u6570\u636e\u957f\u5ea6\uff1a" + this.length + ", \u8d85\u51fa\u7f13\u51b2\u533a\u6570\u636e\uff0c\u8fd9\u5c06\u4e22\u5f03\u540e\u9762\u7684\u6570\u636e! "));
                            return;
                        }
                        if (this.length <= 0) {
                            this.offset = 0;
                            this.length = 0;
                            this.state = 0;
                            this.beignDataMills = 0L;
                            this.lockMills = ServiceUtil.getServiceContext().currentTimeMillis() + 2000L;
                            ServiceLog.getLog().warn((Object)("\u63a5\u6536\u5230" + action.connectIp + "\u6570\u636e\u957f\u5ea6\uff1a" + this.length + ", \u8fd9\u5c06\u4e22\u5f03\u540e\u9762\u7684\u6570\u636e! "));
                            return;
                        }
                        if (this.length > this.dataBuf.length) {
                            byte[] data009 = new byte[this.length];
                            System.arraycopy(this.dataBuf, 0, data009, 0, 4);
                            this.dataBuf = data009;
                        }
                        this.state = 1;
                        break;
                    }
                    case 1: {
                        this.dataBuf[this.offset++] = b;
                        if (this.offset != this.length + 4) continue block6;
                        try {
                            action.handleJson(session, this.dataBuf, 4, this.length);
                        }
                        catch (Throwable ex) {
                            ServiceLog.getLog().error((Object)"\u5904\u7406\u5f02\u5e38", ex);
                        }
                        this.offset = 0;
                        this.length = 0;
                        this.state = 0;
                        this.beignDataMills = 0L;
                        break;
                    }
                    default: {
                        this.offset = 0;
                        this.length = 0;
                        this.state = 0;
                        this.lockMills = ServiceUtil.getServiceContext().currentTimeMillis() + 2000L;
                        this.beignDataMills = 0L;
                        return;
                    }
                }
            }
        }
    }

    private static interface ControllAction {
        public void onResult(IoSession var1, Map<?, ?> var2, Map<?, ?> var3, String var4);

        public void Exception(int var1, Throwable var2);
    }

    private static class IoStatus {
        private int inIo1Value = -1;
        private int inIo2Value = -1;
        private int inIo3Value = -1;
        private int outIo1Value = -1;
        private int outIo2Value = -1;

        private IoStatus() {
        }

        public IoStatus setIo(Map<?, ?> MsgData) {
            if (MsgData == null || MsgData.isEmpty()) {
                return this;
            }
            this.inIo1Value = this.getValue(MsgData, "IN1Stata");
            this.inIo2Value = this.getValue(MsgData, "IN2Stata");
            this.inIo3Value = this.getValue(MsgData, "IN3Stata");
            this.outIo1Value = this.getValue(MsgData, "Relay1Stata");
            this.outIo2Value = this.getValue(MsgData, "Relay2Stata");
            return this;
        }

        private int getValue(Map<?, ?> map, String key) {
            Object obj = map.get(key);
            if (obj == null) {
                return -1;
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            String lx = obj.toString();
            if (lx.length() == 0) {
                return -1;
            }
            try {
                return Integer.parseInt(lx);
            }
            catch (Exception exception) {
                return -1;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.inIo1Value;
            result = 31 * result + this.inIo2Value;
            result = 31 * result + this.inIo3Value;
            result = 31 * result + this.outIo1Value;
            result = 31 * result + this.outIo2Value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IoStatus other = (IoStatus)obj;
            if (this.inIo1Value != other.inIo1Value) {
                return false;
            }
            if (this.inIo2Value != other.inIo2Value) {
                return false;
            }
            if (this.inIo3Value != other.inIo3Value) {
                return false;
            }
            if (this.outIo1Value != other.outIo1Value) {
                return false;
            }
            return this.outIo2Value == other.outIo2Value;
        }
    }

    private class SendEntry
    implements TimeoutObjectPool.TimeoutCallback {
        IoSession session;
        Object MsgData;
        String cmd;
        ControllAction action;
        String msgId;
        long waitResponseMills;
        Object waritKey;
        OperationFutureHandler<Boolean> sendHandler;
        String sendJson;

        public SendEntry(IoSession session, Object MsgData, String cmd, ControllAction action, String msgId, long waitResponseMills) {
            this.session = session;
            this.MsgData = MsgData;
            this.cmd = cmd;
            this.action = action;
            this.msgId = msgId;
            if (waitResponseMills < 1000L) {
                waitResponseMills = 1000L;
            }
            this.waitResponseMills = waitResponseMills;
        }

        OperationFuture<Boolean> doSend() {
            block9: {
                if (this.sendHandler != null) {
                    return this.sendHandler;
                }
                this.sendHandler = ServiceUtil.getServiceContext().createOperationFuture();
                try {
                    byte[] sendBytes;
                    if (this.session == null || !this.session.isConnected()) {
                        this.sendHandler.setResult((Object)Boolean.FALSE);
                        if (this.action != null) {
                            this.action.Exception(0, new IOException("\u672a\u8fde\u63a5"));
                        }
                        break block9;
                    }
                    LinkedHashMap<String, Object> sendMap = new LinkedHashMap<String, Object>();
                    sendMap.put("SN", DnctChannelBoardActtion.this.getSN());
                    sendMap.put("Timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
                    sendMap.put("Cmd", this.cmd);
                    if (this.MsgData != null) {
                        sendMap.put("MsgData", this.MsgData);
                    }
                    this.sendJson = ServiceUtil.getHtmlEscapingGson().toJson(sendMap);
                    if (this.action != null) {
                        this.waritKey = new WaitResultKey(this.session.getId(), this.cmd, this.msgId);
                        ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject(this.waritKey, (Object)this, (TimeoutObjectPool.TimeoutCallback)this, this.waitResponseMills, TimeUnit.MILLISECONDS);
                    }
                    try {
                        sendBytes = this.sendJson.getBytes(DnctChannelBoardActtion.this.getCharset());
                    }
                    catch (Exception ex) {
                        sendBytes = this.sendJson.getBytes();
                    }
                    int sendLength = sendBytes.length + 4;
                    IoBuffer buf = IoBuffer.allocate((int)sendLength);
                    buf.putInt(sendBytes.length);
                    buf.put(sendBytes);
                    buf.flip();
                    WriteFuture wf = this.session.write((Object)buf);
                    wf.addListener((IoFutureListener)new IoFutureListener<WriteFuture>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void operationComplete(WriteFuture s) {
                            if (s.getException() != null) {
                                try {
                                    if (!SendEntry.this.session.isConnected()) return;
                                    SendEntry.this.session.close(true);
                                    return;
                                }
                                finally {
                                    try {
                                        SendEntry.this.sendHandler.setException(s.getException());
                                    }
                                    finally {
                                        if (SendEntry.this.waritKey != null && SendEntry.this.action != null && ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(SendEntry.this.waritKey) != null) {
                                            SendEntry.this.action.Exception(0, s.getException());
                                        }
                                    }
                                }
                            }
                            try {
                                ServiceUtil.getServiceContext().getScheduledExecutorService().schedule(new Runnable(){

                                    @Override
                                    public void run() {
                                        (this).SendEntry.this.sendHandler.setResult((Object)Boolean.TRUE);
                                    }
                                }, 100L, TimeUnit.MILLISECONDS);
                                return;
                            }
                            catch (Exception ex) {
                                SendEntry.this.sendHandler.setResult((Object)Boolean.TRUE);
                            }
                        }
                    });
                }
                catch (Throwable ex) {
                    this.sendHandler.setException(ex);
                    if (this.waritKey == null || this.action == null || ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject(this.waritKey) == null) break block9;
                    this.action.Exception(0, ex);
                }
            }
            return this.sendHandler;
        }

        public void onTimeout(Object key, Object value) throws Exception {
            if (this.action != null) {
                this.action.Exception(1, new TimeoutException("Wait response timeout"));
            }
            ServiceLog.getLog().warn((Object)("\u53d1\u9001\uff1a " + this.sendJson + ", \u65e0\u54cd\u5e94"));
        }
    }

    private static class WaitResultKey {
        private long sessionId;
        private String cmd;
        private String msgId;

        public WaitResultKey(long sessionId, String cmd, String msgId) {
            this.sessionId = sessionId;
            this.cmd = cmd;
            this.msgId = msgId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cmd == null ? 0 : this.cmd.hashCode());
            result = 31 * result + (this.msgId == null ? 0 : this.msgId.hashCode());
            result = 31 * result + (int)(this.sessionId ^ this.sessionId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WaitResultKey other = (WaitResultKey)obj;
            if (this.cmd == null ? other.cmd != null : !this.cmd.equals(other.cmd)) {
                return false;
            }
            if (this.msgId == null ? other.msgId != null : !this.msgId.equals(other.msgId)) {
                return false;
            }
            return this.sessionId == other.sessionId;
        }
    }
}

