/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.Constants;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.PacketHandleEquipmentAction;
import com.wovoe.carpark.equipment.action.CameraUartAction;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.action.CarparkLoudspeakerAction;
import com.wovoe.carpark.equipment.action.DynLoudspeakerAction;
import com.wovoe.carpark.equipment.action.ReceiveDataHandler;
import com.wovoe.carpark.equipment.driver.DnctChannelDisplayDriver;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.carpark.service.ApplicationService;
import com.wovoe.carpark.vo.Volume;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DnctChannelDisplayAction
extends PacketHandleEquipmentAction
implements CarChannelDisplayAction,
DynLoudspeakerAction,
EquipmentConfigChanngedListener {
    private ScheduledFuture<?> shedule;
    private boolean checkSeriaSetingok = false;
    private volatile long receiveheardbeatTimemills;
    private AtomicInteger seq = new AtomicInteger(0);
    private static final int MAX_SEQ = 0xFFFFFF;
    private long nextExeSynTimeMills;
    private long watitSendMills = 80L;
    private volatile long redLightMills;
    private final Object lightLock = new Object();
    private Volume currentVolume;
    private Object displayLock = new Object();
    private Hashtable<Integer, Long> dispLayInfoTimeTable = new Hashtable();
    private volatile boolean setSaoMiaoF;
    private volatile byte[] saoMiaoData;
    private volatile Map<String, String> adMap;
    private volatile int currentDisplayCount;
    private ReceiveDataHandler<Integer> rReceiveDataHandler = new ReceiveDataHandler<Integer>(){
        int result;

        @Override
        public boolean handleData(byte[] data, int offset, int len) {
            DnctChannelDisplayAction.this.receiveheardbeatTimemills = ServiceUtil.getServiceContext().currentTimeMillis();
            return true;
        }

        @Override
        public Integer getResponseResult() {
            return this.result;
        }
    };

    public DnctChannelDisplayAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    private boolean canPlayVoice() {
        Volume volume0 = this.currentVolume;
        if (volume0 == null) {
            return true;
        }
        Calendar cl = Calendar.getInstance();
        int hour = cl.get(11);
        int min = cl.get(12);
        int v = hour * 60 + min;
        int begin = volume0.getDayBeginHour() * 60 + volume0.getDayBeginMins();
        int end = volume0.getDayEndHour() * 60 + volume0.getDayEndMins();
        boolean night = v < begin || v > end;
        return !(night ? volume0.getNightVolume() == 0 : volume0.getDayVolume() == 0);
    }

    synchronized void stop() {
        if (this.shedule != null) {
            this.shedule.cancel(true);
        }
        this.equipment.removeEquipmentConfigChanngedListener(this);
    }

    synchronized void start() {
        if (this.shedule != null && !this.shedule.isCancelled()) {
            this.shedule.cancel(true);
        }
        this.shedule = ServiceUtil.getServiceContext().schedule(new JobTask(){

            protected void doRun() throws Exception {
                try {
                    DnctChannelDisplayAction.this.connectIfNotConnected1();
                }
                catch (Throwable ex) {
                    ServiceLog.getLog().error((Object)("\u8fde\u63a5\u663e\u793a\u5c4f[" + DnctChannelDisplayAction.this.equipment.getName() + "]\u5f02\u5e38"), ex);
                }
            }
        }, 2000L, 3500L, TimeUnit.MILLISECONDS);
        this.equipment.addEquipmentConfigChanngedListener(this);
    }

    protected CameraUartAction getWorkingCameraUartAction() {
        Object action = this.getParentEquipmentAction();
        if (action != null && action instanceof CameraUartAction && action.isWorkingProperly()) {
            return (CameraUartAction)action;
        }
        return null;
    }

    protected boolean isSupportHeartbeat() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String v = config.getConfigValue("support_heartbeat");
        boolean notSuport = v != null && Constants.NO_STR.equals(v);
        return !notSuport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSeq() {
        int h = this.seq.incrementAndGet();
        if (h >= 0xFFFFFF) {
            AtomicInteger atomicInteger = this.seq;
            synchronized (atomicInteger) {
                if (this.seq.get() >= 0xFFFFFF) {
                    this.seq.set(0);
                }
                h = this.seq.incrementAndGet();
            }
        }
        return h;
    }

    private byte[] toSendBytes(byte cmd, byte[] data) {
        return DnctChannelDisplayAction.toSendBytes(this.getSeq(), cmd, data);
    }

    private static byte[] toSendBytes(int sendSeq, byte cmd, byte[] data) {
        int dataLen;
        if (data == null) {
            dataLen = 0;
        } else {
            dataLen = data.length;
            if (dataLen > 245) {
                dataLen = 245;
            }
        }
        byte[] sendData = new byte[dataLen + 9];
        int index = 0;
        sendData[index++] = -86;
        sendData[index++] = 85;
        sendData[index++] = (byte)(sendSeq >> 16);
        sendData[index++] = (byte)(sendSeq >> 8);
        sendData[index++] = (byte)sendSeq;
        sendData[index++] = 58;
        byte DL = (byte)(dataLen + 2);
        sendData[index++] = DL;
        sendData[index++] = cmd;
        if (dataLen > 0) {
            System.arraycopy(data, 0, sendData, index, dataLen);
            index += dataLen;
        }
        int xor = cmd;
        if (dataLen > 0) {
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                xor ^= b;
                ++n2;
            }
        }
        sendData[index++] = (byte)xor;
        return sendData;
    }

    protected int getUatIndex() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer uatIndex = config.getConfigIntValue("uatIndex");
        if (uatIndex == null) {
            uatIndex = 0;
        }
        return uatIndex;
    }

    private byte[] createConfigData() {
        byte st = this.isVerticalScreen() ? (byte)1 : 0;
        byte[] byArray = new byte[4];
        byArray[0] = (byte)this.getDislaySaoCount();
        byArray[1] = st;
        byArray[2] = (byte)this.getDislayModuleCount();
        byte[] saoMiaoData0 = byArray;
        return saoMiaoData0;
    }

    private Integer getCurrentConfigMapIntValue(String key) {
        if (key == null) {
            return null;
        }
        String vx = this.getCurrentConfigMap().get(key);
        if (vx == null || vx.length() == 0) {
            return null;
        }
        try {
            return Integer.valueOf(vx);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private Map<String, String> getCurrentConfigMap() {
        Map<String, String> m;
        String display_type_style = this.equipment.getEquipmentConfig().getConfigValue("display_type_style");
        if (display_type_style == null || display_type_style.length() == 0) {
            display_type_style = "0";
        }
        if ((m = DnctChannelDisplayDriver.getConfigMap().get(display_type_style)) == null) {
            m = DnctChannelDisplayDriver.getConfigMap().get("0");
        }
        if (m == null) {
            m = Collections.EMPTY_MAP;
        }
        return m;
    }

    private int getDislaySaoCount() {
        Integer sa = this.getCurrentConfigMapIntValue("display_sao");
        if (sa == null) {
            sa = 1;
        }
        if (sa < 0 || sa > 2) {
            sa = 1;
        }
        return sa;
    }

    private int getDislayModuleCount() {
        Integer mo = this.getCurrentConfigMapIntValue("display_mozu");
        if (mo == null) {
            mo = 1;
        }
        if (mo < 1 || mo > 2) {
            mo = 1;
        }
        return mo;
    }

    private void checkAndSetConfigData() {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            return;
        }
        if (!this.isWorkingProperly()) {
            return;
        }
        byte[] saoMiaoData0 = this.saoMiaoData;
        final byte[] data = this.createConfigData();
        if (saoMiaoData0 == null || this.setSaoMiaoF || !Arrays.equals(saoMiaoData0, data)) {
            this.adMap = null;
            this.nextExeSynTimeMills = 0L;
            byte[] fBytes = this.toSendBytes((byte)11, data);
            action.sendNoResponseRS485Data(this.getUatIndex(), fBytes, this.watitSendMills).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void operationComplete(OperationFuture<Integer> f) {
                    if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                        DnctChannelDisplayAction.this.setSaoMiaoF = false;
                        DnctChannelDisplayAction.this.saoMiaoData = data;
                    }
                }

                public void waitCompleteTimeout() {
                }
            });
        }
    }

    private void delAd() {
        int displayCcount = this.getDisplayCount();
        boolean vertical = this.isVerticalScreen();
        if (displayCcount < 2) {
            displayCcount = 2;
        } else if (displayCcount > 4) {
            displayCcount = 4;
        }
        int modeCount = this.getDislayModuleCount();
        if (displayCcount == 4 && vertical && modeCount == 2) {
            displayCcount = 5;
        }
        int i = displayCcount;
        while (i < 8) {
            this.deleteAd(i);
            ++i;
        }
    }

    private Map<String, String> getAdMap() {
        LinkedHashMap<String, String> aMap = new LinkedHashMap<String, String>();
        int displayCcount = this.getDisplayCount();
        boolean vertical = this.isVerticalScreen();
        if (displayCcount < 2) {
            displayCcount = 2;
        } else if (displayCcount > 4) {
            displayCcount = 4;
        }
        int modeCount = this.getDislayModuleCount();
        if (displayCcount == 4 && vertical && modeCount == 2) {
            displayCcount = 5;
        }
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        int i = 1;
        while (i <= displayCcount) {
            block91: {
                int YEN;
                int YST;
                int XEN;
                int XST;
                byte[] sendText;
                String adText;
                int cmd;
                int colorType;
                int actionType;
                block90: {
                    int freeType;
                    block89: {
                        if (i < 5) {
                            Integer actionType0;
                            Integer freeType0;
                            if (this.equipment.getUse() == 1) {
                                freeType0 = config.getConfigIntValue("display_position_" + i + "_free_type");
                                freeType = freeType0 == null ? 1 : freeType0;
                                actionType0 = config.getConfigIntValue("display_position_" + i + "_action");
                                actionType = actionType0 != null ? actionType0 : 3;
                                Integer colorType0 = config.getConfigIntValue("display_position_" + i + "_color");
                                colorType = colorType0 != null ? colorType0 : 2;
                            } else {
                                freeType0 = config.getConfigIntValue("display_position_" + i + "_type");
                                freeType = freeType0 == null ? 2 : freeType0;
                                actionType0 = config.getConfigIntValue("display_position_" + i + "_action1");
                                actionType = actionType0 != null ? actionType0 : 3;
                                Integer colorType0 = config.getConfigIntValue("display_position_" + i + "_color1");
                                colorType = colorType0 != null ? colorType0 : 2;
                            }
                        } else {
                            freeType = 1;
                            actionType = 3;
                            colorType = 1;
                        }
                        if (freeType != true) break block89;
                        cmd = 59;
                        adText = i < 5 ? (this.equipment.getUse() == 1 ? config.getConfigValue("display_position_" + i + "_free_type" + 1) : config.getConfigValue("display_position_" + i + "_type" + 1)) : "P";
                        break block90;
                    }
                    if (freeType != 3) break block91;
                    adText = "y\u5e74m\u6708d\u65e5h\u65f6f\u5206";
                    cmd = 60;
                }
                if (adText == null || adText.length() == 0) {
                    adText = i == 1 ? "\u51cf\u901f\u6162\u884c" : (i == 2 ? "\u4e00\u8f66\u4e00\u6746" : (i == 3 ? "\u6ce8\u610f\u5b89\u5168" : (i == 4 ? "\u8f66\u724c\u8bc6\u522b" : "P")));
                }
                String text = ServiceUtil.getString(adText, 160, "GBK");
                try {
                    sendText = text.getBytes("GBK");
                }
                catch (UnsupportedEncodingException e) {
                    try {
                        sendText = text.getBytes("GB2312");
                    }
                    catch (Exception ex) {
                        sendText = text.getBytes();
                    }
                }
                byte TWID = (byte)(i - 1);
                if (actionType < 1 || actionType > 4) {
                    actionType = 3;
                }
                int maxDisplayBytes = 8;
                if (vertical) {
                    if (displayCcount == 4) {
                        maxDisplayBytes = 4;
                    } else if (displayCcount == 5) {
                        if (i == 1 | i == 4) {
                            maxDisplayBytes = 4;
                        } else if (i == 5) {
                            maxDisplayBytes = 2;
                        }
                    }
                }
                byte ETM = sendText.length > maxDisplayBytes ? (byte)actionType : (byte)0;
                int MC = 0;
                if (vertical) {
                    if (displayCcount == 4) {
                        if (i == 1) {
                            XST = 0;
                            XEN = 32;
                            YST = 48;
                            YEN = 64;
                            if (ETM == 3 || ETM == 4) {
                                MC = 32;
                            } else if (ETM == 1 || ETM == 2) {
                                MC = 16;
                            }
                        } else if (i == 2) {
                            XST = 16;
                            XEN = 32;
                            YST = 16;
                            YEN = 48;
                            if (ETM == 3 || ETM == 4) {
                                MC = 16;
                            } else if (ETM == 1 || ETM == 2) {
                                MC = 16;
                            }
                        } else if (i == 3) {
                            XST = 0;
                            XEN = 16;
                            YST = 16;
                            YEN = 48;
                            if (ETM == 3 || ETM == 4) {
                                MC = 16;
                            } else if (ETM == 1 || ETM == 2) {
                                MC = 16;
                            }
                        } else {
                            XST = 0;
                            XEN = 32;
                            YST = 0;
                            YEN = 16;
                            if (ETM == 3 || ETM == 4) {
                                MC = 32;
                            } else if (ETM == 1 || ETM == 2) {
                                MC = 16;
                            }
                        }
                    } else if (displayCcount == 5) {
                        if (i == 1) {
                            XST = 0;
                            XEN = 32;
                            YST = 112;
                            YEN = -128;
                            if (ETM == 3 || ETM == 4) {
                                MC = 32;
                            } else if (ETM == 1 || ETM == 2) {
                                MC = 16;
                            }
                        } else if (i == 2) {
                            XST = 16;
                            XEN = 32;
                            YST = 16;
                            YEN = 80;
                            if (ETM == 3 || ETM == 4) {
                                MC = 16;
                            } else if (ETM == 1 || ETM == 2) {
                                MC = 16;
                            }
                        } else if (i == 3) {
                            XST = 0;
                            XEN = 16;
                            YST = 16;
                            YEN = 80;
                            if (ETM == 3 || ETM == 4) {
                                MC = 16;
                            } else if (ETM == 1 || ETM == 2) {
                                MC = 16;
                            }
                        } else if (i == 4) {
                            XST = 0;
                            XEN = 32;
                            YST = 0;
                            YEN = 16;
                            if (ETM == 3 || ETM == 4) {
                                MC = 32;
                            } else if (ETM == 1 || ETM == 2) {
                                MC = 16;
                            }
                        } else {
                            XST = 8;
                            XEN = 24;
                            YST = 80;
                            YEN = 112;
                        }
                    } else if (i == 1) {
                        XST = 0;
                        XEN = 16;
                        YST = 0;
                        YEN = 64;
                        if (ETM == 3 || ETM == 4) {
                            MC = 16;
                        } else if (ETM == 1 || ETM == 2) {
                            MC = 16;
                        }
                    } else {
                        XST = 16;
                        XEN = 32;
                        YST = 0;
                        YEN = 64;
                        if (ETM == 3 || ETM == 4) {
                            MC = 16;
                        } else if (ETM == 1 || ETM == 2) {
                            MC = 16;
                        }
                    }
                } else {
                    XST = 0;
                    XEN = 64;
                    if (ETM == 3 || ETM == 4) {
                        MC = 64;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                    if (displayCcount == 2) {
                        if (i == 1) {
                            XST = 0;
                            XEN = 64;
                            YST = 48;
                            YEN = 64;
                        } else {
                            YST = 32;
                            YEN = 48;
                        }
                    } else if (i == 1) {
                        YST = 48;
                        YEN = 64;
                    } else if (i == 2) {
                        YST = 32;
                        YEN = 48;
                    } else if (i == 3) {
                        YST = 16;
                        YEN = 32;
                    } else {
                        YST = 0;
                        YEN = 16;
                    }
                }
                int ETS = ETM == 3 || ETM == 4 ? 10 : (ETM == 1 || ETM == 2 ? 80 : 1);
                byte DT = 0;
                int FINDEX = 1;
                if (i == 5) {
                    FINDEX = 2;
                }
                byte BC = 0;
                int DRS = -1;
                byte TC1 = (byte)colorType;
                byte TC2 = (byte)colorType;
                byte TL = (byte)sendText.length;
                byte[] sendDataBytes = new byte[15 + sendText.length];
                sendDataBytes[0] = TWID;
                sendDataBytes[1] = ETM;
                sendDataBytes[2] = XST;
                sendDataBytes[3] = YST;
                sendDataBytes[4] = XEN;
                sendDataBytes[5] = YEN;
                sendDataBytes[6] = MC;
                sendDataBytes[7] = ETS;
                sendDataBytes[8] = DT;
                sendDataBytes[9] = DRS;
                sendDataBytes[10] = FINDEX;
                sendDataBytes[11] = TC1;
                sendDataBytes[12] = TC2;
                sendDataBytes[13] = BC;
                sendDataBytes[14] = TL;
                System.arraycopy(sendText, 0, sendDataBytes, 15, sendText.length);
                aMap.put("ad_" + i + "_" + cmd, BytesTool.byteArrayToHexString((byte[])sendDataBytes));
            }
            ++i;
        }
        return aMap;
    }

    private void checkAndSetAd() {
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            return;
        }
        if (!this.isWorkingProperly()) {
            return;
        }
        Map<String, String> adMap = this.getAdMap();
        LinkedHashMap<String, String> opMap = new LinkedHashMap<String, String>();
        Map<String, String> oldMap = this.adMap;
        if (oldMap != null && !oldMap.isEmpty()) {
            opMap.putAll(oldMap);
        }
        final Hashtable<String, String> newMap = new Hashtable<String, String>();
        String AD = "ad_";
        for (Map.Entry<String, String> entry : adMap.entrySet()) {
            if (!entry.getKey().startsWith(AD)) continue;
            if (!entry.getValue().equals(opMap.get(entry.getKey()))) {
                int cmd = Integer.parseInt(entry.getKey().substring(entry.getKey().lastIndexOf(95) + 1));
                byte[] sendData = BytesTool.hexStringToByteArray((String)entry.getValue());
                byte[] data = this.toSendBytes((byte)cmd, sendData);
                if (opMap.get(entry.getKey()) != null) {
                    newMap.put(entry.getKey(), (String)opMap.get(entry.getKey()));
                }
                final String key = entry.getKey();
                final String value = entry.getValue();
                action.sendNoResponseRS485Data(this.getUatIndex(), data, this.watitSendMills).addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                    }

                    public void operationComplete(OperationFuture<Integer> f) {
                        if (f.getException() == null && f.getResult() != null && (Integer)f.getResult() == 0) {
                            newMap.put(key, value);
                        }
                    }
                });
                continue;
            }
            newMap.put(entry.getKey(), entry.getValue());
        }
        this.adMap = newMap;
    }

    public void deleteAd(int index) {
        if (index < 0 || index > 7) {
            return;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            return;
        }
        if (!this.isWorkingProperly()) {
            return;
        }
        byte[] data = this.toSendBytes((byte)61, new byte[]{(byte)index});
        action.sendNoResponseRS485Data(this.getUatIndex(), data, this.watitSendMills);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectIfNotConnected1() {
        Object heartBitdata;
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            if (!this.checkSeriaSetingok) return;
            this.checkSeriaSetingok = false;
            return;
        }
        if (!this.checkSeriaSetingok) {
            EquipmentConfig config = this.equipment.getEquipmentConfig();
            Integer uatIndex = config.getConfigIntValue("uatIndex");
            if (uatIndex == null) {
                uatIndex = 0;
            }
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("uatIndex", uatIndex);
            param.put("dataBits", 8);
            param.put("baudRate", 9600);
            param.put("stopBits", 1);
            param.put("screen_mode", 2);
            param.put("parity", "PARITY_NONE");
            param.put("flowControl", "NONE");
            OperationFuture<Integer> operf = action.setSerialIfNeed(param);
            try {
                Integer ok = (Integer)operf.get(8L, TimeUnit.SECONDS);
                if (ok == null || ok != 0) {
                    return;
                }
                this.checkSeriaSetingok = true;
            }
            catch (Exception ex) {
                LogUtil.getLog().warn((Object)ex.getMessage());
                return;
            }
        }
        if (!this.checkSeriaSetingok) {
            return;
        }
        if (this.isSupportHeartbeat()) {
            heartBitdata = this.toSendBytes((byte)1, null);
            action.sendHaveResponseRS485Data(this.getUatIndex(), (byte[])heartBitdata, this.rReceiveDataHandler);
        }
        if (!this.isWorkingProperly()) return;
        this.checkAndSetConfigData();
        this.checkAndSetAd();
        Object object = this.lightLock;
        heartBitdata = object;
        synchronized (object) {
            int displayCout;
            long currntMills;
            if (this.redLightMills > 0L && ServiceUtil.getServiceContext().currentTimeMillis() >= this.redLightMills) {
                this.redLightMills = 0L;
                byte[] byArray = new byte[2];
                byArray[1] = -1;
                byte[] redLightBytes = this.toSendBytes((byte)53, byArray);
                action.sendNoResponseRS485Data(this.getUatIndex(), redLightBytes, this.watitSendMills);
            }
            // ** MonitorExit[heartBitdata /* !! */ ] (shouldn't be in output)
            ApplicationService applicationService = (ApplicationService)ServiceUtil.getServiceContext().getService(ApplicationService.class);
            Volume volume = applicationService.getVolume(this.equipment);
            if (volume != null && this.currentVolume == null) {
                this.setVolume0(volume, false);
            }
            if ((currntMills = ServiceUtil.getServiceContext().currentTimeMillis()) > this.nextExeSynTimeMills) {
                Calendar cl = Calendar.getInstance();
                int year = cl.get(1);
                int month = cl.get(2) + 1;
                int day = cl.get(5);
                int hour = cl.get(11);
                int minus = cl.get(12);
                int sec = cl.get(13);
                int week = cl.get(7) - 1;
                byte[] data = new byte[]{(byte)year, (byte)(year >> 8), (byte)month, (byte)day, (byte)hour, (byte)minus, (byte)sec, (byte)week};
                byte[] sendData = this.toSendBytes((byte)5, data);
                OperationFuture<Integer> op = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.watitSendMills);
                op.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void operationComplete(OperationFuture<Integer> f) {
                        if (f.getException() == null) {
                            if (f.getResult() != null && (Integer)f.getResult() == 0) {
                                DnctChannelDisplayAction.this.nextExeSynTimeMills = currntMills + TimeUnit.MINUTES.toMillis(10L);
                            } else {
                                ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5c4f" + DnctChannelDisplayAction.this.equipment.getName() + "\u65f6\u95f4\u53c2\u6570\u5931\u8d25"));
                            }
                        } else {
                            ServiceLog.getLog().warn((Object)("\u8bbe\u7f6e\u5c4f" + DnctChannelDisplayAction.this.equipment.getName() + "\u65f6\u95f4\u53c2\u6570\u5f02\u5e38\uff1a\u539f\u56e0:" + f.getException().getMessage()));
                        }
                    }

                    public void waitCompleteTimeout() {
                    }
                });
            }
            if (this.currentDisplayCount == (displayCout = this.getDisplayCount())) return;
            this.currentDisplayCount = displayCout;
            this.delAd();
            return;
        }
    }

    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (remainSpaceMap == null || remainSpaceMap.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        List<DisplaySpaceConfig> list = this.getSpaceCofigList();
        if (list == null || list.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        OperationFuture<Integer> f = null;
        for (DisplaySpaceConfig config : list) {
            Integer v = remainSpaceMap.get(config.spaceTypeNo);
            if (v == null) continue;
            f = this.display0(60, config.screenIndex, String.valueOf(config.spacefix) + v, true);
        }
        if (f == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        return f;
    }

    public List<DisplaySpaceConfig> getSpaceCofigList() {
        LinkedList<DisplaySpaceConfig> list;
        block12: {
            EquipmentConfig config;
            int screenCount;
            block11: {
                screenCount = this.getDisplayCount();
                list = null;
                config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() != 1) break block11;
                int i = 1;
                while (i <= screenCount) {
                    Integer displayType = config.getConfigIntValue("display_position_" + i + "_free_type");
                    if (displayType != null && displayType == 2) {
                        String prefix;
                        String spaceTypeNo = config.getConfigValue("display_position_" + i + "_free_type2");
                        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                            spaceTypeNo = "0";
                        }
                        if ((prefix = config.getConfigValue("display_position_" + i + "_free_type2_prefix")) == null || prefix.length() == 0 || "0".equals(prefix)) {
                            prefix = "";
                        }
                        if (list == null) {
                            list = new LinkedList<DisplaySpaceConfig>();
                        }
                        DisplaySpaceConfig c = new DisplaySpaceConfig();
                        c.screenIndex = i;
                        c.spacefix = prefix;
                        c.spaceTypeNo = spaceTypeNo;
                        list.add(c);
                    }
                    ++i;
                }
                break block12;
            }
            if (this.equipment.getUse() != 2) break block12;
            int i = 1;
            while (i <= screenCount) {
                Integer displayType = config.getConfigIntValue("display_position_" + i + "_type");
                if (displayType == null) {
                    displayType = 2;
                }
                if (displayType == 2) {
                    String prefix;
                    String spaceTypeNo = config.getConfigValue("display_position_" + i + "_type2");
                    if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                        spaceTypeNo = "0";
                    }
                    if ((prefix = config.getConfigValue("display_position_" + i + "_type2_prefix")) == null || prefix.length() == 0 || "0".equals(prefix)) {
                        prefix = "";
                    }
                    if (list == null) {
                        list = new LinkedList();
                    }
                    DisplaySpaceConfig c = new DisplaySpaceConfig();
                    c.screenIndex = i;
                    c.spacefix = prefix;
                    c.spaceTypeNo = spaceTypeNo;
                    list.add(c);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        List<DisplaySpaceConfig> x = this.getSpaceCofigList();
        if (x == null || x.isEmpty()) {
            return null;
        }
        HashSet<String> plateSet = new HashSet<String>();
        for (DisplaySpaceConfig c : x) {
            plateSet.add(c.spaceTypeNo);
        }
        return plateSet;
    }

    @Override
    public boolean isWorkingProperly() {
        long timeMills;
        Object action = this.getParentEquipmentAction();
        if (action == null) {
            return false;
        }
        if (!action.isWorkingProperly()) {
            return false;
        }
        if (this.isSupportHeartbeat() && (timeMills = ServiceUtil.getServiceContext().currentTimeMillis()) - this.receiveheardbeatTimemills > 7000L) {
            if (this.nextExeSynTimeMills != 0L) {
                this.nextExeSynTimeMills = 0L;
            }
            return false;
        }
        return true;
    }

    @Override
    public CarparkLoudspeakerAction getCarparkLoudspeakerAction() {
        return null;
    }

    @Override
    public DynLoudspeakerAction getDynLoudspeakerAction() {
        return this;
    }

    private byte[] getVolumeBytes(Volume volume) {
        byte[] bytes = new byte[4];
        bytes[0] = (byte)volume.getDayBeginHour();
        bytes[1] = (byte)volume.getDayEndHour();
        int dayVolume = Math.round((float)volume.getDayVolume() / 100.0f * 10.0f);
        if (dayVolume <= 0) {
            dayVolume = 1;
        } else if (dayVolume >= 10) {
            dayVolume = 10;
        }
        int nightVolume = Math.round((float)volume.getNightVolume() / 100.0f * 10.0f);
        if (nightVolume <= 0) {
            nightVolume = 1;
        } else if (nightVolume >= 10) {
            nightVolume = 10;
        }
        bytes[2] = (byte)dayVolume;
        bytes[3] = (byte)nightVolume;
        return bytes;
    }

    private OperationFuture<Integer> setVolume0(final Volume volume, final boolean playVoiceWhenSuccess) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (volume == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new NullPointerException("volume is null"));
            return h;
        }
        byte[] data = this.getVolumeBytes(volume);
        byte[] sendBytes = this.toSendBytes((byte)-96, data);
        OperationFuture<Integer> f1 = action.sendNoResponseRS485Data(this.getUatIndex(), sendBytes, this.watitSendMills);
        f1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

            public void waitCompleteTimeout() {
            }

            public void operationComplete(OperationFuture<Integer> da) {
                if (da.getException() == null && da.getResult() != null && (Integer)da.getResult() == 0) {
                    DnctChannelDisplayAction.this.currentVolume = volume;
                    if (playVoiceWhenSuccess) {
                        int value;
                        Calendar cl = Calendar.getInstance();
                        int hour = cl.get(11);
                        int min = cl.get(12);
                        int v = hour * 60 + min;
                        int begin = volume.getDayBeginHour() * 60 + 0;
                        int end = volume.getDayEndHour() * 60 + 0;
                        boolean night = v < begin || v > end;
                        if (night) {
                            if (volume.getNightVolume() == 0) {
                                return;
                            }
                            int nightVolume = Math.round((float)volume.getNightVolume() / 100.0f * 10.0f);
                            if (nightVolume <= 0) {
                                nightVolume = 1;
                            } else if (nightVolume >= 10) {
                                nightVolume = 10;
                            }
                            value = nightVolume;
                        } else {
                            if (volume.getDayVolume() == 0) {
                                return;
                            }
                            int dayVolume = Math.round((float)volume.getDayVolume() / 100.0f * 10.0f);
                            if (dayVolume <= 0) {
                                dayVolume = 1;
                            } else if (dayVolume >= 10) {
                                dayVolume = 10;
                            }
                            value = dayVolume;
                        }
                        DnctChannelDisplayAction.this.play("\u97f3\u91cf:" + value);
                    }
                }
            }
        });
        return f1;
    }

    @Override
    public OperationFuture<Integer> setVolume(Volume volume) {
        return this.setVolume0(volume, true);
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        this.checkAndSetConfigData();
        this.checkAndSetAd();
    }

    @Override
    public OperationFuture<Integer> play(String text) {
        return this.play(text, null, null);
    }

    @Override
    public OperationFuture<Integer> play(String text, Integer volume, DynLoudspeakerAction.PlayFinishCallback finishCallback) {
        byte[] sendText;
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (text == null || text.length() == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        if (!this.canPlayVoice()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        text = ServiceUtil.getString(text, 80, "GB2312");
        try {
            sendText = text.getBytes("GB2312");
        }
        catch (UnsupportedEncodingException e) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)e);
            return h;
        }
        if (sendText.length == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        byte[] data = new byte[sendText.length + 2];
        data[0] = 2;
        data[1] = (byte)sendText.length;
        System.arraycopy(sendText, 0, data, 2, sendText.length);
        byte[] sendData = this.toSendBytes((byte)48, data);
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.watitSendMills);
        return result;
    }

    @Override
    public boolean isSurpportFinishCallback() {
        return false;
    }

    public OperationFuture<Integer> play(byte ... codes) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (codes == null || codes.length == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        if (!this.canPlayVoice()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        int len = codes.length > 80 ? 80 : codes.length;
        byte[] data = new byte[len + 2];
        data[0] = 2;
        data[1] = (byte)len;
        System.arraycopy(codes, 0, data, 2, len);
        byte[] sendData = this.toSendBytes((byte)49, data);
        OperationFuture<Integer> result = action.sendNoResponseRS485Data(this.getUatIndex(), sendData, this.watitSendMills);
        return result;
    }

    public byte[] getPlateCodes(String plate) {
        if (plate == null || plate.length() == 0) {
            return new byte[0];
        }
        if (plate.startsWith("WJ")) {
            plate = "\u6b66" + plate.substring(2);
        } else if (plate.startsWith("\u6b66\u8b66")) {
            plate = "\u6b66" + plate.substring(2);
        }
        ArrayList<Byte> plateCode = new ArrayList<Byte>(plate.length());
        int i = 0;
        while (i < plate.length()) {
            byte d;
            char v = plate.charAt(i);
            switch (v) {
                case '0': {
                    d = 0;
                    break;
                }
                case '1': {
                    d = 1;
                    break;
                }
                case '2': {
                    d = 2;
                    break;
                }
                case '3': {
                    d = 3;
                    break;
                }
                case '4': {
                    d = 4;
                    break;
                }
                case '5': {
                    d = 5;
                    break;
                }
                case '6': {
                    d = 6;
                    break;
                }
                case '7': {
                    d = 7;
                    break;
                }
                case '8': {
                    d = 8;
                    break;
                }
                case '9': {
                    d = 9;
                    break;
                }
                case 'A': {
                    d = 15;
                    break;
                }
                case 'B': {
                    d = 16;
                    break;
                }
                case 'C': {
                    d = 17;
                    break;
                }
                case 'D': {
                    d = 18;
                    break;
                }
                case 'E': {
                    d = 19;
                    break;
                }
                case 'F': {
                    d = 20;
                    break;
                }
                case 'G': {
                    d = 21;
                    break;
                }
                case 'H': {
                    d = 22;
                    break;
                }
                case 'I': {
                    d = 23;
                    break;
                }
                case 'J': {
                    d = 24;
                    break;
                }
                case 'K': {
                    d = 25;
                    break;
                }
                case 'L': {
                    d = 26;
                    break;
                }
                case 'M': {
                    d = 27;
                    break;
                }
                case 'N': {
                    d = 28;
                    break;
                }
                case 'O': {
                    d = 29;
                    break;
                }
                case 'P': {
                    d = 30;
                    break;
                }
                case 'Q': {
                    d = 31;
                    break;
                }
                case 'R': {
                    d = 32;
                    break;
                }
                case 'S': {
                    d = 33;
                    break;
                }
                case 'T': {
                    d = 34;
                    break;
                }
                case 'U': {
                    d = 35;
                    break;
                }
                case 'V': {
                    d = 36;
                    break;
                }
                case 'W': {
                    d = 37;
                    break;
                }
                case 'X': {
                    d = 38;
                    break;
                }
                case 'Y': {
                    d = 39;
                    break;
                }
                case 'Z': {
                    d = 40;
                    break;
                }
                case '\u4eac': {
                    d = 41;
                    break;
                }
                case '\u6d25': {
                    d = 42;
                    break;
                }
                case '\u5180': {
                    d = 43;
                    break;
                }
                case '\u664b': {
                    d = 44;
                    break;
                }
                case '\u8499': {
                    d = 45;
                    break;
                }
                case '\u8fbd': {
                    d = 46;
                    break;
                }
                case '\u5409': {
                    d = 47;
                    break;
                }
                case '\u9ed1': {
                    d = 48;
                    break;
                }
                case '\u6caa': {
                    d = 49;
                    break;
                }
                case '\u82cf': {
                    d = 50;
                    break;
                }
                case '\u6d59': {
                    d = 51;
                    break;
                }
                case '\u7696': {
                    d = 52;
                    break;
                }
                case '\u95fd': {
                    d = 53;
                    break;
                }
                case '\u8d63': {
                    d = 54;
                    break;
                }
                case '\u9c81': {
                    d = 55;
                    break;
                }
                case '\u8c6b': {
                    d = 56;
                    break;
                }
                case '\u9102': {
                    d = 57;
                    break;
                }
                case '\u6e58': {
                    d = 58;
                    break;
                }
                case '\u7ca4': {
                    d = 59;
                    break;
                }
                case '\u6842': {
                    d = 60;
                    break;
                }
                case '\u743c': {
                    d = 61;
                    break;
                }
                case '\u6e1d': {
                    d = 62;
                    break;
                }
                case '\u5ddd': {
                    d = 63;
                    break;
                }
                case '\u8d35': {
                    d = 64;
                    break;
                }
                case '\u4e91': {
                    d = 65;
                    break;
                }
                case '\u85cf': {
                    d = 66;
                    break;
                }
                case '\u9655': {
                    d = 67;
                    break;
                }
                case '\u7518': {
                    d = 68;
                    break;
                }
                case '\u9752': {
                    d = 69;
                    break;
                }
                case '\u5b81': {
                    d = 70;
                    break;
                }
                case '\u65b0': {
                    d = 71;
                    break;
                }
                case '\u6e2f': {
                    d = 72;
                    break;
                }
                case '\u6fb3': {
                    d = 73;
                    break;
                }
                case '\u53f0': {
                    d = 74;
                    break;
                }
                case '\u8b66': {
                    d = 75;
                    break;
                }
                case '\u519b': {
                    d = 76;
                    break;
                }
                case '\u7a7a': {
                    d = 77;
                    break;
                }
                case '\u6d77': {
                    d = 78;
                    break;
                }
                case '\u5317': {
                    d = 79;
                    break;
                }
                case '\u6c88': {
                    d = 80;
                    break;
                }
                case '\u5170': {
                    d = 81;
                    break;
                }
                case '\u6d4e': {
                    d = 82;
                    break;
                }
                case '\u5357': {
                    d = 83;
                    break;
                }
                case '\u5e7f': {
                    d = 84;
                    break;
                }
                case '\u6210': {
                    d = 85;
                    break;
                }
                case '\u9886': {
                    d = 92;
                    break;
                }
                case '\u5b66': {
                    d = 93;
                    break;
                }
                case '\u6b66': {
                    d = 97;
                    break;
                }
                default: {
                    d = -1;
                }
            }
            if (d != -1) {
                plateCode.add(d);
            }
            ++i;
        }
        if (plateCode.isEmpty()) {
            return new byte[0];
        }
        byte[] rb = new byte[plateCode.size()];
        int i2 = 0;
        while (i2 < plateCode.size()) {
            rb[i2] = (Byte)plateCode.get(i2);
            ++i2;
        }
        return rb;
    }

    public byte[] getMoneyOrDayTimeCode(String str) {
        if (str == null || str.length() == 0) {
            return new byte[0];
        }
        if (str.indexOf(31186) != -1) {
            str = str.replace("\u79d2", "");
        }
        byte[] data = new byte[str.length()];
        int index = 0;
        int i = 0;
        while (i < str.length()) {
            int d;
            char v = str.charAt(i);
            switch (v) {
                case '0': {
                    d = 0;
                    break;
                }
                case '1': {
                    d = 1;
                    break;
                }
                case '2': {
                    d = 2;
                    break;
                }
                case '3': {
                    d = 3;
                    break;
                }
                case '4': {
                    d = 4;
                    break;
                }
                case '5': {
                    d = 5;
                    break;
                }
                case '6': {
                    d = 6;
                    break;
                }
                case '7': {
                    d = 7;
                    break;
                }
                case '8': {
                    d = 8;
                    break;
                }
                case '9': {
                    d = 9;
                    break;
                }
                case '\u70b9': {
                    d = 14;
                    break;
                }
                case '\u5341': {
                    d = 10;
                    break;
                }
                case '\u767e': {
                    d = 11;
                    break;
                }
                case '\u5343': {
                    d = 12;
                    break;
                }
                case '\u4e07': {
                    d = 13;
                    break;
                }
                case '\u5143': {
                    d = 99;
                    break;
                }
                case '\u89d2': {
                    d = 100;
                    break;
                }
                case '\u5206': {
                    d = -118;
                    break;
                }
                case '\u5e74': {
                    d = -103;
                    break;
                }
                case '\u6708': {
                    d = -86;
                    break;
                }
                case '\u65e5': {
                    d = 101;
                    break;
                }
                case '\u5929': {
                    d = -125;
                    break;
                }
                case '\u65f6': {
                    d = -119;
                    break;
                }
                default: {
                    return new byte[0];
                }
            }
            data[index++] = d;
            ++i;
        }
        return data;
    }

    @Override
    public int getDisplayCount() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 2;
        }
        return display_count;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        return this.display0(displayTimes, position, text, false);
    }

    @Override
    public boolean isVerticalScreen() {
        Integer ax = this.getCurrentConfigMapIntValue("display_tyle");
        return ax != null && ax == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationFuture<Integer> display0(int displayTimes, int position, String text, boolean spaceInfo) {
        Object object = this.displayLock;
        synchronized (object) {
            Long x;
            byte[] sendText;
            if (!this.isWorkingProperly()) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            CameraUartAction action = this.getWorkingCameraUartAction();
            if (action == null) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
                return h;
            }
            if (text == null || text.length() == 0) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setResult((Object)0);
                return h;
            }
            text = ServiceUtil.getString(text, 160, "GBK");
            try {
                sendText = text.getBytes("GBK");
            }
            catch (UnsupportedEncodingException e) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setException((Throwable)e);
                return h;
            }
            if (!spaceInfo) {
                this.dispLayInfoTimeTable.put(position, ServiceUtil.getServiceContext().currentTimeMillis() + (long)(displayTimes * 1000));
            } else if (this.equipment.getUse() == 1 && (x = this.dispLayInfoTimeTable.get(position)) != null && ServiceUtil.getServiceContext().currentTimeMillis() < x) {
                OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                h.setResult((Object)0);
                return h;
            }
            if (position == 1 && this.isVerticalScreen() && this.getDislayModuleCount() == 2 && this.getDisplayCount() == 4) {
                this.display1(displayTimes, 5, "P".getBytes(), action);
            }
            return this.display1(displayTimes, position, sendText, action);
        }
    }

    private byte getconfigByteValue(EquipmentConfig config, String key, byte defualtValue) {
        if (config == null) {
            return defualtValue;
        }
        Integer v = config.getConfigIntValue(key);
        if (v == null) {
            return defualtValue;
        }
        return v.byteValue();
    }

    private OperationFuture<Integer> display1(int displayTimes, int position, byte[] sendText, CameraUartAction action) {
        int YEN;
        int YST;
        int XEN;
        int XST;
        int TC2;
        int TC1;
        int ETM;
        int ac;
        int color;
        int TWID;
        if (sendText == null || sendText.length == 0) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        if (position < 1) {
            position = 1;
        } else if (position > 5) {
            position = 5;
        }
        int displayCcount = this.getDisplayCount();
        boolean vertical = this.isVerticalScreen();
        if (displayCcount < 2) {
            displayCcount = 2;
        } else if (displayCcount > 4) {
            displayCcount = 4;
        }
        int modeCount = this.getDislayModuleCount();
        if (displayCcount == 4 && vertical && modeCount == 2) {
            displayCcount = 5;
        }
        if ((TWID = (int)(position - 1)) < 0) {
            TWID = 0;
        } else if (TWID > 7) {
            TWID = 7;
        }
        if (this.equipment.getUse() == 1) {
            color = this.getconfigByteValue(this.equipment.getEquipmentConfig(), "display_position_" + position + "_color", (byte)2);
            ac = this.getconfigByteValue(this.equipment.getEquipmentConfig(), "display_position_" + position + "_action", (byte)3);
            if (color < 1 || color > 3) {
                color = 2;
            }
            if (ac < 1 || ac > 4) {
                ac = 3;
            }
            ETM = ac;
            TC2 = TC1 = color;
        } else {
            color = this.getconfigByteValue(this.equipment.getEquipmentConfig(), "display_position_" + position + "_color1", (byte)2);
            ac = this.getconfigByteValue(this.equipment.getEquipmentConfig(), "display_position_" + position + "_action1", (byte)3);
            if (color < 1 || color > 3) {
                color = 2;
            }
            if (ac < 1 || ac > 4) {
                ac = 3;
            }
            ETM = ac;
            TC2 = TC1 = color;
        }
        int maxDisplayBytes = 8;
        if (vertical) {
            if (displayCcount == 4) {
                maxDisplayBytes = 4;
            } else if (displayCcount == 5) {
                if (position == 1 | position == 4) {
                    maxDisplayBytes = 4;
                } else if (position == 5) {
                    maxDisplayBytes = 2;
                }
            }
        }
        if (sendText.length <= maxDisplayBytes) {
            ETM = 0;
        }
        int ETS = ETM == 3 || ETM == 4 ? 10 : (ETM == 1 || ETM == 2 ? 80 : 1);
        if (displayTimes > 255) {
            displayTimes = 255;
        }
        byte DRS = (byte)displayTimes;
        byte DT = 0;
        int FINDEX = 1;
        if (position == 5) {
            FINDEX = 2;
        }
        byte BC = 0;
        byte TL = (byte)sendText.length;
        int MC = 0;
        if (vertical) {
            if (displayCcount == 4) {
                if (position == 1) {
                    XST = 0;
                    XEN = 32;
                    YST = 48;
                    YEN = 64;
                    if (ETM == 3 || ETM == 4) {
                        MC = 32;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                } else if (position == 2) {
                    XST = 16;
                    XEN = 32;
                    YST = 16;
                    YEN = 48;
                    if (ETM == 3 || ETM == 4) {
                        MC = 16;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                } else if (position == 3) {
                    XST = 0;
                    XEN = 16;
                    YST = 16;
                    YEN = 48;
                    if (ETM == 3 || ETM == 4) {
                        MC = 16;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                } else {
                    XST = 0;
                    XEN = 32;
                    YST = 0;
                    YEN = 16;
                    if (ETM == 3 || ETM == 4) {
                        MC = 32;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                }
            } else if (displayCcount == 5) {
                if (position == 1) {
                    XST = 0;
                    XEN = 32;
                    YST = 112;
                    YEN = -128;
                    if (ETM == 3 || ETM == 4) {
                        MC = 32;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                } else if (position == 2) {
                    XST = 16;
                    XEN = 32;
                    YST = 16;
                    YEN = 80;
                    if (ETM == 3 || ETM == 4) {
                        MC = 16;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                } else if (position == 3) {
                    XST = 0;
                    XEN = 16;
                    YST = 16;
                    YEN = 80;
                    if (ETM == 3 || ETM == 4) {
                        MC = 16;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                } else if (position == 4) {
                    XST = 0;
                    XEN = 32;
                    YST = 0;
                    YEN = 16;
                    if (ETM == 3 || ETM == 4) {
                        MC = 32;
                    } else if (ETM == 1 || ETM == 2) {
                        MC = 16;
                    }
                } else {
                    XST = 8;
                    XEN = 24;
                    YST = 80;
                    YEN = 112;
                }
            } else if (position == 1) {
                XST = 0;
                XEN = 16;
                YST = 0;
                YEN = 64;
                if (ETM == 3 || ETM == 4) {
                    MC = 16;
                } else if (ETM == 1 || ETM == 2) {
                    MC = 16;
                }
            } else {
                XST = 16;
                XEN = 32;
                YST = 0;
                YEN = 64;
                if (ETM == 3 || ETM == 4) {
                    MC = 16;
                } else if (ETM == 1 || ETM == 2) {
                    MC = 16;
                }
            }
        } else {
            XST = 0;
            XEN = 64;
            if (ETM == 3 || ETM == 4) {
                MC = 64;
            } else if (ETM == 1 || ETM == 2) {
                MC = 16;
            }
            if (displayCcount == 2) {
                if (position == 1) {
                    XST = 0;
                    XEN = 64;
                    YST = 48;
                    YEN = 64;
                } else {
                    YST = 32;
                    YEN = 48;
                }
            } else if (position == 1) {
                YST = 48;
                YEN = 64;
            } else if (position == 2) {
                YST = 32;
                YEN = 48;
            } else if (position == 3) {
                YST = 16;
                YEN = 32;
            } else {
                YST = 0;
                YEN = 16;
            }
        }
        byte[] sendDataBytes = new byte[15 + sendText.length];
        sendDataBytes[0] = TWID;
        sendDataBytes[1] = ETM;
        sendDataBytes[2] = XST;
        sendDataBytes[3] = YST;
        sendDataBytes[4] = XEN;
        sendDataBytes[5] = YEN;
        sendDataBytes[6] = MC;
        sendDataBytes[7] = ETS;
        sendDataBytes[8] = DT;
        sendDataBytes[9] = DRS;
        sendDataBytes[10] = FINDEX;
        sendDataBytes[11] = TC1;
        sendDataBytes[12] = TC2;
        sendDataBytes[13] = BC;
        sendDataBytes[14] = TL;
        System.arraycopy(sendText, 0, sendDataBytes, 15, sendText.length);
        byte[] dataV = this.toSendBytes((byte)58, sendDataBytes);
        return action.sendNoResponseRS485Data(this.getUatIndex(), dataV, this.watitSendMills);
    }

    @Override
    public boolean isSupportTrafficLights() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        String v = config.getConfigValue("trafficLights");
        return v != null && "1".equals(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        CameraUartAction action = this.getWorkingCameraUartAction();
        if (action == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setException((Throwable)new Exception("\u8bbe\u5907\u672a\u8fde\u63a5"));
            return h;
        }
        if (sec <= 0) {
            sec = 1;
        }
        byte secx = (byte)(sec > 255 ? -1 : (byte)sec);
        Object object = this.lightLock;
        synchronized (object) {
            this.redLightMills = ServiceUtil.getServiceContext().currentTimeMillis() + (long)(secx * 1000);
            byte[] redLightBytes = this.toSendBytes((byte)53, new byte[]{1, secx});
            return action.sendNoResponseRS485Data(this.getUatIndex(), redLightBytes, this.watitSendMills);
        }
    }

    @Override
    public OperationFuture<Integer> displayQrCode(int sec, String qrContent, String lineMsg) {
        OperationFutureHandler opHander = ServiceUtil.getServiceContext().createOperationFuture();
        opHander.setResult((Object)1);
        return opHander;
    }

    @Override
    public int getDisplayQrCodeType() {
        Integer codeType = this.equipment.getEquipmentConfig().getConfigIntValue("display_qrcode");
        if (codeType != null) {
            return codeType;
        }
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return this.equipment.getEquipmentConfig().getConfigValue("qrcode_content");
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        OperationFuture<Integer> pf = null;
        if (texts != null && texts.length > 0) {
            int position = 1;
            String[] stringArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    pf = this.display(displayTimes, position, s);
                    ++position;
                }
                ++n2;
            }
        }
        return pf;
    }

    private static class DisplaySpaceConfig {
        int screenIndex;
        String spacefix;
        String spaceTypeNo;

        private DisplaySpaceConfig() {
        }
    }
}

