/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentAction;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.EquipmentConfigChanngedListener;
import com.wovoe.carpark.equipment.EquipmentDriver;
import com.wovoe.carpark.equipment.EquipmentState;
import com.wovoe.carpark.equipment.action.CarChannelDisplayAction;
import com.wovoe.carpark.equipment.driver.EQScreenDriver;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import com.wovoe.framework.LogUtil;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class EQScreenAction
extends AbstractEquipmentAction
implements CarChannelDisplayAction,
EquipmentConfigChanngedListener {
    private volatile boolean connected;
    private Map<Integer, Long> lockMap = new ConcurrentHashMap<Integer, Long>();
    private Object displayLock = new Object();
    private volatile long adMills;
    private InetSocketAddress inetSocketAddress;
    public static final String Extend_prefix = "Extend_";

    public EQScreenAction(Equipment equipment, EquipmentDriver driver) {
        this.setEquipment(equipment);
        this.setDriver(driver);
    }

    synchronized void start() {
    }

    synchronized void stop() {
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this.inetSocketAddress == null) {
            this.inetSocketAddress = this.createInetSocketAddress();
        }
        return this.inetSocketAddress;
    }

    protected boolean checkAddressChanged() {
        InetSocketAddress szi = this.createInetSocketAddress();
        if (!szi.equals(this.getInetSocketAddress())) {
            this.inetSocketAddress = szi;
            return true;
        }
        return false;
    }

    private InetSocketAddress createInetSocketAddress() {
        String ip = this.equipment.getEquipmentConfig().getConfigValue("ip");
        Integer x = this.equipment.getEquipmentConfig().getConfigIntValue("netPort");
        int o = 5005;
        if (x != null && x > 0 && x < 65535) {
            o = x;
        }
        InetSocketAddress s = new InetSocketAddress(ip, o);
        return s;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean isExtendDefineSpaceTypeNo(String spaceTypeNo) {
        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
            return false;
        }
        return spaceTypeNo.startsWith(Extend_prefix);
    }

    public Integer getExtendSpaceTypeNoCode(String spaceTypeNo) {
        return EQScreenDriver.getEQScreenExtend() == null ? null : EQScreenDriver.getEQScreenExtend().getExtendSpaceTypeNoCode(spaceTypeNo);
    }

    public Map<Integer, String> getExtendSpaceTypeNoCodeValue(List<DisplaySpaceConfig> extendConfigList, Map<String, Integer> remainSpaceMap) {
        return EQScreenDriver.getEQScreenExtend() == null ? null : EQScreenDriver.getEQScreenExtend().getExtendSpaceTypeNoCodeValue(extendConfigList, remainSpaceMap, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationFuture<Integer> displayParkingSpaces(Map<String, Integer> remainSpaceMap) {
        Map<Integer, String> map;
        if (remainSpaceMap == null || remainSpaceMap.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        List<DisplaySpaceConfig> list = this.getSpaceCofigList();
        if (list == null || list.isEmpty()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)0);
            return h;
        }
        OperationFuture<Integer> f = null;
        EquipmentConfig configx = this.equipment.getEquipmentConfig();
        TreeMap<Integer, String> disPlayMap = new TreeMap<Integer, String>();
        LinkedList<DisplaySpaceConfig> extendConfigList = null;
        for (DisplaySpaceConfig object : list) {
            String displayMsg;
            String sx;
            Integer v = remainSpaceMap.get(object.spaceTypeNo);
            if (v == null) continue;
            if (this.isExtendDefineSpaceTypeNo(object.spaceTypeNo)) {
                if (extendConfigList == null) {
                    extendConfigList = new LinkedList<DisplaySpaceConfig>();
                }
                extendConfigList.add(object);
                continue;
            }
            int numFormat = 0;
            if (this.equipment.getUse() == 2) {
                String txc;
                sx = configx.getConfigValue("display_position_" + object.screenIndex + "_type" + 2 + "_suffix");
                if (sx == null || sx.length() == 0 || "0".equals(sx)) {
                    sx = "";
                }
                if ((txc = configx.getConfigValue("display_position_" + object.screenIndex + "_type" + 2 + "_numformat")) != null && txc.length() > 0) {
                    try {
                        numFormat = Integer.parseInt(txc);
                    }
                    catch (Exception exception) {}
                }
            } else {
                sx = "";
            }
            if (v == Integer.MIN_VALUE) {
                displayMsg = String.valueOf(object.spacefix) + sx;
            } else if (numFormat > 1) {
                String format = "%0" + numFormat + "d";
                displayMsg = String.valueOf(object.spacefix) + String.format(format, v) + sx;
            } else {
                displayMsg = String.valueOf(object.spacefix) + v + sx;
            }
            disPlayMap.put(object.screenIndex, displayMsg);
        }
        if (extendConfigList != null && !extendConfigList.isEmpty() && (map = this.getExtendSpaceTypeNoCodeValue((List<DisplaySpaceConfig>)extendConfigList, remainSpaceMap)) != null && !map.isEmpty()) {
            disPlayMap.putAll(map);
        }
        if (disPlayMap.isEmpty()) {
            OperationFutureHandler operationFutureHandler = ServiceUtil.getServiceContext().createOperationFuture();
            operationFutureHandler.setResult((Object)0);
            return operationFutureHandler;
        }
        if (disPlayMap.size() == 1) {
            for (Map.Entry entry : disPlayMap.entrySet()) {
                f = this.display0(60, (Integer)entry.getKey(), (String)entry.getValue(), 2);
            }
            return f;
        }
        Object object = this.displayLock;
        synchronized (object) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            String eqIdName = "eqId";
            String playTypeName = "playType";
            paramMap.put(eqIdName, this.equipment.getEquipmentNo());
            paramMap.put("displayCount", String.valueOf(disPlayMap.size()));
            int index = 0;
            String playTypeValue = null;
            for (Map.Entry e : disPlayMap.entrySet()) {
                Long v1 = this.lockMap.get(e.getKey());
                if (v1 != null) {
                    if (ServiceUtil.getServiceContext().currentTimeMillis() < v1) {
                        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                        h.setResult((Object)0);
                        return h;
                    }
                    this.lockMap.remove(e.getKey());
                }
                Map<String, String> m1 = this.getDisplayMap((Integer)e.getKey(), (String)e.getValue(), 2);
                for (Map.Entry<String, String> e3 : m1.entrySet()) {
                    if (eqIdName.equals(e3.getKey())) continue;
                    if (playTypeName.equals(e3.getKey())) {
                        if (playTypeValue != null && playTypeValue.length() != 0) continue;
                        playTypeValue = e3.getValue();
                        continue;
                    }
                    paramMap.put(String.valueOf(e3.getKey()) + index, e3.getValue());
                }
                ++index;
            }
            if (playTypeValue == null || playTypeValue.length() == 0) {
                playTypeValue = "3";
            }
            paramMap.put(playTypeName, playTypeValue);
            return this.doOption(paramMap, "diplayAll", "\u663e\u793a\u4f59\u4f4d\u4fe1\u606f");
        }
    }

    public void displayAd() {
        try {
            int sCount = this.getDisplayCount();
            LinkedList<KeyValueEntry> list = null;
            int i = 1;
            while (i <= sCount) {
                block13: {
                    String key;
                    EquipmentConfig config;
                    block14: {
                        Integer type;
                        block12: {
                            config = this.equipment.getEquipmentConfig();
                            if (this.equipment.getUse() != 2) break block12;
                            type = config.getConfigIntValue("display_position_" + i + "_type");
                            if (type == null || type != 1) break block13;
                            key = "display_position_" + i + "_type1";
                            break block14;
                        }
                        type = config.getConfigIntValue("display_position_" + i + "_free_type");
                        if (type != null && type != 1) break block13;
                        key = "display_position_" + i + "_free_type1";
                    }
                    String value = config.getConfigValue(key);
                    if (value == null || value.length() == 0) {
                        value = i == 1 ? "\u51cf\u901f\u6162\u884c" : (i == 2 ? "\u4e00\u8f66\u4e00\u6746" : (i == 3 ? "\u6ce8\u610f\u5b89\u5168" : "\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf"));
                    }
                    if (list == null) {
                        list = new LinkedList<KeyValueEntry>();
                    }
                    list.add(new KeyValueEntry((Object)i, (Object)value));
                }
                ++i;
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            long currentMills = ServiceUtil.getServiceContext().currentTimeMillis();
            long x = currentMills - this.adMills;
            if (x > 15000L) {
                this.adMills = currentMills;
                for (KeyValueEntry en : list) {
                    this.display0(33, (Integer)en.getKey(), (String)en.getValue(), 1);
                }
            }
        }
        catch (Exception ex) {
            LogUtil.getLog().warn((Object)(String.valueOf(this.equipment.getIp()) + ": \u663e\u793a\u5e7f\u544a: " + ex.getMessage()));
        }
    }

    private Map<String, String> getDisplayMap(int position, String text, int type) {
        Integer actionType;
        int playType;
        Integer speed;
        Integer fontSize;
        EquipmentConfig config;
        Integer width0;
        int desplayLine = this.getDisplayCount();
        if (desplayLine <= 0) {
            desplayLine = 1;
        }
        int width = (width0 = (config = this.equipment.getEquipmentConfig()).getConfigIntValue("screemWidth")) == null || width0 <= 0 ? 128 : width0;
        Integer height0 = config.getConfigIntValue("screemHeight");
        int height = height0 == null || height0 <= 0 ? 16 : height0;
        int x = 0;
        int y = 0;
        Integer x1 = this.equipment.getUse() == 2 ? config.getConfigIntValue("display_position_" + position + "_x1") : config.getConfigIntValue("display_position_" + position + "_x");
        if (x1 != null && x1 > 0) {
            x += x1.intValue();
        }
        int w = width;
        int h = height;
        Integer y1 = this.equipment.getUse() == 2 ? config.getConfigIntValue("display_position_" + position + "_y1") : config.getConfigIntValue("display_position_" + position + "_y");
        if (y1 == null || y1 < 0) {
            y1 = 0;
        }
        if (desplayLine > 1) {
            h = height / desplayLine;
            int px = position - 1;
            y = h * px;
        }
        if (y1 > 0 && y1 < h) {
            h -= y1.intValue();
            y += y1.intValue();
        }
        if ((fontSize = this.equipment.getUse() == 2 ? config.getConfigIntValue("display_position_" + position + "_fontSize1") : config.getConfigIntValue("display_position_" + position + "_fontSize")) == null || fontSize <= 0) {
            fontSize = 12;
        }
        if ((speed = this.equipment.getUse() == 2 ? config.getConfigIntValue("display_position_" + position + "_speed1") : config.getConfigIntValue("display_position_" + position + "_speed")) == null || speed < 0) {
            speed = 1;
        }
        Integer playType0 = this.equipment.getUse() == 2 ? config.getConfigIntValue("display_position_" + position + "_directShow1") : config.getConfigIntValue("display_position_" + position + "_directShow");
        int n = playType = playType0 == null ? 1 : playType0;
        if (playType < 1 || playType > 3) {
            playType = 1;
        }
        if ((actionType = this.equipment.getUse() == 2 ? config.getConfigIntValue("display_position_" + position + "_actionType1") : config.getConfigIntValue("display_position_" + position + "_actionType")) == null || actionType < 0) {
            actionType = 1;
        }
        if (type == 2) {
            actionType = 1;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("eqId", this.equipment.getEquipmentNo());
        paramMap.put("text", text);
        paramMap.put("x", String.valueOf(x));
        paramMap.put("y", String.valueOf(y));
        paramMap.put("w", String.valueOf(w));
        paramMap.put("h", String.valueOf(h));
        paramMap.put("actionType", actionType.toString());
        paramMap.put("playType", String.valueOf(playType));
        paramMap.put("speed", speed.toString());
        paramMap.put("fontSize", fontSize.toString());
        return paramMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationFuture<Integer> display0(int displayTimes, int position, String text, int type) {
        Object object = this.displayLock;
        synchronized (object) {
            if (type == 0) {
                int times = 2000;
                this.lockMap.put(position, ServiceUtil.getServiceContext().currentTimeMillis() + (long)(times * displayTimes));
            } else {
                Long v1 = this.lockMap.get(position);
                if (v1 != null) {
                    if (ServiceUtil.getServiceContext().currentTimeMillis() < v1) {
                        OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
                        h.setResult((Object)0);
                        return h;
                    }
                    this.lockMap.remove(position);
                }
            }
            Map<String, String> paramMap = this.getDisplayMap(position, text, type);
            return this.doOption(paramMap, "diplay", "\u663e\u793a\u4fe1\u606f");
        }
    }

    private OperationFuture<Integer> doClearAllProgram() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("eqId", this.equipment.getEquipmentNo());
        return this.doOption(paramMap, "clearAllProgram", "\u6e05\u9664\u6240\u6709\u8282\u76ee");
    }

    private OperationFuture<Integer> doOption(Map<String, String> playParamMap, String op, String opName) {
        if (!this.isWorkingProperly()) {
            OperationFutureHandler r = ServiceUtil.getServiceContext().createOperationFuture();
            r.setResult((Object)1);
            return r;
        }
        if (!ServiceUtil.getServiceContext().getEQScreenActionTool().isInitSuccess()) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            LogUtil.getLog().warn((Object)"EQSDK \u672a\u521d\u59cb\u5316\u6210\u529f\uff01\u8bf7\u7a0d\u540e\u8c03\u7528");
            h.setResult((Object)1);
            return h;
        }
        if (ServiceUtil.getServiceContext().getEQScreenActionTool().getLocalProcessTransport() == null) {
            OperationFutureHandler h = ServiceUtil.getServiceContext().createOperationFuture();
            h.setResult((Object)1);
            return h;
        }
        OperationFuture<Integer> fxx = ServiceUtil.getServiceContext().getEQScreenActionTool().getLocalProcessTransport().doRemoteService("/EQAction", op, playParamMap, 5000L, opName);
        return fxx;
    }

    @Override
    public Set<String> getNeedDisplaySpaceTypeNos() {
        List<DisplaySpaceConfig> x = this.getSpaceCofigList();
        if (x == null || x.isEmpty()) {
            return null;
        }
        HashSet<String> plateSet = new HashSet<String>();
        for (DisplaySpaceConfig c : x) {
            plateSet.add(c.spaceTypeNo);
        }
        return plateSet;
    }

    public List<DisplaySpaceConfig> getSpaceCofigList() {
        LinkedList<DisplaySpaceConfig> list;
        block12: {
            EquipmentConfig config;
            int screenCount;
            block11: {
                screenCount = this.getDisplayCount();
                list = null;
                config = this.equipment.getEquipmentConfig();
                if (this.equipment.getUse() != 1) break block11;
                int i = 1;
                while (i <= screenCount) {
                    Integer displayType = config.getConfigIntValue("display_position_" + i + "_free_type");
                    if (displayType != null && displayType == 2) {
                        String prefix;
                        String spaceTypeNo = config.getConfigValue("display_position_" + i + "_free_type2");
                        if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                            spaceTypeNo = "0";
                        }
                        if ((prefix = config.getConfigValue("display_position_" + i + "_free_type2_prefix")) == null || "0".equals(prefix)) {
                            prefix = "";
                        }
                        if (list == null) {
                            list = new LinkedList<DisplaySpaceConfig>();
                        }
                        DisplaySpaceConfig c = new DisplaySpaceConfig();
                        c.screenIndex = i;
                        c.spacefix = prefix;
                        c.spaceTypeNo = spaceTypeNo;
                        list.add(c);
                    }
                    ++i;
                }
                break block12;
            }
            if (this.equipment.getUse() != 2) break block12;
            int i = 1;
            while (i <= screenCount) {
                Integer displayType = config.getConfigIntValue("display_position_" + i + "_type");
                if (displayType == null) {
                    displayType = 2;
                }
                if (displayType == 2) {
                    String prefix;
                    String spaceTypeNo = config.getConfigValue("display_position_" + i + "_type2");
                    if (spaceTypeNo == null || spaceTypeNo.length() == 0) {
                        spaceTypeNo = "0";
                    }
                    if ((prefix = config.getConfigValue("display_position_" + i + "_type2_prefix")) == null || "0".equals(prefix)) {
                        prefix = "";
                    }
                    if (list == null) {
                        list = new LinkedList();
                    }
                    DisplaySpaceConfig c = new DisplaySpaceConfig();
                    c.screenIndex = i;
                    c.spacefix = prefix;
                    c.spaceTypeNo = spaceTypeNo;
                    list.add(c);
                }
                ++i;
            }
        }
        return list;
    }

    @Override
    public boolean isWorkingProperly() {
        return this.connected;
    }

    @Override
    public EquipmentState getEquipmentState() {
        return this.isWorkingProperly() ? EquipmentState.CONNECTED : EquipmentState.DISCONNECTED;
    }

    @Override
    public void onConfigPropertyChange(Map<String, KeyValueEntry<String, String>> changedProperties) {
        ServiceUtil.getServiceContext().getEQScreenActionTool().run();
        this.adMills = 0L;
        this.doClearAllProgram();
        this.displayAd();
    }

    @Override
    public int getDisplayCount() {
        EquipmentConfig config = this.equipment.getEquipmentConfig();
        Integer display_count = config.getConfigIntValue("display_count");
        if (display_count == null) {
            display_count = 1;
        }
        return display_count;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, int position, String text) {
        return this.display0(displayTimes, position, text, 0);
    }

    @Override
    public boolean isSupportTrafficLights() {
        return false;
    }

    @Override
    public OperationFuture<Integer> lightGreen(int sec) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public OperationFuture<Integer> displayQrCode(int sec, String qrContent, String lineMsg) {
        OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        f.setResult((Object)1);
        return f;
    }

    @Override
    public boolean isVerticalScreen() {
        return false;
    }

    @Override
    public OperationFuture<Integer> display(int displayTimes, String[] texts) {
        OperationFuture<Integer> pf = null;
        if (texts != null && texts.length > 0) {
            int position = 1;
            String[] stringArray = texts;
            int n = texts.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s != null && s.length() > 0) {
                    pf = this.display(displayTimes, position, s);
                    ++position;
                }
                ++n2;
            }
        }
        return pf;
    }

    @Override
    public int getDisplayQrCodeType() {
        return 0;
    }

    @Override
    public String getDisplayStaticQrCodeContent() {
        return null;
    }

    public static class DisplaySpaceConfig {
        public int screenIndex;
        public String spacefix;
        public String spaceTypeNo;
    }
}

