/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.LocalProcessTransport;
import com.wovoe.carpark.PathFinder;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentConfig;
import com.wovoe.carpark.equipment.driver.EQScreenAction;
import com.wovoe.carpark.event.app.InformationEvent;
import com.wovoe.carpark.internel.ServiceLog;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.BytesTool;
import com.wovoe.framework.JobTask;
import com.wovoe.framework.OperationFuture;
import com.wovoe.framework.OperationFutureHandler;
import com.wovoe.framework.TimeoutObjectPool;
import com.wovoe.framework.communication.AbstractProtocolHandler;
import com.wovoe.framework.communication.AppProtocolPacket;
import com.wovoe.framework.communication.ByteArrayPacket;
import com.wovoe.framework.communication.ByteBufferPacket;
import com.wovoe.framework.communication.CommunicationHandle;
import com.wovoe.framework.communication.CommunicationHandleManger;
import com.wovoe.framework.communication.ProtocolContext;
import com.wovoe.framework.communication.ProtocolHandler;
import com.wovoe.framework.communication.ProtocolHandlerChain;
import com.wovoe.framework.communication.ReadWriteProtocolHandlerChain;
import com.wovoe.framework.communication.RootWriteProtocolHandler;
import com.wovoe.framework.communication.SendCallbackHandler;
import com.wovoe.framework.communication.SimpleAttributeHolder;
import com.wovoe.framework.communication.udp.UDPConfig;
import com.wovoe.framework.communication.udp.UDPEndpoint;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class EQScreenActionTool
extends JobTask {
    public static final String LIBRARY_NAME = "EQ2008_Dll";
    public static final String ACTION_NAME = "/EQAction";
    private static volatile boolean allEqLoaded = false;
    private static volatile boolean inited = false;
    private static volatile AtomicBoolean checking = new AtomicBoolean(false);
    private ScheduledFuture<?> job;
    public static final String NAME_UDP_EQSCREEN_HANDLE = "UDP_EQScreen2008_Handle";
    public static final String CONFIG_UDP_EQSCREEN_PORT = "accept.udp.eqscreen.port";
    private static byte[] testBytes;
    protected UDPConfig udpConfig;
    private LocalProcessTransport localProcessTransport;

    public void setAllEqLoaded(boolean allEqLoaded0) {
        allEqLoaded = allEqLoaded0;
    }

    public boolean isAllEqLoaded() {
        return allEqLoaded;
    }

    public boolean isInitSuccess() {
        return inited;
    }

    private static String getLibFileName() {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "EQ2008_Dll.dll";
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "EQ2008_Dll.so";
        }
        return "EQ2008_Dll.dll";
    }

    private static String getLibDirName(boolean os32) {
        String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
        if (OS_NAME.indexOf("win") != -1) {
            return "win" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nux") != -1) {
            return "linux" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("nix") != -1) {
            return "unix" + (os32 ? "32" : "64");
        }
        if (OS_NAME.indexOf("mac") != -1) {
            return "mac" + (os32 ? "32" : "64");
        }
        return os32 ? "32" : "64";
    }

    public LocalProcessTransport getLocalProcessTransport() {
        if (this.localProcessTransport == null) {
            if (ServiceUtil.getServiceContext().getLocalProcessTransport64() == null) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                String libFileName = EQScreenActionTool.getLibFileName();
                File libFile = new File(PathFinder.findHomeDir(), "native/EQ_LEDSdk/" + EQScreenActionTool.getLibDirName(true) + "/" + libFileName);
                if (libFile.exists() && libFile.isFile()) {
                    ServiceLog.getLog().info((Object)("EQ\u5c4f\u4f7f\u752832\u4f4d\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                } else {
                    libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
                    if (libFile.exists() && libFile.isFile()) {
                        ServiceLog.getLog().info((Object)("EQ\u5c4f\u4f7f\u752832\u4f4d\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                    } else {
                        ServiceLog.getLog().warn((Object)"EQ\u5c4f\u65e0\u6cd5\u627e\u5230\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4EQ\u5c4f\u65e0\u6cd5\u663e\u793a!!!!");
                    }
                }
                return this.localProcessTransport;
            }
            String libFileName = EQScreenActionTool.getLibFileName();
            File libFile = new File(PathFinder.findHomeDir(), "native/EQ_LEDSdk/" + EQScreenActionTool.getLibDirName(false) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)("EQ\u5c4f\u4f7f\u752864\u4f4d\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre64/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
                ServiceLog.getLog().info((Object)("EQ\u5c4f\u4f7f\u752864\u4f4d\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "native/EQ_LEDSdk/" + EQScreenActionTool.getLibDirName(true) + "/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)("EQ\u5c4f\u4f7f\u752832\u4f4d\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            libFile = new File(PathFinder.findHomeDir(), "bin/jre32/bin/" + libFileName);
            if (libFile.exists() && libFile.isFile()) {
                this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport32();
                ServiceLog.getLog().info((Object)("EQ\u5c4f\u4f7f\u752832\u4f4d\u5904\u7406\u5e93:" + libFile.getAbsolutePath()));
                return this.localProcessTransport;
            }
            ServiceLog.getLog().warn((Object)"EQ\u5c4f\u65e0\u6cd5\u627e\u5230\u672c\u5730\u5e93\uff0c\u8fd9\u53ef\u80fd\u5bfc\u81f4\u65e0\u6cd5\u663e\u793a!!!!");
            this.localProcessTransport = ServiceUtil.getServiceContext().getLocalProcessTransport64();
            return this.localProcessTransport;
        }
        return this.localProcessTransport;
    }

    private OperationFuture<Integer> checkInitConfig() {
        final OperationFutureHandler f = ServiceUtil.getServiceContext().createOperationFuture();
        try {
            if (!this.isAllEqLoaded()) {
                inited = false;
                f.setResult((Object)1);
                return f;
            }
            Collection<Equipment> eqls = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(10);
            if (eqls == null || eqls.isEmpty()) {
                inited = false;
                f.setResult((Object)1);
                return f;
            }
            final HashMap<String, String> configMap = new HashMap<String, String>();
            String[] paramStrs = new String[]{"ip", "screemWidth", "screemHeight", "cardType", "colorStyle", "serialBaud", "serialNum", "netPort", "communicationMode"};
            StringBuilder eqIds = new StringBuilder();
            for (Equipment eq : eqls) {
                if (!(eq.getEquipmentAction() instanceof EQScreenAction)) continue;
                if (eqIds.length() > 0) {
                    eqIds.append(',');
                }
                eqIds.append(eq.getEquipmentNo());
                EquipmentConfig config = eq.getEquipmentConfig();
                String[] stringArray = paramStrs;
                int n = paramStrs.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    String value = config.getConfigValue(name);
                    if (value != null && value.length() > 0) {
                        configMap.put(String.valueOf(name) + "_" + eq.getEquipmentNo(), value);
                    }
                    ++n2;
                }
            }
            if (eqIds.length() == 0) {
                inited = false;
                f.setResult((Object)1);
                return f;
            }
            configMap.put("eqIds", eqIds.toString());
            if (this.getLocalProcessTransport() == null) {
                inited = false;
                f.setResult((Object)1);
                return f;
            }
            OperationFuture<Integer> f1 = this.getLocalProcessTransport().loadNativeDriveIfNeed("com.wovoe.screen.eq.drive.Drive", "\u52a0\u8f7dEQ\u63a7\u5236\u672c\u5730\u9a71\u52a8");
            f1.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                public void waitCompleteTimeout() {
                }

                public void operationComplete(OperationFuture<Integer> fx) {
                    if (fx.getException() == null && fx.getResult() != null && (Integer)fx.getResult() == 0) {
                        OperationFuture<Integer> fxx = EQScreenActionTool.this.getLocalProcessTransport().doRemoteService(EQScreenActionTool.ACTION_NAME, "init", configMap, 5000L, "\u68c0\u67e5\u914d\u7f6e\u6587\u4ef6");
                        fxx.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                            public void operationComplete(OperationFuture<Integer> fx13) {
                                if (fx13.getException() != null) {
                                    inited = false;
                                    f.setException(fx13.getException());
                                } else if (fx13.isCancelled()) {
                                    inited = false;
                                    f.cancel(true);
                                } else {
                                    Integer r = (Integer)fx13.getResult();
                                    if (r != null && r == 0) {
                                        inited = true;
                                    } else {
                                        inited = false;
                                    }
                                    f.setResult((Object)r);
                                }
                            }

                            public void waitCompleteTimeout() {
                            }
                        });
                    } else {
                        inited = false;
                        f.setResult((Object)1);
                    }
                }
            });
        }
        catch (Exception ex) {
            inited = false;
            f.setResult((Object)1);
            ServiceLog.getLog().warn((Object)ex.getMessage(), (Throwable)ex);
        }
        return f;
    }

    public synchronized void start() {
        if (this.job == null) {
            this.checkUDPEndpointStart();
            this.job = ServiceUtil.getServiceContext().schedule(this, 1000L, 3000L, TimeUnit.MILLISECONDS);
            ServiceUtil.getServiceContext().addExitRunnable(new Runnable(){

                @Override
                public void run() {
                    EQScreenActionTool.this.destroy();
                }
            });
        }
    }

    public synchronized void destroy() {
        if (this.job != null) {
            this.job.cancel(true);
            this.job = null;
        }
    }

    private void checkUDPEndpointStart() {
        if (ServiceUtil.getServiceContext().getUDPEndpoint().isShutdown()) {
            return;
        }
        if (ServiceUtil.getServiceContext().getUDPEndpoint().getUDPConfig(NAME_UDP_EQSCREEN_HANDLE) == null) {
            int end = 20000;
            int begin = 8974;
            boolean success = false;
            int port = begin;
            while (port < end) {
                UDPDetectedConfig udpConfig0 = new UDPDetectedConfig(port);
                try {
                    ServiceUtil.getServiceContext().getUDPEndpoint().bind((UDPConfig)udpConfig0);
                    success = true;
                    this.udpConfig = udpConfig0;
                    break;
                }
                catch (Exception e) {
                    ServiceLog.getLog().warn((Object)e.getMessage(), (Throwable)e);
                    ++port;
                }
            }
            if (!success) {
                ServiceUtil.getServiceContext().getCarparkEventListenerManager().syncThrowEvent(new InformationEvent(new Object(), "\u9519\u8bef\uff1a\u65e0\u53ef\u7528\u7aef\u53e3\u5728[" + begin + "," + end + ") \u4e4b\u95f4\uff0c\u8fd9\u5c06\u5bfc\u81f4\u663e\u793a\u5c4f\u65e0\u6cd5\u9a71\u52a8", 3, 12000));
                ServiceLog.getLog().warn((Object)("\u9519\u8bef\uff1a\u65e0\u53ef\u7528\u7aef\u53e3\u5728[" + begin + "," + end + ") \u4e4b\u95f4\uff0c\u8fd9\u5c06\u5bfc\u81f4\u663e\u793a\u5c4f\u65e0\u6cd5\u9a71\u52a8"));
            }
        }
    }

    protected void doRun() throws Exception {
        if (this.isAllEqLoaded() && this.job != null) {
            if (checking.compareAndSet(false, true)) {
                OperationFuture<Integer> f = this.checkInitConfig();
                f.addCompleteListener((OperationFuture.CompleteListener)new OperationFuture.CompleteListener<Integer>(){

                    public void waitCompleteTimeout() {
                        checking.set(false);
                    }

                    public void operationComplete(OperationFuture<Integer> of) {
                        checking.set(false);
                    }
                }, 10L, TimeUnit.SECONDS);
            }
            this.checkConnected();
        }
    }

    private void checkConnected() {
        Collection<Equipment> eqls = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(10);
        if (eqls != null && !eqls.isEmpty()) {
            for (Equipment eq : eqls) {
                if (!(eq.getEquipmentAction() instanceof EQScreenAction)) continue;
                EQScreenAction action = (EQScreenAction)eq.getEquipmentAction();
                InetSocketAddress address = action.getInetSocketAddress();
                if (address == null) {
                    action.setConnected(false);
                    continue;
                }
                CommunicationHandle h1 = CommunicationHandleManger.getCommunicationHandle((String)NAME_UDP_EQSCREEN_HANDLE);
                if (h1 == null) {
                    action.setConnected(false);
                    continue;
                }
                String key = EQScreenActionTool.getKey(eq, address);
                if (ServiceUtil.getServiceContext().getTimeoutObjectPool().getObject((Object)key) != null) continue;
                EqBytesDataCallback callback = new EqBytesDataCallback(eq, key);
                ServiceUtil.getServiceContext().getTimeoutObjectPool().addObject((Object)key, (Object)callback, (TimeoutObjectPool.TimeoutCallback)callback, 5000L, TimeUnit.MILLISECONDS);
                if (testBytes == null) {
                    testBytes = BytesTool.hexStringToByteArray((String)"acacacacfeff008001000a0000920fca");
                }
                byte[] sendBytes = testBytes;
                ByteArrayAppPacket appPacket = new ByteArrayAppPacket();
                appPacket.setAttribute("send.target.address", address);
                ByteBufferPacket sendPacket = new ByteBufferPacket(ByteBuffer.wrap(sendBytes));
                sendPacket.setSocketAddress((SocketAddress)address);
                appPacket.sendBytes = new ByteArrayPacket[]{sendPacket};
                h1.send((AppProtocolPacket)appPacket, (SendCallbackHandler)callback);
            }
        }
    }

    private static String getKey(Equipment eq, SocketAddress address) {
        String key = "EQ_" + eq.getDriver().getName() + "_" + eq.getEquipmentNo() + "_" + address.toString() + "_conn";
        return key;
    }

    private static class ByteArrayAppPacket
    extends SimpleAttributeHolder
    implements AppProtocolPacket {
        private ByteArrayPacket[] sendBytes;

        private ByteArrayAppPacket() {
        }
    }

    private static class EQProtocolHandler
    extends AbstractProtocolHandler {
        private EQProtocolHandler() {
        }

        protected boolean handleRead(ProtocolContext ctx) throws Exception {
            SocketAddress sourceAddress;
            if (ctx.getMessage() instanceof ByteArrayPacket && (sourceAddress = (SocketAddress)ctx.getAttribute("receive.source.address")) != null && sourceAddress instanceof InetSocketAddress) {
                ByteArrayPacket byteArray = (ByteArrayPacket)ctx.getMessage();
                Collection<Equipment> eqls = ServiceUtil.getServiceContext().getEquipmentManager().getByEquipmentType(10);
                if (eqls != null && !eqls.isEmpty()) {
                    for (Equipment eq : eqls) {
                        EQScreenAction action;
                        InetSocketAddress address;
                        Object obj = eq.getEquipmentAction();
                        if (obj == null || !(obj instanceof EQScreenAction) || (address = (action = (EQScreenAction)obj).getInetSocketAddress()) == null || !((Object)address).equals(sourceAddress)) continue;
                        String key = EQScreenActionTool.getKey(eq, address);
                        Object tobj = ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)key);
                        if (tobj == null || !(tobj instanceof EqBytesDataCallback)) break;
                        ((EqBytesDataCallback)tobj).handle(byteArray);
                        break;
                    }
                }
            }
            return true;
        }

        protected boolean handleWrite(ProtocolContext ctx) throws Exception {
            Object message = ctx.getMessage();
            if (message instanceof ByteArrayAppPacket) {
                ByteArrayAppPacket p = (ByteArrayAppPacket)((Object)message);
                if (p.sendBytes == null || p.sendBytes.length == 0) {
                    return false;
                }
                ctx.setMessage((Object)p.sendBytes);
            }
            return true;
        }
    }

    private static class EqBytesDataCallback
    implements TimeoutObjectPool.TimeoutCallback,
    SendCallbackHandler {
        protected Equipment equpment;
        protected String key;

        public EqBytesDataCallback(Equipment equpment, String key) {
            this.equpment = equpment;
            this.key = key;
        }

        public void onTimeout(Object arg0, Object arg1) throws Exception {
            EQScreenAction action = (EQScreenAction)this.equpment.getEquipmentAction();
            action.setConnected(false);
        }

        protected void handle(ByteArrayPacket byteArray) {
            EQScreenAction action = (EQScreenAction)this.equpment.getEquipmentAction();
            action.setConnected(true);
        }

        public void onSendCompleted(CommunicationHandle arg0) {
        }

        public void onSendException(Throwable arg0, CommunicationHandle arg1) {
            if (this.key != null) {
                ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this.key);
            }
            EQScreenAction action = (EQScreenAction)this.equpment.getEquipmentAction();
            action.setConnected(false);
        }

        public void onSendTimeout(CommunicationHandle arg0) {
            ServiceUtil.getServiceContext().getTimeoutObjectPool().removeObject((Object)this.key);
            EQScreenAction action = (EQScreenAction)this.equpment.getEquipmentAction();
            action.setConnected(false);
        }
    }

    private static class UDPDetectedConfig
    implements UDPConfig {
        private int port;

        public UDPDetectedConfig(int port) {
            this.port = port;
        }

        public ProtocolHandlerChain createProtocolHandlerChain(UDPEndpoint arg0) {
            ReadWriteProtocolHandlerChain rwchain = new ReadWriteProtocolHandlerChain();
            rwchain.appendNextProtocolHandler((ProtocolHandler)new EQProtocolHandler());
            rwchain.appendNextProtocolHandler((ProtocolHandler)new RootWriteProtocolHandler());
            return rwchain;
        }

        public int getACKTimeoutMills() {
            return 0;
        }

        public String getAcceptName() {
            return EQScreenActionTool.NAME_UDP_EQSCREEN_HANDLE;
        }

        public int getAcceptPort() {
            return this.port;
        }

        public int getReSendTimes() {
            return 0;
        }
    }
}

