/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.dto.CarparkArea;
import com.wovoe.carpark.dto.CarparkCarType;
import com.wovoe.carpark.dto.CarparkPassportType;
import com.wovoe.carpark.equipment.AbstractEquipmentDriver;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.driver.EQScreenAction;
import com.wovoe.carpark.equipment.driver.EQScreenExtend;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EQScreenDriver
extends AbstractEquipmentDriver {
    public static final String DRIVER_NAME = "wovoe_eq_net_screen_driver";
    public static EQScreenExtend eqScreenExtend;

    public static void setEQScreenExtend(EQScreenExtend e) {
        eqScreenExtend = e;
    }

    public static EQScreenExtend getEQScreenExtend() {
        return eqScreenExtend;
    }

    public EQScreenDriver() {
        this.init();
    }

    protected void init() {
        this.name = DRIVER_NAME;
        this.alias = String.valueOf(this.getAlisTypeName("EQ-20X")) + "\u4f59\u4f4d/\u8f66\u9053\u5c4f\u63a7\u5236\u5361\u3010\u7f51\u53e3\u3011\u9a71\u52a8";
        this.parentDriverNames = null;
        this.equipmentType = 10;
        this.defaultUse = 2;
        this.description = "\u7528\u4e8e\u663e\u793a\u4f59\u4f4d\u6216\u51fa\u5165\u4fe1\u606f";
        this.supplier = "WOVOE";
        this.version = "1.0.0";
        this.pcEquipment = false;
        this.channelEquipment = true;
    }

    @Override
    public Map<Integer, String> getUseMap() {
        LinkedHashMap<Integer, String> m = new LinkedHashMap<Integer, String>();
        m.put(1, "\u8f66\u9053\u4fe1\u606f\u5c4f");
        m.put(2, "\u4f59\u4f4d\u4fe1\u606f\u5c4f");
        return m;
    }

    @Override
    public String getEquipmentTypeName() {
        return "\u4f59\u4f4d/\u8f66\u9053\u5c4f";
    }

    @Override
    protected void doStartEquipment(Equipment equipment, Map<String, String> config) {
        equipment.setEquipmentConfig(this.createEquipmentConfig(config));
        EQScreenAction c = new EQScreenAction(equipment, this);
        this.setAction(equipment, c);
        equipment.addEquipmentConfigChanngedListener(c);
        c.start();
    }

    @Override
    protected void doStopEquipment(Equipment equipment) {
        EQScreenAction action = (EQScreenAction)equipment.getEquipmentAction();
        if (action != null) {
            equipment.removeEquipmentConfigChanngedListener(action);
            action.stop();
        }
    }

    @Override
    protected void addParameterDefinitionList(List<EquipmentParameter> pl) {
        List<KeyValueEntry<String, String>> extendKv;
        int display_count;
        EquipmentParameter p = new EquipmentParameter();
        p.setParameterName("ip");
        p.setParameterNameDes("IP\u5730\u5740");
        p.setUnique(true);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("netPort");
        p.setParameterNameDes("\u8fde\u63a5\u7aef\u53e3");
        p.setParameterDefaultValue("5005");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("cardType");
        p.setParameterNameDes("\u63a7\u5236\u5361\u578b\u53f7");
        ArrayList<Object> parameterSelectValues = new ArrayList<KeyValueEntry<String, String>>(2);
        parameterSelectValues.add(new KeyValueEntry((Object)"21", (Object)"EQ2013"));
        parameterSelectValues.add(new KeyValueEntry((Object)"22", (Object)"EQ2023"));
        parameterSelectValues.add(new KeyValueEntry((Object)"23", (Object)"EQ2033"));
        parameterSelectValues.add(new KeyValueEntry((Object)"0", (Object)"EQ3002-I"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"EQ3002-II"));
        parameterSelectValues.add(new KeyValueEntry((Object)"2", (Object)"EQ3002-III"));
        parameterSelectValues.add(new KeyValueEntry((Object)"3", (Object)"EQ2008-I/II"));
        parameterSelectValues.add(new KeyValueEntry((Object)"4", (Object)"EQ2010-I"));
        parameterSelectValues.add(new KeyValueEntry((Object)"5", (Object)"EQ2008-IE"));
        parameterSelectValues.add(new KeyValueEntry((Object)"7", (Object)"EQ2011"));
        parameterSelectValues.add(new KeyValueEntry((Object)"8", (Object)"EQ2012"));
        parameterSelectValues.add(new KeyValueEntry((Object)"9", (Object)"EQ2008-M"));
        p.setInputType(1);
        p.setParameterSelectValues(parameterSelectValues);
        p.setParameterDefaultValue("22");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("screemWidth");
        p.setParameterNameDes("\u5c4f\u5e55\u5bbd\u5ea6");
        p.setParameterDefaultValue("128");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("screemHeight");
        p.setParameterNameDes("\u5c4f\u5e55\u9ad8\u5ea6");
        p.setParameterDefaultValue("16");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("colorStyle");
        p.setParameterNameDes("\u5c4f\u7c7b\u578b");
        p.setParameterDefaultValue("0");
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u5355\u8272"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u53cc\u8272"));
        parameterSelectValues.add(new KeyValueEntry((Object)"2", (Object)"\u4e03\u5f69"));
        p.setInputType(1);
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("display_count");
        p.setParameterNameDes("\u5c4f\u7684\u6570\u91cf");
        p.setParameterDefaultValue("1");
        p.setInputType(1);
        int n = display_count = eqScreenExtend == null ? 4 : eqScreenExtend.getMaxDisplayCount();
        if (display_count < 4) {
            display_count = 4;
        } else if (display_count > 20) {
            display_count = 20;
        }
        parameterSelectValues = new ArrayList(display_count);
        int i = 1;
        while (i <= display_count) {
            parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)String.valueOf(i), (Object)(String.valueOf(String.valueOf(i)) + "\u884c\u5c4f")));
            ++i;
        }
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues0 = new ArrayList<KeyValueEntry<String, String>>(4);
        parameterSelectValues0.add(new KeyValueEntry((Object)"1", (Object)"\u5e7f\u544a\u4fe1\u606f"));
        parameterSelectValues0.add(new KeyValueEntry((Object)"2", (Object)"\u4f59\u4f4d\u4fe1\u606f"));
        LinkedList<KeyValueEntry<String, String>> parameterSelectValues1 = new LinkedList<KeyValueEntry<String, String>>();
        parameterSelectValues1.add(new KeyValueEntry((Object)"staticText", (Object)"\u9759\u6001\u6587\u672c"));
        List<KeyValueEntry<String, String>> list = extendKv = eqScreenExtend == null ? null : eqScreenExtend.getDisplayKeyValueEntry();
        if (extendKv != null && !extendKv.isEmpty()) {
            parameterSelectValues1.addAll(extendKv);
        }
        parameterSelectValues1.add(new KeyValueEntry((Object)"0", (Object)"\u8bbe\u5907\u6240\u5c5e\u573a\u533a\u603b\u4f59\u4f4d"));
        if (ServiceUtil.getServiceContext() != null && ServiceUtil.getServiceContext().getDBConfigCache() != null) {
            Map<String, CarparkCarType> carTypeMap;
            Map<String, CarparkPassportType> passportTypeMap;
            Map<String, String> spaceTypeMap;
            Map<String, CarparkArea> areaMap = ServiceUtil.getServiceContext().getDBConfigCache().getAreasMap();
            if (areaMap != null && areaMap.size() > 1) {
                parameterSelectValues1.add(new KeyValueEntry((Object)"r-a_0", (Object)"\u6240\u6709\u573a\u533a(\u8f66\u573a)\u603b\u4f59\u4f4d"));
                for (CarparkArea area : areaMap.values()) {
                    if (area.getChildren() != null && !area.getChildren().isEmpty()) {
                        parameterSelectValues1.add(new KeyValueEntry((Object)("r-a_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + " \u4f59\u4f4d\u6570(\u542b\u5b50\u533a\u57df)")));
                        parameterSelectValues1.add(new KeyValueEntry((Object)("r-as_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + " \u4f59\u4f4d\u6570(\u4e0d\u542b\u5b50\u533a\u57df)")));
                        continue;
                    }
                    parameterSelectValues1.add(new KeyValueEntry((Object)("r-a_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + " \u4f59\u4f4d\u6570")));
                }
            }
            if ((spaceTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getSpaceTypeMap()) != null && !spaceTypeMap.isEmpty()) {
                for (Map.Entry<String, String> s1 : spaceTypeMap.entrySet()) {
                    if (areaMap == null || areaMap.isEmpty()) continue;
                    for (CarparkArea carparkArea : areaMap.values()) {
                        if (carparkArea.getChildren() != null && !carparkArea.getChildren().isEmpty()) {
                            parameterSelectValues1.add(new KeyValueEntry((Object)("r-a_" + carparkArea.getArea_no() + "-d_" + s1.getKey()), (Object)(String.valueOf(carparkArea.getArea_name()) + " " + s1.getValue() + " \u4f59\u4f4d\u6570(\u542b\u5b50\u533a\u57df)")));
                            parameterSelectValues1.add(new KeyValueEntry((Object)("r-a_" + carparkArea.getArea_no() + "-s_" + s1.getKey()), (Object)(String.valueOf(carparkArea.getArea_name()) + " " + s1.getValue() + " \u4f59\u4f4d\u6570(\u4e0d\u542b\u5b50\u533a\u57df)")));
                            continue;
                        }
                        parameterSelectValues1.add(new KeyValueEntry((Object)("r-a_" + carparkArea.getArea_no() + "-d_" + s1.getKey()), (Object)(String.valueOf(carparkArea.getArea_name()) + " " + s1.getValue() + " \u4f59\u4f4d\u6570")));
                    }
                }
            }
            if (areaMap != null && areaMap.size() > 1) {
                parameterSelectValues1.add(new KeyValueEntry((Object)"t-a_0", (Object)"\u6240\u6709\u573a\u533a(\u8f66\u573a)\u8f66\u8f86\u603b\u6570"));
                for (CarparkArea area : areaMap.values()) {
                    if (area.getChildren() != null && !area.getChildren().isEmpty()) {
                        parameterSelectValues1.add(new KeyValueEntry((Object)("t-a_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + " \u8f66\u8f86\u6570(\u542b\u5b50\u533a\u57df)")));
                        parameterSelectValues1.add(new KeyValueEntry((Object)("t-as_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + " \u8f66\u8f86\u6570(\u4e0d\u542b\u5b50\u533a\u57df)")));
                        continue;
                    }
                    parameterSelectValues1.add(new KeyValueEntry((Object)("t-a_" + area.getArea_no()), (Object)(String.valueOf(area.getArea_name()) + " \u8f66\u8f86\u6570")));
                }
            }
            if (spaceTypeMap != null && !spaceTypeMap.isEmpty()) {
                for (Map.Entry<String, String> s1 : spaceTypeMap.entrySet()) {
                    if (areaMap == null || areaMap.isEmpty()) continue;
                    for (CarparkArea carparkArea : areaMap.values()) {
                        parameterSelectValues1.add(new KeyValueEntry((Object)("t-a_" + carparkArea.getArea_no() + "-d_" + s1.getKey()), (Object)(String.valueOf(carparkArea.getArea_name()) + " " + s1.getValue() + " \u8f66\u8f86\u6570")));
                    }
                }
            }
            if ((passportTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getPassportTypeMap()) != null) {
                for (CarparkPassportType t : passportTypeMap.values()) {
                    parameterSelectValues1.add(new KeyValueEntry((Object)("t-a_0-b_" + t.getPassport_type_no()), (Object)("\u8f66\u573a " + t.getPassport_type_name() + " \u8f66\u8f86\u6570")));
                    if (areaMap == null) continue;
                    for (CarparkArea area : areaMap.values()) {
                        parameterSelectValues1.add(new KeyValueEntry((Object)("t-a_" + area.getArea_no() + "-b_" + t.getPassport_type_no()), (Object)(String.valueOf(area.getArea_name()) + " " + t.getPassport_type_name() + " \u8f66\u8f86\u6570")));
                    }
                }
            }
            if ((carTypeMap = ServiceUtil.getServiceContext().getDBConfigCache().getCarTypeMap()) != null) {
                for (CarparkCarType carparkCarType : carTypeMap.values()) {
                    parameterSelectValues1.add(new KeyValueEntry((Object)("t-a_0-c_" + carparkCarType.getCar_type_no()), (Object)("\u8f66\u573a" + carparkCarType.getCar_type_name() + "\u8f66\u8f86\u6570")));
                    if (areaMap == null) continue;
                    for (CarparkArea area : areaMap.values()) {
                        parameterSelectValues1.add(new KeyValueEntry((Object)("t-a_" + area.getArea_no() + "-c_" + carparkCarType.getCar_type_name()), (Object)(String.valueOf(area.getArea_name()) + " " + carparkCarType.getCar_type_name() + " \u8f66\u8f86\u6570")));
                    }
                }
            }
        }
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues2 = new ArrayList<KeyValueEntry<String, String>>(4);
        parameterSelectValues2.add(new KeyValueEntry((Object)"1", (Object)"\u56fa\u5b9a\u663e\u793a"));
        parameterSelectValues2.add(new KeyValueEntry((Object)"2", (Object)"\u6eda\u52a8\u663e\u793a"));
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues3 = new ArrayList<KeyValueEntry<String, String>>(4);
        parameterSelectValues3.add(new KeyValueEntry((Object)"1", (Object)"\u5b9e\u65f6\u663e\u793a"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"2", (Object)"\u5355\u884c\u6587\u672c"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"3", (Object)"\u6807\u51c6\u6587\u672c"));
        int i2 = 1;
        while (i2 <= display_count) {
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_free_type");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u7a7a\u95f2\u663e\u793a\u7c7b\u578b");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues0);
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_free_type");
            p.setParameterName("display_position_" + i2 + "_free_type" + 1);
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u7a7a\u95f2\u663e\u793a\u5185\u5bb9");
            if (i2 == 1) {
                p.setParameterDefaultValue("\u51cf\u901f\u6162\u884c");
            } else if (i2 == 2) {
                p.setParameterDefaultValue("\u4e00\u8f66\u4e00\u6746");
            } else if (i2 == 3) {
                p.setParameterDefaultValue("\u6ce8\u610f\u5b89\u5168");
            } else {
                p.setParameterDefaultValue("\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf");
            }
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_free_type");
            p.setParameterName("display_position_" + i2 + "_free_type" + 2);
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u7a7a\u95f2\u663e\u793a\u4f59\u4f4d\u7c7b\u578b");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues1);
            p.setParameterDefaultValue("0");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_free_type");
            p.setParameterName("display_position_" + i2 + "_free_type" + 2 + "_prefix");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u7a7a\u95f2\u663e\u793a\u4f59\u4f4d\u524d\u7f00");
            p.setParameterDefaultValue("");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_actionType");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u52a8\u4f5c");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues2);
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_speed");
            p.setParameterNameDes("\u7b2c" + i2 + "\u6eda\u52a8\u901f\u5ea6");
            p.setParameterDefaultValue("1");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_fontSize");
            p.setParameterNameDes("\u7b2c" + i2 + "\u5b57\u4f53\u5927\u5c0f");
            p.setParameterDefaultValue("12");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_directShow");
            p.setParameterNameDes("\u7b2c" + i2 + "\u663e\u793a\u65b9\u5f0f");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues3);
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_y");
            p.setParameterNameDes("\u7b2c" + i2 + "\u5b57\u4f53\u9876\u7aef\u95f4\u8ddd");
            p.setParameterDefaultValue("0");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_x");
            p.setParameterNameDes("\u7b2c" + i2 + "\u5b57\u4f53\u5de6\u4fa7\u95f4\u8ddd");
            p.setParameterDefaultValue("0");
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_type");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u7c7b\u578b");
            p.setParameterDefaultValue("2");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues0);
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_type");
            p.setParameterName("display_position_" + i2 + "_type" + 1);
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u5185\u5bb9");
            if (i2 == 1) {
                p.setParameterDefaultValue("\u51cf\u901f\u6162\u884c");
            } else if (i2 == 2) {
                p.setParameterDefaultValue("\u4e00\u8f66\u4e00\u6746");
            } else if (i2 == 3) {
                p.setParameterDefaultValue("\u6ce8\u610f\u5b89\u5168");
            } else {
                p.setParameterDefaultValue("\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf");
            }
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_type");
            p.setParameterName("display_position_" + i2 + "_type" + 2);
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u4f59\u4f4d\u7c7b\u578b");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues1);
            p.setParameterDefaultValue("0");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_type");
            p.setParameterName("display_position_" + i2 + "_type" + 2 + "_prefix");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u4f59\u4f4d\u524d\u7f00");
            p.setParameterDefaultValue("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_type");
            p.setParameterName("display_position_" + i2 + "_type" + 2 + "_suffix");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u4f59\u4f4d\u540e\u7f00");
            p.setParameterDefaultValue("");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i2 + "_type");
            p.setParameterName("display_position_" + i2 + "_type" + 2 + "_numformat");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u4f59\u4f4d\u6700\u5c0f\u663e\u793a\u4f4d\u6570");
            p.setParameterDefaultValue("1");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_actionType1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u884c\u663e\u793a\u52a8\u4f5c");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues2);
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_speed1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u6eda\u52a8\u901f\u5ea6");
            p.setParameterDefaultValue("1");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_fontSize1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u5b57\u4f53\u5927\u5c0f");
            p.setParameterDefaultValue("5");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_directShow1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u663e\u793a\u65b9\u5f0f");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues3);
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_y1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u5b57\u4f53\u9876\u7aef\u95f4\u8ddd");
            p.setParameterDefaultValue("0");
            p.setUse(2);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i2 + "_x1");
            p.setParameterNameDes("\u7b2c" + i2 + "\u5b57\u4f53\u5de6\u4fa7\u95f4\u8ddd");
            p.setParameterDefaultValue("0");
            p.setUse(2);
            pl.add(p);
            ++i2;
        }
    }

    @Override
    public boolean isSupportMultiChannel() {
        return false;
    }
}

