/*
 * Decompiled with CFR 0.152.
 */
package com.wovoe.carpark.equipment.driver;

import com.wovoe.carpark.equipment.AbstractEquipmentDriver;
import com.wovoe.carpark.equipment.Equipment;
import com.wovoe.carpark.equipment.EquipmentParameter;
import com.wovoe.carpark.equipment.driver.FRTKDisplayAction;
import com.wovoe.carpark.internel.ServiceUtil;
import com.wovoe.framework.KeyValueEntry;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FRTKDisplayDriver
extends AbstractEquipmentDriver {
    public static final String DRIVER_NAME = "wovoe_frtk1_screen_driver";

    public FRTKDisplayDriver() {
        this.init();
    }

    @Override
    protected void doStartEquipment(Equipment equipment, Map<String, String> config) {
        equipment.setEquipmentConfig(this.createEquipmentConfig(config));
        FRTKDisplayAction c = new FRTKDisplayAction(equipment, this);
        this.setAction(equipment, c);
        c.start();
    }

    @Override
    protected void doStopEquipment(Equipment equipment) {
        FRTKDisplayAction action = (FRTKDisplayAction)equipment.getEquipmentAction();
        action.stop();
    }

    @Override
    public String getEquipmentTypeName() {
        return "\u8f66\u9053\u5c4f";
    }

    @Override
    public boolean isSupportMultiChannel() {
        return false;
    }

    @Override
    public Map<Integer, String> getUseMap() {
        LinkedHashMap<Integer, String> m = new LinkedHashMap<Integer, String>();
        m.put(1, "\u8f66\u9053\u4fe1\u606f\u5c4f");
        return m;
    }

    protected void init() {
        this.name = DRIVER_NAME;
        this.alias = String.valueOf(this.getAlisTypeName("FRTC_EP01")) + "\u8f66\u9053\u5c4f\u63a7\u5236\u5361\u9a71\u52a8";
        this.equipmentType = 10;
        this.defaultUse = 1;
        this.description = "\u7528\u4e8e\u663e\u793a\u51fa\u5165\u6216\u4f59\u4f4d\u4fe1\u606f";
        this.supplier = "WOVOE";
        this.version = "1.0.0";
        this.pcEquipment = false;
        this.channelEquipment = true;
        this.parentDriverNames = new String[]{"wovoe_ice_ip_camera_driver", "wovoe_qy_ip_camera_driver", "wovoe_zhenshi_ip_camera_driver", "wlyk_hikvision_ip_regplate_camera_driver", "wlyk_uniview_ip_regplate_camera_driver", "wlyk_qlmrg_ip_camera_driver"};
    }

    @Override
    protected void addParameterDefinitionList(List<EquipmentParameter> pl) {
        EquipmentParameter p = new EquipmentParameter();
        p.setParameterName("uatIndex");
        p.setParameterNameDes("\u8fde\u63a5\u76f8\u673a\u4e32\u53e3\u7aef\u53e3");
        p.setParameterDefaultValue("0");
        p.setInputType(1);
        ArrayList<Object> parameterSelectValues = new ArrayList<KeyValueEntry<String, String>>(2);
        parameterSelectValues.add(new KeyValueEntry((Object)"0", (Object)"\u4e32\u53e31"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u4e32\u53e32"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("baudRate");
        p.setParameterNameDes("\u5c4f\u5361\u4e32\u53e3\u6ce2\u7279\u7387");
        p.setParameterDefaultValue("4800");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(7);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"2400", (Object)"2400"));
        parameterSelectValues.add(new KeyValueEntry((Object)"4800", (Object)"4800"));
        parameterSelectValues.add(new KeyValueEntry((Object)"9600", (Object)"9600"));
        parameterSelectValues.add(new KeyValueEntry((Object)"19200", (Object)"19200"));
        parameterSelectValues.add(new KeyValueEntry((Object)"38400", (Object)"38400"));
        parameterSelectValues.add(new KeyValueEntry((Object)"57600", (Object)"57600"));
        parameterSelectValues.add(new KeyValueEntry((Object)"115200", (Object)"115200"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("RS485_ADDR");
        p.setParameterNameDes("RS485\u5730\u5740[0-255(\u5e7f\u64ad)]");
        p.setParameterDefaultValue("255");
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("detect_heartBeat");
        p.setParameterNameDes("\u662f\u5426\u68c0\u6d4b\u8bbe\u5907\u72b6\u6001");
        p.setParameterDefaultValue("1");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"0", (Object)"\u4e0d\u68c0\u6d4b"));
        parameterSelectValues.add(new KeyValueEntry((Object)"1", (Object)"\u68c0\u6d4b"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("font_size");
        p.setParameterNameDes("\u5b57\u4f53\u5927\u5c0f");
        p.setParameterDefaultValue("16");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"16", (Object)"16"));
        parameterSelectValues.add(new KeyValueEntry((Object)"32", (Object)"32"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        p = new EquipmentParameter();
        p.setParameterName("screen_width");
        p.setParameterNameDes("\u5c4f\u5bbd\u5ea6");
        p.setParameterDefaultValue("64");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(3);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"64", (Object)"64"));
        parameterSelectValues.add(new KeyValueEntry((Object)"128", (Object)"128"));
        parameterSelectValues.add(new KeyValueEntry((Object)"192", (Object)"192"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        if (ServiceUtil.getServiceContext().getCarparkLocalConfig() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() != null && ServiceUtil.getServiceContext().getCarparkLocalConfig().getCarpark_deploy_type() == 1) {
            p = new EquipmentParameter();
            p.setParameterName("DAY_TIME_SET");
            p.setParameterNameDes("\u767d\u5929\u65f6\u6bb5");
            p.setParameterDefaultValue("07:00:00-19:00:00");
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("DAY_TIME_VOLUME");
            p.setParameterNameDes("\u767d\u5929\u97f3\u91cf[0-100]");
            p.setParameterDefaultValue("50");
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("NIGHT_TIME_VOLUME");
            p.setParameterNameDes("\u591c\u95f4\u97f3\u91cf[0-100]");
            p.setParameterDefaultValue("50");
            pl.add(p);
        }
        p = new EquipmentParameter();
        p.setParameterName("display_count");
        p.setParameterNameDes("\u663e\u793a\u884c\u6570");
        p.setParameterDefaultValue("2");
        p.setInputType(1);
        parameterSelectValues = new ArrayList(2);
        parameterSelectValues.add((KeyValueEntry<String, String>)new KeyValueEntry((Object)"2", (Object)"2\u884c\u5c4f"));
        parameterSelectValues.add(new KeyValueEntry((Object)"4", (Object)"4\u884c\u5c4f"));
        p.setParameterSelectValues(parameterSelectValues);
        pl.add(p);
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues0 = new ArrayList<KeyValueEntry<String, String>>(2);
        parameterSelectValues0.add(new KeyValueEntry((Object)"1", (Object)"\u5e7f\u544a\u4fe1\u606f"));
        parameterSelectValues0.add(new KeyValueEntry((Object)"3", (Object)"\u65f6\u949f\u663e\u793a"));
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues2 = new ArrayList<KeyValueEntry<String, String>>(3);
        parameterSelectValues2.add(new KeyValueEntry((Object)"0", (Object)"\u7acb\u5373\u9000\u51fa"));
        parameterSelectValues2.add(new KeyValueEntry((Object)"1", (Object)"\u81ea\u5de6\u5411\u53f3\u6eda\u52a8\u9000\u51fa"));
        parameterSelectValues2.add(new KeyValueEntry((Object)"2", (Object)"\u62c9\u5e18\u9000\u51fa"));
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues3 = new ArrayList<KeyValueEntry<String, String>>(20);
        parameterSelectValues3.add(new KeyValueEntry((Object)"0", (Object)"\u7acb\u5373\u663e\u793a"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"1", (Object)"\u81ea\u53f3\u5411\u5de6\u6eda\u52a8"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"2", (Object)"\u81ea\u52a8\u6362\u884c\u663e\u793a"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"3", (Object)"\u5411\u4e0a\u6eda\u52a8\u8fdb\u5165"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"4", (Object)"\u5206\u5c4f\u663e\u793a"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"5", (Object)"\u53f3\u4e0a\u98de\u5165"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"6", (Object)"\u5de6\u4e0a\u98de\u5165"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"7", (Object)"\u53f3\u4e0b\u98de\u5165"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"8", (Object)"\u5de6\u4e0b\u98de\u5165"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"9", (Object)"\u53f3\u79fb\u8fdb"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"10", (Object)"\u53f3\u62c9\u5e18"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"11", (Object)"\u5355\u5b57\u81ea\u53f3\u5411\u5de6\u98de\u5165"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"12", (Object)"\u5355\u5b57\u81ea\u5de6\u5411\u53f3\u98de\u5165"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"13", (Object)"\u5b57\u5e55\u6a21\u5f0f"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"14", (Object)"\u956d\u5c04\u6253\u5b57\u6a21\u5f0f"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"15", (Object)"\u53e0\u52a0\u8fdb\u5165"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"16", (Object)"\u4e2d\u95f4\u6ea2\u51fa\u6a21\u5f0f"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"17", (Object)"\u62c9\u7a97\u6a21\u5f0f"));
        parameterSelectValues3.add(new KeyValueEntry((Object)"18", (Object)"\u76f4\u89d2\u51fa\u73b0"));
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues4 = new ArrayList<KeyValueEntry<String, String>>(7);
        parameterSelectValues4.add(new KeyValueEntry((Object)"0", (Object)"\u7ea2\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"1", (Object)"\u7eff\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"2", (Object)"\u9ec4\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"3", (Object)"\u84dd\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"4", (Object)"\u7d2b\u8272"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"5", (Object)"\u6c34\u84dd"));
        parameterSelectValues4.add(new KeyValueEntry((Object)"6", (Object)"\u767d\u8272"));
        ArrayList<KeyValueEntry<String, String>> parameterSelectValues5 = new ArrayList<KeyValueEntry<String, String>>(11);
        int i = 0;
        while (i < 11) {
            if (i == 0) {
                parameterSelectValues5.add(new KeyValueEntry((Object)String.valueOf(i), (Object)"\u9ed8\u8ba4"));
            } else {
                parameterSelectValues5.add(new KeyValueEntry((Object)String.valueOf(i), (Object)String.valueOf(i)));
            }
            ++i;
        }
        i = 1;
        while (i <= 4) {
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_free_type");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u7a7a\u95f2\u663e\u793a\u7c7b\u578b");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues0);
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParentParameterKey("display_position_" + i + "_free_type");
            p.setParameterName("display_position_" + i + "_free_type" + 1);
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u7a7a\u95f2\u663e\u793a\u5185\u5bb9");
            if (i == 1) {
                p.setParameterDefaultValue("\u51cf\u901f\u6162\u884c");
            } else if (i == 2) {
                p.setParameterDefaultValue("\u4e00\u8f66\u4e00\u6746");
            } else if (i == 3) {
                p.setParameterDefaultValue("\u6ce8\u610f\u5b89\u5168");
            } else {
                p.setParameterDefaultValue("\u9ad8\u6e05\u8f66\u724c\u8bc6\u522b\u7cfb\u7edf");
            }
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_color");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u663e\u793a\u989c\u8272");
            p.setParameterDefaultValue("0");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues4);
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_action");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u663e\u793a\u52a8\u4f5c");
            p.setParameterDefaultValue("1");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues3);
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_eac");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u9000\u51fa\u52a8\u4f5c");
            p.setParameterDefaultValue("0");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues2);
            p.setUse(1);
            pl.add(p);
            p = new EquipmentParameter();
            p.setParameterName("display_position_" + i + "_speed");
            p.setParameterNameDes("\u7b2c" + i + "\u884c\u6eda\u52a8\u901f\u5ea6");
            p.setParameterDefaultValue("0");
            p.setInputType(1);
            p.setParameterSelectValues(parameterSelectValues5);
            p.setUse(1);
            pl.add(p);
            ++i;
        }
    }
}

